/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.exception;

import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathInfo;

public class TableNotFoundException
extends HoodieException {
    public TableNotFoundException(String basePath) {
        super(TableNotFoundException.getErrorMessage(basePath));
    }

    public TableNotFoundException(String basePath, Throwable t) {
        super(TableNotFoundException.getErrorMessage(basePath), t);
    }

    private static String getErrorMessage(String basePath) {
        return "Hoodie table not found in path " + basePath;
    }

    public static void checkTableValidity(HoodieStorage storage, StoragePath basePathDir, StoragePath metaPathDir) {
        try {
            StoragePathInfo pathInfo = storage.getPathInfo(metaPathDir);
            if (!pathInfo.isDirectory()) {
                throw new TableNotFoundException(metaPathDir.toString());
            }
        }
        catch (FileNotFoundException | IllegalArgumentException e) {
            throw new TableNotFoundException(metaPathDir.toString(), e);
        }
        catch (IOException e) {
            throw new HoodieIOException("Could not check if " + basePathDir + " is a valid table", e);
        }
    }
}

