/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.queue;

import java.util.Iterator;
import org.apache.hudi.common.util.collection.ClosableIterator;
import org.apache.hudi.common.util.queue.HoodieMessageQueue;
import org.apache.hudi.common.util.queue.HoodieProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IteratorBasedQueueProducer<I>
implements HoodieProducer<I> {
    private static final Logger LOG = LoggerFactory.getLogger(IteratorBasedQueueProducer.class);
    private final Iterator<I> inputIterator;

    public IteratorBasedQueueProducer(Iterator<I> inputIterator) {
        this.inputIterator = inputIterator;
    }

    @Override
    public void produce(HoodieMessageQueue<I, ?> queue) throws Exception {
        LOG.info("starting to buffer records");
        while (this.inputIterator.hasNext()) {
            queue.insertRecord(this.inputIterator.next());
        }
        LOG.info("finished buffering records");
    }

    @Override
    public void close() {
        if (this.inputIterator instanceof ClosableIterator) {
            ((ClosableIterator)this.inputIterator).close();
        }
    }
}

