/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.timeline.versioning.compaction;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hudi.avro.model.HoodieCompactionOperation;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.versioning.AbstractMigratorBase;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.storage.StoragePath;

public class CompactionV1MigrationHandler
extends AbstractMigratorBase<HoodieCompactionPlan> {
    public static final Integer VERSION = 1;

    public CompactionV1MigrationHandler(HoodieTableMetaClient metaClient) {
        super(metaClient);
    }

    @Override
    public Integer getManagedVersion() {
        return VERSION;
    }

    @Override
    public HoodieCompactionPlan upgradeFrom(HoodieCompactionPlan input) {
        throw new IllegalArgumentException("This is the lowest version. Input cannot be any lower version");
    }

    @Override
    public HoodieCompactionPlan downgradeFrom(HoodieCompactionPlan input) {
        ValidationUtils.checkArgument((input.getVersion() == 2 ? 1 : 0) != 0, (String)("Input version is " + input.getVersion() + ". Must be 2"));
        HoodieCompactionPlan compactionPlan = new HoodieCompactionPlan();
        StoragePath basePath = this.metaClient.getBasePathV2();
        List<HoodieCompactionOperation> v1CompactionOperationList = new ArrayList<HoodieCompactionOperation>();
        if (null != input.getOperations()) {
            v1CompactionOperationList = input.getOperations().stream().map(inp -> HoodieCompactionOperation.newBuilder().setBaseInstantTime(inp.getBaseInstantTime()).setFileId(inp.getFileId()).setPartitionPath(inp.getPartitionPath()).setMetrics(inp.getMetrics()).setDataFilePath(CompactionV1MigrationHandler.convertToV1Path(basePath, inp.getPartitionPath(), inp.getDataFilePath())).setDeltaFilePaths(inp.getDeltaFilePaths().stream().map(s -> CompactionV1MigrationHandler.convertToV1Path(basePath, inp.getPartitionPath(), s)).collect(Collectors.toList())).build()).collect(Collectors.toList());
        }
        compactionPlan.setOperations(v1CompactionOperationList);
        compactionPlan.setExtraMetadata(input.getExtraMetadata());
        compactionPlan.setVersion(this.getManagedVersion());
        return compactionPlan;
    }

    private static String convertToV1Path(StoragePath basePath, String partitionPath, String fileName) {
        if (fileName == null || fileName.isEmpty()) {
            return fileName;
        }
        return new StoragePath(FSUtils.constructAbsolutePath(basePath, partitionPath), fileName).toString();
    }
}

