/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.HoodieConfig;
import org.apache.hudi.common.config.HoodieMetaserverConfig;
import org.apache.hudi.common.fs.ConsistencyGuard;
import org.apache.hudi.common.fs.ConsistencyGuardConfig;
import org.apache.hudi.common.fs.FailSafeConsistencyGuard;
import org.apache.hudi.common.fs.FileSystemRetryConfig;
import org.apache.hudi.common.fs.NoOpConsistencyGuard;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieArchivedTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineLayout;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.ConfigUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.TableNotFoundException;
import org.apache.hudi.io.storage.HoodieIOFactory;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.storage.StoragePathFilter;
import org.apache.hudi.storage.StoragePathInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTableMetaClient
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(HoodieTableMetaClient.class);
    public static final String METAFOLDER_NAME = ".hoodie";
    public static final String TEMPFOLDER_NAME = ".hoodie/.temp";
    public static final String AUXILIARYFOLDER_NAME = ".hoodie/.aux";
    public static final String BOOTSTRAP_INDEX_ROOT_FOLDER_PATH = ".hoodie/.aux/.bootstrap";
    public static final String SAMPLE_WRITES_FOLDER_PATH = ".hoodie/.aux/.sample_writes";
    public static final String HEARTBEAT_FOLDER_NAME = ".hoodie/.heartbeat";
    public static final String METADATA_TABLE_FOLDER_PATH = ".hoodie/metadata";
    public static final String HASHING_METADATA_FOLDER_NAME = ".bucket_index/consistent_hashing_metadata";
    public static final String BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH = ".hoodie/.aux/.bootstrap/.partitions";
    public static final String BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH = ".hoodie/.aux/.bootstrap/.fileids";
    public static final String SCHEMA_FOLDER_NAME = ".schema";
    public static final String MARKER_EXTN = ".marker";
    private final Map<String, HoodieArchivedTimeline> archivedTimelineMap = new HashMap<String, HoodieArchivedTimeline>();
    protected StoragePath basePath;
    protected StoragePath metaPath;
    private transient HoodieStorage storage;
    private boolean loadActiveTimelineOnLoad;
    protected StorageConfiguration<?> storageConf;
    private HoodieTableType tableType;
    private TimelineLayoutVersion timelineLayoutVersion;
    protected HoodieTableConfig tableConfig;
    protected HoodieActiveTimeline activeTimeline;
    private ConsistencyGuardConfig consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
    private FileSystemRetryConfig fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().build();
    protected HoodieMetaserverConfig metaserverConfig;

    protected HoodieTableMetaClient(HoodieStorage storage, String basePath, boolean loadActiveTimelineOnLoad, ConsistencyGuardConfig consistencyGuardConfig, Option<TimelineLayoutVersion> layoutVersion, String payloadClassName, String recordMergerStrategy, FileSystemRetryConfig fileSystemRetryConfig) {
        LOG.info("Loading HoodieTableMetaClient from " + basePath);
        this.consistencyGuardConfig = consistencyGuardConfig;
        this.fileSystemRetryConfig = fileSystemRetryConfig;
        this.storageConf = storage.getConf();
        this.storage = storage;
        this.basePath = new StoragePath(basePath);
        this.metaPath = new StoragePath(basePath, METAFOLDER_NAME);
        TableNotFoundException.checkTableValidity(this.storage, this.basePath, this.metaPath);
        this.tableConfig = new HoodieTableConfig(this.storage, this.metaPath, payloadClassName, recordMergerStrategy);
        this.tableType = this.tableConfig.getTableType();
        Option<TimelineLayoutVersion> tableConfigVersion = this.tableConfig.getTimelineLayoutVersion();
        if (layoutVersion.isPresent() && tableConfigVersion.isPresent()) {
            ValidationUtils.checkArgument((((TimelineLayoutVersion)layoutVersion.get()).compareTo((TimelineLayoutVersion)tableConfigVersion.get()) >= 0 ? 1 : 0) != 0, (String)("Layout Version defined in hoodie properties has higher version (" + tableConfigVersion.get() + ") than the one passed in config (" + layoutVersion.get() + ")"));
        }
        this.timelineLayoutVersion = (TimelineLayoutVersion)layoutVersion.orElseGet(() -> (TimelineLayoutVersion)this.tableConfig.getTimelineLayoutVersion().get());
        this.loadActiveTimelineOnLoad = loadActiveTimelineOnLoad;
        LOG.info("Finished Loading Table of type " + (Object)((Object)this.tableType) + "(version=" + this.timelineLayoutVersion + ", baseFileFormat=" + (Object)((Object)this.tableConfig.getBaseFileFormat()) + ") from " + basePath);
        if (loadActiveTimelineOnLoad) {
            LOG.info("Loading Active commit timeline for " + basePath);
            this.getActiveTimeline();
        }
    }

    public HoodieTableMetaClient() {
    }

    public static HoodieTableMetaClient reload(HoodieTableMetaClient oldMetaClient) {
        return HoodieTableMetaClient.builder().setStorage(oldMetaClient.getStorage()).setBasePath(oldMetaClient.basePath.toString()).setLoadActiveTimelineOnLoad(oldMetaClient.loadActiveTimelineOnLoad).setConsistencyGuardConfig(oldMetaClient.consistencyGuardConfig).setLayoutVersion((Option<TimelineLayoutVersion>)Option.of((Object)oldMetaClient.timelineLayoutVersion)).setPayloadClassName(null).setRecordMergerStrategy(null).setFileSystemRetryConfig(oldMetaClient.fileSystemRetryConfig).build();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.storage = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    public StoragePath getBasePathV2() {
        return this.basePath;
    }

    @Deprecated
    public String getBasePath() {
        return this.basePath.toString();
    }

    public HoodieTableType getTableType() {
        return this.tableType;
    }

    public StoragePath getMetaPath() {
        return this.metaPath;
    }

    public String getSchemaFolderName() {
        return new StoragePath(this.metaPath, SCHEMA_FOLDER_NAME).toString();
    }

    public String getHashingMetadataPath() {
        return new StoragePath(this.metaPath, HASHING_METADATA_FOLDER_NAME).toString();
    }

    public String getTempFolderPath() {
        return this.basePath + "/" + TEMPFOLDER_NAME;
    }

    public String getMarkerFolderPath(String instantTs) {
        return String.format("%s%s%s", this.getTempFolderPath(), "/", instantTs);
    }

    public String getMetaAuxiliaryPath() {
        return this.basePath + "/" + AUXILIARYFOLDER_NAME;
    }

    public static String getHeartbeatFolderPath(String basePath) {
        return String.format("%s%s%s", basePath, "/", HEARTBEAT_FOLDER_NAME);
    }

    public String getBootstrapIndexByPartitionFolderPath() {
        return this.basePath + "/" + BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH;
    }

    public String getBootstrapIndexByFileIdFolderNameFolderPath() {
        return this.basePath + "/" + BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH;
    }

    public String getArchivePath() {
        String archiveFolder = this.tableConfig.getArchivelogFolder();
        return this.getMetaPath() + "/" + archiveFolder;
    }

    public HoodieTableConfig getTableConfig() {
        return this.tableConfig;
    }

    public TimelineLayoutVersion getTimelineLayoutVersion() {
        return this.timelineLayoutVersion;
    }

    public HoodieStorage getStorage() {
        if (this.storage == null) {
            this.storage = HoodieTableMetaClient.getStorage(this.metaPath, this.getStorageConf(), this.consistencyGuardConfig, this.fileSystemRetryConfig);
        }
        return this.storage;
    }

    private static HoodieStorage getStorage(StoragePath path, StorageConfiguration<?> storageConf, ConsistencyGuardConfig consistencyGuardConfig, FileSystemRetryConfig fileSystemRetryConfig) {
        HoodieStorage newStorage = HoodieStorageUtils.getStorage(path, storageConf);
        Object consistencyGuard = consistencyGuardConfig.isConsistencyCheckEnabled() ? new FailSafeConsistencyGuard(newStorage, consistencyGuardConfig) : new NoOpConsistencyGuard();
        return HoodieIOFactory.getIOFactory(newStorage).getStorage(path, fileSystemRetryConfig.isFileSystemActionRetryEnable(), fileSystemRetryConfig.getMaxRetryIntervalMs(), fileSystemRetryConfig.getMaxRetryNumbers(), fileSystemRetryConfig.getInitialRetryIntervalMs(), fileSystemRetryConfig.getRetryExceptions(), (ConsistencyGuard)consistencyGuard);
    }

    public void setHoodieStorage(HoodieStorage storage) {
        this.storage = storage;
    }

    public HoodieStorage getRawHoodieStorage() {
        return this.getStorage().getRawStorage();
    }

    public StorageConfiguration<?> getStorageConf() {
        return this.storageConf;
    }

    public synchronized HoodieActiveTimeline getActiveTimeline() {
        if (this.activeTimeline == null) {
            this.activeTimeline = new HoodieActiveTimeline(this);
        }
        return this.activeTimeline;
    }

    public synchronized HoodieActiveTimeline reloadActiveTimeline() {
        this.activeTimeline = new HoodieActiveTimeline(this);
        return this.activeTimeline;
    }

    public ConsistencyGuardConfig getConsistencyGuardConfig() {
        return this.consistencyGuardConfig;
    }

    public FileSystemRetryConfig getFileSystemRetryConfig() {
        return this.fileSystemRetryConfig;
    }

    public synchronized HoodieArchivedTimeline getArchivedTimeline() {
        return this.getArchivedTimeline("");
    }

    public HoodieMetaserverConfig getMetaserverConfig() {
        if (this.metaserverConfig == null) {
            this.metaserverConfig = new HoodieMetaserverConfig();
        }
        return this.metaserverConfig;
    }

    public HoodieArchivedTimeline getArchivedTimeline(String startTs) {
        return this.getArchivedTimeline(startTs, true);
    }

    public HoodieArchivedTimeline getArchivedTimeline(String startTs, boolean useCache) {
        if (useCache) {
            if (!this.archivedTimelineMap.containsKey(startTs)) {
                this.archivedTimelineMap.clear();
                this.archivedTimelineMap.put(startTs, this.instantiateArchivedTimeline(startTs));
            }
            return this.archivedTimelineMap.get(startTs);
        }
        return this.instantiateArchivedTimeline(startTs);
    }

    private HoodieArchivedTimeline instantiateArchivedTimeline(String startTs) {
        return StringUtils.isNullOrEmpty((String)startTs) ? new HoodieArchivedTimeline(this) : new HoodieArchivedTimeline(this, startTs);
    }

    public void validateTableProperties(Properties properties) {
        String bucketEngine;
        String indexType;
        String keyGenClass;
        if (!this.getTableConfig().populateMetaFields() && Boolean.parseBoolean((String)properties.getOrDefault((Object)HoodieTableConfig.POPULATE_META_FIELDS.key(), HoodieTableConfig.POPULATE_META_FIELDS.defaultValue().toString()))) {
            throw new HoodieException(HoodieTableConfig.POPULATE_META_FIELDS.key() + " already disabled for the table. Can't be re-enabled back");
        }
        if (!(this.getTableConfig().populateMetaFields() || (keyGenClass = properties.getProperty(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), "org.apache.hudi.keygen.SimpleKeyGenerator")).equals("org.apache.hudi.keygen.SimpleKeyGenerator") || keyGenClass.equals("org.apache.hudi.keygen.NonpartitionedKeyGenerator") || keyGenClass.equals("org.apache.hudi.keygen.ComplexKeyGenerator"))) {
            throw new HoodieException("Only simple, non-partitioned or complex key generator are supported when meta-fields are disabled. Used: " + keyGenClass);
        }
        if (this.tableType == HoodieTableType.COPY_ON_WRITE && (indexType = properties.getProperty("hoodie.index.type")) != null && indexType.equals("BUCKET") && (bucketEngine = properties.getProperty("hoodie.index.bucket.engine")) != null && bucketEngine.equals("CONSISTENT_HASHING")) {
            throw new HoodieException("Consistent hashing bucket index does not work with COW table. Use simple bucket index or an MOR table.");
        }
    }

    public static HoodieTableMetaClient initTableAndGetMetaClient(StorageConfiguration<?> storageConf, String basePath, Properties props) throws IOException {
        StoragePath auxiliaryFolder;
        StoragePath temporaryFolder;
        StoragePath archiveLogDir;
        String archiveLogPropVal;
        StoragePath schemaPathDir;
        StoragePath metaPathDir;
        LOG.info("Initializing " + basePath + " as hoodie table " + basePath);
        StoragePath basePathDir = new StoragePath(basePath);
        HoodieStorage storage = HoodieStorageUtils.getStorage(basePath, storageConf);
        if (!storage.exists(basePathDir)) {
            storage.createDirectory(basePathDir);
        }
        if (!storage.exists(metaPathDir = new StoragePath(basePath, METAFOLDER_NAME))) {
            storage.createDirectory(metaPathDir);
        }
        if (!storage.exists(schemaPathDir = new StoragePath(metaPathDir, SCHEMA_FOLDER_NAME))) {
            storage.createDirectory(schemaPathDir);
        }
        if (!StringUtils.isNullOrEmpty((String)(archiveLogPropVal = new HoodieConfig(props).getStringOrDefault(HoodieTableConfig.ARCHIVELOG_FOLDER))) && !storage.exists(archiveLogDir = new StoragePath(metaPathDir, archiveLogPropVal))) {
            storage.createDirectory(archiveLogDir);
        }
        if (!storage.exists(temporaryFolder = new StoragePath(basePath, TEMPFOLDER_NAME))) {
            storage.createDirectory(temporaryFolder);
        }
        if (!storage.exists(auxiliaryFolder = new StoragePath(basePath, AUXILIARYFOLDER_NAME))) {
            storage.createDirectory(auxiliaryFolder);
        }
        HoodieTableMetaClient.initializeBootstrapDirsIfNotExists(basePath, storage);
        HoodieTableConfig.create(storage, metaPathDir, props);
        HoodieTableMetaClient metaClient = HoodieTableMetaClient.builder().setConf(storageConf).setBasePath(basePath).setMetaserverConfig(props).build();
        LOG.info("Finished initializing Table of type " + (Object)((Object)metaClient.getTableConfig().getTableType()) + " from " + basePath);
        return metaClient;
    }

    public static void initializeBootstrapDirsIfNotExists(String basePath, HoodieStorage storage) throws IOException {
        StoragePath bootstrap_index_folder_by_fileids;
        StoragePath bootstrap_index_folder_by_partition = new StoragePath(basePath, BOOTSTRAP_INDEX_BY_PARTITION_FOLDER_PATH);
        if (!storage.exists(bootstrap_index_folder_by_partition)) {
            storage.createDirectory(bootstrap_index_folder_by_partition);
        }
        if (!storage.exists(bootstrap_index_folder_by_fileids = new StoragePath(basePath, BOOTSTRAP_INDEX_BY_FILE_ID_FOLDER_PATH))) {
            storage.createDirectory(bootstrap_index_folder_by_fileids);
        }
    }

    public static List<StoragePathInfo> scanFiles(HoodieStorage storage, StoragePath metaPath, StoragePathFilter nameFilter) throws IOException {
        return storage.listDirectEntries(metaPath, nameFilter);
    }

    public boolean isTimelineNonEmpty() {
        return !this.getCommitsTimeline().filterCompletedInstants().empty();
    }

    public HoodieTimeline getCommitsTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: {
                return this.getActiveTimeline().getCommitAndReplaceTimeline();
            }
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getCommitsTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public HoodieTimeline getCommitsAndCompactionTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: {
                return this.getActiveTimeline().getCommitAndReplaceTimeline();
            }
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getWriteTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public HoodieTimeline getCommitTimeline() {
        switch (this.getTableType()) {
            case COPY_ON_WRITE: 
            case MERGE_ON_READ: {
                return this.getActiveTimeline().getCommitAndReplaceTimeline();
            }
        }
        throw new HoodieException("Unsupported table type :" + (Object)((Object)this.getTableType()));
    }

    public String getCommitActionType() {
        return CommitUtils.getCommitActionType(this.getTableType());
    }

    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(Set<String> includedExtensions, boolean applyLayoutVersionFilters) throws IOException {
        return this.scanHoodieInstantsFromFileSystem(this.metaPath, includedExtensions, applyLayoutVersionFilters);
    }

    public List<HoodieInstant> scanHoodieInstantsFromFileSystem(StoragePath timelinePath, Set<String> includedExtensions, boolean applyLayoutVersionFilters) throws IOException {
        Stream<HoodieInstant> instantStream = HoodieTableMetaClient.scanFiles(this.getStorage(), timelinePath, (StoragePathFilter & Serializable)path -> {
            String extension = HoodieInstant.getTimelineFileExtension(path.getName());
            return includedExtensions.contains(extension);
        }).stream().map(HoodieInstant::new);
        if (applyLayoutVersionFilters) {
            instantStream = TimelineLayout.getLayout(this.getTimelineLayoutVersion()).filterHoodieInstants(instantStream);
        }
        return instantStream.sorted().collect(Collectors.toList());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HoodieTableMetaClient that = (HoodieTableMetaClient)o;
        return Objects.equals(this.basePath, that.basePath) && this.tableType == that.tableType;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.basePath, this.tableType});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HoodieTableMetaClient{");
        sb.append("basePath='").append(this.basePath).append('\'');
        sb.append(", metaPath='").append(this.metaPath).append('\'');
        sb.append(", tableType=").append((Object)this.tableType);
        sb.append('}');
        return sb.toString();
    }

    public void initializeBootstrapDirsIfNotExists() throws IOException {
        HoodieTableMetaClient.initializeBootstrapDirsIfNotExists(this.basePath.toString(), this.getStorage());
    }

    private static HoodieTableMetaClient newMetaClient(HoodieStorage storage, String basePath, boolean loadActiveTimelineOnLoad, ConsistencyGuardConfig consistencyGuardConfig, Option<TimelineLayoutVersion> layoutVersion, String payloadClassName, String recordMergerStrategy, FileSystemRetryConfig fileSystemRetryConfig, HoodieMetaserverConfig metaserverConfig) {
        return metaserverConfig.isMetaserverEnabled() ? (HoodieTableMetaClient)ReflectionUtils.loadClass((String)"org.apache.hudi.common.table.HoodieTableMetaserverClient", (Class[])new Class[]{HoodieStorage.class, String.class, ConsistencyGuardConfig.class, String.class, FileSystemRetryConfig.class, Option.class, Option.class, HoodieMetaserverConfig.class}, (Object[])new Object[]{storage, basePath, consistencyGuardConfig, recordMergerStrategy, fileSystemRetryConfig, Option.ofNullable((Object)metaserverConfig.getDatabaseName()), Option.ofNullable((Object)metaserverConfig.getTableName()), metaserverConfig}) : new HoodieTableMetaClient(storage, basePath, loadActiveTimelineOnLoad, consistencyGuardConfig, layoutVersion, payloadClassName, recordMergerStrategy, fileSystemRetryConfig);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static PropertyBuilder withPropertyBuilder() {
        return new PropertyBuilder();
    }

    public static class PropertyBuilder {
        private HoodieTableType tableType;
        private String databaseName;
        private String tableName;
        private String tableCreateSchema;
        private String recordKeyFields;
        private String archiveLogFolder;
        private String payloadClassName;
        private String recordMergerStrategy;
        private Integer timelineLayoutVersion;
        private String baseFileFormat;
        private String preCombineField;
        private String partitionFields;
        private Boolean cdcEnabled;
        private String cdcSupplementalLoggingMode;
        private String bootstrapIndexClass;
        private String bootstrapBasePath;
        private Boolean bootstrapIndexEnable;
        private Boolean populateMetaFields;
        private String keyGeneratorClassProp;
        private Boolean hiveStylePartitioningEnable;
        private Boolean urlEncodePartitioning;
        private HoodieTimelineTimeZone commitTimeZone;
        private Boolean partitionMetafileUseBaseFormat;
        private Boolean shouldDropPartitionColumns;
        private String metadataPartitions;
        private String inflightMetadataPartitions;
        private String secondaryIndexesMetadata;
        private Properties others = new Properties();

        private PropertyBuilder() {
        }

        public PropertyBuilder setTableType(HoodieTableType tableType) {
            this.tableType = tableType;
            return this;
        }

        public PropertyBuilder setTableType(String tableType) {
            return this.setTableType(HoodieTableType.valueOf(tableType));
        }

        public PropertyBuilder setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public PropertyBuilder setTableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public PropertyBuilder setTableCreateSchema(String tableCreateSchema) {
            this.tableCreateSchema = tableCreateSchema;
            return this;
        }

        public PropertyBuilder setRecordKeyFields(String recordKeyFields) {
            this.recordKeyFields = recordKeyFields;
            return this;
        }

        public PropertyBuilder setArchiveLogFolder(String archiveLogFolder) {
            this.archiveLogFolder = archiveLogFolder;
            return this;
        }

        public PropertyBuilder setPayloadClassName(String payloadClassName) {
            this.payloadClassName = payloadClassName;
            return this;
        }

        public PropertyBuilder setRecordMergerStrategy(String recordMergerStrategy) {
            this.recordMergerStrategy = recordMergerStrategy;
            return this;
        }

        public PropertyBuilder setPayloadClass(Class<? extends HoodieRecordPayload> payloadClass) {
            return this.setPayloadClassName(payloadClass.getName());
        }

        public PropertyBuilder setTimelineLayoutVersion(Integer timelineLayoutVersion) {
            this.timelineLayoutVersion = timelineLayoutVersion;
            return this;
        }

        public PropertyBuilder setBaseFileFormat(String baseFileFormat) {
            this.baseFileFormat = baseFileFormat;
            return this;
        }

        public PropertyBuilder setPreCombineField(String preCombineField) {
            this.preCombineField = preCombineField;
            return this;
        }

        public PropertyBuilder setPartitionFields(String partitionFields) {
            this.partitionFields = partitionFields;
            return this;
        }

        public PropertyBuilder setCDCEnabled(boolean cdcEnabled) {
            this.cdcEnabled = cdcEnabled;
            return this;
        }

        public PropertyBuilder setCDCSupplementalLoggingMode(String cdcSupplementalLoggingMode) {
            this.cdcSupplementalLoggingMode = cdcSupplementalLoggingMode.toUpperCase();
            return this;
        }

        public PropertyBuilder setBootstrapIndexClass(String bootstrapIndexClass) {
            this.bootstrapIndexClass = bootstrapIndexClass;
            return this;
        }

        public PropertyBuilder setBootstrapBasePath(String bootstrapBasePath) {
            this.bootstrapBasePath = bootstrapBasePath;
            return this;
        }

        public PropertyBuilder setBootstrapIndexEnable(Boolean bootstrapIndexEnable) {
            this.bootstrapIndexEnable = bootstrapIndexEnable;
            return this;
        }

        public PropertyBuilder setPopulateMetaFields(boolean populateMetaFields) {
            this.populateMetaFields = populateMetaFields;
            return this;
        }

        public PropertyBuilder setKeyGeneratorClassProp(String keyGeneratorClassProp) {
            this.keyGeneratorClassProp = keyGeneratorClassProp;
            return this;
        }

        public PropertyBuilder setHiveStylePartitioningEnable(Boolean hiveStylePartitioningEnable) {
            this.hiveStylePartitioningEnable = hiveStylePartitioningEnable;
            return this;
        }

        public PropertyBuilder setUrlEncodePartitioning(Boolean urlEncodePartitioning) {
            this.urlEncodePartitioning = urlEncodePartitioning;
            return this;
        }

        public PropertyBuilder setCommitTimezone(HoodieTimelineTimeZone timelineTimeZone) {
            this.commitTimeZone = timelineTimeZone;
            return this;
        }

        public PropertyBuilder setPartitionMetafileUseBaseFormat(Boolean useBaseFormat) {
            this.partitionMetafileUseBaseFormat = useBaseFormat;
            return this;
        }

        public PropertyBuilder setShouldDropPartitionColumns(Boolean shouldDropPartitionColumns) {
            this.shouldDropPartitionColumns = shouldDropPartitionColumns;
            return this;
        }

        public PropertyBuilder setMetadataPartitions(String partitions) {
            this.metadataPartitions = partitions;
            return this;
        }

        public PropertyBuilder setInflightMetadataPartitions(String partitions) {
            this.inflightMetadataPartitions = partitions;
            return this;
        }

        public PropertyBuilder setSecondaryIndexesMetadata(String secondaryIndexesMetadata) {
            this.secondaryIndexesMetadata = secondaryIndexesMetadata;
            return this;
        }

        public PropertyBuilder set(Map<String, Object> props) {
            for (ConfigProperty<String> configProperty : HoodieTableConfig.PERSISTED_CONFIG_LIST) {
                String value;
                if (!ConfigUtils.containsConfigProperty(props, configProperty) || (value = ConfigUtils.getStringWithAltKeys(props, configProperty)) == null) continue;
                this.others.put(configProperty.key(), value);
            }
            return this;
        }

        public PropertyBuilder fromMetaClient(HoodieTableMetaClient metaClient) {
            return this.setTableType(metaClient.getTableType()).setTableName(metaClient.getTableConfig().getTableName()).setArchiveLogFolder(metaClient.getArchivePath()).setPayloadClassName(metaClient.getTableConfig().getPayloadClass()).setRecordMergerStrategy(metaClient.getTableConfig().getRecordMergerStrategy());
        }

        public PropertyBuilder fromProperties(Properties properties) {
            HoodieConfig hoodieConfig = new HoodieConfig(properties);
            for (ConfigProperty<String> configProperty : HoodieTableConfig.PERSISTED_CONFIG_LIST) {
                String value;
                if (!hoodieConfig.contains(configProperty) || (value = hoodieConfig.getString(configProperty)) == null) continue;
                this.others.put(configProperty.key(), value);
            }
            if (hoodieConfig.contains(HoodieTableConfig.DATABASE_NAME)) {
                this.setDatabaseName(hoodieConfig.getString(HoodieTableConfig.DATABASE_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.NAME)) {
                this.setTableName(hoodieConfig.getString(HoodieTableConfig.NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TYPE)) {
                this.setTableType(hoodieConfig.getString(HoodieTableConfig.TYPE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.ARCHIVELOG_FOLDER)) {
                this.setArchiveLogFolder(hoodieConfig.getString(HoodieTableConfig.ARCHIVELOG_FOLDER));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PAYLOAD_CLASS_NAME)) {
                this.setPayloadClassName(hoodieConfig.getString(HoodieTableConfig.PAYLOAD_CLASS_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.RECORD_MERGER_STRATEGY)) {
                this.setRecordMergerStrategy(hoodieConfig.getString(HoodieTableConfig.RECORD_MERGER_STRATEGY));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TIMELINE_LAYOUT_VERSION)) {
                this.setTimelineLayoutVersion(hoodieConfig.getInt(HoodieTableConfig.TIMELINE_LAYOUT_VERSION));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BASE_FILE_FORMAT)) {
                this.setBaseFileFormat(hoodieConfig.getString(HoodieTableConfig.BASE_FILE_FORMAT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME)) {
                this.setBootstrapIndexClass(hoodieConfig.getString(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_BASE_PATH)) {
                this.setBootstrapBasePath(hoodieConfig.getString(HoodieTableConfig.BOOTSTRAP_BASE_PATH));
            }
            if (hoodieConfig.contains(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE)) {
                this.setBootstrapIndexEnable(hoodieConfig.getBoolean(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PRECOMBINE_FIELD)) {
                this.setPreCombineField(hoodieConfig.getString(HoodieTableConfig.PRECOMBINE_FIELD));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PARTITION_FIELDS)) {
                this.setPartitionFields(hoodieConfig.getString(HoodieTableConfig.PARTITION_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.RECORDKEY_FIELDS)) {
                this.setRecordKeyFields(hoodieConfig.getString(HoodieTableConfig.RECORDKEY_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.CDC_ENABLED)) {
                this.setCDCEnabled(hoodieConfig.getBoolean(HoodieTableConfig.CDC_ENABLED));
            }
            if (hoodieConfig.contains(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE)) {
                this.setCDCSupplementalLoggingMode(hoodieConfig.getString(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.CREATE_SCHEMA)) {
                this.setTableCreateSchema(hoodieConfig.getString(HoodieTableConfig.CREATE_SCHEMA));
            }
            if (hoodieConfig.contains(HoodieTableConfig.POPULATE_META_FIELDS)) {
                this.setPopulateMetaFields(hoodieConfig.getBoolean(HoodieTableConfig.POPULATE_META_FIELDS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME)) {
                this.setKeyGeneratorClassProp(hoodieConfig.getString(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME));
            }
            if (hoodieConfig.contains(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE)) {
                this.setHiveStylePartitioningEnable(hoodieConfig.getBoolean(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE));
            }
            if (hoodieConfig.contains(HoodieTableConfig.URL_ENCODE_PARTITIONING)) {
                this.setUrlEncodePartitioning(hoodieConfig.getBoolean(HoodieTableConfig.URL_ENCODE_PARTITIONING));
            }
            if (hoodieConfig.contains(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT)) {
                this.setPartitionMetafileUseBaseFormat(hoodieConfig.getBoolean(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.DROP_PARTITION_COLUMNS)) {
                this.setShouldDropPartitionColumns(hoodieConfig.getBoolean(HoodieTableConfig.DROP_PARTITION_COLUMNS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TABLE_METADATA_PARTITIONS)) {
                this.setMetadataPartitions(hoodieConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS));
            }
            if (hoodieConfig.contains(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT)) {
                this.setInflightMetadataPartitions(hoodieConfig.getString(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT));
            }
            if (hoodieConfig.contains(HoodieTableConfig.SECONDARY_INDEXES_METADATA)) {
                this.setSecondaryIndexesMetadata(hoodieConfig.getString(HoodieTableConfig.SECONDARY_INDEXES_METADATA));
            }
            return this;
        }

        public Properties build() {
            ValidationUtils.checkArgument((this.tableType != null ? 1 : 0) != 0, (String)"tableType is null");
            ValidationUtils.checkArgument((this.tableName != null ? 1 : 0) != 0, (String)"tableName is null");
            HoodieTableConfig tableConfig = new HoodieTableConfig();
            tableConfig.setAll(this.others);
            if (this.databaseName != null) {
                tableConfig.setValue(HoodieTableConfig.DATABASE_NAME, this.databaseName);
            }
            tableConfig.setValue(HoodieTableConfig.NAME, this.tableName);
            tableConfig.setValue(HoodieTableConfig.TYPE, this.tableType.name());
            tableConfig.setValue(HoodieTableConfig.VERSION, String.valueOf(HoodieTableVersion.current().versionCode()));
            if (this.tableType == HoodieTableType.MERGE_ON_READ && this.payloadClassName != null) {
                tableConfig.setValue(HoodieTableConfig.PAYLOAD_CLASS_NAME, this.payloadClassName);
            }
            if (this.tableType == HoodieTableType.MERGE_ON_READ && this.recordMergerStrategy != null) {
                tableConfig.setValue(HoodieTableConfig.RECORD_MERGER_STRATEGY, this.recordMergerStrategy);
            }
            if (null != this.tableCreateSchema) {
                tableConfig.setValue(HoodieTableConfig.CREATE_SCHEMA, this.tableCreateSchema);
            }
            if (!StringUtils.isNullOrEmpty((String)this.archiveLogFolder)) {
                tableConfig.setValue(HoodieTableConfig.ARCHIVELOG_FOLDER, this.archiveLogFolder);
            } else {
                tableConfig.setDefaultValue(HoodieTableConfig.ARCHIVELOG_FOLDER);
            }
            if (null != this.timelineLayoutVersion) {
                tableConfig.setValue(HoodieTableConfig.TIMELINE_LAYOUT_VERSION, String.valueOf(this.timelineLayoutVersion));
            }
            if (null != this.baseFileFormat) {
                tableConfig.setValue(HoodieTableConfig.BASE_FILE_FORMAT, this.baseFileFormat.toUpperCase());
            }
            if (null != this.bootstrapIndexClass) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_INDEX_CLASS_NAME, this.bootstrapIndexClass);
            }
            if (null != this.bootstrapIndexEnable) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE, Boolean.toString(this.bootstrapIndexEnable));
            }
            if (null != this.bootstrapBasePath) {
                tableConfig.setValue(HoodieTableConfig.BOOTSTRAP_BASE_PATH, this.bootstrapBasePath);
            }
            if (StringUtils.nonEmpty((String)this.preCombineField)) {
                tableConfig.setValue(HoodieTableConfig.PRECOMBINE_FIELD, this.preCombineField);
            }
            if (null != this.partitionFields) {
                tableConfig.setValue(HoodieTableConfig.PARTITION_FIELDS, this.partitionFields);
            }
            if (null != this.recordKeyFields) {
                tableConfig.setValue(HoodieTableConfig.RECORDKEY_FIELDS, this.recordKeyFields);
            }
            if (null != this.cdcEnabled) {
                tableConfig.setValue(HoodieTableConfig.CDC_ENABLED, Boolean.toString(this.cdcEnabled));
                if (this.cdcEnabled.booleanValue() && null != this.cdcSupplementalLoggingMode) {
                    tableConfig.setValue(HoodieTableConfig.CDC_SUPPLEMENTAL_LOGGING_MODE, this.cdcSupplementalLoggingMode);
                }
            }
            if (null != this.populateMetaFields) {
                tableConfig.setValue(HoodieTableConfig.POPULATE_META_FIELDS, Boolean.toString(this.populateMetaFields));
            }
            if (null != this.keyGeneratorClassProp) {
                tableConfig.setValue(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME, this.keyGeneratorClassProp);
            }
            if (null != this.hiveStylePartitioningEnable) {
                tableConfig.setValue(HoodieTableConfig.HIVE_STYLE_PARTITIONING_ENABLE, Boolean.toString(this.hiveStylePartitioningEnable));
            }
            if (null != this.urlEncodePartitioning) {
                tableConfig.setValue(HoodieTableConfig.URL_ENCODE_PARTITIONING, Boolean.toString(this.urlEncodePartitioning));
            }
            if (null != this.commitTimeZone) {
                tableConfig.setValue(HoodieTableConfig.TIMELINE_TIMEZONE, this.commitTimeZone.toString());
            }
            if (null != this.partitionMetafileUseBaseFormat) {
                tableConfig.setValue(HoodieTableConfig.PARTITION_METAFILE_USE_BASE_FORMAT, this.partitionMetafileUseBaseFormat.toString());
            }
            if (null != this.shouldDropPartitionColumns) {
                tableConfig.setValue(HoodieTableConfig.DROP_PARTITION_COLUMNS, Boolean.toString(this.shouldDropPartitionColumns));
            }
            if (null != this.metadataPartitions) {
                tableConfig.setValue(HoodieTableConfig.TABLE_METADATA_PARTITIONS, this.metadataPartitions);
            }
            if (null != this.inflightMetadataPartitions) {
                tableConfig.setValue(HoodieTableConfig.TABLE_METADATA_PARTITIONS_INFLIGHT, this.inflightMetadataPartitions);
            }
            if (null != this.secondaryIndexesMetadata) {
                tableConfig.setValue(HoodieTableConfig.SECONDARY_INDEXES_METADATA, this.secondaryIndexesMetadata);
            }
            return tableConfig.getProps();
        }

        public HoodieTableMetaClient initTable(StorageConfiguration<?> configuration, String basePath) throws IOException {
            return HoodieTableMetaClient.initTableAndGetMetaClient(configuration, basePath, this.build());
        }
    }

    public static class Builder {
        private StorageConfiguration<?> conf;
        private HoodieStorage storage;
        private String basePath;
        private boolean loadActiveTimelineOnLoad = false;
        private String payloadClassName = null;
        private String recordMergerStrategy = null;
        private ConsistencyGuardConfig consistencyGuardConfig = ConsistencyGuardConfig.newBuilder().build();
        private FileSystemRetryConfig fileSystemRetryConfig = FileSystemRetryConfig.newBuilder().build();
        private HoodieMetaserverConfig metaserverConfig = HoodieMetaserverConfig.newBuilder().build();
        private Option<TimelineLayoutVersion> layoutVersion = Option.of((Object)TimelineLayoutVersion.CURR_LAYOUT_VERSION);

        public Builder setConf(StorageConfiguration<?> conf) {
            this.conf = conf;
            return this;
        }

        public Builder setStorage(HoodieStorage storage) {
            this.storage = storage;
            return this;
        }

        public Builder setBasePath(String basePath) {
            this.basePath = basePath;
            return this;
        }

        public Builder setLoadActiveTimelineOnLoad(boolean loadActiveTimelineOnLoad) {
            this.loadActiveTimelineOnLoad = loadActiveTimelineOnLoad;
            return this;
        }

        public Builder setPayloadClassName(String payloadClassName) {
            this.payloadClassName = payloadClassName;
            return this;
        }

        public Builder setRecordMergerStrategy(String recordMergerStrategy) {
            this.recordMergerStrategy = recordMergerStrategy;
            return this;
        }

        public Builder setConsistencyGuardConfig(ConsistencyGuardConfig consistencyGuardConfig) {
            this.consistencyGuardConfig = consistencyGuardConfig;
            return this;
        }

        public Builder setFileSystemRetryConfig(FileSystemRetryConfig fileSystemRetryConfig) {
            this.fileSystemRetryConfig = fileSystemRetryConfig;
            return this;
        }

        public Builder setLayoutVersion(Option<TimelineLayoutVersion> layoutVersion) {
            this.layoutVersion = layoutVersion;
            return this;
        }

        public Builder setMetaserverConfig(Properties props) {
            this.metaserverConfig = new HoodieMetaserverConfig.Builder().fromProperties(props).build();
            return this;
        }

        public Builder setMetaserverConfig(Map<String, String> map) {
            Properties properties = new Properties();
            properties.putAll(map);
            return this.setMetaserverConfig(properties);
        }

        public HoodieTableMetaClient build() {
            ValidationUtils.checkArgument((this.conf != null || this.storage != null ? 1 : 0) != 0, (String)"Storage configuration or HoodieStorage needs to be set to init HoodieTableMetaClient");
            ValidationUtils.checkArgument((this.basePath != null ? 1 : 0) != 0, (String)"basePath needs to be set to init HoodieTableMetaClient");
            if (this.storage == null) {
                this.storage = HoodieTableMetaClient.getStorage(new StoragePath(this.basePath), this.conf, this.consistencyGuardConfig, this.fileSystemRetryConfig);
            }
            return HoodieTableMetaClient.newMetaClient(this.storage, this.basePath, this.loadActiveTimelineOnLoad, this.consistencyGuardConfig, (Option<TimelineLayoutVersion>)this.layoutVersion, this.payloadClassName, this.recordMergerStrategy, this.fileSystemRetryConfig, this.metaserverConfig);
        }
    }
}

