/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model.debezium;

import java.io.IOException;
import java.util.Objects;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.debezium.AbstractDebeziumAvroPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.exception.HoodieDebeziumAvroPayloadException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MySqlDebeziumAvroPayload
extends AbstractDebeziumAvroPayload {
    private static final Logger LOG = LoggerFactory.getLogger(MySqlDebeziumAvroPayload.class);

    public MySqlDebeziumAvroPayload(GenericRecord record, Comparable orderingVal) {
        super(record, orderingVal);
    }

    public MySqlDebeziumAvroPayload(Option<GenericRecord> record) {
        super(record);
    }

    private Option<String> extractSeq(IndexedRecord record) {
        Object value = ((GenericRecord)record).get("_event_seq");
        return Option.ofNullable((Object)Objects.toString(value, null));
    }

    @Override
    protected boolean shouldPickCurrentRecord(IndexedRecord currentRecord, IndexedRecord insertRecord, Schema schema) throws IOException {
        String insertSourceSeq = (String)this.extractSeq(insertRecord).orElseThrow(() -> new HoodieDebeziumAvroPayloadException(String.format("%s cannot be null in insert record: %s", "_event_seq", insertRecord)));
        Option<String> currentSourceSeqOpt = this.extractSeq(currentRecord);
        if (!currentSourceSeqOpt.isPresent()) {
            return false;
        }
        String[] currentFilePos = ((String)currentSourceSeqOpt.get()).split("\\.");
        String[] insertFilePos = insertSourceSeq.split("\\.");
        long currentFileNum = Long.valueOf(currentFilePos[0]);
        long insertFileNum = Long.valueOf(insertFilePos[0]);
        if (insertFileNum < currentFileNum) {
            return true;
        }
        if (insertFileNum > currentFileNum) {
            return false;
        }
        Long currentPos = Long.valueOf(currentFilePos[1]);
        Long insertPos = Long.valueOf(insertFilePos[1]);
        return insertPos <= currentPos;
    }
}

