/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io.storage;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.function.Function;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.compress.Compression;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.io.hfile.HFileContext;
import org.apache.hadoop.hbase.io.hfile.HFileContextBuilder;
import org.apache.hadoop.io.Writable;
import org.apache.hudi.common.util.StringUtils;

public class TestHoodieReaderWriterUtils {
    public static void writeHFileForTesting(String fileLocation, int blockSize, Compression.Algorithm compressionAlgo, int numEntries, Function<Integer, String> keyCreator, Function<Integer, String> valueCreator, boolean uniqueKeys) throws IOException {
        HFileContext context = new HFileContextBuilder().withBlockSize(blockSize).withCompression(compressionAlgo).build();
        Configuration conf = new Configuration();
        CacheConfig cacheConfig = new CacheConfig(conf);
        Path filePath = new Path(fileLocation);
        FileSystem fs = filePath.getFileSystem(conf);
        try (HFile.Writer writer = HFile.getWriterFactory((Configuration)conf, (CacheConfig)cacheConfig).withPath(fs, filePath).withFileContext(context).create();){
            for (int i = 0; i < numEntries; ++i) {
                byte[] keyBytes = StringUtils.getUTF8Bytes((String)keyCreator.apply(i));
                writer.append((Cell)new KeyValue(keyBytes, null, null, StringUtils.getUTF8Bytes((String)valueCreator.apply(i))));
                if (uniqueKeys) continue;
                for (int j = 0; j < 20; ++j) {
                    writer.append((Cell)new KeyValue(keyBytes, null, null, StringUtils.getUTF8Bytes((String)(valueCreator.apply(i) + "_" + j))));
                }
            }
            writer.appendFileInfo(StringUtils.getUTF8Bytes((String)"hudi_hfile_testing.custom_key"), StringUtils.getUTF8Bytes((String)"hudi_custom_value"));
            writer.appendMetaBlock("bloomFilter", new Writable(){

                public void write(DataOutput out) throws IOException {
                    out.write(StringUtils.getUTF8Bytes((String)"/////wAAABQBAAABID797Rg6cC9QEnS/mT3C01cdQGaLYH2jbOCLtMA0RWppEH1HQg=="));
                }

                public void readFields(DataInput in) throws IOException {
                }
            });
        }
    }
}

