/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import javax.xml.bind.DatatypeConverter;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.hash.HashID;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.EnumSource;

public class TestHashID {
    @ParameterizedTest
    @EnumSource(value=HashID.Size.class)
    public void testHashForByteInput(HashID.Size size) {
        int count = 8;
        Random random = new Random();
        for (int i = 0; i < 8; ++i) {
            String message = random.ints(50, 120).filter(j -> !(j > 57 && j < 65 || j > 90 && j < 97)).limit(32 + i * 4).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            byte[] originalData = StringUtils.getUTF8Bytes((String)message);
            byte[] hashBytes = HashID.hash((byte[])originalData, (HashID.Size)size);
            Assertions.assertEquals((int)hashBytes.length, (int)size.byteSize());
        }
    }

    @ParameterizedTest
    @EnumSource(value=HashID.Size.class)
    public void testHashForStringInput(HashID.Size size) {
        int count = 8;
        Random random = new Random();
        for (int i = 0; i < 8; ++i) {
            String message = random.ints(50, 120).filter(j -> !(j > 57 && j < 65 || j > 90 && j < 97)).limit(32 + i * 4).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append).toString();
            byte[] hashBytes = HashID.hash((String)message, (HashID.Size)size);
            Assertions.assertEquals((int)hashBytes.length, (int)size.byteSize());
        }
    }

    @Test
    public void testHashValues() {
        HashMap<HashID.Size, HashMap> expectedValuesMap = new HashMap<HashID.Size, HashMap>();
        HashMap<String, String> hash32ExpectedValues = new HashMap<String, String>(){
            {
                this.put("Hudi", "FB6A3F92");
                this.put("Data lake", "99913A4D");
                this.put("Data Lake", "6F7DAD6A");
                this.put("Col1", "B4393B9A");
                this.put("A", "CDD946CE");
                this.put("2021/10/28/", "BBD4FDB2");
            }
        };
        expectedValuesMap.put(HashID.Size.BITS_32, hash32ExpectedValues);
        HashMap<String, String> hash64ExpectedValues = new HashMap<String, String>(){
            {
                this.put("Hudi", "F7727B9A28379071");
                this.put("Data lake", "52BC72D592EBCAE5");
                this.put("Data Lake", "5ED19AF9FD746E3E");
                this.put("Col1", "22FB1DD2F4784D31");
                this.put("A", "EBF88350484B5AA7");
                this.put("2021/10/28/", "2A9399AF6E7C8B12");
            }
        };
        expectedValuesMap.put(HashID.Size.BITS_128, hash64ExpectedValues);
        HashMap<String, String> hash128ExpectedValues = new HashMap<String, String>(){
            {
                this.put("Hudi", "09DAB749F255311C1C9EF6DD7B790170");
                this.put("Data lake", "7F2FC1EA445FC81F67CAA25EC9089C08");
                this.put("Data Lake", "9D2CEF0D61B02848C528A070ED75C570");
                this.put("Col1", "EC0FFE21E704DE2A580661C59A81D453");
                this.put("A", "7FC56270E7A70FA81A5935B72EACBE29");
                this.put("2021/10/28/", "1BAE8F04F44CB7ACF2458EF5219742DC");
            }
        };
        expectedValuesMap.put(HashID.Size.BITS_128, hash128ExpectedValues);
        for (Map.Entry allSizeEntries : expectedValuesMap.entrySet()) {
            for (Map.Entry sizeEntry : ((Map)allSizeEntries.getValue()).entrySet()) {
                byte[] actualHashBytes = HashID.hash((String)((String)sizeEntry.getKey()), (HashID.Size)((HashID.Size)allSizeEntries.getKey()));
                byte[] expectedHashBytes = DatatypeConverter.parseHexBinary((String)((String)sizeEntry.getValue()));
                Assertions.assertTrue((boolean)Arrays.equals(expectedHashBytes, actualHashBytes));
            }
        }
    }
}

