/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.hudi.common.util.MapUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

class TestMapUtils {
    TestMapUtils() {
    }

    private static Stream<Arguments> containsAllArgs() {
        HashMap<String, String> m0 = new HashMap<String, String>();
        m0.put("k0", "v0");
        m0.put("k1", "v1");
        m0.put("k2", "v2");
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put("k1", "v1");
        HashMap<String, String> m2 = new HashMap<String, String>();
        m2.put("k2", "v2");
        m2.put("k", "v");
        Map m3 = Collections.emptyMap();
        HashMap<String, Object> m4 = new HashMap<String, Object>();
        m4.put("k0", null);
        HashMap<String, Integer> m5 = new HashMap<String, Integer>();
        m5.put("k0", 0);
        ArrayList<Arguments> argsList = new ArrayList<Arguments>();
        argsList.add(Arguments.of((Object[])new Object[]{m0, m1, true}));
        argsList.add(Arguments.of((Object[])new Object[]{m0, m3, true}));
        argsList.add(Arguments.of((Object[])new Object[]{m5, m3, true}));
        argsList.add(Arguments.of((Object[])new Object[]{m0, m4, false}));
        argsList.add(Arguments.of((Object[])new Object[]{m0, m2, false}));
        argsList.add(Arguments.of((Object[])new Object[]{m0, m5, false}));
        return argsList.stream();
    }

    @ParameterizedTest
    @MethodSource(value={"containsAllArgs"})
    void containsAll(Map<?, ?> m1, Map<?, ?> m2, boolean expectedResult) {
        Assertions.assertEquals((Object)expectedResult, (Object)MapUtils.containsAll(m1, m2));
    }
}

