/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecordMerger;
import org.apache.hudi.common.model.HoodieRecordMerger;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.HoodieRecordUtils;
import org.apache.hudi.exception.HoodieException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHoodieRecordUtils {
    TestHoodieRecordUtils() {
    }

    @Test
    void loadHoodieMerge() {
        String mergeClassName = HoodieAvroRecordMerger.class.getName();
        HoodieRecordMerger recordMerger1 = HoodieRecordUtils.loadRecordMerger((String)mergeClassName);
        HoodieRecordMerger recordMerger2 = HoodieRecordUtils.loadRecordMerger((String)mergeClassName);
        Assertions.assertEquals((Object)recordMerger1.getClass().getName(), (Object)mergeClassName);
        Assertions.assertEquals((Object)recordMerger1, (Object)recordMerger2);
    }

    @Test
    void loadHoodieMergeWithWrongMerger() {
        String mergeClassName = "wrong.package.MergerName";
        Assertions.assertThrows(HoodieException.class, () -> HoodieRecordUtils.loadRecordMerger((String)mergeClassName));
    }

    @Test
    void loadPayload() {
        String payloadClassName = DefaultHoodieRecordPayload.class.getName();
        HoodieRecordPayload payload = HoodieRecordUtils.loadPayload((String)payloadClassName, (Object[])new Object[]{null, 0}, (Class[])new Class[]{GenericRecord.class, Comparable.class});
        Assertions.assertEquals((Object)payload.getClass().getName(), (Object)payloadClassName);
    }
}

