/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.util.Option;

public class SpillableMapTestUtils {
    public static final String DUMMY_COMMIT_TIME = "DUMMY_COMMIT_TIME";
    public static final String DUMMY_FILE_ID = "DUMMY_FILE_ID";

    public static List<String> upsertRecords(List<IndexedRecord> iRecords, Map<String, HoodieRecord<? extends HoodieRecordPayload>> records) {
        ArrayList<String> recordKeys = new ArrayList<String>();
        iRecords.forEach(r -> {
            String key = ((GenericRecord)r).get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString();
            String partitionPath = ((GenericRecord)r).get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString();
            recordKeys.add(key);
            HoodieAvroRecord record = new HoodieAvroRecord(new HoodieKey(key, partitionPath), (HoodieRecordPayload)new HoodieAvroPayload(Option.of((Object)((GenericRecord)r))));
            record.unseal();
            record.setCurrentLocation(new HoodieRecordLocation(DUMMY_COMMIT_TIME, DUMMY_FILE_ID));
            record.seal();
            records.put(key, (HoodieRecord<? extends HoodieRecordPayload>)record);
        });
        return recordKeys;
    }
}

