/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.InflaterInputStream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.io.JsonEncoder;
import org.apache.avro.specific.SpecificDatumWriter;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.MercifulJsonConverter;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.FileIOUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.collection.Pair;

public class RawTripTestPayload
implements HoodieRecordPayload<RawTripTestPayload> {
    public static final String JSON_DATA_SCHEMA_STR = "{\"type\":\"record\",\"name\":\"triprec\",\"fields\":[{\"name\":\"number\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"time\",\"type\":\"string\"}]}";
    public static final Schema JSON_DATA_SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"triprec\",\"fields\":[{\"name\":\"number\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"time\",\"type\":\"string\"}]}");
    private static final MercifulJsonConverter JSON_CONVERTER = new MercifulJsonConverter();
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private String partitionPath;
    private String rowKey;
    private byte[] jsonDataCompressed;
    private int dataSize;
    private boolean isDeleted;
    private Comparable orderingVal;

    public RawTripTestPayload(Option<String> jsonData, String rowKey, String partitionPath, String schemaStr, Boolean isDeleted, Comparable orderingVal) throws IOException {
        if (jsonData.isPresent()) {
            this.jsonDataCompressed = this.compressData((String)jsonData.get());
            this.dataSize = ((String)jsonData.get()).length();
        }
        this.rowKey = rowKey;
        this.partitionPath = partitionPath;
        this.isDeleted = isDeleted;
        this.orderingVal = orderingVal;
    }

    public RawTripTestPayload(String jsonData, String rowKey, String partitionPath, String schemaStr) throws IOException {
        this((Option<String>)Option.of((Object)jsonData), rowKey, partitionPath, schemaStr, false, Long.valueOf(0L));
    }

    public RawTripTestPayload(String jsonData) throws IOException {
        this.jsonDataCompressed = this.compressData(jsonData);
        this.dataSize = jsonData.length();
        Map jsonRecordMap = (Map)OBJECT_MAPPER.readValue(jsonData, Map.class);
        this.rowKey = jsonRecordMap.get("_row_key").toString();
        this.partitionPath = RawTripTestPayload.extractPartitionFromTimeField(jsonRecordMap.get("time").toString());
        this.isDeleted = false;
        this.orderingVal = Integer.valueOf(((Object)jsonRecordMap.getOrDefault("number", 0L)).toString());
    }

    public RawTripTestPayload(GenericRecord record, Comparable orderingVal) {
        this.orderingVal = orderingVal;
        try (ByteArrayOutputStream out = new ByteArrayOutputStream();){
            JsonEncoder jsonEncoder = EncoderFactory.get().jsonEncoder(record.getSchema(), (OutputStream)out);
            SpecificDatumWriter w = new SpecificDatumWriter(record.getSchema());
            w.write((Object)record, (Encoder)jsonEncoder);
            jsonEncoder.flush();
            out.flush();
            String jsonData = out.toString("UTF-8");
            Map jsonRecordMap = (Map)OBJECT_MAPPER.readValue(jsonData, Map.class);
            for (Schema.Field f : record.getSchema().getFields()) {
                Object fieldValue = jsonRecordMap.get(f.name());
                if (!(fieldValue instanceof Map)) continue;
                Object unionValue = ((Map)fieldValue).values().iterator().next();
                jsonRecordMap.put(f.name(), unionValue);
            }
            jsonData = OBJECT_MAPPER.writeValueAsString((Object)jsonRecordMap);
            this.jsonDataCompressed = this.compressData(jsonData);
            this.dataSize = jsonData.length();
            this.rowKey = jsonRecordMap.get("_row_key").toString();
            this.partitionPath = RawTripTestPayload.extractPartitionFromTimeField(jsonRecordMap.get("time").toString());
            this.isDeleted = false;
        }
        catch (IOException e) {
            throw new IllegalStateException("Fail to instantiate.", e);
        }
    }

    @Deprecated
    public static List<String> recordsToStrings(List<HoodieRecord> records) {
        return records.stream().map(RawTripTestPayload::recordToString).filter(Option::isPresent).map(Option::get).collect(Collectors.toList());
    }

    public static Option<String> recordToString(HoodieRecord record) {
        try {
            String str = ((RawTripTestPayload)record.getData()).getJsonData();
            str = "{" + str.substring(str.indexOf("\"timestamp\":"));
            str = str.substring(0, str.length() - 1);
            return Option.of((Object)(str + ", \"partition\": \"" + record.getPartitionPath() + "\"}"));
        }
        catch (IOException e) {
            return Option.empty();
        }
    }

    public static List<String> deleteRecordsToStrings(List<HoodieKey> records) {
        return records.stream().map(record -> "{\"_row_key\": \"" + record.getRecordKey() + "\",\"partition\": \"" + record.getPartitionPath() + "\"}").collect(Collectors.toList());
    }

    public static List<HoodieRecord> asDefaultPayloadRecords(List<HoodieRecord> records) throws IOException {
        return RawTripTestPayload.asDefaultPayloadRecords(records, false);
    }

    public static List<HoodieRecord> asDefaultPayloadRecords(List<HoodieRecord> records, boolean isDeleted) throws IOException {
        ArrayList<HoodieRecord> convertedRecords = new ArrayList<HoodieRecord>();
        for (HoodieRecord r : records) {
            GenericRecord avroData = (GenericRecord)((RawTripTestPayload)r.getData()).getRecordToInsert(HoodieTestDataGenerator.AVRO_SCHEMA);
            avroData.put("_hoodie_is_deleted", (Object)isDeleted);
            convertedRecords.add(HoodieAvroUtils.createHoodieRecordFromAvro((IndexedRecord)avroData, (String)DefaultHoodieRecordPayload.class.getName(), (String)"timestamp", (Option)Option.of((Object)Pair.of((Object)"_row_key", (Object)"partition_path")), (Boolean)false, (Option)Option.empty(), (Boolean)false, (Option)Option.of((Object)HoodieTestDataGenerator.AVRO_SCHEMA)));
        }
        return convertedRecords;
    }

    public String getPartitionPath() {
        return this.partitionPath;
    }

    public RawTripTestPayload preCombine(RawTripTestPayload oldValue) {
        if (oldValue.orderingVal.compareTo(this.orderingVal) > 0) {
            return oldValue;
        }
        return this;
    }

    public Option<IndexedRecord> combineAndGetUpdateValue(IndexedRecord oldRec, Schema schema) throws IOException {
        return this.getInsertValue(schema);
    }

    public Option<IndexedRecord> getInsertValue(Schema schema) throws IOException {
        if (this.isDeleted) {
            return Option.empty();
        }
        return Option.of((Object)JSON_CONVERTER.convert(this.getJsonData(), schema));
    }

    public Comparable<?> getOrderingValue() {
        return this.orderingVal;
    }

    public IndexedRecord getRecordToInsert(Schema schema) throws IOException {
        return JSON_CONVERTER.convert(this.getJsonData(), schema);
    }

    public Option<Map<String, String>> getMetadata() {
        HashMap<String, String> metadataMap = new HashMap<String, String>();
        metadataMap.put("InputRecordCount_1506582000", "2");
        return Option.of(metadataMap);
    }

    public String getRowKey() {
        return this.rowKey;
    }

    public String getJsonData() throws IOException {
        return this.unCompressData(this.jsonDataCompressed);
    }

    public Map<String, Object> getJsonDataAsMap() throws IOException {
        return (Map)OBJECT_MAPPER.readValue(this.getJsonData(), Map.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] compressData(String jsonData) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        DeflaterOutputStream dos = new DeflaterOutputStream((OutputStream)baos, new Deflater(9), true);
        try {
            dos.write(StringUtils.getUTF8Bytes((String)jsonData));
        }
        finally {
            dos.flush();
            dos.close();
        }
        return baos.toByteArray();
    }

    private String unCompressData(byte[] data) throws IOException {
        try (InflaterInputStream iis = new InflaterInputStream(new ByteArrayInputStream(data));){
            String string = FileIOUtils.readAsUTFString((InputStream)iis, (int)this.dataSize);
            return string;
        }
    }

    public RawTripTestPayload clone() {
        try {
            return new RawTripTestPayload(this.unCompressData(this.jsonDataCompressed), this.rowKey, this.partitionPath, null);
        }
        catch (IOException e) {
            return null;
        }
    }

    public HoodieRecord toHoodieRecord() {
        return new HoodieAvroRecord(new HoodieKey(this.getRowKey(), this.getPartitionPath()), (HoodieRecordPayload)this);
    }

    public static String extractPartitionFromTimeField(String timeField) {
        return timeField.split("T")[0].replace("-", "/");
    }
}

