/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.JavaSerializer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.DistributedFileSystem;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.ReflectionUtils;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.junit.jupiter.api.Assumptions;

public class HoodieTestUtils {
    public static final String HOODIE_DATABASE = "test_incremental";
    public static final String RAW_TRIPS_TEST_NAME = "raw_trips";
    public static final String DEFAULT_WRITE_TOKEN = "1-0-1";
    public static final int DEFAULT_LOG_VERSION = 1;
    public static final String[] DEFAULT_PARTITION_PATHS = new String[]{"2016/03/15", "2015/03/16", "2015/03/17"};
    public static final String HADOOP_STORAGE_CONF = "org.apache.hudi.storage.hadoop.HadoopStorageConfiguration";

    public static StorageConfiguration<Configuration> getDefaultStorageConf() {
        return (StorageConfiguration)ReflectionUtils.loadClass((String)HADOOP_STORAGE_CONF, (Class[])new Class[]{Boolean.class}, (Object[])new Object[]{false});
    }

    public static StorageConfiguration<Configuration> getDefaultStorageConfWithDefaults() {
        return (StorageConfiguration)ReflectionUtils.loadClass((String)HADOOP_STORAGE_CONF, (Class[])new Class[]{Boolean.class}, (Object[])new Object[]{true});
    }

    public static HoodieStorage getDefaultStorage() {
        return HoodieTestUtils.getStorage("file:///");
    }

    public static HoodieStorage getStorage(String path) {
        return HoodieStorageUtils.getStorage((String)path, HoodieTestUtils.getDefaultStorageConf());
    }

    public static HoodieStorage getStorage(StoragePath path) {
        return HoodieStorageUtils.getStorage((StoragePath)path, HoodieTestUtils.getDefaultStorageConf());
    }

    public static HoodieTableMetaClient init(String basePath) throws IOException {
        return HoodieTestUtils.init(basePath, HoodieTableType.COPY_ON_WRITE);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType) throws IOException {
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultStorageConf(), basePath, tableType);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType, Properties properties) throws IOException {
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultStorageConf(), basePath, tableType, properties);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType, String bootstrapBasePath, boolean bootstrapIndexEnable, String keyGenerator) throws IOException {
        return HoodieTestUtils.init(basePath, tableType, bootstrapBasePath, bootstrapIndexEnable, keyGenerator, "datestr");
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType, String bootstrapBasePath, boolean bootstrapIndexEnable, String keyGenerator, String partitionFieldConfigValue) throws IOException {
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key(), bootstrapBasePath);
        props.put(HoodieTableConfig.BOOTSTRAP_INDEX_ENABLE.key(), (Object)bootstrapIndexEnable);
        if (keyGenerator != null) {
            props.put("hoodie.datasource.write.keygenerator.class", keyGenerator);
        }
        if (keyGenerator != null && !keyGenerator.equals("org.apache.hudi.keygen.NonpartitionedKeyGenerator")) {
            props.put("hoodie.datasource.write.partitionpath.field", partitionFieldConfigValue);
            props.put(HoodieTableConfig.PARTITION_FIELDS.key(), partitionFieldConfigValue);
        }
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultStorageConf(), basePath, tableType, props);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType, String bootstrapBasePath, boolean bootstrapIndexEnable) throws IOException {
        return HoodieTestUtils.init(basePath, tableType, bootstrapBasePath, bootstrapIndexEnable, null);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieFileFormat baseFileFormat) throws IOException {
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultStorageConf(), basePath, HoodieTableType.COPY_ON_WRITE, baseFileFormat);
    }

    public static HoodieTableMetaClient init(StorageConfiguration<?> storageConf, String basePath) throws IOException {
        return HoodieTestUtils.init(storageConf, basePath, HoodieTableType.COPY_ON_WRITE);
    }

    public static HoodieTableMetaClient init(StorageConfiguration<?> storageConf, String basePath, HoodieTableType tableType) throws IOException {
        return HoodieTestUtils.init(storageConf, basePath, tableType, new Properties());
    }

    public static HoodieTableMetaClient init(StorageConfiguration<?> storageConf, String basePath, HoodieTableType tableType, String tableName) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(HoodieTableConfig.NAME.key(), tableName);
        return HoodieTestUtils.init(storageConf, basePath, tableType, properties);
    }

    public static HoodieTableMetaClient init(StorageConfiguration<?> storageConf, String basePath, HoodieTableType tableType, HoodieFileFormat baseFileFormat, String databaseName) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), baseFileFormat.toString());
        return HoodieTestUtils.init(storageConf, basePath, tableType, properties, databaseName);
    }

    public static HoodieTableMetaClient init(StorageConfiguration<?> storageConf, String basePath, HoodieTableType tableType, HoodieFileFormat baseFileFormat) throws IOException {
        return HoodieTestUtils.init(storageConf, basePath, tableType, baseFileFormat, false, null, true);
    }

    public static HoodieTableMetaClient init(StorageConfiguration<?> storageConf, String basePath, HoodieTableType tableType, HoodieFileFormat baseFileFormat, boolean setKeyGen, String keyGenerator, boolean populateMetaFields) throws IOException {
        Properties properties = new Properties();
        properties.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), baseFileFormat.toString());
        if (setKeyGen) {
            properties.setProperty("hoodie.datasource.write.keygenerator.class", keyGenerator);
        }
        properties.setProperty("hoodie.populate.meta.fields", Boolean.toString(populateMetaFields));
        return HoodieTestUtils.init(storageConf, basePath, tableType, properties);
    }

    public static HoodieTableMetaClient init(StorageConfiguration<?> storageConf, String basePath, HoodieTableType tableType, Properties properties) throws IOException {
        return HoodieTestUtils.init(storageConf, basePath, tableType, properties, null);
    }

    public static HoodieTableMetaClient init(StorageConfiguration<?> storageConf, String basePath, HoodieTableType tableType, Properties properties, String databaseName) throws IOException {
        HoodieTableMetaClient.PropertyBuilder builder = HoodieTableMetaClient.withPropertyBuilder().setDatabaseName(databaseName).setTableName(RAW_TRIPS_TEST_NAME).setTableType(tableType).setPayloadClass(HoodieAvroPayload.class);
        String keyGen = properties.getProperty("hoodie.datasource.write.keygenerator.class");
        if (!Objects.equals(keyGen, "org.apache.hudi.keygen.NonpartitionedKeyGenerator") && !properties.containsKey("hoodie.datasource.write.partitionpath.field")) {
            builder.setPartitionFields("some_nonexistent_field");
        }
        Properties processedProperties = builder.fromProperties(properties).build();
        return HoodieTableMetaClient.initTableAndGetMetaClient((StorageConfiguration)storageConf.newInstance(), (String)basePath, (Properties)processedProperties);
    }

    public static HoodieTableMetaClient init(String basePath, HoodieTableType tableType, String bootstrapBasePath, HoodieFileFormat baseFileFormat, String keyGenerator) throws IOException {
        Properties props = new Properties();
        props.setProperty(HoodieTableConfig.BOOTSTRAP_BASE_PATH.key(), bootstrapBasePath);
        props.setProperty(HoodieTableConfig.BASE_FILE_FORMAT.key(), baseFileFormat.name());
        if (keyGenerator != null) {
            props.put("hoodie.datasource.write.keygenerator.class", keyGenerator);
            props.put("hoodie.datasource.write.partitionpath.field", "datestr");
        }
        return HoodieTestUtils.init(HoodieTestUtils.getDefaultStorageConf(), basePath, tableType, props);
    }

    public static HoodieTableMetaClient createMetaClient(StorageConfiguration<?> storageConf, String basePath) {
        return HoodieTableMetaClient.builder().setConf(storageConf).setBasePath(basePath).build();
    }

    public static HoodieTableMetaClient createMetaClient(HoodieStorage storage, String basePath) {
        return HoodieTestUtils.createMetaClient(storage.getConf().newInstance(), basePath);
    }

    public static HoodieTableMetaClient createMetaClient(HoodieEngineContext context, String basePath) {
        return HoodieTestUtils.createMetaClient(context.getStorageConf().newInstance(), basePath);
    }

    public static HoodieTableMetaClient createMetaClient(String basePath) {
        return HoodieTestUtils.createMetaClient(HoodieTestUtils.getDefaultStorageConf(), basePath);
    }

    public static <T extends Serializable> T serializeDeserialize(T object, Class<T> clazz) {
        Kryo kryo = new Kryo();
        kryo.register(HoodieTableMetaClient.class, (Serializer)new JavaSerializer());
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Output output = new Output((OutputStream)baos);
        kryo.writeObject(output, object);
        output.close();
        Input input = new Input((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        Serializable deserializedObject = (Serializable)kryo.readObject(input, clazz);
        input.close();
        return (T)deserializedObject;
    }

    public static List<HoodieWriteStat> generateFakeHoodieWriteStat(int limit) {
        ArrayList<HoodieWriteStat> writeStatList = new ArrayList<HoodieWriteStat>();
        for (int i = 0; i < limit; ++i) {
            HoodieWriteStat writeStat = new HoodieWriteStat();
            writeStat.setFileId(UUID.randomUUID().toString());
            writeStat.setNumDeletes(0L);
            writeStat.setNumUpdateWrites(100L);
            writeStat.setNumWrites(100L);
            writeStat.setPath("/some/fake/path" + i);
            writeStat.setPartitionPath("/some/fake/partition/path" + i);
            writeStat.setTotalLogFilesCompacted(100L);
            HoodieWriteStat.RuntimeStats runtimeStats = new HoodieWriteStat.RuntimeStats();
            runtimeStats.setTotalScanTime(100L);
            runtimeStats.setTotalCreateTime(100L);
            runtimeStats.setTotalUpsertTime(100L);
            writeStat.setRuntimeStats(runtimeStats);
            writeStatList.add(writeStat);
        }
        return writeStatList;
    }

    public static void createCompactionCommitInMetadataTable(StorageConfiguration<?> storageConf, String basePath, String instantTime) throws IOException {
        String metadataTableBasePath = HoodieTableMetadata.getMetadataTableBasePath((String)basePath);
        HoodieTestUtils.init(storageConf, metadataTableBasePath, HoodieTableType.MERGE_ON_READ);
        HoodieTestDataGenerator.createCommitFile(metadataTableBasePath, instantTime + "001", storageConf);
    }

    public static int getJavaVersion() {
        String version = System.getProperty("java.version");
        if (version.startsWith("1.")) {
            version = version.substring(2, 3);
        } else {
            int dot = version.indexOf(".");
            if (dot != -1) {
                version = version.substring(0, dot);
            }
        }
        return Integer.parseInt(version);
    }

    public static boolean shouldUseExternalHdfs() {
        return HoodieTestUtils.getJavaVersion() == 11 || HoodieTestUtils.getJavaVersion() == 17;
    }

    public static DistributedFileSystem useExternalHdfs() throws IOException {
        Assumptions.assumeTrue((boolean)Boolean.valueOf(System.getProperty("use.external.hdfs", "false")));
        Configuration conf = new Configuration();
        conf.set("fs.defaultFS", "hdfs://localhost:9000");
        conf.set("dfs.replication", "3");
        return (DistributedFileSystem)DistributedFileSystem.get((Configuration)conf);
    }
}

