/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieCompactionPlan;
import org.apache.hudi.common.model.HoodieAvroPayload;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.common.model.HoodiePartitionMetadata;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimelineMetadataUtils;
import org.apache.hudi.common.testutils.RawTripTestPayload;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.HoodieStorageUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.StoragePath;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieTestDataGenerator
implements AutoCloseable {
    private boolean makeDatesAmbiguous = false;
    public static final int BYTES_PER_RECORD = 1228;
    public static final int BLOOM_FILTER_BYTES = 323495;
    private static Logger logger = LoggerFactory.getLogger(HoodieTestDataGenerator.class);
    public static final String NO_PARTITION_PATH = "";
    public static final String DEFAULT_FIRST_PARTITION_PATH = "2016/03/15";
    public static final String DEFAULT_SECOND_PARTITION_PATH = "2015/03/16";
    public static final String DEFAULT_THIRD_PARTITION_PATH = "2015/03/17";
    public static final String[] DEFAULT_PARTITION_PATHS = new String[]{"2016/03/15", "2015/03/16", "2015/03/17"};
    public static final int DEFAULT_PARTITION_DEPTH = 3;
    public static final String TRIP_TYPE_ENUM_TYPE = "{\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}";
    public static final Schema TRIP_TYPE_ENUM_SCHEMA = new Schema.Parser().parse("{\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}");
    public static final String TRIP_SCHEMA_PREFIX = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},";
    public static final String TRIP_SCHEMA_SUFFIX = "{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String FARE_NESTED_SCHEMA = "{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},";
    public static final String FARE_FLATTENED_SCHEMA = "{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},";
    public static final String TIP_NESTED_SCHEMA = "{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},";
    public static final String MAP_TYPE_SCHEMA = "{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},";
    public static final String EXTRA_TYPE_SCHEMA = "{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},";
    public static final String TRIP_EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_FLATTENED_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_NESTED_EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}";
    public static final String TRIP_SCHEMA = "{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
    public static final String SHORT_TRIP_SCHEMA = "{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}";
    public static final String NULL_SCHEMA = Schema.create((Schema.Type)Schema.Type.NULL).toString();
    public static final String TRIP_HIVE_COLUMN_TYPES = "bigint,string,string,string,string,string,double,double,double,double,int,bigint,float,binary,int,bigint,decimal(10,6),map<string,string>,struct<amount:double,currency:string>,array<struct<amount:double,currency:string>>,boolean";
    public static final Schema AVRO_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema NESTED_AVRO_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    public static final Schema AVRO_SCHEMA_WITH_METADATA_FIELDS = HoodieAvroUtils.addMetadataFields((Schema)AVRO_SCHEMA);
    public static final Schema AVRO_SHORT_TRIP_SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}");
    public static final Schema AVRO_TRIP_SCHEMA = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}");
    public static final Schema FLATTENED_AVRO_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    private final Random rand;
    private final Map<String, Map<Integer, KeyPartition>> existingKeysBySchema;
    private final String[] partitionPaths;
    private Map<String, Integer> numKeysBySchema;

    public HoodieTestDataGenerator(long seed) {
        this(seed, DEFAULT_PARTITION_PATHS, new HashMap<Integer, KeyPartition>());
    }

    public HoodieTestDataGenerator(String schema, long seed) {
        this(schema, seed, DEFAULT_PARTITION_PATHS, new HashMap<Integer, KeyPartition>());
    }

    public HoodieTestDataGenerator(long seed, String[] partitionPaths, Map<Integer, KeyPartition> keyPartitionMap) {
        this(TRIP_EXAMPLE_SCHEMA, seed, partitionPaths, keyPartitionMap);
    }

    public HoodieTestDataGenerator(String schema, long seed, String[] partitionPaths, Map<Integer, KeyPartition> keyPartitionMap) {
        this.rand = new Random(seed);
        this.partitionPaths = Arrays.copyOf(partitionPaths, partitionPaths.length);
        this.existingKeysBySchema = new HashMap<String, Map<Integer, KeyPartition>>();
        this.existingKeysBySchema.put(schema, keyPartitionMap);
        this.numKeysBySchema = new HashMap<String, Integer>();
        this.numKeysBySchema.put(schema, keyPartitionMap.size());
        logger.info(String.format("Test DataGenerator's seed (%s)", seed));
    }

    @Deprecated
    public HoodieTestDataGenerator(String[] partitionPaths) {
        this(partitionPaths, new HashMap<Integer, KeyPartition>());
    }

    @Deprecated
    public HoodieTestDataGenerator() {
        this(DEFAULT_PARTITION_PATHS);
    }

    public static HoodieTestDataGenerator createTestGeneratorFirstPartition() {
        return new HoodieTestDataGenerator(new String[]{DEFAULT_FIRST_PARTITION_PATH});
    }

    public static HoodieTestDataGenerator createTestGeneratorSecondPartition() {
        return new HoodieTestDataGenerator(new String[]{DEFAULT_SECOND_PARTITION_PATH});
    }

    public static HoodieTestDataGenerator createTestGeneratorThirdPartition() {
        return new HoodieTestDataGenerator(new String[]{DEFAULT_THIRD_PARTITION_PATH});
    }

    public HoodieTestDataGenerator(boolean makeDatesAmbiguous) {
        this();
        this.makeDatesAmbiguous = makeDatesAmbiguous;
    }

    @Deprecated
    public HoodieTestDataGenerator(String[] partitionPaths, Map<Integer, KeyPartition> keyPartitionMap) {
        this(System.nanoTime(), partitionPaths, keyPartitionMap);
    }

    public static Long getNextCommitTime(long curCommitTime) {
        if ((curCommitTime + 1L) % 1000000000000L >= 60L) {
            return Long.parseLong(HoodieActiveTimeline.createNewInstantTime());
        }
        return curCommitTime + 1L;
    }

    public static String getCommitTimeAtUTC(long epochSecond) {
        return HoodieInstantTimeGenerator.getInstantFromTemporalAccessor((TemporalAccessor)Instant.ofEpochSecond(epochSecond).atZone(ZoneOffset.UTC));
    }

    public static void writePartitionMetadataDeprecated(HoodieStorage storage, String[] partitionPaths, String basePath) {
        new HoodieTestDataGenerator().writePartitionMetadata(storage, partitionPaths, basePath);
    }

    public void writePartitionMetadata(HoodieStorage storage, String[] partitionPaths, String basePath) {
        for (String partitionPath : partitionPaths) {
            new HoodiePartitionMetadata(storage, "000", new StoragePath(basePath), new StoragePath(basePath, partitionPath), Option.empty()).trySave();
        }
    }

    public int getEstimatedFileSizeInBytes(int numOfRecords) {
        return numOfRecords * 1228 + 323495;
    }

    public RawTripTestPayload generateRandomValueAsPerSchema(String schemaStr, HoodieKey key, String commitTime, boolean isFlattened) throws IOException {
        if (TRIP_EXAMPLE_SCHEMA.equals(schemaStr)) {
            return this.generateRandomValue(key, commitTime, isFlattened);
        }
        if (TRIP_SCHEMA.equals(schemaStr)) {
            return this.generatePayloadForTripSchema(key, commitTime);
        }
        if (SHORT_TRIP_SCHEMA.equals(schemaStr)) {
            return this.generatePayloadForShortTripSchema(key, commitTime);
        }
        if (TRIP_NESTED_EXAMPLE_SCHEMA.equals(schemaStr)) {
            return this.generateNestedExampleRandomValue(key, commitTime);
        }
        return null;
    }

    public RawTripTestPayload generateRandomValue(HoodieKey key, String instantTime) throws IOException {
        return this.generateRandomValue(key, instantTime, false);
    }

    private RawTripTestPayload generateRandomValue(HoodieKey key, String instantTime, boolean isFlattened) throws IOException {
        return this.generateRandomValue(key, instantTime, isFlattened, 0L);
    }

    private RawTripTestPayload generateNestedExampleRandomValue(HoodieKey key, String instantTime) throws IOException {
        return this.generateNestedExampleRandomValue(key, instantTime, 0);
    }

    private RawTripTestPayload generateRandomValue(HoodieKey key, String instantTime, boolean isFlattened, long timestamp) throws IOException {
        GenericRecord rec = this.generateGenericRecord(key.getRecordKey(), key.getPartitionPath(), "rider-" + instantTime, "driver-" + instantTime, timestamp, false, isFlattened);
        return new RawTripTestPayload(rec.toString(), key.getRecordKey(), key.getPartitionPath(), TRIP_EXAMPLE_SCHEMA);
    }

    private RawTripTestPayload generateNestedExampleRandomValue(HoodieKey key, String instantTime, int ts) throws IOException {
        GenericRecord rec = this.generateNestedExampleGenericRecord(key.getRecordKey(), key.getPartitionPath(), "rider-" + instantTime, "driver-" + instantTime, ts, false);
        return new RawTripTestPayload(rec.toString(), key.getRecordKey(), key.getPartitionPath(), TRIP_EXAMPLE_SCHEMA);
    }

    public RawTripTestPayload generatePayloadForTripSchema(HoodieKey key, String commitTime) throws IOException {
        GenericRecord rec = this.generateRecordForTripSchema(key.getRecordKey(), "rider-" + commitTime, "driver-" + commitTime, 0L);
        return new RawTripTestPayload(rec.toString(), key.getRecordKey(), key.getPartitionPath(), TRIP_SCHEMA);
    }

    public RawTripTestPayload generatePayloadForShortTripSchema(HoodieKey key, String commitTime) throws IOException {
        GenericRecord rec = this.generateRecordForShortTripSchema(key.getRecordKey(), "rider-" + commitTime, "driver-" + commitTime, 0L);
        return new RawTripTestPayload(rec.toString(), key.getRecordKey(), key.getPartitionPath(), SHORT_TRIP_SCHEMA);
    }

    private RawTripTestPayload generateRandomDeleteValue(HoodieKey key, String instantTime) throws IOException {
        GenericRecord rec = this.generateGenericRecord(key.getRecordKey(), key.getPartitionPath(), "rider-" + instantTime, "driver-" + instantTime, 0L, true, false);
        return new RawTripTestPayload((Option<String>)Option.of((Object)rec.toString()), key.getRecordKey(), key.getPartitionPath(), TRIP_EXAMPLE_SCHEMA, true, Long.valueOf(0L));
    }

    private HoodieAvroPayload generateAvroPayload(HoodieKey key, String instantTime) {
        GenericRecord rec = this.generateGenericRecord(key.getRecordKey(), key.getPartitionPath(), "rider-" + instantTime, "driver-" + instantTime, 0L);
        return new HoodieAvroPayload(Option.of((Object)rec));
    }

    public GenericRecord generateGenericRecord(String rowKey, String partitionPath, String riderName, String driverName, long timestamp) {
        return this.generateGenericRecord(rowKey, partitionPath, riderName, driverName, timestamp, false, false);
    }

    private void generateTripPrefixValues(GenericRecord rec, String rowKey, String partitionPath, String riderName, String driverName, long timestamp) {
        rec.put("_row_key", (Object)rowKey);
        rec.put("timestamp", (Object)timestamp);
        rec.put("partition_path", (Object)partitionPath);
        rec.put("trip_type", (Object)new GenericData.EnumSymbol(TRIP_TYPE_ENUM_SCHEMA, this.rand.nextInt(2) == 0 ? "UBERX" : "BLACK"));
        rec.put("rider", (Object)riderName);
        rec.put("driver", (Object)driverName);
        rec.put("begin_lat", (Object)this.rand.nextDouble());
        rec.put("begin_lon", (Object)this.rand.nextDouble());
        rec.put("end_lat", (Object)this.rand.nextDouble());
        rec.put("end_lon", (Object)this.rand.nextDouble());
    }

    private void generateFareFlattenedValues(GenericRecord rec) {
        rec.put("fare", (Object)(this.rand.nextDouble() * 100.0));
        rec.put("currency", (Object)"USD");
    }

    private void generateExtraSchemaValues(GenericRecord rec) {
        rec.put("distance_in_meters", (Object)this.rand.nextInt());
        rec.put("seconds_since_epoch", (Object)this.rand.nextLong());
        rec.put("weight", (Object)Float.valueOf(this.rand.nextFloat()));
        byte[] bytes = StringUtils.getUTF8Bytes((String)"Canada");
        rec.put("nation", (Object)ByteBuffer.wrap(bytes));
        long randomMillis = HoodieTestDataGenerator.genRandomTimeMillis(this.rand);
        Instant instant = Instant.ofEpochMilli(randomMillis);
        rec.put("current_date", (Object)(this.makeDatesAmbiguous ? -1000000 : (int)LocalDateTime.ofInstant(instant, ZoneOffset.UTC).toLocalDate().toEpochDay()));
        rec.put("current_ts", (Object)randomMillis);
        BigDecimal bigDecimal = new BigDecimal(String.format(Locale.ENGLISH, "%5f", Float.valueOf(this.rand.nextFloat())));
        Schema decimalSchema = AVRO_SCHEMA.getField("height").schema();
        Conversions.DecimalConversion decimalConversions = new Conversions.DecimalConversion();
        GenericFixed genericFixed = decimalConversions.toFixed(bigDecimal, decimalSchema, (LogicalType)LogicalTypes.decimal((int)10, (int)6));
        rec.put("height", (Object)genericFixed);
    }

    private void generateMapTypeValues(GenericRecord rec) {
        rec.put("city_to_state", Collections.singletonMap("LA", "CA"));
    }

    private void generateFareNestedValues(GenericRecord rec) {
        GenericData.Record fareRecord = new GenericData.Record(AVRO_SCHEMA.getField("fare").schema());
        fareRecord.put("amount", (Object)(this.rand.nextDouble() * 100.0));
        fareRecord.put("currency", (Object)"USD");
        rec.put("fare", (Object)fareRecord);
    }

    private void generateTipNestedValues(GenericRecord rec) {
        GenericData.Array tipHistoryArray = new GenericData.Array(1, AVRO_SCHEMA.getField("tip_history").schema());
        Schema tipSchema = new Schema.Parser().parse(AVRO_SCHEMA.getField("tip_history").schema().toString()).getElementType();
        GenericData.Record tipRecord = new GenericData.Record(tipSchema);
        tipRecord.put("amount", (Object)(this.rand.nextDouble() * 100.0));
        tipRecord.put("currency", (Object)"USD");
        tipHistoryArray.add((Object)tipRecord);
        rec.put("tip_history", (Object)tipHistoryArray);
    }

    private void generateTripSuffixValues(GenericRecord rec, boolean isDeleteRecord) {
        if (isDeleteRecord) {
            rec.put("_hoodie_is_deleted", (Object)true);
        } else {
            rec.put("_hoodie_is_deleted", (Object)false);
        }
    }

    public GenericRecord generateGenericRecord(String rowKey, String partitionPath, String riderName, String driverName, long timestamp, boolean isDeleteRecord, boolean isFlattened) {
        GenericData.Record rec = new GenericData.Record(isFlattened ? FLATTENED_AVRO_SCHEMA : AVRO_SCHEMA);
        this.generateTripPrefixValues((GenericRecord)rec, rowKey, partitionPath, riderName, driverName, timestamp);
        if (isFlattened) {
            this.generateFareFlattenedValues((GenericRecord)rec);
        } else {
            this.generateExtraSchemaValues((GenericRecord)rec);
            this.generateMapTypeValues((GenericRecord)rec);
            this.generateFareNestedValues((GenericRecord)rec);
            this.generateTipNestedValues((GenericRecord)rec);
        }
        this.generateTripSuffixValues((GenericRecord)rec, isDeleteRecord);
        return rec;
    }

    public GenericRecord generateNestedExampleGenericRecord(String rowKey, String partitionPath, String riderName, String driverName, long timestamp, boolean isDeleteRecord) {
        GenericData.Record rec = new GenericData.Record(NESTED_AVRO_SCHEMA);
        this.generateTripPrefixValues((GenericRecord)rec, rowKey, partitionPath, riderName, driverName, timestamp);
        this.generateFareNestedValues((GenericRecord)rec);
        this.generateTripSuffixValues((GenericRecord)rec, isDeleteRecord);
        return rec;
    }

    public GenericRecord generateRecordForTripSchema(String rowKey, String riderName, String driverName, long timestamp) {
        GenericData.Record rec = new GenericData.Record(AVRO_TRIP_SCHEMA);
        rec.put("_row_key", (Object)rowKey);
        rec.put("timestamp", (Object)timestamp);
        rec.put("rider", (Object)riderName);
        rec.put("driver", (Object)driverName);
        rec.put("fare", (Object)(this.rand.nextDouble() * 100.0));
        rec.put("_hoodie_is_deleted", (Object)false);
        return rec;
    }

    public GenericRecord generateRecordForShortTripSchema(String rowKey, String riderName, String driverName, long timestamp) {
        GenericData.Record rec = new GenericData.Record(AVRO_SHORT_TRIP_SCHEMA);
        rec.put("_row_key", (Object)rowKey);
        rec.put("timestamp", (Object)timestamp);
        rec.put("rider", (Object)riderName);
        rec.put("driver", (Object)driverName);
        rec.put("fare", (Object)(this.rand.nextDouble() * 100.0));
        rec.put("_hoodie_is_deleted", (Object)false);
        return rec;
    }

    public static void createRequestedCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path pendingRequestedFile = new Path(basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeRequestedCommitFileName((String)instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, pendingRequestedFile, configuration);
    }

    public static void createPendingCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path pendingCommitFile = new Path(basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeInflightCommitFileName((String)instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, pendingCommitFile, configuration);
    }

    public static void createCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        HoodieTestDataGenerator.createCommitFile(basePath, instantTime, configuration, commitMetadata);
    }

    private static void createCommitFile(String basePath, String instantTime, StorageConfiguration<?> configuration, HoodieCommitMetadata commitMetadata) {
        Arrays.asList(HoodieTimeline.makeCommitFileName((String)instantTime), HoodieTimeline.makeInflightCommitFileName((String)instantTime), HoodieTimeline.makeRequestedCommitFileName((String)instantTime)).forEach(f -> HoodieTestDataGenerator.createMetadataFile(f, basePath, configuration, commitMetadata));
    }

    private static void createMetadataFile(String f, String basePath, StorageConfiguration<?> configuration, HoodieCommitMetadata commitMetadata) {
        try {
            HoodieTestDataGenerator.createMetadataFile(f, basePath, configuration, StringUtils.getUTF8Bytes((String)commitMetadata.toJsonString()));
        }
        catch (IOException e) {
            throw new HoodieIOException(e.getMessage(), e);
        }
    }

    private static void createMetadataFile(String f, String basePath, StorageConfiguration<?> configuration, byte[] content) {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + f);
        OutputStream os = null;
        try {
            HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, configuration);
            os = storage.create(new StoragePath(commitFile.toUri()), true);
            os.write(content);
        }
        catch (IOException ioe) {
            throw new HoodieIOException(ioe.getMessage(), ioe);
        }
        finally {
            if (null != os) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    throw new HoodieIOException(e.getMessage(), e);
                }
            }
        }
    }

    public static void createReplaceCommitRequestedFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeRequestedReplaceFileName((String)instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, commitFile, configuration);
    }

    public static void createReplaceCommitInflightFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeInflightReplaceFileName((String)instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, commitFile, configuration);
    }

    private static void createPendingReplaceFile(String basePath, String instantTime, StorageConfiguration<?> configuration, HoodieCommitMetadata commitMetadata) {
        Arrays.asList(HoodieTimeline.makeInflightReplaceFileName((String)instantTime), HoodieTimeline.makeRequestedReplaceFileName((String)instantTime)).forEach(f -> HoodieTestDataGenerator.createMetadataFile(f, basePath, configuration, commitMetadata));
    }

    public static void createPendingReplaceFile(String basePath, String instantTime, StorageConfiguration<?> configuration) {
        HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
        HoodieTestDataGenerator.createPendingReplaceFile(basePath, instantTime, configuration, commitMetadata);
    }

    public static void createEmptyCleanRequestedFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeRequestedCleanerFileName((String)instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, commitFile, configuration);
    }

    private static void createEmptyFile(String basePath, Path filePath, StorageConfiguration<?> configuration) throws IOException {
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, configuration);
        OutputStream os = storage.create(new StoragePath(filePath.toUri()), true);
        os.close();
    }

    public static void createCompactionRequestedFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeRequestedCompactionFileName((String)instantTime));
        HoodieTestDataGenerator.createEmptyFile(basePath, commitFile, configuration);
    }

    public static void createCompactionAuxiliaryMetadata(String basePath, HoodieInstant instant, StorageConfiguration<?> configuration) throws IOException {
        Path commitFile = new Path(basePath + "/" + ".hoodie/.aux" + "/" + instant.getFileName());
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, configuration);
        try (OutputStream os = storage.create(new StoragePath(commitFile.toUri()), true);){
            HoodieCompactionPlan workload = HoodieCompactionPlan.newBuilder().setVersion(Integer.valueOf(1)).build();
            os.write((byte[])TimelineMetadataUtils.serializeCompactionPlan((HoodieCompactionPlan)workload).get());
        }
    }

    public static void createSavepointFile(String basePath, String instantTime, StorageConfiguration<?> configuration) throws IOException {
        StoragePath commitFile = new StoragePath(basePath + "/" + ".hoodie" + "/" + HoodieTimeline.makeSavePointFileName((String)instantTime));
        HoodieStorage storage = HoodieStorageUtils.getStorage((String)basePath, configuration);
        try (OutputStream os = storage.create(commitFile, true);){
            HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
            os.write(StringUtils.getUTF8Bytes((String)commitMetadata.toJsonString()));
        }
    }

    public List<HoodieRecord> generateInsertsAsPerSchema(String commitTime, Integer n, String schemaStr) {
        return this.generateInsertsStream(commitTime, n, false, schemaStr).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInserts(String instantTime, Integer n) {
        return this.generateInserts(instantTime, n, false);
    }

    public List<HoodieRecord> generateInsertsNestedExample(String instantTime, Integer n) {
        return this.generateInsertsStream(instantTime, n, false, TRIP_NESTED_EXAMPLE_SCHEMA).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInserts(String instantTime, Integer n, boolean isFlattened) {
        return this.generateInsertsStream(instantTime, n, isFlattened, TRIP_EXAMPLE_SCHEMA).collect(Collectors.toList());
    }

    public Stream<HoodieRecord> generateInsertsStream(String commitTime, Integer n, boolean isFlattened, String schemaStr) {
        return this.generateInsertsStream(commitTime, n, isFlattened, schemaStr, false);
    }

    public List<HoodieRecord> generateInsertsContainsAllPartitions(String instantTime, Integer n) {
        if (n < this.partitionPaths.length) {
            throw new HoodieIOException("n must greater then partitionPaths length");
        }
        return this.generateInsertsStream(instantTime, n, false, TRIP_EXAMPLE_SCHEMA, true).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateInsertsForPartition(String instantTime, Integer n, String partition) {
        return this.generateInsertsStream(instantTime, n, false, TRIP_EXAMPLE_SCHEMA, false, () -> partition, () -> HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString()).collect(Collectors.toList());
    }

    public Stream<HoodieRecord> generateInsertsStream(String commitTime, Integer n, boolean isFlattened, String schemaStr, boolean containsAllPartitions) {
        AtomicInteger partitionIndex = new AtomicInteger(0);
        return this.generateInsertsStream(commitTime, n, isFlattened, schemaStr, containsAllPartitions, () -> {
            String partitionToUse = this.partitionPaths[partitionIndex.get()];
            partitionIndex.set((partitionIndex.get() + 1) % this.partitionPaths.length);
            return partitionToUse;
        }, () -> HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString());
    }

    public Stream<HoodieRecord> generateInsertsStream(String instantTime, Integer n, boolean isFlattened, String schemaStr, boolean containsAllPartitions, Supplier<String> partitionPathSupplier, Supplier<String> recordKeySupplier) {
        int currSize = this.getNumExistingKeys(schemaStr);
        return IntStream.range(0, n).boxed().map(i -> {
            String partitionPath = (String)partitionPathSupplier.get();
            if (containsAllPartitions && i < this.partitionPaths.length) {
                partitionPath = this.partitionPaths[i];
            }
            HoodieKey key = new HoodieKey((String)recordKeySupplier.get(), partitionPath);
            KeyPartition kp = new KeyPartition();
            kp.key = key;
            kp.partitionPath = partitionPath;
            this.populateKeysBySchema(schemaStr, currSize + i, kp);
            this.incrementNumExistingKeysBySchema(schemaStr);
            try {
                return new HoodieAvroRecord(key, (HoodieRecordPayload)this.generateRandomValueAsPerSchema(schemaStr, key, instantTime, isFlattened));
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        });
    }

    private void populateKeysBySchema(String schemaStr, int i, KeyPartition kp) {
        if (this.existingKeysBySchema.containsKey(schemaStr)) {
            this.existingKeysBySchema.get(schemaStr).put(i, kp);
        } else {
            this.existingKeysBySchema.put(schemaStr, new HashMap());
            this.existingKeysBySchema.get(schemaStr).put(i, kp);
        }
    }

    private void incrementNumExistingKeysBySchema(String schemaStr) {
        if (this.numKeysBySchema.containsKey(schemaStr)) {
            this.numKeysBySchema.put(schemaStr, this.numKeysBySchema.get(schemaStr) + 1);
        } else {
            this.numKeysBySchema.put(schemaStr, 1);
        }
    }

    public List<HoodieRecord> generateSameKeyInserts(String instantTime, List<HoodieRecord> origin) throws IOException {
        ArrayList<HoodieRecord> copy = new ArrayList<HoodieRecord>();
        for (HoodieRecord r : origin) {
            HoodieKey key = r.getKey();
            HoodieAvroRecord record = new HoodieAvroRecord(key, (HoodieRecordPayload)this.generateRandomValue(key, instantTime));
            copy.add((HoodieRecord)record);
        }
        return copy;
    }

    public List<HoodieRecord> generateInsertsWithHoodieAvroPayload(String instantTime, int limit) {
        ArrayList<HoodieRecord> inserts = new ArrayList<HoodieRecord>();
        int currSize = this.getNumExistingKeys(TRIP_EXAMPLE_SCHEMA);
        for (int i = 0; i < limit; ++i) {
            String partitionPath = this.partitionPaths[this.rand.nextInt(this.partitionPaths.length)];
            HoodieKey key = new HoodieKey(HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), partitionPath);
            HoodieAvroRecord record = new HoodieAvroRecord(key, (HoodieRecordPayload)this.generateAvroPayload(key, instantTime));
            inserts.add((HoodieRecord)record);
            KeyPartition kp = new KeyPartition();
            kp.key = key;
            kp.partitionPath = partitionPath;
            this.populateKeysBySchema(TRIP_EXAMPLE_SCHEMA, currSize + i, kp);
            this.incrementNumExistingKeysBySchema(TRIP_EXAMPLE_SCHEMA);
        }
        return inserts;
    }

    public List<HoodieRecord> generateUpdatesWithHoodieAvroPayload(String instantTime, List<HoodieRecord> baseRecords) {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (HoodieRecord baseRecord : baseRecords) {
            HoodieAvroRecord record = new HoodieAvroRecord(baseRecord.getKey(), (HoodieRecordPayload)this.generateAvroPayload(baseRecord.getKey(), instantTime));
            updates.add((HoodieRecord)record);
        }
        return updates;
    }

    public List<HoodieRecord> generateDeletes(String instantTime, Integer n) throws IOException {
        List<HoodieRecord> inserts = this.generateInserts(instantTime, n);
        return this.generateDeletesFromExistingRecords(inserts);
    }

    public List<HoodieRecord> generateDeletesFromExistingRecords(List<HoodieRecord> existingRecords) throws IOException {
        ArrayList<HoodieRecord> deletes = new ArrayList<HoodieRecord>();
        for (HoodieRecord existingRecord : existingRecords) {
            HoodieRecord record = this.generateDeleteRecord(existingRecord);
            deletes.add(record);
        }
        return deletes;
    }

    public HoodieRecord generateDeleteRecord(HoodieRecord existingRecord) throws IOException {
        HoodieKey key = existingRecord.getKey();
        return this.generateDeleteRecord(key);
    }

    public HoodieRecord generateDeleteRecord(HoodieKey key) throws IOException {
        RawTripTestPayload payload = new RawTripTestPayload((Option<String>)Option.empty(), key.getRecordKey(), key.getPartitionPath(), null, true, Long.valueOf(0L));
        return new HoodieAvroRecord(key, (HoodieRecordPayload)payload);
    }

    public HoodieRecord generateUpdateRecord(HoodieKey key, String instantTime) throws IOException {
        return new HoodieAvroRecord(key, (HoodieRecordPayload)this.generateRandomValue(key, instantTime));
    }

    public HoodieRecord generateUpdateRecordWithTimestamp(HoodieKey key, String instantTime, long timestamp) throws IOException {
        return new HoodieAvroRecord(key, (HoodieRecordPayload)this.generateRandomValue(key, instantTime, false, timestamp));
    }

    public List<HoodieRecord> generateUpdates(String instantTime, List<HoodieRecord> baseRecords) throws IOException {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (HoodieRecord baseRecord : baseRecords) {
            HoodieRecord record = this.generateUpdateRecord(baseRecord.getKey(), instantTime);
            updates.add(record);
        }
        return updates;
    }

    public List<HoodieRecord> generateUpdatesWithTimestamp(String instantTime, List<HoodieRecord> baseRecords, long timestamp) throws IOException {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (HoodieRecord baseRecord : baseRecords) {
            updates.add(this.generateUpdateRecordWithTimestamp(baseRecord.getKey(), instantTime, timestamp));
        }
        return updates;
    }

    public List<HoodieRecord> generateUpdatesForDifferentPartition(String instantTime, List<HoodieRecord> baseRecords, long timestamp, String newPartition) throws IOException {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (HoodieRecord baseRecord : baseRecords) {
            String partition = baseRecord.getPartitionPath();
            ValidationUtils.checkState((!partition.equals(newPartition) ? 1 : 0) != 0, (String)"newPartition should be different from any given record's current partition.");
            HoodieKey key = new HoodieKey(baseRecord.getRecordKey(), newPartition);
            HoodieRecord record = this.generateUpdateRecordWithTimestamp(key, instantTime, timestamp);
            updates.add(record);
        }
        return updates;
    }

    public List<HoodieRecord> generateUpdates(String instantTime, Integer n) throws IOException {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        for (int i = 0; i < n; ++i) {
            Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
            Integer numExistingKeys = this.numKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
            KeyPartition kp = existingKeys.get(this.rand.nextInt(numExistingKeys - 1));
            HoodieRecord record = this.generateUpdateRecord(kp.key, instantTime);
            updates.add(record);
        }
        return updates;
    }

    public List<HoodieRecord> generateUpdatesForAllRecords(String instantTime) {
        ArrayList<HoodieRecord> updates = new ArrayList<HoodieRecord>();
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        existingKeys.values().forEach(kp -> {
            try {
                HoodieRecord record = this.generateUpdateRecord(kp.key, instantTime);
                updates.add(record);
            }
            catch (IOException ioe) {
                throw new HoodieIOException(ioe.getMessage(), ioe);
            }
        });
        return updates;
    }

    public List<HoodieRecord> generateUpdatesAsPerSchema(String commitTime, Integer n, String schemaStr) {
        return this.generateUniqueUpdatesStream(commitTime, n, schemaStr).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdates(String instantTime, Integer n) {
        return this.generateUniqueUpdatesStream(instantTime, n, TRIP_EXAMPLE_SCHEMA).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdatesNestedExample(String instantTime, Integer n) {
        return this.generateUniqueUpdatesStream(instantTime, n, TRIP_NESTED_EXAMPLE_SCHEMA).collect(Collectors.toList());
    }

    public List<HoodieRecord> generateUniqueUpdatesAsPerSchema(String instantTime, Integer n, String schemaStr) {
        return this.generateUniqueUpdatesStream(instantTime, n, schemaStr).collect(Collectors.toList());
    }

    public List<HoodieKey> generateUniqueDeletes(Integer n) {
        return this.generateUniqueDeleteStream(n).collect(Collectors.toList());
    }

    public Stream<HoodieRecord> generateUniqueUpdatesStream(String instantTime, Integer n, String schemaStr) {
        HashSet used = new HashSet();
        int numExistingKeys = this.numKeysBySchema.getOrDefault(schemaStr, 0);
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(schemaStr);
        if (n > numExistingKeys) {
            throw new IllegalArgumentException("Requested unique updates is greater than number of available keys");
        }
        return IntStream.range(0, n).boxed().map(i -> {
            int index = numExistingKeys == 1 ? 0 : this.rand.nextInt(numExistingKeys - 1);
            KeyPartition kp = (KeyPartition)existingKeys.get(index);
            while (used.contains(kp)) {
                index = (index + 1) % numExistingKeys;
                kp = (KeyPartition)existingKeys.get(index);
            }
            logger.debug("key getting updated: " + kp.key.getRecordKey());
            used.add(kp);
            try {
                return new HoodieAvroRecord(kp.key, (HoodieRecordPayload)this.generateRandomValueAsPerSchema(schemaStr, kp.key, instantTime, false));
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        });
    }

    public Stream<HoodieKey> generateUniqueDeleteStream(Integer n) {
        HashSet<KeyPartition> used = new HashSet<KeyPartition>();
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        Integer numExistingKeys = this.numKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        if (n > numExistingKeys) {
            throw new IllegalArgumentException("Requested unique deletes is greater than number of available keys");
        }
        ArrayList<HoodieKey> result = new ArrayList<HoodieKey>();
        for (int i = 0; i < n; ++i) {
            int index = this.rand.nextInt(numExistingKeys);
            while (!existingKeys.containsKey(index)) {
                index = (index + 1) % numExistingKeys;
            }
            KeyPartition kp = existingKeys.remove(index);
            existingKeys.put(index, existingKeys.get(numExistingKeys - 1));
            existingKeys.remove(numExistingKeys - 1);
            Integer n2 = numExistingKeys;
            Integer n3 = numExistingKeys = Integer.valueOf(numExistingKeys - 1);
            used.add(kp);
            result.add(kp.key);
        }
        this.numKeysBySchema.put(TRIP_EXAMPLE_SCHEMA, numExistingKeys);
        return result.stream();
    }

    public Stream<HoodieRecord> generateUniqueDeleteRecordStream(String instantTime, Integer n) {
        HashSet<KeyPartition> used = new HashSet<KeyPartition>();
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        Integer numExistingKeys = this.numKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        if (n > numExistingKeys) {
            throw new IllegalArgumentException("Requested unique deletes is greater than number of available keys");
        }
        ArrayList<HoodieAvroRecord> result = new ArrayList<HoodieAvroRecord>();
        for (int i = 0; i < n; ++i) {
            int index = this.rand.nextInt(numExistingKeys);
            while (!existingKeys.containsKey(index)) {
                index = (index + 1) % numExistingKeys;
            }
            KeyPartition kp = existingKeys.remove(index);
            existingKeys.put(index, existingKeys.get(numExistingKeys - 1));
            existingKeys.remove(numExistingKeys - 1);
            Integer n2 = numExistingKeys;
            Integer n3 = numExistingKeys = Integer.valueOf(numExistingKeys - 1);
            used.add(kp);
            try {
                result.add(new HoodieAvroRecord(kp.key, (HoodieRecordPayload)this.generateRandomDeleteValue(kp.key, instantTime)));
                continue;
            }
            catch (IOException e) {
                throw new HoodieIOException(e.getMessage(), e);
            }
        }
        this.numKeysBySchema.put(TRIP_EXAMPLE_SCHEMA, numExistingKeys);
        return result.stream();
    }

    public List<HoodieRecord> generateUniqueDeleteRecords(String instantTime, Integer n) {
        return this.generateUniqueDeleteRecordStream(instantTime, n).collect(Collectors.toList());
    }

    public boolean deleteExistingKeyIfPresent(HoodieKey key) {
        Map<Integer, KeyPartition> existingKeys = this.existingKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        Integer numExistingKeys = this.numKeysBySchema.get(TRIP_EXAMPLE_SCHEMA);
        for (Map.Entry<Integer, KeyPartition> entry : existingKeys.entrySet()) {
            if (!entry.getValue().key.equals((Object)key)) continue;
            int index = entry.getKey();
            existingKeys.put(index, existingKeys.get(numExistingKeys - 1));
            existingKeys.remove(numExistingKeys - 1);
            Integer n = numExistingKeys;
            Integer n2 = numExistingKeys = Integer.valueOf(numExistingKeys - 1);
            this.numKeysBySchema.put(TRIP_EXAMPLE_SCHEMA, numExistingKeys);
            return true;
        }
        return false;
    }

    public GenericRecord generateGenericRecord() {
        return this.generateGenericRecord(HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), "0", HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), HoodieTestDataGenerator.genPseudoRandomUUID(this.rand).toString(), this.rand.nextLong());
    }

    public List<GenericRecord> generateGenericRecords(int numRecords) {
        ArrayList<GenericRecord> list = new ArrayList<GenericRecord>();
        IntStream.range(0, numRecords).forEach(i -> list.add(this.generateGenericRecord()));
        return list;
    }

    public String[] getPartitionPaths() {
        return this.partitionPaths;
    }

    public int getNumExistingKeys(String schemaStr) {
        return this.numKeysBySchema.getOrDefault(schemaStr, 0);
    }

    @Override
    public void close() {
        this.existingKeysBySchema.clear();
    }

    private static long genRandomTimeMillis(Random r) {
        long anchorTs = 1234567890L;
        return anchorTs + r.nextLong() % 259200000L;
    }

    public static UUID genPseudoRandomUUID(Random r) {
        byte[] bytes = new byte[16];
        r.nextBytes(bytes);
        bytes[6] = (byte)(bytes[6] & 0xF);
        bytes[6] = (byte)(bytes[6] | 0x40);
        bytes[8] = (byte)(bytes[8] & 0x3F);
        bytes[8] = (byte)(bytes[8] | 0x80);
        try {
            Constructor ctor = UUID.class.getDeclaredConstructor(byte[].class);
            ctor.setAccessible(true);
            return (UUID)ctor.newInstance(new Object[]{bytes});
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            logger.info("Failed to generate pseudo-random UUID!");
            throw new HoodieException((Throwable)e);
        }
    }

    public static class KeyPartition
    implements Serializable {
        public HoodieKey key;
        public String partitionPath;
    }
}

