/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.testutils;

import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.mapred.Counters;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hudi.common.util.Option;

public class HadoopMapRedUtils {
    public static Reporter createTestReporter() {
        class TestReporter
        implements Reporter {
            private final ConcurrentHashMap<String, Counters.Counter> counters = new ConcurrentHashMap();

            TestReporter() {
            }

            public void setStatus(String status) {
            }

            public Counters.Counter getCounter(Enum<?> name) {
                return this.counters.computeIfAbsent(name.name(), ignored -> new Counters.Counter());
            }

            public Counters.Counter getCounter(String group, String name) {
                return this.counters.computeIfAbsent(this.getKey(group, name), ignored -> new Counters.Counter());
            }

            public void incrCounter(Enum<?> key, long amount) {
                Option.ofNullable((Object)this.counters.get(key)).ifPresent(c -> c.increment(amount));
            }

            public void incrCounter(String group, String counter, long amount) {
                Option.ofNullable((Object)this.counters.get(this.getKey(group, counter))).ifPresent(c -> c.increment(amount));
            }

            public InputSplit getInputSplit() throws UnsupportedOperationException {
                throw new UnsupportedOperationException("not supported");
            }

            public float getProgress() {
                return -1.0f;
            }

            public void progress() {
            }

            private String getKey(String group, String name) {
                return String.format("%s:%s", group, name);
            }
        }
        return new TestReporter();
    }
}

