/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.model;

import java.io.IOException;
import java.util.Arrays;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.common.model.FirstValueAvroPayload;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.common.testutils.PreCombineTestUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.MethodSource;

public class TestFirstValueAvroPayload {
    private Schema schema;
    private Properties props;

    @BeforeEach
    public void setUp() throws Exception {
        this.schema = Schema.createRecord(Arrays.asList(new Schema.Field("id", Schema.create((Schema.Type)Schema.Type.STRING), "", null), new Schema.Field("partition", Schema.create((Schema.Type)Schema.Type.STRING), "", null), new Schema.Field("ts", Schema.create((Schema.Type)Schema.Type.LONG), "", null), new Schema.Field("_hoodie_is_deleted", Schema.create((Schema.Type)Schema.Type.BOOLEAN), "", (Object)false)));
        this.props = new Properties();
        this.props.setProperty("hoodie.payload.ordering.field", "ts");
        this.props.setProperty("hoodie.payload.event.time.field", "ts");
    }

    @ParameterizedTest
    @MethodSource(value={"org.apache.hudi.common.testutils.PreCombineTestUtils#configurePreCombine"})
    public void testActiveRecordsForFirstValueAvroPayload(String key) throws IOException {
        PreCombineTestUtils.setPreCombineConfig(this.props, key, "ts");
        GenericData.Record record1 = new GenericData.Record(this.schema);
        record1.put("id", (Object)"0");
        record1.put("partition", (Object)"partition0");
        record1.put("ts", (Object)0L);
        record1.put("_hoodie_is_deleted", (Object)false);
        GenericData.Record record2 = new GenericData.Record(this.schema);
        record2.put("id", (Object)"0");
        record2.put("partition", (Object)"partition0");
        record2.put("ts", (Object)0L);
        record2.put("_hoodie_is_deleted", (Object)false);
        FirstValueAvroPayload payload1 = new FirstValueAvroPayload((GenericRecord)record1, (Comparable)Integer.valueOf(1));
        FirstValueAvroPayload payload2 = new FirstValueAvroPayload((GenericRecord)record2, (Comparable)Integer.valueOf(1));
        Assertions.assertEquals((Object)payload1.preCombine((HoodieRecordPayload)payload2, this.props), (Object)payload2);
        Assertions.assertEquals((Object)payload2.preCombine((HoodieRecordPayload)payload1, this.props), (Object)payload1);
        Assertions.assertEquals((Object)record1, (Object)payload1.getInsertValue(this.schema, this.props).get());
        Assertions.assertEquals((Object)record2, (Object)payload2.getInsertValue(this.schema, this.props).get());
        Assertions.assertEquals((Object)payload1.combineAndGetUpdateValue((IndexedRecord)record2, this.schema, this.props).get(), (Object)record2);
        Assertions.assertEquals((Object)payload2.combineAndGetUpdateValue((IndexedRecord)record1, this.schema, this.props).get(), (Object)record1);
    }
}

