/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.JsonProperties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericDatumReader;
import org.apache.avro.generic.GenericDatumWriter;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.IndexedRecord;
import org.apache.avro.io.BinaryDecoder;
import org.apache.avro.io.BinaryEncoder;
import org.apache.avro.io.Decoder;
import org.apache.avro.io.DecoderFactory;
import org.apache.avro.io.Encoder;
import org.apache.avro.io.EncoderFactory;
import org.apache.avro.util.Utf8;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.BooleanWrapper;
import org.apache.hudi.avro.model.BytesWrapper;
import org.apache.hudi.avro.model.DateWrapper;
import org.apache.hudi.avro.model.DecimalWrapper;
import org.apache.hudi.avro.model.DoubleWrapper;
import org.apache.hudi.avro.model.FloatWrapper;
import org.apache.hudi.avro.model.IntWrapper;
import org.apache.hudi.avro.model.LongWrapper;
import org.apache.hudi.avro.model.StringWrapper;
import org.apache.hudi.avro.model.TimestampMicrosWrapper;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.exception.SchemaCompatibilityException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public class TestHoodieAvroUtils {
    private static String EVOLVED_SCHEMA = "{\"type\": \"record\",\"name\": \"testrec1\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"},{\"name\": \"new_col_not_nullable_default_dummy_val\", \"type\": \"string\", \"default\": \"dummy_val\"},{\"name\": \"new_col_nullable_wo_default\", \"type\": [\"int\", \"null\"]},{\"name\": \"new_col_nullable_default_null\", \"type\": [\"null\" ,\"string\"],\"default\": null},{\"name\": \"new_col_nullable_default_dummy_val\", \"type\": [\"string\" ,\"null\"],\"default\": \"dummy_val\"}]}";
    private static String EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"}]}";
    private static final String EXAMPLE_SCHEMA_WITH_PROPS = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\", \"custom_field_property\":\"value\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"}], \"custom_schema_property\": \"custom_schema_property_value\"}";
    private static int NUM_FIELDS_IN_EXAMPLE_SCHEMA = 4;
    private static String SCHEMA_WITH_METADATA_FIELD = "{\"type\": \"record\",\"name\": \"testrec2\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"},{\"name\": \"_hoodie_commit_time\", \"type\": [\"null\", \"string\"]},{\"name\": \"nullable_field\",\"type\": [\"null\" ,\"string\"],\"default\": null},{\"name\": \"nullable_field_wo_default\",\"type\": [\"null\" ,\"string\"]}]}";
    private static String SCHEMA_WITH_NON_NULLABLE_FIELD = "{\"type\": \"record\",\"name\": \"testrec3\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"},{\"name\": \"nullable_field\",\"type\": [\"null\" ,\"string\"],\"default\": null},{\"name\": \"non_nullable_field_wo_default\",\"type\": \"string\"},{\"name\": \"non_nullable_field_with_default\",\"type\": \"string\", \"default\": \"dummy\"}]}";
    private static String SCHEMA_WITH_NON_NULLABLE_FIELD_WITH_DEFAULT = "{\"type\": \"record\",\"name\": \"testrec4\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\", \"column_category\": \"user_profile\"},{\"name\": \"nullable_field\",\"type\": [\"null\" ,\"string\"],\"default\": null},{\"name\": \"non_nullable_field_with_default\",\"type\": \"string\", \"default\": \"dummy\"}]}";
    private static String SCHEMA_WITH_DECIMAL_FIELD = "{\"type\":\"record\",\"name\":\"record\",\"fields\":[{\"name\":\"key_col\",\"type\":[\"null\",\"int\"],\"default\":null},{\"name\":\"decimal_col\",\"type\":[\"null\",{\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":8,\"scale\":4}],\"default\":null}]}";
    private static String SCHEMA_WITH_NESTED_FIELD = "{\"name\":\"MyClass\",\"type\":\"record\",\"namespace\":\"com.acme.avro\",\"fields\":[{\"name\":\"firstname\",\"type\":\"string\"},{\"name\":\"lastname\",\"type\":\"string\"},{\"name\":\"student\",\"type\":{\"name\":\"student\",\"type\":\"record\",\"fields\":[{\"name\":\"firstname\",\"type\":[\"null\" ,\"string\"],\"default\": null},{\"name\":\"lastname\",\"type\":[\"null\" ,\"string\"],\"default\": null}]}}]}";
    private static String SCHEMA_WITH_NESTED_FIELD_RENAMED = "{\"name\":\"MyClass\",\"type\":\"record\",\"namespace\":\"com.acme.avro\",\"fields\":[{\"name\":\"fn\",\"type\":\"string\"},{\"name\":\"ln\",\"type\":\"string\"},{\"name\":\"ss\",\"type\":{\"name\":\"ss\",\"type\":\"record\",\"fields\":[{\"name\":\"fn\",\"type\":[\"null\" ,\"string\"],\"default\": null},{\"name\":\"ln\",\"type\":[\"null\" ,\"string\"],\"default\": null}]}}]}";
    private static String SCHEMA_WITH_AVRO_TYPES = "{\"name\":\"TestRecordAvroTypes\",\"type\":\"record\",\"fields\":[{\"name\":\"booleanField\",\"type\":\"boolean\"},{\"name\":\"intField\",\"type\":\"int\"},{\"name\":\"longField\",\"type\":\"long\"},{\"name\":\"floatField\",\"type\":\"float\"},{\"name\":\"doubleField\",\"type\":\"double\"},{\"name\":\"bytesField\",\"type\":\"bytes\"},{\"name\":\"stringField\",\"type\":\"string\"},{\"name\":\"decimalField\",\"type\":\"bytes\",\"logicalType\":\"decimal\",\"precision\":20,\"scale\":5},{\"name\":\"timeMillisField\",\"type\":\"int\",\"logicalType\":\"time-millis\"},{\"name\":\"timeMicrosField\",\"type\":\"long\",\"logicalType\":\"time-micros\"},{\"name\":\"timestampMillisField\",\"type\":\"long\",\"logicalType\":\"timestamp-millis\"},{\"name\":\"timestampMicrosField\",\"type\":\"long\",\"logicalType\":\"timestamp-micros\"},{\"name\":\"localTimestampMillisField\",\"type\":\"long\",\"logicalType\":\"local-timestamp-millis\"},{\"name\":\"localTimestampMicrosField\",\"type\":\"long\",\"logicalType\":\"local-timestamp-micros\"}]}";

    @Test
    public void testPropsPresent() {
        Schema schema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(EXAMPLE_SCHEMA));
        boolean piiPresent = false;
        for (Schema.Field field : schema.getFields()) {
            if (HoodieAvroUtils.isMetadataField((String)field.name())) continue;
            Assertions.assertNotNull((Object)field.name(), (String)"field name is null");
            Map props = field.getObjectProps();
            Assertions.assertNotNull((Object)props, (String)"The property is null");
            if (field.name().equals("pii_col")) {
                piiPresent = true;
                Assertions.assertTrue((boolean)props.containsKey("column_category"), (String)"sensitivity_level is removed in field 'pii_col'");
                continue;
            }
            Assertions.assertEquals((int)0, (int)props.size(), (String)"The property shows up but not set");
        }
        Assertions.assertTrue((boolean)piiPresent, (String)"column pii_col doesn't show up");
    }

    @Test
    public void testDefaultValue() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EVOLVED_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        Schema schemaWithMetadata = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(EVOLVED_SCHEMA));
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)schemaWithMetadata);
        Assertions.assertEquals((Object)"dummy_val", (Object)rec1.get("new_col_not_nullable_default_dummy_val"));
        Assertions.assertNull((Object)rec1.get("new_col_nullable_wo_default"));
        Assertions.assertNull((Object)rec1.get("new_col_nullable_default_null"));
        Assertions.assertEquals((Object)"dummy_val", (Object)rec1.get("new_col_nullable_default_dummy_val"));
        Assertions.assertNull((Object)rec1.get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
    }

    @Test
    public void testDefaultValueWithSchemaEvolution() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)new Schema.Parser().parse(EVOLVED_SCHEMA));
        Assertions.assertEquals((Object)"dummy_val", (Object)rec1.get("new_col_not_nullable_default_dummy_val"));
        Assertions.assertNull((Object)rec1.get("new_col_nullable_wo_default"));
    }

    @Test
    public void testMetadataField() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)new Schema.Parser().parse(SCHEMA_WITH_METADATA_FIELD));
        Assertions.assertNull((Object)rec1.get("_hoodie_commit_time"));
        Assertions.assertNull((Object)rec1.get("nullable_field"));
        Assertions.assertNull((Object)rec1.get("nullable_field_wo_default"));
    }

    @Test
    public void testNonNullableFieldWithoutDefault() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        Assertions.assertThrows(SchemaCompatibilityException.class, () -> TestHoodieAvroUtils.lambda$testNonNullableFieldWithoutDefault$0((GenericRecord)rec));
    }

    @Test
    public void testNonNullableFieldWithDefault() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)new Schema.Parser().parse(SCHEMA_WITH_NON_NULLABLE_FIELD_WITH_DEFAULT));
        Assertions.assertEquals((Object)"dummy", (Object)rec1.get("non_nullable_field_with_default"));
    }

    @Test
    public void testJsonNodeNullWithDefaultValues() {
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        Schema initialSchema = Schema.createRecord((String)"test_record", (String)"test record", (String)"org.test.namespace", (boolean)false);
        Schema.Field field1 = new Schema.Field("key", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field field2 = new Schema.Field("key1", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field field3 = new Schema.Field("key2", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        fields.add(field1);
        fields.add(field2);
        fields.add(field3);
        initialSchema.setFields(fields);
        GenericData.Record rec = new GenericData.Record(initialSchema);
        rec.put("key", (Object)"val");
        rec.put("key1", (Object)"val1");
        rec.put("key2", (Object)"val2");
        ArrayList<Schema.Field> evolvedFields = new ArrayList<Schema.Field>();
        Schema evolvedSchema = Schema.createRecord((String)"evolved_record", (String)"evolved record", (String)"org.evolved.namespace", (boolean)false);
        Schema.Field evolvedField1 = new Schema.Field("key", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field evolvedField2 = new Schema.Field("key1", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field evolvedField3 = new Schema.Field("key2", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field evolvedField4 = new Schema.Field("evolved_field", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        Schema.Field evolvedField5 = new Schema.Field("evolved_field1", HoodieAvroUtils.METADATA_FIELD_SCHEMA, "", (Object)JsonProperties.NULL_VALUE);
        evolvedFields.add(evolvedField1);
        evolvedFields.add(evolvedField2);
        evolvedFields.add(evolvedField3);
        evolvedFields.add(evolvedField4);
        evolvedFields.add(evolvedField5);
        evolvedSchema.setFields(evolvedFields);
        GenericRecord rec1 = HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)evolvedSchema);
        Assertions.assertNull((Object)rec1.get("evolved_field"));
        Assertions.assertNull((Object)rec1.get("evolved_field1"));
    }

    @Test
    public void testAddingAndRemovingMetadataFields() {
        Schema schemaWithMetaCols = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(EXAMPLE_SCHEMA));
        Assertions.assertEquals((int)(NUM_FIELDS_IN_EXAMPLE_SCHEMA + HoodieRecord.HOODIE_META_COLUMNS.size()), (int)schemaWithMetaCols.getFields().size());
        Schema schemaWithoutMetaCols = HoodieAvroUtils.removeMetadataFields((Schema)schemaWithMetaCols);
        Assertions.assertEquals((int)NUM_FIELDS_IN_EXAMPLE_SCHEMA, (int)schemaWithoutMetaCols.getFields().size());
    }

    @Test
    public void testRemoveFields() {
        String schemaStr = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"}]}";
        Schema expectedSchema = new Schema.Parser().parse(schemaStr);
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        rec.put("timestamp", (Object)3.5);
        GenericRecord rec1 = HoodieAvroUtils.removeFields((GenericRecord)rec, Collections.singleton("pii_col"));
        Assertions.assertEquals((Object)"key1", (Object)rec1.get("_row_key"));
        Assertions.assertEquals((Object)"val1", (Object)rec1.get("non_pii_col"));
        Assertions.assertEquals((Object)3.5, (Object)rec1.get("timestamp"));
        if (HoodieAvroUtils.gteqAvro1_10()) {
            GenericRecord finalRec1 = rec1;
            Assertions.assertThrows(AvroRuntimeException.class, () -> finalRec1.get("pii_col"));
        } else {
            Assertions.assertNull((Object)rec1.get("pii_col"));
        }
        Assertions.assertEquals((Object)expectedSchema, (Object)rec1.getSchema());
        schemaStr = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"double\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"non_pii_col\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\"}]}";
        expectedSchema = new Schema.Parser().parse(schemaStr);
        rec1 = HoodieAvroUtils.removeFields((GenericRecord)rec, Collections.singleton(""));
        Assertions.assertEquals((Object)expectedSchema, (Object)rec1.getSchema());
    }

    @Test
    public void testGetRootLevelFieldName() {
        Assertions.assertEquals((Object)"a", (Object)HoodieAvroUtils.getRootLevelFieldName((String)"a.b.c"));
        Assertions.assertEquals((Object)"a", (Object)HoodieAvroUtils.getRootLevelFieldName((String)"a"));
        Assertions.assertEquals((Object)"", (Object)HoodieAvroUtils.getRootLevelFieldName((String)""));
    }

    @Test
    public void testGetNestedFieldVal() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        rec.put("_row_key", (Object)"key1");
        rec.put("non_pii_col", (Object)"val1");
        rec.put("pii_col", (Object)"val2");
        Object rowKey = HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"_row_key", (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)"key1", (Object)rowKey);
        Object rowKeyNotExist = HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"fake_key", (boolean)true, (boolean)false);
        Assertions.assertNull((Object)rowKeyNotExist);
        Assertions.assertEquals((Object)"fake_key(Part -fake_key) field not found in record. Acceptable fields were :[timestamp, _row_key, non_pii_col, pii_col]", (Object)((HoodieException)Assertions.assertThrows(HoodieException.class, () -> TestHoodieAvroUtils.lambda$testGetNestedFieldVal$2((GenericRecord)rec))).getMessage());
        Assertions.assertNull((Object)HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"timestamp", (boolean)false, (boolean)false));
    }

    @Test
    public void testGetNestedFieldValWithNestedField() {
        Schema nestedSchema = new Schema.Parser().parse(SCHEMA_WITH_NESTED_FIELD);
        GenericData.Record rec = new GenericData.Record(nestedSchema);
        Assertions.assertEquals((Object)". field not found in record. Acceptable fields were :[firstname, lastname, student]", (Object)((HoodieException)Assertions.assertThrows(HoodieException.class, () -> TestHoodieAvroUtils.lambda$testGetNestedFieldValWithNestedField$3((GenericRecord)rec))).getMessage());
        Assertions.assertEquals((Object)"fake_key(Part -fake_key) field not found in record. Acceptable fields were :[firstname, lastname, student]", (Object)((HoodieException)Assertions.assertThrows(HoodieException.class, () -> TestHoodieAvroUtils.lambda$testGetNestedFieldValWithNestedField$4((GenericRecord)rec))).getMessage());
        Assertions.assertNull((Object)HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"student", (boolean)false, (boolean)false));
        GenericData.Record studentRecord = new GenericData.Record(rec.getSchema().getField("student").schema());
        studentRecord.put("firstname", (Object)"person");
        rec.put("student", (Object)studentRecord);
        Assertions.assertEquals((Object)studentRecord, (Object)HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"student", (boolean)false, (boolean)false));
        Assertions.assertEquals((Object)"student.fake_key(Part -fake_key) field not found in record. Acceptable fields were :[firstname, lastname]", (Object)((HoodieException)Assertions.assertThrows(HoodieException.class, () -> TestHoodieAvroUtils.lambda$testGetNestedFieldValWithNestedField$5((GenericRecord)rec))).getMessage());
        Assertions.assertEquals((Object)"person", (Object)HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"student.firstname", (boolean)false, (boolean)false));
        Assertions.assertNull((Object)HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"student.lastname", (boolean)false, (boolean)false));
        Assertions.assertEquals((Object)"Cannot find a record at part value :firstname", (Object)((HoodieException)Assertions.assertThrows(HoodieException.class, () -> TestHoodieAvroUtils.lambda$testGetNestedFieldValWithNestedField$6((GenericRecord)rec))).getMessage());
        Assertions.assertEquals((Object)"Cannot find a record at part value :lastname", (Object)((HoodieException)Assertions.assertThrows(HoodieException.class, () -> TestHoodieAvroUtils.lambda$testGetNestedFieldValWithNestedField$7((GenericRecord)rec))).getMessage());
    }

    @Test
    public void testGetNestedFieldValWithDecimalField() {
        GenericData.Record rec = new GenericData.Record(new Schema.Parser().parse(SCHEMA_WITH_DECIMAL_FIELD));
        rec.put("key_col", (Object)"key");
        BigDecimal bigDecimal = new BigDecimal("1234.5678");
        ByteBuffer byteBuffer = ByteBuffer.wrap(bigDecimal.unscaledValue().toByteArray());
        rec.put("decimal_col", (Object)byteBuffer);
        Object decimalCol = HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"decimal_col", (boolean)true, (boolean)false);
        Assertions.assertEquals((Object)bigDecimal, (Object)decimalCol);
        Object obj = rec.get(1);
        Assertions.assertTrue((boolean)(obj instanceof ByteBuffer));
        ByteBuffer buffer = (ByteBuffer)obj;
        Assertions.assertEquals((int)0, (int)buffer.position());
    }

    @Test
    public void testGetNestedFieldSchema() throws IOException {
        Schema schema = SchemaTestUtil.getEvolvedSchema();
        GenericData.Record rec = new GenericData.Record(schema);
        rec.put("field1", (Object)"key1");
        rec.put("field2", (Object)"val1");
        rec.put("name", (Object)"val2");
        rec.put("favorite_number", (Object)2);
        Assertions.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.STRING), (Object)HoodieAvroUtils.getNestedFieldSchemaFromWriteSchema((Schema)rec.getSchema(), (String)"field1"));
        GenericData.Record rec2 = new GenericData.Record(schema);
        rec2.put("field1", (Object)"key1");
        rec2.put("field2", (Object)"val1");
        rec2.put("name", (Object)"val2");
        rec2.put("favorite_number", (Object)12);
        Assertions.assertEquals((int)-1, (int)GenericData.get().compare(rec.get("favorite_number"), rec2.get("favorite_number"), HoodieAvroUtils.getNestedFieldSchemaFromWriteSchema((Schema)rec.getSchema(), (String)"favorite_number")));
        Schema nestedSchema = new Schema.Parser().parse(SCHEMA_WITH_NESTED_FIELD);
        GenericData.Record rec3 = new GenericData.Record(nestedSchema);
        rec3.put("firstname", (Object)"person1");
        rec3.put("lastname", (Object)"person2");
        GenericData.Record studentRecord = new GenericData.Record(rec3.getSchema().getField("student").schema());
        studentRecord.put("firstname", (Object)"person1");
        studentRecord.put("lastname", (Object)"person2");
        rec3.put("student", (Object)studentRecord);
        Assertions.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.STRING), (Object)HoodieAvroUtils.getNestedFieldSchemaFromWriteSchema((Schema)rec3.getSchema(), (String)"student.firstname"));
        Assertions.assertEquals((Object)Schema.create((Schema.Type)Schema.Type.STRING), (Object)HoodieAvroUtils.getNestedFieldSchemaFromWriteSchema((Schema)nestedSchema, (String)"student.firstname"));
    }

    @Test
    public void testReWriteAvroRecordWithNewSchema() {
        Schema nestedSchema = new Schema.Parser().parse(SCHEMA_WITH_NESTED_FIELD);
        GenericData.Record rec3 = new GenericData.Record(nestedSchema);
        rec3.put("firstname", (Object)"person1");
        rec3.put("lastname", (Object)"person2");
        GenericData.Record studentRecord = new GenericData.Record(rec3.getSchema().getField("student").schema());
        studentRecord.put("firstname", (Object)"person1");
        studentRecord.put("lastname", (Object)"person2");
        rec3.put("student", (Object)studentRecord);
        Schema nestedSchemaRename = new Schema.Parser().parse(SCHEMA_WITH_NESTED_FIELD_RENAMED);
        HashMap<String, String> colRenames = new HashMap<String, String>();
        colRenames.put("fn", "firstname");
        colRenames.put("ln", "lastname");
        colRenames.put("ss", "student");
        colRenames.put("ss.fn", "firstname");
        colRenames.put("ss.ln", "lastname");
        GenericRecord studentRecordRename = HoodieAvroUtils.rewriteRecordWithNewSchema((IndexedRecord)rec3, (Schema)nestedSchemaRename, colRenames);
        Assertions.assertEquals((Object)GenericData.get().validate(nestedSchemaRename, (Object)studentRecordRename), (Object)true);
    }

    @Test
    public void testConvertDaysToDate() {
        Date now = new Date(System.currentTimeMillis());
        int days = HoodieAvroUtils.fromJavaDate((Date)now);
        Assertions.assertEquals((Object)now.toLocalDate(), (Object)HoodieAvroUtils.toJavaDate((int)days).toLocalDate());
    }

    @Test
    public void testSanitizeName() {
        Assertions.assertEquals((Object)"__23456", (Object)HoodieAvroUtils.sanitizeName((String)"123456"));
        Assertions.assertEquals((Object)"abcdef", (Object)HoodieAvroUtils.sanitizeName((String)"abcdef"));
        Assertions.assertEquals((Object)"_1", (Object)HoodieAvroUtils.sanitizeName((String)"_1"));
        Assertions.assertEquals((Object)"a*bc", (Object)HoodieAvroUtils.sanitizeName((String)"a.bc", (String)"*"));
        Assertions.assertEquals((Object)"abcdef___", (Object)HoodieAvroUtils.sanitizeName((String)"abcdef_."));
        Assertions.assertEquals((Object)"__ab__cd__", (Object)HoodieAvroUtils.sanitizeName((String)"1ab*cd?"));
    }

    @Test
    public void testGenerateProjectionSchema() {
        Schema originalSchema = HoodieAvroUtils.addMetadataFields((Schema)new Schema.Parser().parse(EXAMPLE_SCHEMA));
        Schema schema1 = HoodieAvroUtils.generateProjectionSchema((Schema)originalSchema, Arrays.asList("_row_key", "timestamp"));
        Assertions.assertEquals((int)2, (int)schema1.getFields().size());
        List fieldNames1 = schema1.getFields().stream().map(Schema.Field::name).collect(Collectors.toList());
        Assertions.assertTrue((boolean)fieldNames1.contains("_row_key"));
        Assertions.assertTrue((boolean)fieldNames1.contains("timestamp"));
        Assertions.assertTrue((boolean)((HoodieException)Assertions.assertThrows(HoodieException.class, () -> HoodieAvroUtils.generateProjectionSchema((Schema)originalSchema, Arrays.asList("_row_key", "timestamp", "fake_field")))).getMessage().contains("Field fake_field not found in log schema. Query cannot proceed!"));
    }

    @Test
    public void testWrapAndUnwrapAvroValues() throws IOException {
        Schema schema = new Schema.Parser().parse(SCHEMA_WITH_AVRO_TYPES);
        GenericData.Record record = new GenericData.Record(schema);
        HashMap<String, Class<LongWrapper>> expectedWrapperClass = new HashMap<String, Class<LongWrapper>>();
        record.put("booleanField", (Object)true);
        expectedWrapperClass.put("booleanField", BooleanWrapper.class);
        record.put("intField", (Object)698);
        expectedWrapperClass.put("intField", IntWrapper.class);
        record.put("longField", (Object)192485030493L);
        expectedWrapperClass.put("longField", LongWrapper.class);
        record.put("floatField", (Object)Float.valueOf(18.125f));
        expectedWrapperClass.put("floatField", FloatWrapper.class);
        record.put("doubleField", (Object)9.4385932342104E7);
        expectedWrapperClass.put("doubleField", DoubleWrapper.class);
        record.put("bytesField", (Object)ByteBuffer.wrap(new byte[]{1, 20, 0, 60, 2, 108}));
        expectedWrapperClass.put("bytesField", BytesWrapper.class);
        record.put("stringField", (Object)"abcdefghijk");
        expectedWrapperClass.put("stringField", StringWrapper.class);
        record.put("decimalField", (Object)ByteBuffer.wrap(StringUtils.getUTF8Bytes((String)"9213032.4966")));
        expectedWrapperClass.put("decimalField", BytesWrapper.class);
        record.put("timeMillisField", (Object)57996136);
        expectedWrapperClass.put("timeMillisField", IntWrapper.class);
        record.put("timeMicrosField", (Object)57996136930L);
        expectedWrapperClass.put("timeMicrosField", LongWrapper.class);
        record.put("timestampMillisField", (Object)1690828731156L);
        expectedWrapperClass.put("timestampMillisField", LongWrapper.class);
        record.put("timestampMicrosField", (Object)1690828731156982L);
        expectedWrapperClass.put("timestampMicrosField", LongWrapper.class);
        record.put("localTimestampMillisField", (Object)1690828731156L);
        expectedWrapperClass.put("localTimestampMillisField", LongWrapper.class);
        record.put("localTimestampMicrosField", (Object)1690828731156982L);
        expectedWrapperClass.put("localTimestampMicrosField", LongWrapper.class);
        GenericDatumWriter writer = new GenericDatumWriter(schema);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BinaryEncoder encoder = EncoderFactory.get().binaryEncoder((OutputStream)baos, null);
        writer.write((Object)record, (Encoder)encoder);
        encoder.flush();
        byte[] data = baos.toByteArray();
        GenericDatumReader reader = new GenericDatumReader(schema);
        BinaryDecoder decoder = DecoderFactory.get().binaryDecoder(data, 0, data.length, null);
        GenericRecord deserializedRecord = (GenericRecord)reader.read(null, (Decoder)decoder);
        Map<String, Object> fieldValueMapping = deserializedRecord.getSchema().getFields().stream().collect(Collectors.toMap(Schema.Field::name, field -> deserializedRecord.get(field.name())));
        for (String fieldName : fieldValueMapping.keySet()) {
            Object value = fieldValueMapping.get(fieldName);
            Object wrapperValue = HoodieAvroUtils.wrapValueIntoAvro((Comparable)((Comparable)value));
            Assertions.assertTrue((boolean)((Class)expectedWrapperClass.get(fieldName)).isInstance(wrapperValue));
            if (value instanceof Utf8) {
                Assertions.assertEquals((Object)value.toString(), (Object)((GenericRecord)wrapperValue).get(0));
                Assertions.assertEquals((Object)value.toString(), (Object)HoodieAvroUtils.unwrapAvroValueWrapper((Object)wrapperValue));
                continue;
            }
            Assertions.assertEquals((Object)value, (Object)((GenericRecord)wrapperValue).get(0));
            Assertions.assertEquals((Object)value, (Object)HoodieAvroUtils.unwrapAvroValueWrapper((Object)wrapperValue));
        }
    }

    public static Stream<Arguments> javaValueParams() {
        Object[][] data = new Object[][]{{new Timestamp(1690766971000L), TimestampMicrosWrapper.class}, {new Date(1672560000000L), DateWrapper.class}, {LocalDate.of(2023, 1, 1), DateWrapper.class}, {new BigDecimal("12345678901234.2948"), DecimalWrapper.class}};
        return Stream.of(data).map(Arguments::of);
    }

    @ParameterizedTest
    @MethodSource(value={"javaValueParams"})
    public void testWrapAndUnwrapJavaValues(Comparable value, Class expectedWrapper) {
        Object wrapperValue = HoodieAvroUtils.wrapValueIntoAvro((Comparable)value);
        Assertions.assertTrue((boolean)expectedWrapper.isInstance(wrapperValue));
        if (value instanceof Timestamp) {
            Assertions.assertEquals((Object)(((Timestamp)value).getTime() * 1000L), (Object)((GenericRecord)wrapperValue).get(0));
            Assertions.assertEquals((long)((Timestamp)value).getTime(), (long)((Instant)HoodieAvroUtils.unwrapAvroValueWrapper((Object)wrapperValue)).toEpochMilli());
        } else if (value instanceof Date) {
            Assertions.assertEquals((Object)((int)ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), ((Date)value).toLocalDate())), (Object)((GenericRecord)wrapperValue).get(0));
            Assertions.assertEquals((Object)((Date)value).toLocalDate(), (Object)HoodieAvroUtils.unwrapAvroValueWrapper((Object)wrapperValue));
        } else if (value instanceof LocalDate) {
            Assertions.assertEquals((Object)((int)ChronoUnit.DAYS.between(LocalDate.ofEpochDay(0L), (LocalDate)value)), (Object)((GenericRecord)wrapperValue).get(0));
            Assertions.assertEquals((Object)value, (Object)HoodieAvroUtils.unwrapAvroValueWrapper((Object)wrapperValue));
        } else {
            Assertions.assertEquals((Object)"0.000000000000000", (Object)((BigDecimal)value).subtract((BigDecimal)HoodieAvroUtils.unwrapAvroValueWrapper((Object)wrapperValue)).toPlainString());
        }
    }

    @Test
    public void testAddMetadataFields() {
        Schema baseSchema = new Schema.Parser().parse(EXAMPLE_SCHEMA_WITH_PROPS);
        Schema schemaWithMetadata = HoodieAvroUtils.addMetadataFields((Schema)baseSchema);
        List updatedFields = schemaWithMetadata.getFields();
        Assertions.assertEquals((Object)HoodieRecord.COMMIT_TIME_METADATA_FIELD, (Object)((Schema.Field)updatedFields.get(0)).name());
        Assertions.assertEquals((Object)HoodieRecord.COMMIT_SEQNO_METADATA_FIELD, (Object)((Schema.Field)updatedFields.get(1)).name());
        Assertions.assertEquals((Object)HoodieRecord.RECORD_KEY_METADATA_FIELD, (Object)((Schema.Field)updatedFields.get(2)).name());
        Assertions.assertEquals((Object)HoodieRecord.PARTITION_PATH_METADATA_FIELD, (Object)((Schema.Field)updatedFields.get(3)).name());
        Assertions.assertEquals((Object)HoodieRecord.FILENAME_METADATA_FIELD, (Object)((Schema.Field)updatedFields.get(4)).name());
        List originalFieldsInUpdatedSchema = updatedFields.subList(5, updatedFields.size());
        Assertions.assertEquals((Object)baseSchema.getFields(), originalFieldsInUpdatedSchema);
        Assertions.assertEquals((Object)"custom_schema_property_value", (Object)schemaWithMetadata.getProp("custom_schema_property"));
        Assertions.assertEquals((Object)"value", (Object)((Schema.Field)originalFieldsInUpdatedSchema.get(0)).getProp("custom_field_property"));
    }

    @Test
    void testSafeAvroToJsonStringMissingRequiredField() {
        Schema schema = new Schema.Parser().parse(EXAMPLE_SCHEMA);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("non_pii_col", (Object)"val1");
        record.put("pii_col", (Object)"val2");
        record.put("timestamp", (Object)3.5);
        String jsonString = HoodieAvroUtils.safeAvroToJsonString((GenericRecord)record);
        Assertions.assertEquals((Object)"{\"timestamp\": 3.5, \"_row_key\": null, \"non_pii_col\": \"val1\", \"pii_col\": \"val2\"}", (Object)jsonString);
    }

    @Test
    void testSafeAvroToJsonStringBadDataType() {
        Schema schema = new Schema.Parser().parse(EXAMPLE_SCHEMA);
        GenericData.Record record = new GenericData.Record(schema);
        record.put("non_pii_col", (Object)"val1");
        record.put("_row_key", (Object)"key");
        record.put("pii_col", (Object)"val2");
        record.put("timestamp", (Object)"foo");
        String jsonString = HoodieAvroUtils.safeAvroToJsonString((GenericRecord)record);
        Assertions.assertEquals((Object)"{\"timestamp\": \"foo\", \"_row_key\": \"key\", \"non_pii_col\": \"val1\", \"pii_col\": \"val2\"}", (Object)jsonString);
    }

    private static /* synthetic */ void lambda$testGetNestedFieldValWithNestedField$7(GenericRecord rec) throws Throwable {
        HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"student.lastname.fake_key", (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void lambda$testGetNestedFieldValWithNestedField$6(GenericRecord rec) throws Throwable {
        HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"student.firstname.fake_key", (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void lambda$testGetNestedFieldValWithNestedField$5(GenericRecord rec) throws Throwable {
        HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"student.fake_key", (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void lambda$testGetNestedFieldValWithNestedField$4(GenericRecord rec) throws Throwable {
        HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"fake_key", (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void lambda$testGetNestedFieldValWithNestedField$3(GenericRecord rec) throws Throwable {
        HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)".", (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void lambda$testGetNestedFieldVal$2(GenericRecord rec) throws Throwable {
        HoodieAvroUtils.getNestedFieldVal((GenericRecord)rec, (String)"fake_key", (boolean)false, (boolean)false);
    }

    private static /* synthetic */ void lambda$testNonNullableFieldWithoutDefault$0(GenericRecord rec) throws Throwable {
        HoodieAvroUtils.rewriteRecord((GenericRecord)rec, (Schema)new Schema.Parser().parse(SCHEMA_WITH_NON_NULLABLE_FIELD));
    }
}

