/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.testutils;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.testutils.HadoopFSTestUtils;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.hudi.storage.StorageConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HoodieMergeOnReadTestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(HoodieMergeOnReadTestUtils.class);

    public static List<GenericRecord> getRecordsUsingInputFormat(StorageConfiguration<?> conf, List<String> inputPaths, String basePath) {
        return HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat(conf, inputPaths, basePath, HadoopFSTestUtils.convertToJobConf(conf), true);
    }

    public static List<GenericRecord> getRecordsUsingInputFormat(StorageConfiguration<?> conf, List<String> inputPaths, String basePath, JobConf jobConf, boolean realtime) {
        return HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat(conf, inputPaths, basePath, jobConf, realtime, true);
    }

    public static List<GenericRecord> getRecordsUsingInputFormat(StorageConfiguration<?> conf, List<String> inputPaths, String basePath, JobConf jobConf, boolean realtime, boolean populateMetaFields) {
        Schema schema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        return HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat(conf, inputPaths, basePath, jobConf, realtime, schema, "bigint,string,string,string,string,string,double,double,double,double,int,bigint,float,binary,int,bigint,decimal(10,6),map<string,string>,struct<amount:double,currency:string>,array<struct<amount:double,currency:string>>,boolean", false, new ArrayList<String>(), populateMetaFields);
    }

    public static List<GenericRecord> getRecordsUsingInputFormat(StorageConfiguration<?> conf, List<String> inputPaths, String basePath, JobConf jobConf, boolean realtime, Schema rawSchema, String rawHiveColumnTypes, boolean projectCols, List<String> projectedColumns) {
        return HoodieMergeOnReadTestUtils.getRecordsUsingInputFormat(conf, inputPaths, basePath, jobConf, realtime, rawSchema, rawHiveColumnTypes, projectCols, projectedColumns, true);
    }

    public static List<GenericRecord> getRecordsUsingInputFormat(StorageConfiguration<?> conf, List<String> inputPaths, String basePath, JobConf jobConf, boolean realtime, Schema rawSchema, String rawHiveColumnTypes, boolean projectCols, List<String> projectedColumns, boolean populateMetaFields) {
        String hiveColumnTypes;
        Schema schema;
        HoodieTableMetaClient metaClient = HoodieTestUtils.createMetaClient(conf, (String)basePath);
        FileInputFormat inputFormat = HoodieInputFormatUtils.getInputFormat((HoodieFileFormat)metaClient.getTableConfig().getBaseFileFormat(), (boolean)realtime, (Configuration)jobConf);
        if (populateMetaFields) {
            schema = HoodieAvroUtils.addMetadataFields((Schema)rawSchema);
            hiveColumnTypes = HoodieAvroUtils.addMetadataColumnTypes((String)rawHiveColumnTypes);
        } else {
            schema = rawSchema;
            hiveColumnTypes = rawHiveColumnTypes;
        }
        HoodieMergeOnReadTestUtils.setPropsForInputFormat(inputFormat, jobConf, schema, hiveColumnTypes, projectCols, projectedColumns, populateMetaFields);
        List fields = projectCols ? schema.getFields().stream().filter(f -> projectedColumns.contains(f.name())).collect(Collectors.toList()) : schema.getFields();
        Schema projectedSchema = Schema.createRecord(fields.stream().map(HoodieAvroUtils::createNewSchemaField).collect(Collectors.toList()));
        ArrayList<GenericRecord> records = new ArrayList<GenericRecord>();
        try {
            InputSplit[] splits;
            FileInputFormat.setInputPaths((JobConf)jobConf, (String)String.join((CharSequence)",", inputPaths));
            for (InputSplit split : splits = inputFormat.getSplits(jobConf, inputPaths.size())) {
                RecordReader recordReader = inputFormat.getRecordReader(split, jobConf, null);
                Object key = recordReader.createKey();
                ArrayWritable writable = (ArrayWritable)recordReader.createValue();
                while (recordReader.next(key, (Object)writable)) {
                    GenericRecordBuilder newRecord = new GenericRecordBuilder(projectedSchema);
                    Writable[] values = writable.get();
                    schema.getFields().stream().filter(f -> !projectCols || projectedColumns.contains(f.name())).map(f -> Pair.of((Object)projectedSchema.getFields().stream().filter(p -> f.name().equals(p.name())).findFirst().get(), (Object)f)).forEach(fieldsPair -> newRecord.set((Schema.Field)fieldsPair.getKey(), (Object)values[((Schema.Field)fieldsPair.getValue()).pos()]));
                    records.add((GenericRecord)newRecord.build());
                }
                recordReader.close();
            }
        }
        catch (IOException ie) {
            LOG.error("Read records error", (Throwable)ie);
        }
        return records;
    }

    private static void setPropsForInputFormat(FileInputFormat inputFormat, JobConf jobConf, Schema schema, String hiveColumnTypes, boolean projectCols, List<String> projectedCols, boolean populateMetaFieldsConfigValue) {
        List fields = schema.getFields();
        List<String> projectedColNames = !projectCols ? fields.stream().map(Schema.Field::name).collect(Collectors.toList()) : projectedCols;
        String names = fields.stream().filter(f -> projectedColNames.contains(f.name())).map(f -> f.name()).collect(Collectors.joining(","));
        String positions = fields.stream().filter(f -> projectedColNames.contains(f.name())).map(f -> String.valueOf(f.pos())).collect(Collectors.joining(","));
        String hiveColumnNames = fields.stream().filter(field -> !field.name().equalsIgnoreCase("datestr")).map(Schema.Field::name).collect(Collectors.joining(","));
        hiveColumnNames = hiveColumnNames + ",datestr";
        StorageConfiguration conf = HoodieTestUtils.getDefaultStorageConf();
        String hiveColumnTypesWithDatestr = hiveColumnTypes + ",string";
        jobConf.set("columns", hiveColumnNames);
        jobConf.set("columns.types", hiveColumnTypesWithDatestr);
        jobConf.set("hive.io.file.readcolumn.names", names);
        jobConf.set("hive.io.file.readcolumn.ids", positions);
        jobConf.set("partition_columns", "datestr");
        conf.set("columns", hiveColumnNames);
        conf.set("hive.io.file.readcolumn.names", names);
        conf.set("hive.io.file.readcolumn.ids", positions);
        conf.set("partition_columns", "datestr");
        conf.set("columns.types", hiveColumnTypesWithDatestr);
        conf.set("columns", hiveColumnNames);
        conf.set("columns.types", hiveColumnTypesWithDatestr);
        HadoopFSTestUtils.setConfForConfigurableInputFormat((FileInputFormat)inputFormat, (Configuration)HadoopFSTestUtils.convertToHadoopConf((StorageConfiguration)conf));
        jobConf.addResource(HadoopFSTestUtils.convertToHadoopConf((StorageConfiguration)conf));
    }
}

