/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class TestUpgradeDowngradeUtils {
    TestUpgradeDowngradeUtils() {
    }

    private HoodieTable createMockTable(Option<HoodieIndexMetadata> indexMetadataOpt) {
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)table.getMetaClient()).thenReturn((Object)metaClient);
        Mockito.when((Object)metaClient.getIndexMetadata()).thenReturn(indexMetadataOpt);
        return table;
    }

    @Test
    void testConvertCompletionTimeToEpoch() {
        String completionTime = "20241112153045678";
        HoodieInstant instant = new HoodieInstant(HoodieInstant.State.COMPLETED, "commit", "20231112153045678", completionTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMddHHmmss");
        LocalDateTime dateTime = LocalDateTime.parse(completionTime.substring(0, completionTime.length() - 3), formatter);
        long expectedEpoch = dateTime.atZone(ZoneId.systemDefault()).toEpochSecond() * 1000L + Long.parseLong(completionTime.substring(completionTime.length() - 3));
        Assertions.assertEquals((long)expectedEpoch, (long)UpgradeDowngradeUtils.convertCompletionTimeToEpoch((HoodieInstant)instant), (String)"Epoch time does not match the expected value.");
        String invalidCompletionTime = "12345";
        HoodieInstant inValidInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "dummy_action", "20231112153045678", invalidCompletionTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        Assertions.assertEquals((long)-1L, (long)UpgradeDowngradeUtils.convertCompletionTimeToEpoch((HoodieInstant)inValidInstant), (String)"Epoch time for invalid input should be -1.");
    }

    @Test
    void testSetPropertiesBasedOnMetadataPartitionsWithEmptySet() {
        TypedProperties properties = new TypedProperties();
        HashSet emptyPartitions = new HashSet();
        UpgradeDowngradeUtils.setPropertiesBasedOnMetadataPartitions((TypedProperties)properties, emptyPartitions, null);
        Assertions.assertEquals((Object)"false", (Object)properties.getString(HoodieMetadataConfig.ENABLE.key()));
    }

    @Test
    void testSetPropertiesBasedOnMetadataPartitionsWithBloomFilters() {
        TypedProperties properties = new TypedProperties();
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("bloom_filters");
        HoodieTable table = this.createMockTable((Option<HoodieIndexMetadata>)Option.empty());
        UpgradeDowngradeUtils.setPropertiesBasedOnMetadataPartitions((TypedProperties)properties, partitions, (HoodieTable)table);
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE.key()));
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE_METADATA_INDEX_BLOOM_FILTER.key()));
    }

    @Test
    void testSetPropertiesBasedOnMetadataPartitionsWithAnyOtherIndexes() {
        TypedProperties properties = new TypedProperties();
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("any_other_index");
        HoodieTable table = this.createMockTable((Option<HoodieIndexMetadata>)Option.empty());
        UpgradeDowngradeUtils.setPropertiesBasedOnMetadataPartitions((TypedProperties)properties, partitions, (HoodieTable)table);
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE.key()));
    }

    @Test
    void testSetPropertiesBasedOnMetadataPartitionsWithMultiplePartitions() {
        TypedProperties properties = new TypedProperties();
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("column_stats");
        partitions.add("bloom_filters");
        partitions.add("record_index");
        HoodieTable table = this.createMockTable((Option<HoodieIndexMetadata>)Option.empty());
        UpgradeDowngradeUtils.setPropertiesBasedOnMetadataPartitions((TypedProperties)properties, partitions, (HoodieTable)table);
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE.key()));
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()));
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE_METADATA_INDEX_BLOOM_FILTER.key()));
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key()));
    }

    @Test
    void testSetPropertiesBasedOnMetadataPartitionsWithColumnStatsAndSourceFields() {
        TypedProperties properties = new TypedProperties();
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("column_stats");
        HashMap<String, HoodieIndexDefinition> indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
        List<String> sourceFields = Arrays.asList("field1", "field2", "field3");
        HoodieIndexDefinition columnStatsDef = HoodieIndexDefinition.newBuilder().withIndexName("column_stats").withIndexType("column_stats").withSourceFields(sourceFields).build();
        indexDefinitions.put("column_stats", columnStatsDef);
        HoodieIndexMetadata indexMetadata = new HoodieIndexMetadata(indexDefinitions);
        HoodieTable table = this.createMockTable((Option<HoodieIndexMetadata>)Option.of((Object)indexMetadata));
        UpgradeDowngradeUtils.setPropertiesBasedOnMetadataPartitions((TypedProperties)properties, partitions, (HoodieTable)table);
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE.key()));
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE_METADATA_INDEX_COLUMN_STATS.key()));
        Assertions.assertEquals((Object)"field1,field2,field3", (Object)properties.getString(HoodieMetadataConfig.COLUMN_STATS_INDEX_FOR_COLUMNS.key()));
    }

    @Test
    void testSetPropertiesBasedOnMetadataPartitionsWithRecordIndexPartitioned() {
        TypedProperties properties = new TypedProperties();
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("record_index");
        HashMap<String, HoodieIndexDefinition> indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
        HashMap<String, String> indexOptions = new HashMap<String, String>();
        indexOptions.put("isPartitioned", "true");
        HoodieIndexDefinition recordIndexDef = HoodieIndexDefinition.newBuilder().withIndexName("record_index").withIndexType("record_index").withIndexOptions(indexOptions).build();
        indexDefinitions.put("record_index", recordIndexDef);
        HoodieIndexMetadata indexMetadata = new HoodieIndexMetadata(indexDefinitions);
        HoodieTable table = this.createMockTable((Option<HoodieIndexMetadata>)Option.of((Object)indexMetadata));
        UpgradeDowngradeUtils.setPropertiesBasedOnMetadataPartitions((TypedProperties)properties, partitions, (HoodieTable)table);
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE.key()));
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.RECORD_LEVEL_INDEX_ENABLE_PROP.key()));
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void testSetPropertiesBasedOnMetadataPartitionsWithRecordIndexNonPartitioned(boolean explicitlySetPartitionedInIndexDef) {
        TypedProperties properties = new TypedProperties();
        HashSet<String> partitions = new HashSet<String>();
        partitions.add("record_index");
        HashMap<String, HoodieIndexDefinition> indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
        HashMap<String, String> indexOptions = new HashMap<String, String>();
        if (explicitlySetPartitionedInIndexDef) {
            indexOptions.put("isPartitioned", "false");
        }
        HoodieIndexDefinition recordIndexDef = HoodieIndexDefinition.newBuilder().withIndexName("record_index").withIndexType("record_index").withIndexOptions(indexOptions).build();
        indexDefinitions.put("record_index", recordIndexDef);
        HoodieIndexMetadata indexMetadata = new HoodieIndexMetadata(indexDefinitions);
        HoodieTable table = this.createMockTable((Option<HoodieIndexMetadata>)Option.of((Object)indexMetadata));
        UpgradeDowngradeUtils.setPropertiesBasedOnMetadataPartitions((TypedProperties)properties, partitions, (HoodieTable)table);
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.ENABLE.key()));
        Assertions.assertEquals((Object)"true", (Object)properties.getString(HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key()));
    }
}

