/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.PartialUpdateAvroPayload;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.NineToEightDowngradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestNineToEightDowngradeHandler {
    private final NineToEightDowngradeHandler handler = new NineToEightDowngradeHandler();
    private final HoodieWriteConfig config = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
    private final HoodieEngineContext context = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
    private final HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
    private HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
    private HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
    private SupportsUpgradeDowngrade upgradeDowngradeHelper = (SupportsUpgradeDowngrade)Mockito.mock(SupportsUpgradeDowngrade.class);

    TestNineToEightDowngradeHandler() {
    }

    @BeforeEach
    public void setUp() {
        Mockito.when((Object)this.upgradeDowngradeHelper.getTable((HoodieWriteConfig)ArgumentMatchers.any(), (HoodieEngineContext)ArgumentMatchers.any())).thenReturn((Object)this.table);
        Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
        Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)this.tableConfig);
        Mockito.when((Object)this.tableConfig.getOrderingFieldsStr()).thenReturn((Object)Option.empty());
    }

    static Stream<Arguments> payloadClassTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{AWSDmsAvroPayload.class.getName(), 4, HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key() + "," + HoodieTableConfig.PARTIAL_UPDATE_MODE.key() + "," + "hoodie.record.merge.property." + "hoodie.payload.delete.field" + "," + "hoodie.record.merge.property." + "hoodie.payload.delete.marker", 3, true, true, "AWSDmsAvroPayload"}), Arguments.of((Object[])new Object[]{OverwriteNonDefaultsWithLatestAvroPayload.class.getName(), 2, HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key() + "," + HoodieTableConfig.PARTIAL_UPDATE_MODE.key(), 3, true, true, "OverwriteNonDefaultsWithLatestAvroPayload"}), Arguments.of((Object[])new Object[]{PartialUpdateAvroPayload.class.getName(), 2, HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key() + "," + HoodieTableConfig.PARTIAL_UPDATE_MODE.key(), 3, true, true, "PartialUpdateAvroPayload"}), Arguments.of((Object[])new Object[]{MySqlDebeziumAvroPayload.class.getName(), 5, HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key() + "," + HoodieTableConfig.ORDERING_FIELDS.key() + "," + HoodieTableConfig.PARTIAL_UPDATE_MODE.key() + "," + "hoodie.record.merge.property." + "hoodie.payload.delete.field" + "," + "hoodie.record.merge.property." + "hoodie.payload.delete.marker", 4, true, true, "MySqlDebeziumAvroPayload"}), Arguments.of((Object[])new Object[]{PostgresDebeziumAvroPayload.class.getName(), 5, HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key() + "," + HoodieTableConfig.PARTIAL_UPDATE_MODE.key() + "," + "hoodie.record.merge.property." + "hoodie.write.partial.update.unavailable.value" + "," + "hoodie.record.merge.property." + "hoodie.payload.delete.field" + "," + "hoodie.record.merge.property." + "hoodie.payload.delete.marker", 3, true, true, "PostgresDebeziumAvroPayload"}), Arguments.of((Object[])new Object[]{OverwriteWithLatestAvroPayload.class.getName(), 2, HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key() + "," + HoodieTableConfig.PARTIAL_UPDATE_MODE.key(), 1, false, false, "OverwriteWithLatestAvroPayload"}), Arguments.of((Object[])new Object[]{DefaultHoodieRecordPayload.class.getName(), 2, HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key() + "," + HoodieTableConfig.PARTIAL_UPDATE_MODE.key(), 1, false, false, "DefaultHoodieRecordPayload"}), Arguments.of((Object[])new Object[]{EventTimeAvroPayload.class.getName(), 2, HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME.key() + "," + HoodieTableConfig.PARTIAL_UPDATE_MODE.key(), 1, false, false, "EventTimeAvroPayload"}));
    }

    @ParameterizedTest(name="testDowngradeFor{6}")
    @MethodSource(value={"payloadClassTestCases"})
    void testDowngradeForPayloadClass(String payloadClassName, int expectedPropertiesToRemoveSize, String expectedPropsToRemove, int expectedPropertiesToAddSize, boolean hasRecordMergeMode, boolean hasRecordMergeStrategyId, String testName) {
        try (MockedStatic utilities = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            utilities.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any()), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any()), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any()), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any()), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any()))).thenAnswer(invocation -> null);
            Mockito.when((Object)this.tableConfig.getLegacyPayloadClass()).thenReturn((Object)payloadClassName);
            Mockito.when((Object)this.tableConfig.getTableType()).thenReturn((Object)HoodieTableType.MERGE_ON_READ);
            UpgradeDowngrade.TableConfigChangeSet propertiesToChange = this.handler.downgrade(this.config, this.context, "anyInstant", this.upgradeDowngradeHelper);
            Assertions.assertEquals((int)expectedPropertiesToRemoveSize, (int)propertiesToChange.propertiesToDelete().size());
            if (expectedPropertiesToAddSize > 0) {
                List<String> propsToRemove = Arrays.asList(expectedPropsToRemove.split(","));
                Collections.sort(propsToRemove);
                List actualPropsRemoved = propertiesToChange.propertiesToDelete().stream().map(ConfigProperty::key).sorted().collect(Collectors.toList());
                Assertions.assertEquals(propsToRemove, actualPropsRemoved);
            }
            Assertions.assertTrue((boolean)propertiesToChange.propertiesToDelete().contains(HoodieTableConfig.PARTIAL_UPDATE_MODE));
            Assertions.assertTrue((boolean)propertiesToChange.propertiesToDelete().contains(HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME));
            Assertions.assertEquals((int)expectedPropertiesToAddSize, (int)propertiesToChange.propertiesToUpdate().size());
            Assertions.assertEquals((Object)payloadClassName, propertiesToChange.propertiesToUpdate().get(HoodieTableConfig.PAYLOAD_CLASS_NAME));
            if (hasRecordMergeMode) {
                Assertions.assertEquals((Object)RecordMergeMode.CUSTOM.name(), propertiesToChange.propertiesToUpdate().get(HoodieTableConfig.RECORD_MERGE_MODE));
            }
            if (hasRecordMergeStrategyId) {
                Assertions.assertEquals((Object)"00000000-0000-0000-0000-000000000000", propertiesToChange.propertiesToUpdate().get(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID));
            }
            if (payloadClassName.equals(MySqlDebeziumAvroPayload.class.getName())) {
                Assertions.assertTrue((boolean)propertiesToChange.propertiesToUpdate().containsKey(HoodieTableConfig.PRECOMBINE_FIELD));
                Assertions.assertEquals(propertiesToChange.propertiesToUpdate().get(HoodieTableConfig.PRECOMBINE_FIELD), (Object)"_event_seq");
            }
        }
    }

    @Test
    void testDowngradeForOtherPayloadClass() {
        try (MockedStatic utilities = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            utilities.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any()), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any()), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any()), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any()), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any()))).thenAnswer(invocation -> null);
            Mockito.when((Object)this.tableConfig.getLegacyPayloadClass()).thenReturn((Object)"NonExistentPayloadClass");
            Mockito.when((Object)this.tableConfig.getTableType()).thenReturn((Object)HoodieTableType.MERGE_ON_READ);
            UpgradeDowngrade.TableConfigChangeSet propertiesToChange = this.handler.downgrade(this.config, this.context, "anyInstant", this.upgradeDowngradeHelper);
            Assertions.assertEquals((int)1, (int)propertiesToChange.propertiesToDelete().size());
            Assertions.assertTrue((boolean)propertiesToChange.propertiesToDelete().contains(HoodieTableConfig.PARTIAL_UPDATE_MODE));
            Assertions.assertEquals((int)0, (int)propertiesToChange.propertiesToUpdate().size());
        }
    }

    @Test
    void testDowngradeDropsOnlyV2OrAboveIndexes() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            mockedUtils.when(() -> UpgradeDowngradeUtils.dropNonV1IndexPartitions((HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.eq((Object)this.config)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.eq((Object)this.context)), (HoodieTable)((HoodieTable)ArgumentMatchers.eq((Object)this.table)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.eq((Object)this.upgradeDowngradeHelper)), (String)((String)ArgumentMatchers.any(String.class)))).thenAnswer(invocation -> {
                BaseHoodieWriteClient writeClient = this.upgradeDowngradeHelper.getWriteClient(this.config, this.context);
                List<String> partitionsToDrop = Arrays.asList("secondary_index_v2");
                writeClient.dropIndex(partitionsToDrop);
                return null;
            });
            HashMap<String, HoodieIndexDefinition> indexDefs = new HashMap<String, HoodieIndexDefinition>();
            indexDefs.put(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "v1", HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "v1").withIndexType(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath()).withVersion(HoodieIndexVersion.V1).build());
            indexDefs.put(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "v2", HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "v2").withIndexType(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath()).withVersion(HoodieIndexVersion.V2).build());
            indexDefs.put(MetadataPartitionType.FILES.getPartitionPath(), HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.FILES.getPartitionPath()).withIndexType(MetadataPartitionType.FILES.getPartitionPath()).withVersion(HoodieIndexVersion.V2).build());
            indexDefs.put(MetadataPartitionType.COLUMN_STATS.getPartitionPath(), HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.COLUMN_STATS.getPartitionPath()).withIndexType(MetadataPartitionType.COLUMN_STATS.getPartitionPath()).withVersion(HoodieIndexVersion.V2).build());
            HoodieIndexMetadata metadata = new HoodieIndexMetadata(indexDefs);
            Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)metadata));
            Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)this.tableConfig);
            HashSet mdtPartitions = new HashSet(indexDefs.keySet());
            Mockito.when((Object)this.tableConfig.getMetadataPartitions()).thenReturn(mdtPartitions);
            BaseHoodieWriteClient writeClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
            Mockito.when((Object)this.upgradeDowngradeHelper.getWriteClient(this.config, this.context)).thenReturn((Object)writeClient);
            this.handler.downgrade(this.config, this.context, "20240101120000", this.upgradeDowngradeHelper);
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(List.class);
            ((BaseHoodieWriteClient)Mockito.verify((Object)writeClient, (VerificationMode)Mockito.times((int)1))).dropIndex((List)argumentCaptor.capture());
            List capturedIndexes = (List)argumentCaptor.getValue();
            Assertions.assertEquals(new HashSet<String>(Arrays.asList("secondary_index_v2")), new HashSet(capturedIndexes));
        }
    }

    @Test
    void testDowngradeDropsPartitionStatsWhenColStatsV2IsDeleted() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            mockedUtils.when(() -> UpgradeDowngradeUtils.dropNonV1IndexPartitions((HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.eq((Object)this.config)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.eq((Object)this.context)), (HoodieTable)((HoodieTable)ArgumentMatchers.eq((Object)this.table)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.eq((Object)this.upgradeDowngradeHelper)), (String)((String)ArgumentMatchers.any(String.class)))).thenCallRealMethod();
            HashMap<String, HoodieIndexDefinition> indexDefs = new HashMap<String, HoodieIndexDefinition>();
            indexDefs.put(MetadataPartitionType.COLUMN_STATS.getPartitionPath(), HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.COLUMN_STATS.getPartitionPath()).withIndexType(MetadataPartitionType.COLUMN_STATS.getPartitionPath()).withVersion(HoodieIndexVersion.V2).build());
            HoodieIndexMetadata metadata = new HoodieIndexMetadata(indexDefs);
            Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)metadata));
            Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)this.tableConfig);
            HashSet<String> mdtPartitions = new HashSet<String>();
            mdtPartitions.add(MetadataPartitionType.COLUMN_STATS.getPartitionPath());
            mdtPartitions.add(MetadataPartitionType.PARTITION_STATS.getPartitionPath());
            Mockito.when((Object)this.tableConfig.getMetadataPartitions()).thenReturn(mdtPartitions);
            Mockito.when((Object)this.metaClient.getIndexForMetadataPartition(MetadataPartitionType.COLUMN_STATS.getPartitionPath())).thenReturn((Object)Option.of(indexDefs.get(MetadataPartitionType.COLUMN_STATS.getPartitionPath())));
            Mockito.when((Object)this.metaClient.getIndexForMetadataPartition(MetadataPartitionType.PARTITION_STATS.getPartitionPath())).thenReturn((Object)Option.empty());
            BaseHoodieWriteClient writeClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
            Mockito.when((Object)this.upgradeDowngradeHelper.getWriteClient(this.config, this.context)).thenReturn((Object)writeClient);
            this.handler.downgrade(this.config, this.context, "20240101120000", this.upgradeDowngradeHelper);
            ArgumentCaptor argumentCaptor = ArgumentCaptor.forClass(List.class);
            ((BaseHoodieWriteClient)Mockito.verify((Object)writeClient, (VerificationMode)Mockito.times((int)1))).dropIndex((List)argumentCaptor.capture());
            List capturedIndexes = (List)argumentCaptor.getValue();
            Assertions.assertEquals(new HashSet<String>(Arrays.asList(MetadataPartitionType.COLUMN_STATS.getPartitionPath(), MetadataPartitionType.PARTITION_STATS.getPartitionPath())), new HashSet(capturedIndexes));
        }
    }

    @Test
    void testDowngradeDoesNotDropV1Indexes() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            mockedUtils.when(() -> UpgradeDowngradeUtils.dropNonV1IndexPartitions((HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.eq((Object)this.config)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.eq((Object)this.context)), (HoodieTable)((HoodieTable)ArgumentMatchers.eq((Object)this.table)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.eq((Object)this.upgradeDowngradeHelper)), (String)((String)ArgumentMatchers.any(String.class)))).thenCallRealMethod();
            HashMap<String, HoodieIndexDefinition> indexDefs = new HashMap<String, HoodieIndexDefinition>();
            indexDefs.put(MetadataPartitionType.COLUMN_STATS.getPartitionPath(), HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.COLUMN_STATS.getPartitionPath()).withIndexType(MetadataPartitionType.COLUMN_STATS.getPartitionPath()).withVersion(HoodieIndexVersion.V1).build());
            indexDefs.put(MetadataPartitionType.PARTITION_STATS.getPartitionPath(), HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.PARTITION_STATS.getPartitionPath()).withIndexType(MetadataPartitionType.PARTITION_STATS.getPartitionPath()).withVersion(HoodieIndexVersion.V1).build());
            HoodieIndexMetadata metadata = new HoodieIndexMetadata(indexDefs);
            Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)metadata));
            Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)this.tableConfig);
            HashSet<String> mdtPartitions = new HashSet<String>();
            mdtPartitions.add(MetadataPartitionType.COLUMN_STATS.getPartitionPath());
            mdtPartitions.add(MetadataPartitionType.PARTITION_STATS.getPartitionPath());
            Mockito.when((Object)this.tableConfig.getMetadataPartitions()).thenReturn(mdtPartitions);
            Mockito.when((Object)this.metaClient.getIndexForMetadataPartition(MetadataPartitionType.COLUMN_STATS.getPartitionPath())).thenReturn((Object)Option.of(indexDefs.get(MetadataPartitionType.COLUMN_STATS.getPartitionPath())));
            Mockito.when((Object)this.metaClient.getIndexForMetadataPartition(MetadataPartitionType.PARTITION_STATS.getPartitionPath())).thenReturn((Object)Option.of(indexDefs.get(MetadataPartitionType.PARTITION_STATS.getPartitionPath())));
            BaseHoodieWriteClient writeClient = (BaseHoodieWriteClient)Mockito.mock(BaseHoodieWriteClient.class);
            Mockito.when((Object)this.upgradeDowngradeHelper.getWriteClient(this.config, this.context)).thenReturn((Object)writeClient);
            this.handler.downgrade(this.config, this.context, "20240101120000", this.upgradeDowngradeHelper);
            ((BaseHoodieWriteClient)Mockito.verify((Object)writeClient, (VerificationMode)Mockito.times((int)0))).dropIndex((List)ArgumentMatchers.any());
        }
    }
}

