/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.upgrade;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.hudi.common.config.ConfigProperty;
import org.apache.hudi.common.config.RecordMergeMode;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.AWSDmsAvroPayload;
import org.apache.hudi.common.model.DefaultHoodieRecordPayload;
import org.apache.hudi.common.model.EventTimeAvroPayload;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.model.HoodieIndexMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.OverwriteNonDefaultsWithLatestAvroPayload;
import org.apache.hudi.common.model.OverwriteWithLatestAvroPayload;
import org.apache.hudi.common.model.PartialUpdateAvroPayload;
import org.apache.hudi.common.model.debezium.MySqlDebeziumAvroPayload;
import org.apache.hudi.common.model.debezium.PostgresDebeziumAvroPayload;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.PartialUpdateMode;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieIndexVersion;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.upgrade.EightToNineUpgradeHandler;
import org.apache.hudi.table.upgrade.SupportsUpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngrade;
import org.apache.hudi.table.upgrade.UpgradeDowngradeUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

class TestEightToNineUpgradeHandler {
    private final EightToNineUpgradeHandler handler = new EightToNineUpgradeHandler();
    private final HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
    private final HoodieEngineContext context = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
    private final HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
    private final HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
    private final HoodieTableConfig tableConfig = (HoodieTableConfig)Mockito.mock(HoodieTableConfig.class);
    private final SupportsUpgradeDowngrade upgradeDowngradeHelper = (SupportsUpgradeDowngrade)Mockito.mock(SupportsUpgradeDowngrade.class);
    private final HoodieWriteConfig config = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
    private static final Map<ConfigProperty, String> DEFAULT_CONFIG_UPDATED = Collections.emptyMap();
    private static final Set<ConfigProperty> DEFAULT_CONFIG_REMOVED = Collections.emptySet();
    private static final UpgradeDowngrade.TableConfigChangeSet DEFAULT_UPGRADE_RESULT = new UpgradeDowngrade.TableConfigChangeSet(DEFAULT_CONFIG_UPDATED, DEFAULT_CONFIG_REMOVED);
    private static final String INSTANT_TIME = "20231201120000";
    private StoragePath indexDefPath;
    @TempDir
    private Path tempDir;

    TestEightToNineUpgradeHandler() {
    }

    @BeforeEach
    public void setUp() throws IOException {
        Mockito.when((Object)this.upgradeDowngradeHelper.getTable((HoodieWriteConfig)ArgumentMatchers.any(), (HoodieEngineContext)ArgumentMatchers.any())).thenReturn((Object)this.table);
        Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
        Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)this.tableConfig);
        Mockito.when((Object)this.config.autoUpgrade()).thenReturn((Object)true);
        Mockito.when((Object)this.config.getPayloadClass()).thenReturn(null);
        Mockito.when((Object)this.upgradeDowngradeHelper.getTable(this.config, this.context)).thenReturn((Object)this.table);
        Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)this.metaClient);
        Mockito.when((Object)this.metaClient.getTableConfig()).thenReturn((Object)this.tableConfig);
        Mockito.when((Object)this.metaClient.getStorage()).thenReturn((Object)this.storage);
        Mockito.when((Object)this.tableConfig.getTableVersion()).thenReturn((Object)HoodieTableVersion.EIGHT);
        Mockito.when((Object)this.tableConfig.getOrderingFieldsStr()).thenReturn((Object)Option.empty());
        Mockito.when((Object)this.tableConfig.getPayloadClassIfPresent()).thenReturn((Object)Option.empty());
        this.indexDefPath = new StoragePath(this.tempDir.resolve("index.json").toString());
        Mockito.when((Object)this.metaClient.getIndexDefinitionPath()).thenReturn((Object)this.indexDefPath.toString());
        Mockito.when((Object)this.storage.exists((StoragePath)ArgumentMatchers.any(StoragePath.class))).thenReturn((Object)false);
        Mockito.when((Object)this.storage.createNewFile((StoragePath)ArgumentMatchers.any(StoragePath.class))).thenReturn((Object)true);
        ByteArrayOutputStream capturedContent = new ByteArrayOutputStream();
        Mockito.when((Object)this.storage.create((StoragePath)ArgumentMatchers.any(StoragePath.class), ArgumentMatchers.anyBoolean())).thenReturn((Object)capturedContent);
        Mockito.when((Object)this.config.autoUpgrade()).thenReturn((Object)true);
    }

    static Stream<Arguments> payloadClassTestCases() {
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.addAll(TestEightToNineUpgradeHandler.getArguments(DefaultHoodieRecordPayload.class.getName(), "", null, null, "DefaultHoodieRecordPayload"));
        arguments.addAll(TestEightToNineUpgradeHandler.getArguments(EventTimeAvroPayload.class.getName(), "", RecordMergeMode.EVENT_TIME_ORDERING.name(), null, "EventTimeAvroPayload"));
        arguments.addAll(TestEightToNineUpgradeHandler.getArguments(OverwriteWithLatestAvroPayload.class.getName(), "", null, null, "OverwriteWithLatestAvroPayload"));
        arguments.addAll(TestEightToNineUpgradeHandler.getArguments(AWSDmsAvroPayload.class.getName(), "hoodie.record.merge.property.hoodie.payload.delete.field=Op,hoodie.record.merge.property.hoodie.payload.delete.marker=D", RecordMergeMode.COMMIT_TIME_ORDERING.name(), null, "AWSDmsAvroPayload"));
        arguments.addAll(TestEightToNineUpgradeHandler.getArguments(PostgresDebeziumAvroPayload.class.getName(), "hoodie.record.merge.property.hoodie.write.partial.update.unavailable.value=__debezium_unavailable_value,hoodie.record.merge.property.hoodie.payload.delete.field=_change_operation_type,hoodie.record.merge.property.hoodie.payload.delete.marker=d", RecordMergeMode.EVENT_TIME_ORDERING.name(), PartialUpdateMode.FILL_UNAVAILABLE.name(), "PostgresDebeziumAvroPayload"));
        arguments.addAll(TestEightToNineUpgradeHandler.getArguments(PartialUpdateAvroPayload.class.getName(), "", RecordMergeMode.EVENT_TIME_ORDERING.name(), PartialUpdateMode.IGNORE_DEFAULTS.name(), "PartialUpdateAvroPayload"));
        arguments.addAll(TestEightToNineUpgradeHandler.getArguments(MySqlDebeziumAvroPayload.class.getName(), "hoodie.record.merge.property.hoodie.payload.delete.field=_change_operation_type,hoodie.record.merge.property.hoodie.payload.delete.marker=d", RecordMergeMode.EVENT_TIME_ORDERING.name(), null, "MySqlDebeziumAvroPayload"));
        arguments.addAll(TestEightToNineUpgradeHandler.getArguments(OverwriteNonDefaultsWithLatestAvroPayload.class.getName(), "", RecordMergeMode.COMMIT_TIME_ORDERING.name(), PartialUpdateMode.IGNORE_DEFAULTS.name(), "OverwriteNonDefaultsWithLatestAvroPayload"));
        return arguments.stream();
    }

    private static List<Arguments> getArguments(String payloadClassName, String expectedMergeProperties, String expectedRecordMergeMode, String expectedPartialUpdateMode, String testName) {
        return Arrays.asList(Arguments.of((Object[])new Object[]{payloadClassName, expectedMergeProperties, expectedRecordMergeMode, expectedPartialUpdateMode, testName, true}), Arguments.of((Object[])new Object[]{payloadClassName, expectedMergeProperties, expectedRecordMergeMode, expectedPartialUpdateMode, testName, false}));
    }

    @ParameterizedTest(name="testUpgradeWith{4}")
    @MethodSource(value={"payloadClassTestCases"})
    void testUpgradeWithPayloadClass(String payloadClassName, String expectedMergeProperties, String expectedRecordMergeMode, String expectedPartialUpdateMode, String testName, boolean isPayloadClassConfiguredInTableConfig) {
        try (MockedStatic utilities = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            utilities.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any()), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any()), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any()), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any()), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any()))).thenAnswer(invocation -> null);
            if (isPayloadClassConfiguredInTableConfig) {
                Mockito.when((Object)this.tableConfig.getPayloadClassIfPresent()).thenReturn((Object)Option.ofNullable((Object)payloadClassName));
            } else {
                Mockito.when((Object)this.config.getPayloadClass()).thenReturn((Object)payloadClassName);
            }
            Mockito.when((Object)this.tableConfig.getTableType()).thenReturn((Object)HoodieTableType.MERGE_ON_READ);
            Mockito.when((Object)this.tableConfig.getRecordMergeStrategyId()).thenReturn((Object)"1897ef5f-18bc-4557-939c-9d6a8afd1519");
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
            UpgradeDowngrade.TableConfigChangeSet propertiesToHandle = this.handler.upgrade(this.config, this.context, "anyInstant", this.upgradeDowngradeHelper);
            Map propertiesToAdd = propertiesToHandle.propertiesToUpdate();
            Set propertiesToRemove = propertiesToHandle.propertiesToDelete();
            if (!StringUtils.isNullOrEmpty((String)expectedMergeProperties)) {
                String[] configs;
                for (String config : configs = expectedMergeProperties.split(",")) {
                    String[] kv = config.split("=");
                    boolean found = false;
                    for (Map.Entry e : propertiesToAdd.entrySet()) {
                        if (!((ConfigProperty)e.getKey()).key().equals(kv[0])) continue;
                        Assertions.assertEquals((Object)kv[1], e.getValue());
                        found = true;
                    }
                    Assertions.assertTrue((boolean)found);
                }
            }
            if (expectedRecordMergeMode == null) {
                Assertions.assertFalse((boolean)propertiesToAdd.containsKey(HoodieTableConfig.RECORD_MERGE_MODE));
            } else {
                Assertions.assertTrue((boolean)propertiesToAdd.containsKey(HoodieTableConfig.RECORD_MERGE_MODE));
                Assertions.assertEquals((Object)expectedRecordMergeMode, propertiesToAdd.get(HoodieTableConfig.RECORD_MERGE_MODE));
            }
            if (expectedPartialUpdateMode != null) {
                Assertions.assertTrue((boolean)propertiesToAdd.containsKey(HoodieTableConfig.PARTIAL_UPDATE_MODE));
                Assertions.assertEquals((Object)expectedPartialUpdateMode, propertiesToAdd.get(HoodieTableConfig.PARTIAL_UPDATE_MODE));
            } else {
                Assertions.assertFalse((boolean)propertiesToAdd.containsKey(HoodieTableConfig.PARTIAL_UPDATE_MODE));
            }
            this.assertPayloadClassChange(propertiesToAdd, propertiesToRemove, payloadClassName);
        }
    }

    @Test
    void testUpgradeWithNoIndexMetadata() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.empty());
            UpgradeDowngrade.TableConfigChangeSet result = this.handler.upgrade(this.config, this.context, INSTANT_TIME, this.upgradeDowngradeHelper);
            Assertions.assertEquals((Object)DEFAULT_UPGRADE_RESULT.propertiesToUpdate(), (Object)result.propertiesToUpdate());
            Assertions.assertEquals(Collections.singleton(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID), (Object)result.propertiesToDelete());
        }
    }

    private void assertPayloadClassChange(Map<ConfigProperty, String> propertiesToAdd, Set<ConfigProperty> propertiesToRemove, String payloadClass) {
        if (payloadClass.equals(MySqlDebeziumAvroPayload.class.getName()) || payloadClass.equals(PostgresDebeziumAvroPayload.class.getName())) {
            Assertions.assertEquals((int)3, (int)propertiesToRemove.size());
            Assertions.assertTrue((boolean)propertiesToRemove.contains(HoodieTableConfig.PRECOMBINE_FIELD));
        } else {
            Assertions.assertEquals((int)2, (int)propertiesToRemove.size());
        }
        Assertions.assertTrue((boolean)propertiesToRemove.contains(HoodieTableConfig.PAYLOAD_CLASS_NAME));
        Assertions.assertTrue((boolean)propertiesToRemove.contains(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID));
        Assertions.assertTrue((boolean)propertiesToAdd.containsKey(HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME));
        Assertions.assertEquals((Object)payloadClass, (Object)propertiesToAdd.get(HoodieTableConfig.LEGACY_PAYLOAD_CLASS_NAME));
        if (payloadClass.equals(MySqlDebeziumAvroPayload.class.getName())) {
            Assertions.assertTrue((boolean)propertiesToAdd.containsKey(HoodieTableConfig.ORDERING_FIELDS));
            Assertions.assertEquals((Object)"_event_bin_file,_event_pos", (Object)propertiesToAdd.get(HoodieTableConfig.ORDERING_FIELDS));
            Assertions.assertTrue((boolean)propertiesToRemove.contains(HoodieTableConfig.PRECOMBINE_FIELD));
        } else if (payloadClass.equals(PostgresDebeziumAvroPayload.class.getName())) {
            Assertions.assertEquals((Object)"_event_lsn", (Object)propertiesToAdd.get(HoodieTableConfig.ORDERING_FIELDS));
        }
    }

    @Test
    void testUpgradeWithMissingIndexVersion() throws IOException {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);
             MockedStatic mockedMetaClient = Mockito.mockStatic(HoodieTableMetaClient.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            mockedMetaClient.when(() -> HoodieTableMetaClient.writeIndexMetadataToStorage((HoodieStorage)((HoodieStorage)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any(String.class)), (HoodieIndexMetadata)((HoodieIndexMetadata)ArgumentMatchers.any(HoodieIndexMetadata.class)), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenCallRealMethod();
            HoodieIndexMetadata indexMetadata = this.createIndexMetadataWithMissingVersions();
            Assertions.assertNull((Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("column_stats")).getVersion());
            Assertions.assertNull((Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("secondary_index_idx_price")).getVersion());
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
            ByteArrayOutputStream capturedContent = new ByteArrayOutputStream();
            Mockito.when((Object)this.storage.create((StoragePath)ArgumentMatchers.eq((Object)this.indexDefPath), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)capturedContent);
            UpgradeDowngrade.TableConfigChangeSet result = this.handler.upgrade(this.config, this.context, INSTANT_TIME, this.upgradeDowngradeHelper);
            Assertions.assertEquals((Object)DEFAULT_UPGRADE_RESULT.propertiesToUpdate(), (Object)result.propertiesToUpdate());
            Assertions.assertEquals(Collections.singleton(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID), (Object)result.propertiesToDelete());
            ((HoodieStorage)Mockito.verify((Object)this.storage)).create(this.indexDefPath, true);
            String writtenJson = capturedContent.toString();
            String expectedJson = "{\n  \"indexDefinitions\": {\n    \"column_stats\": {\n      \"indexName\": \"column_stats\",\n      \"indexType\": \"column_stats\",\n      \"indexFunction\": \"column_stats\",\n      \"sourceFields\": [\"field1\", \"field2\"],\n      \"indexOptions\": {},\n      \"version\": \"V1\"\n    },\n    \"secondary_index_idx_price\": {\n      \"indexName\": \"secondary_index_idx_price\",\n      \"indexType\": \"secondary_index\",\n      \"indexFunction\": \"identity\",\n      \"sourceFields\": [\"price\"],\n      \"indexOptions\": {},\n      \"version\": \"V1\"\n    }\n  }\n}";
            HoodieIndexMetadata writtenMetadata = HoodieIndexMetadata.fromJson((String)writtenJson);
            HoodieIndexMetadata expectedMetadata = HoodieIndexMetadata.fromJson((String)expectedJson);
            Assertions.assertEquals((int)expectedMetadata.getIndexDefinitions().size(), (int)writtenMetadata.getIndexDefinitions().size());
            HoodieIndexDefinition writtenColumnStats = (HoodieIndexDefinition)writtenMetadata.getIndexDefinitions().get("column_stats");
            HoodieIndexDefinition expectedColumnStats = (HoodieIndexDefinition)expectedMetadata.getIndexDefinitions().get("column_stats");
            Assertions.assertEquals((Object)expectedColumnStats.getIndexName(), (Object)writtenColumnStats.getIndexName());
            Assertions.assertEquals((Object)expectedColumnStats.getIndexType(), (Object)writtenColumnStats.getIndexType());
            Assertions.assertEquals((Object)expectedColumnStats.getIndexFunction(), (Object)writtenColumnStats.getIndexFunction());
            Assertions.assertEquals((Object)expectedColumnStats.getSourceFields(), (Object)writtenColumnStats.getSourceFields());
            Assertions.assertEquals((Object)expectedColumnStats.getIndexOptions(), (Object)writtenColumnStats.getIndexOptions());
            Assertions.assertEquals((Object)expectedColumnStats.getVersion(), (Object)writtenColumnStats.getVersion());
            HoodieIndexDefinition writtenSecondaryIndex = (HoodieIndexDefinition)writtenMetadata.getIndexDefinitions().get("secondary_index_idx_price");
            HoodieIndexDefinition expectedSecondaryIndex = (HoodieIndexDefinition)expectedMetadata.getIndexDefinitions().get("secondary_index_idx_price");
            Assertions.assertEquals((Object)expectedSecondaryIndex.getIndexName(), (Object)writtenSecondaryIndex.getIndexName());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getIndexType(), (Object)writtenSecondaryIndex.getIndexType());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getIndexFunction(), (Object)writtenSecondaryIndex.getIndexFunction());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getSourceFields(), (Object)writtenSecondaryIndex.getSourceFields());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getIndexOptions(), (Object)writtenSecondaryIndex.getIndexOptions());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getVersion(), (Object)writtenSecondaryIndex.getVersion());
        }
    }

    @Test
    void testUpgradeWithIndexMetadataHavingVersions() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            HoodieIndexMetadata indexMetadata = this.createIndexMetadataWithVersions();
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
            UpgradeDowngrade.TableConfigChangeSet result = this.handler.upgrade(this.config, this.context, INSTANT_TIME, this.upgradeDowngradeHelper);
            Assertions.assertEquals((Object)DEFAULT_UPGRADE_RESULT.propertiesToUpdate(), (Object)result.propertiesToUpdate());
            Assertions.assertEquals(Collections.singleton(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID), (Object)result.propertiesToDelete());
        }
    }

    @Test
    void testUpgradeWithEmptyIndexMetadata() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            HoodieIndexMetadata indexMetadata = new HoodieIndexMetadata();
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
            UpgradeDowngrade.TableConfigChangeSet result = this.handler.upgrade(this.config, this.context, INSTANT_TIME, this.upgradeDowngradeHelper);
            Assertions.assertEquals((Object)DEFAULT_UPGRADE_RESULT.propertiesToUpdate(), (Object)result.propertiesToUpdate());
            Assertions.assertEquals(Collections.singleton(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID), (Object)result.propertiesToDelete());
        }
    }

    @Test
    void testUpgradeWithFileAlreadyExists() throws IOException {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);
             MockedStatic mockedMetaClient = Mockito.mockStatic(HoodieTableMetaClient.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            mockedMetaClient.when(() -> HoodieTableMetaClient.writeIndexMetadataToStorage((HoodieStorage)((HoodieStorage)ArgumentMatchers.any()), (String)((String)ArgumentMatchers.any(String.class)), (HoodieIndexMetadata)((HoodieIndexMetadata)ArgumentMatchers.any(HoodieIndexMetadata.class)), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenCallRealMethod();
            HoodieIndexMetadata indexMetadata = this.createIndexMetadataWithMissingVersions();
            Mockito.when((Object)this.metaClient.getIndexMetadata()).thenReturn((Object)Option.of((Object)indexMetadata));
            Mockito.when((Object)this.storage.exists(this.indexDefPath)).thenReturn((Object)true);
            ByteArrayOutputStream capturedContent = new ByteArrayOutputStream();
            Mockito.when((Object)this.storage.create((StoragePath)ArgumentMatchers.eq((Object)this.indexDefPath), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)capturedContent);
            UpgradeDowngrade.TableConfigChangeSet result = this.handler.upgrade(this.config, this.context, INSTANT_TIME, this.upgradeDowngradeHelper);
            Assertions.assertEquals((Object)DEFAULT_UPGRADE_RESULT.propertiesToUpdate(), (Object)result.propertiesToUpdate());
            Assertions.assertEquals(Collections.singleton(HoodieTableConfig.RECORD_MERGE_STRATEGY_ID), (Object)result.propertiesToDelete());
            ((HoodieStorage)Mockito.verify((Object)this.storage)).create(this.indexDefPath, true);
            String writtenJson = capturedContent.toString();
            String expectedJson = "{\n  \"indexDefinitions\": {\n    \"column_stats\": {\n      \"indexName\": \"column_stats\",\n      \"indexType\": \"column_stats\",\n      \"indexFunction\": \"column_stats\",\n      \"sourceFields\": [\"field1\", \"field2\"],\n      \"indexOptions\": {},\n      \"version\": \"V1\"\n    },\n    \"secondary_index_idx_price\": {\n      \"indexName\": \"secondary_index_idx_price\",\n      \"indexType\": \"secondary_index\",\n      \"indexFunction\": \"identity\",\n      \"sourceFields\": [\"price\"],\n      \"indexOptions\": {},\n      \"version\": \"V1\"\n    }\n  }\n}";
            HoodieIndexMetadata writtenMetadata = HoodieIndexMetadata.fromJson((String)writtenJson);
            HoodieIndexMetadata expectedMetadata = HoodieIndexMetadata.fromJson((String)expectedJson);
            Assertions.assertEquals((int)expectedMetadata.getIndexDefinitions().size(), (int)writtenMetadata.getIndexDefinitions().size());
            HoodieIndexDefinition writtenColumnStats = (HoodieIndexDefinition)writtenMetadata.getIndexDefinitions().get("column_stats");
            HoodieIndexDefinition expectedColumnStats = (HoodieIndexDefinition)expectedMetadata.getIndexDefinitions().get("column_stats");
            Assertions.assertEquals((Object)expectedColumnStats.getIndexName(), (Object)writtenColumnStats.getIndexName());
            Assertions.assertEquals((Object)expectedColumnStats.getIndexType(), (Object)writtenColumnStats.getIndexType());
            Assertions.assertEquals((Object)expectedColumnStats.getIndexFunction(), (Object)writtenColumnStats.getIndexFunction());
            Assertions.assertEquals((Object)expectedColumnStats.getSourceFields(), (Object)writtenColumnStats.getSourceFields());
            Assertions.assertEquals((Object)expectedColumnStats.getIndexOptions(), (Object)writtenColumnStats.getIndexOptions());
            Assertions.assertEquals((Object)expectedColumnStats.getVersion(), (Object)writtenColumnStats.getVersion());
            HoodieIndexDefinition writtenSecondaryIndex = (HoodieIndexDefinition)writtenMetadata.getIndexDefinitions().get("secondary_index_idx_price");
            HoodieIndexDefinition expectedSecondaryIndex = (HoodieIndexDefinition)expectedMetadata.getIndexDefinitions().get("secondary_index_idx_price");
            Assertions.assertEquals((Object)expectedSecondaryIndex.getIndexName(), (Object)writtenSecondaryIndex.getIndexName());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getIndexType(), (Object)writtenSecondaryIndex.getIndexType());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getIndexFunction(), (Object)writtenSecondaryIndex.getIndexFunction());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getSourceFields(), (Object)writtenSecondaryIndex.getSourceFields());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getIndexOptions(), (Object)writtenSecondaryIndex.getIndexOptions());
            Assertions.assertEquals((Object)expectedSecondaryIndex.getVersion(), (Object)writtenSecondaryIndex.getVersion());
        }
    }

    private HoodieIndexMetadata createIndexMetadataWithMissingVersions() {
        HashMap<String, HoodieIndexDefinition> indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
        HoodieIndexDefinition columnStatsDef = HoodieIndexDefinition.newBuilder().withIndexName("column_stats").withIndexType("column_stats").withIndexFunction("column_stats").withSourceFields(Arrays.asList("field1", "field2")).withIndexOptions(Collections.emptyMap()).build();
        HoodieIndexDefinition secondaryIndexDef = HoodieIndexDefinition.newBuilder().withIndexName("secondary_index_idx_price").withIndexType("secondary_index").withIndexFunction("identity").withSourceFields(Arrays.asList("price")).withIndexOptions(Collections.emptyMap()).build();
        indexDefinitions.put("column_stats", columnStatsDef);
        indexDefinitions.put("secondary_index_idx_price", secondaryIndexDef);
        return new HoodieIndexMetadata(indexDefinitions);
    }

    private HoodieIndexMetadata createIndexMetadataWithVersions() {
        HashMap<String, HoodieIndexDefinition> indexDefinitions = new HashMap<String, HoodieIndexDefinition>();
        HoodieIndexDefinition columnStatsDef = HoodieIndexDefinition.newBuilder().withIndexName("column_stats").withIndexType("column_stats").withIndexFunction("column_stats").withSourceFields(Arrays.asList("field1", "field2")).withIndexOptions(Collections.emptyMap()).withVersion(HoodieIndexVersion.V1).build();
        HoodieIndexDefinition secondaryIndexDef = HoodieIndexDefinition.newBuilder().withIndexName("secondary_index_idx_price").withIndexType("secondary_index").withIndexFunction("identity").withSourceFields(Arrays.asList("price")).withIndexOptions(Collections.emptyMap()).withVersion(HoodieIndexVersion.V1).build();
        indexDefinitions.put("column_stats", columnStatsDef);
        indexDefinitions.put("secondary_index_idx_price", secondaryIndexDef);
        return new HoodieIndexMetadata(indexDefinitions);
    }

    @Test
    void testPopulateIndexVersionIfMissing() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            HoodieIndexMetadata indexMetadata = TestEightToNineUpgradeHandler.loadIndexDefFromResource("indexMissingVersion1.json");
            Assertions.assertNull((Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("column_stats")).getVersion());
            Assertions.assertNull((Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("secondary_index_idx_price")).getVersion());
            EightToNineUpgradeHandler.populateIndexVersionIfMissing((Option)Option.of((Object)indexMetadata));
            Assertions.assertEquals((Object)HoodieIndexVersion.V1, (Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("column_stats")).getVersion());
            Assertions.assertEquals((Object)HoodieIndexVersion.V1, (Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("secondary_index_idx_price")).getVersion());
            TestEightToNineUpgradeHandler.validateAllFieldsExcludingVersion(indexMetadata);
        }
    }

    @Test
    void testPopulateIndexVersionIfMissingWithMixedVersions() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            HoodieIndexMetadata indexMetadata = TestEightToNineUpgradeHandler.loadIndexDefFromResource("indexMissingVersion2.json");
            Assertions.assertNull((Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("column_stats")).getVersion());
            Assertions.assertEquals((Object)HoodieIndexVersion.V2, (Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("secondary_index_idx_price")).getVersion());
            EightToNineUpgradeHandler.populateIndexVersionIfMissing((Option)Option.of((Object)indexMetadata));
            Assertions.assertEquals((Object)HoodieIndexVersion.V1, (Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("column_stats")).getVersion());
            Assertions.assertEquals((Object)HoodieIndexVersion.V2, (Object)((HoodieIndexDefinition)indexMetadata.getIndexDefinitions().get("secondary_index_idx_price")).getVersion());
        }
    }

    @Test
    void testPopulateIndexVersionIfMissingWithEmptyOption() {
        try (MockedStatic mockedUtils = Mockito.mockStatic(UpgradeDowngradeUtils.class);){
            mockedUtils.when(() -> UpgradeDowngradeUtils.rollbackFailedWritesAndCompact((HoodieTable)((HoodieTable)ArgumentMatchers.any(HoodieTable.class)), (HoodieEngineContext)((HoodieEngineContext)ArgumentMatchers.any(HoodieEngineContext.class)), (HoodieWriteConfig)((HoodieWriteConfig)ArgumentMatchers.any(HoodieWriteConfig.class)), (SupportsUpgradeDowngrade)((SupportsUpgradeDowngrade)ArgumentMatchers.any(SupportsUpgradeDowngrade.class)), (boolean)ArgumentMatchers.anyBoolean(), (HoodieTableVersion)((HoodieTableVersion)ArgumentMatchers.any(HoodieTableVersion.class)))).thenAnswer(invocation -> null);
            Assertions.assertDoesNotThrow(() -> EightToNineUpgradeHandler.populateIndexVersionIfMissing((Option)Option.empty()));
        }
    }

    private static HoodieIndexMetadata loadIndexDefFromResource(String resourceName) {
        try {
            String resourcePath = TestEightToNineUpgradeHandler.class.getClassLoader().getResource(resourceName).toString();
            return HoodieIndexMetadata.fromJson((String)new String(Files.readAllBytes(Paths.get(new URI(resourcePath)))));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void validateAllFieldsExcludingVersion(HoodieIndexMetadata loadedDef) {
        HoodieIndexDefinition colStatsDef = (HoodieIndexDefinition)loadedDef.getIndexDefinitions().get("column_stats");
        Assertions.assertEquals((Object)"column_stats", (Object)colStatsDef.getIndexName());
        Assertions.assertEquals((Object)"column_stats", (Object)colStatsDef.getIndexType());
        Assertions.assertEquals((Object)"column_stats", (Object)colStatsDef.getIndexFunction());
        Assertions.assertEquals(Collections.emptyMap(), (Object)colStatsDef.getIndexOptions());
        Assertions.assertEquals(Arrays.asList("_hoodie_commit_time", "_hoodie_partition_path", "_hoodie_record_key", "key", "secKey", "partition", "intField", "city", "textField1", "textField2", "textField3", "textField4", "decimalField", "longField", "incrLongField", "round"), (Object)colStatsDef.getSourceFields());
        HoodieIndexDefinition secIdxDef = (HoodieIndexDefinition)loadedDef.getIndexDefinitions().get("secondary_index_idx_price");
        Assertions.assertEquals((Object)"secondary_index_idx_price", (Object)secIdxDef.getIndexName());
        Assertions.assertEquals((Object)"secondary_index", (Object)secIdxDef.getIndexType());
        Assertions.assertEquals((Object)"identity", (Object)secIdxDef.getIndexFunction());
        Assertions.assertEquals(Collections.singletonList("price"), (Object)secIdxDef.getSourceFields());
        Assertions.assertEquals(Collections.emptyMap(), (Object)secIdxDef.getIndexOptions());
    }
}

