/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.table.action.clean;

import java.io.IOException;
import java.util.Collections;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanFileInfo;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.InstantGenerator;
import org.apache.hudi.common.table.timeline.versioning.TimelineLayoutVersion;
import org.apache.hudi.common.table.timeline.versioning.v1.InstantComparatorV1;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.storage.hadoop.HadoopStorageConfiguration;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.clean.CleanPlanActionExecutor;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestCleanPlanActionExecutor {
    TestCleanPlanActionExecutor() {
    }

    @ParameterizedTest
    @ValueSource(booleans={true, false})
    void emptyCompletedCleanReturnsPreviousCleanPlan(boolean isEmptyPlan) throws IOException {
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieTableMetaClient metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        Mockito.when((Object)table.getMetaClient()).thenReturn((Object)metaClient);
        InstantGenerator instantGenerator = (InstantGenerator)Mockito.mock(InstantGenerator.class);
        Mockito.when((Object)table.getInstantGenerator()).thenReturn((Object)instantGenerator);
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        TestCleanPlanActionExecutor.mockThatCleanIsRequired(table);
        HoodieInstant lastCompletedInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        HoodieInstant lastRequestInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        HoodieInstant lastInflightInstant = new HoodieInstant(HoodieInstant.State.INFLIGHT, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)instantGenerator.getCleanRequestedInstant("001")).thenReturn((Object)lastRequestInstant);
        TestCleanPlanActionExecutor.mockEmptyLastCompletedClean(table, lastCompletedInstant, activeTimeline, isEmptyPlan);
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        CleanPlanActionExecutor executor = (CleanPlanActionExecutor)Mockito.spy((Object)new CleanPlanActionExecutor((HoodieEngineContext)engineContext, HoodieWriteConfig.newBuilder().withPath("file://tmp").build(), table, Option.empty()));
        HoodieCleanerPlan cleanerPlan = HoodieCleanerPlan.newBuilder().setEarliestInstantToRetain(HoodieActionInstant.newBuilder().setAction("commit").setTimestamp("001").setState(HoodieInstant.State.COMPLETED.name()).build()).setFilesToBeDeletedPerPartition(Collections.singletonMap("partition1", Collections.singletonList("file1"))).setFilePathsToBeDeletedPerPartition(Collections.singletonMap("partition1", Collections.singletonList(HoodieCleanFileInfo.newBuilder().setFilePath("file1").build()))).setLastCompletedCommitTimestamp("002").setPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS.name()).setVersion(TimelineLayoutVersion.CURR_VERSION).build();
        if (isEmptyPlan) {
            Mockito.when((Object)activeTimeline.readCleanerPlan(lastRequestInstant)).thenThrow(new Throwable[]{new IOException("Empty plan")});
            Mockito.when((Object)activeTimeline.isEmpty(lastRequestInstant)).thenReturn((Object)true);
            Mockito.when((Object)instantGenerator.getCleanInflightInstant("001")).thenReturn((Object)lastInflightInstant);
            ((CleanPlanActionExecutor)Mockito.doReturn((Object)cleanerPlan).when((Object)executor)).requestClean((HoodieEngineContext)engineContext);
        } else {
            Mockito.when((Object)activeTimeline.readCleanerPlan(lastRequestInstant)).thenReturn((Object)cleanerPlan);
        }
        Option actualPlan = executor.requestClean();
        Assertions.assertEquals((Object)Option.of((Object)cleanerPlan), (Object)actualPlan);
        ((HoodieActiveTimeline)Mockito.verify((Object)activeTimeline)).deleteEmptyInstantIfExists(lastCompletedInstant);
        if (isEmptyPlan) {
            ((HoodieTableMetaClient)Mockito.verify((Object)metaClient)).reloadActiveTimeline();
            ((HoodieActiveTimeline)Mockito.verify((Object)activeTimeline)).deleteEmptyInstantIfExists(lastRequestInstant);
            ((HoodieActiveTimeline)Mockito.verify((Object)activeTimeline)).deleteEmptyInstantIfExists(lastInflightInstant);
        }
    }

    @Test
    void emptyCompletedClean_failsToReadPreviousPlan() throws IOException {
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        InstantGenerator instantGenerator = (InstantGenerator)Mockito.mock(InstantGenerator.class);
        Mockito.when((Object)table.getInstantGenerator()).thenReturn((Object)instantGenerator);
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        TestCleanPlanActionExecutor.mockThatCleanIsRequired(table);
        HoodieInstant lastCompletedInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        HoodieInstant lastRequestInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)instantGenerator.getCleanRequestedInstant("001")).thenReturn((Object)lastRequestInstant);
        TestCleanPlanActionExecutor.mockEmptyLastCompletedClean(table, lastCompletedInstant, activeTimeline, false);
        Mockito.when((Object)activeTimeline.readCleanerPlan(lastRequestInstant)).thenThrow(new Throwable[]{new HoodieIOException("failed to read")});
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        CleanPlanActionExecutor executor = new CleanPlanActionExecutor((HoodieEngineContext)engineContext, HoodieWriteConfig.newBuilder().withPath("file://tmp").build(), table, Option.empty());
        Assertions.assertThrows(HoodieIOException.class, () -> ((CleanPlanActionExecutor)executor).requestClean());
    }

    @Test
    void lastCleanIsNonEmpty() {
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        HoodieActiveTimeline activeTimeline = (HoodieActiveTimeline)Mockito.mock(HoodieActiveTimeline.class);
        TestCleanPlanActionExecutor.mockThatCleanIsRequired(table);
        HoodieInstant lastCompletedInstant = new HoodieInstant(HoodieInstant.State.COMPLETED, "clean", "001", InstantComparatorV1.REQUESTED_TIME_BASED_COMPARATOR);
        Mockito.when((Object)table.getCleanTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.of((Object)lastCompletedInstant));
        Mockito.when((Object)table.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Mockito.when((Object)activeTimeline.isEmpty(lastCompletedInstant)).thenReturn((Object)false);
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        CleanPlanActionExecutor executor = (CleanPlanActionExecutor)Mockito.spy((Object)new CleanPlanActionExecutor((HoodieEngineContext)engineContext, HoodieWriteConfig.newBuilder().withPath("file://tmp").build(), table, Option.empty()));
        HoodieCleanerPlan emptyPlan = new HoodieCleanerPlan();
        ((CleanPlanActionExecutor)Mockito.doReturn((Object)emptyPlan).when((Object)executor)).requestClean((HoodieEngineContext)engineContext);
        Assertions.assertEquals((Object)Option.empty(), (Object)executor.requestClean());
    }

    @Test
    void lastCleanIsNotPresent() {
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        TestCleanPlanActionExecutor.mockThatCleanIsRequired(table);
        Mockito.when((Object)table.getCleanTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.empty());
        HoodieLocalEngineContext engineContext = new HoodieLocalEngineContext((StorageConfiguration)new HadoopStorageConfiguration(Boolean.valueOf(false)));
        CleanPlanActionExecutor executor = (CleanPlanActionExecutor)Mockito.spy((Object)new CleanPlanActionExecutor((HoodieEngineContext)engineContext, HoodieWriteConfig.newBuilder().withPath("file://tmp").build(), table, Option.empty()));
        HoodieCleanerPlan emptyPlan = new HoodieCleanerPlan();
        ((CleanPlanActionExecutor)Mockito.doReturn((Object)emptyPlan).when((Object)executor)).requestClean((HoodieEngineContext)engineContext);
        Assertions.assertEquals((Object)Option.empty(), (Object)executor.requestClean());
    }

    private static void mockEmptyLastCompletedClean(HoodieTable table, HoodieInstant lastCompletedInstant, HoodieActiveTimeline activeTimeline, boolean hasEmptyPlan) {
        if (hasEmptyPlan) {
            Mockito.when((Object)table.getCleanTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.of((Object)lastCompletedInstant)).thenReturn((Object)Option.empty());
        } else {
            Mockito.when((Object)table.getCleanTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.of((Object)lastCompletedInstant));
        }
        Mockito.when((Object)table.getActiveTimeline()).thenReturn((Object)activeTimeline);
        Mockito.when((Object)activeTimeline.isEmpty(lastCompletedInstant)).thenReturn((Object)true);
    }

    private static void mockThatCleanIsRequired(HoodieTable table) {
        Mockito.when((Object)table.getActiveTimeline().getCleanerTimeline().filterCompletedInstants().lastInstant()).thenReturn((Object)Option.empty());
        HoodieTimeline commitsTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)table.getActiveTimeline().getCommitsTimeline().filterCompletedInstants()).thenReturn((Object)commitsTimeline);
        Mockito.when((Object)commitsTimeline.countInstants()).thenReturn((Object)2);
    }
}

