/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metrics.prometheus;

import com.codahale.metrics.MetricRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.config.metrics.HoodieMetricsPrometheusConfig;
import org.apache.hudi.metrics.HoodieMetrics;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.metrics.prometheus.PrometheusReporter;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ExtendWith(value={MockitoExtension.class})
public class TestPrometheusReporter {
    private static final Logger LOG = LoggerFactory.getLogger(TestPrometheusReporter.class);
    @Mock
    HoodieWriteConfig writeConfig;
    @Mock
    HoodieMetricsConfig metricsConfig;
    HoodieMetrics hoodieMetrics;
    Metrics metrics;
    private static final int TEST_PORT = 19090;
    private static final int TEST_PORT_2 = 19091;
    private List<PrometheusReporter> reportersToCleanup;

    @BeforeEach
    void setUp() {
        this.reportersToCleanup = new ArrayList<PrometheusReporter>();
    }

    @AfterEach
    void shutdownMetrics() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
        for (PrometheusReporter reporter : this.reportersToCleanup) {
            try {
                reporter.stop();
            }
            catch (Exception e) {
                LOG.debug("Exception during test cleanup: {}", (Object)e.getMessage());
            }
        }
        this.reportersToCleanup.clear();
    }

    @Test
    public void testRegisterGauge() {
        Mockito.when((Object)this.writeConfig.getMetricsConfig()).thenReturn((Object)this.metricsConfig);
        Mockito.when((Object)this.writeConfig.isMetricsOn()).thenReturn((Object)true);
        Mockito.when((Object)this.metricsConfig.getMetricsReporterType()).thenReturn((Object)MetricsReporterType.PROMETHEUS);
        Mockito.when((Object)this.metricsConfig.getPrometheusPort()).thenReturn((Object)9090);
        Mockito.when((Object)this.metricsConfig.getBasePath()).thenReturn((Object)("s3://test" + UUID.randomUUID()));
        Assertions.assertDoesNotThrow(() -> {
            new HoodieMetrics(this.writeConfig, HoodieTestUtils.getDefaultStorage());
            this.hoodieMetrics = new HoodieMetrics(this.writeConfig, HoodieTestUtils.getDefaultStorage());
            this.metrics = this.hoodieMetrics.getMetrics();
        });
    }

    @Test
    public void testMultiTableReferenceCountingBasic() {
        MetricRegistry registry1 = new MetricRegistry();
        MetricRegistry registry2 = new MetricRegistry();
        HoodieMetricsConfig config1 = this.createMockConfig(19090);
        HoodieMetricsConfig config2 = this.createMockConfig(19090);
        Assertions.assertFalse((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)0, (int)PrometheusReporter.getReferenceCount((int)19090));
        PrometheusReporter reporter1 = new PrometheusReporter(config1, registry1);
        this.reportersToCleanup.add(reporter1);
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getActiveExportsCount((int)19090));
        PrometheusReporter reporter2 = new PrometheusReporter(config2, registry2);
        this.reportersToCleanup.add(reporter2);
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)2, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertEquals((int)2, (int)PrometheusReporter.getActiveExportsCount((int)19090));
        reporter1.stop();
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getActiveExportsCount((int)19090));
        reporter2.stop();
        Assertions.assertFalse((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)0, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertEquals((int)0, (int)PrometheusReporter.getActiveExportsCount((int)19090));
        this.reportersToCleanup.clear();
    }

    @Test
    public void testMultiplePortsIndependent() {
        MetricRegistry registry1 = new MetricRegistry();
        MetricRegistry registry2 = new MetricRegistry();
        HoodieMetricsConfig config1 = this.createMockConfig(19090);
        HoodieMetricsConfig config2 = this.createMockConfig(19091);
        PrometheusReporter reporter1 = new PrometheusReporter(config1, registry1);
        PrometheusReporter reporter2 = new PrometheusReporter(config2, registry2);
        this.reportersToCleanup.add(reporter1);
        this.reportersToCleanup.add(reporter2);
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19091));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getReferenceCount((int)19091));
        reporter1.stop();
        Assertions.assertFalse((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19091));
        Assertions.assertEquals((int)0, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getReferenceCount((int)19091));
        reporter2.stop();
        this.reportersToCleanup.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConcurrentReporterCreation() throws Exception {
        int numThreads = 10;
        ExecutorService executor = Executors.newFixedThreadPool(10);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch completeLatch = new CountDownLatch(10);
        ArrayList reporters = new ArrayList();
        try {
            ArrayList futures = new ArrayList();
            for (int i = 0; i < 10; ++i) {
                futures.add(executor.submit(() -> {
                    try {
                        startLatch.await();
                        MetricRegistry registry = new MetricRegistry();
                        HoodieMetricsConfig config = this.createMockConfig(19090);
                        PrometheusReporter reporter = new PrometheusReporter(config, registry);
                        List list = reporters;
                        synchronized (list) {
                            reporters.add(reporter);
                        }
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        LOG.debug("Thread interrupted during concurrent test setup");
                    }
                    catch (Exception e) {
                        LOG.debug("Expected exception during concurrent PrometheusReporter test: {}", (Object)e.getMessage());
                    }
                    finally {
                        completeLatch.countDown();
                    }
                }));
            }
            startLatch.countDown();
            Assertions.assertTrue((boolean)completeLatch.await(10L, TimeUnit.SECONDS));
            for (Future future : futures) {
                Assertions.assertDoesNotThrow(() -> future.get());
            }
            Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19090));
            Assertions.assertEquals((int)10, (int)PrometheusReporter.getReferenceCount((int)19090));
            Assertions.assertEquals((int)10, (int)PrometheusReporter.getActiveExportsCount((int)19090));
            ArrayList arrayList = reporters;
            synchronized (arrayList) {
                for (PrometheusReporter reporter : reporters) {
                    reporter.stop();
                }
                this.reportersToCleanup.addAll(reporters);
            }
            Assertions.assertFalse((boolean)PrometheusReporter.isServerRunning((int)19090));
            Assertions.assertEquals((int)0, (int)PrometheusReporter.getReferenceCount((int)19090));
        }
        finally {
            executor.shutdown();
            this.reportersToCleanup.clear();
        }
    }

    @Test
    public void testReporterLifecycle() {
        MetricRegistry registry = new MetricRegistry();
        HoodieMetricsConfig config = this.createMockConfig(19090);
        PrometheusReporter reporter = new PrometheusReporter(config, registry);
        this.reportersToCleanup.add(reporter);
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertEquals((int)1, (int)PrometheusReporter.getActiveExportsCount((int)19090));
        reporter.stop();
        Assertions.assertFalse((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)0, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertEquals((int)0, (int)PrometheusReporter.getActiveExportsCount((int)19090));
        this.reportersToCleanup.clear();
    }

    @Test
    public void testPartialFailureScenario() {
        MetricRegistry registry1 = new MetricRegistry();
        MetricRegistry registry2 = new MetricRegistry();
        MetricRegistry registry3 = new MetricRegistry();
        HoodieMetricsConfig config = this.createMockConfig(19090);
        PrometheusReporter reporter1 = new PrometheusReporter(config, registry1);
        PrometheusReporter reporter2 = new PrometheusReporter(config, registry2);
        PrometheusReporter reporter3 = new PrometheusReporter(config, registry3);
        this.reportersToCleanup.add(reporter1);
        this.reportersToCleanup.add(reporter2);
        this.reportersToCleanup.add(reporter3);
        Assertions.assertEquals((int)3, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19090));
        reporter2.stop();
        Assertions.assertEquals((int)2, (int)PrometheusReporter.getReferenceCount((int)19090));
        Assertions.assertTrue((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)2, (int)PrometheusReporter.getActiveExportsCount((int)19090));
        reporter1.stop();
        reporter3.stop();
        Assertions.assertFalse((boolean)PrometheusReporter.isServerRunning((int)19090));
        Assertions.assertEquals((int)0, (int)PrometheusReporter.getReferenceCount((int)19090));
        this.reportersToCleanup.clear();
    }

    private HoodieMetricsConfig createMockConfig(int port) {
        Properties props = new Properties();
        props.setProperty(HoodieMetricsPrometheusConfig.PROMETHEUS_PORT_NUM.key(), String.valueOf(port));
        return HoodieMetricsConfig.newBuilder().fromProperties(props).build();
    }
}

