/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hudi.avro.model.HoodieRecordIndexInfo;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.model.EmptyHoodieRecordPayload;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordLocation;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieMetadataPayload;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.RecordIndexMapper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestMetadataIndexMapper
extends HoodieCommonTestHarness {
    @Test
    public void testRLIIndexMapperWithInsertsAndUpserts() throws Exception {
        WriteStatus writeStatus = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.0));
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        List records = dataGenerator.generateInserts("001", Integer.valueOf(10));
        for (int i = 0; i < records.size(); ++i) {
            HoodieRecord record = (HoodieRecord)records.get(i);
            String fileId = UUID.randomUUID().toString();
            if (i < 5) {
                record.setCurrentLocation(new HoodieRecordLocation(InProcessTimeGenerator.createNewInstantTime(), fileId));
            }
            record.setNewLocation(new HoodieRecordLocation(InProcessTimeGenerator.createNewInstantTime(), fileId));
            writeStatus.markSuccess(record, Option.empty());
        }
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("random").build();
        RecordIndexMapper recordIndexMapper = new RecordIndexMapper(writeConfig);
        Iterator rliRecords = recordIndexMapper.apply(writeStatus);
        AtomicInteger totalRLIRecords = new AtomicInteger();
        rliRecords.forEachRemaining(rliRecord -> {
            totalRLIRecords.getAndIncrement();
            HoodieRecord record = rliRecord;
            Assertions.assertEquals((Object)MetadataPartitionType.RECORD_INDEX.getPartitionPath(), (Object)record.getKey().getPartitionPath());
            HoodieRecordIndexInfo recordIndexInfo = ((HoodieMetadataPayload)record.getData()).recordIndexMetadata;
            Assertions.assertNotNull((Object)recordIndexInfo);
            Assertions.assertTrue((boolean)StringUtils.nonEmpty((String)recordIndexInfo.getPartitionName()));
            Assertions.assertNotNull((Object)recordIndexInfo.getFileIdHighBits());
            Assertions.assertNotNull((Object)recordIndexInfo.getFileIdLowBits());
        });
        Assertions.assertEquals((int)5, (int)totalRLIRecords.get());
    }

    @Test
    public void testRLIIndexGeneratorWithDeletes() throws Exception {
        WriteStatus writeStatus = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.0));
        HoodieTestDataGenerator dataGenerator = new HoodieTestDataGenerator();
        List records = dataGenerator.generateInserts("001", Integer.valueOf(10));
        for (int i = 0; i < records.size(); ++i) {
            HoodieRecord record = (HoodieRecord)records.get(i);
            String fileId = UUID.randomUUID().toString();
            record.setCurrentLocation(new HoodieRecordLocation(InProcessTimeGenerator.createNewInstantTime(), fileId));
            writeStatus.markSuccess(record, Option.empty());
        }
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("random").build();
        RecordIndexMapper recordIndexMapper = new RecordIndexMapper(writeConfig);
        Iterator rliRecords = recordIndexMapper.apply(writeStatus);
        AtomicInteger totalRLIRecords = new AtomicInteger();
        rliRecords.forEachRemaining(rliRecord -> {
            totalRLIRecords.getAndIncrement();
            HoodieRecord record = rliRecord;
            Assertions.assertEquals((Object)MetadataPartitionType.RECORD_INDEX.getPartitionPath(), (Object)record.getKey().getPartitionPath());
            Assertions.assertTrue((boolean)(record.getData() instanceof EmptyHoodieRecordPayload));
        });
        Assertions.assertEquals((int)10, (int)totalRLIRecords.get());
    }
}

