/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.util.Properties;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieCleaningPolicy;
import org.apache.hudi.common.model.HoodieFailedWritesCleaningPolicy;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.config.HoodieCleanConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.metadata.HoodieMetadataWriteUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieMetadataWriteUtils {
    @Test
    public void testCreateMetadataWriteConfigForCleaner() {
        HoodieWriteConfig writeConfig1 = HoodieWriteConfig.newBuilder().withPath("/tmp/").withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(5).build()).build();
        HoodieWriteConfig metadataWriteConfig1 = HoodieMetadataWriteUtils.createMetadataWriteConfig((HoodieWriteConfig)writeConfig1, (HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER, (HoodieTableVersion)HoodieTableVersion.SIX);
        Assertions.assertEquals((Object)HoodieFailedWritesCleaningPolicy.EAGER, (Object)metadataWriteConfig1.getFailedWritesCleanPolicy());
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_COMMITS, (Object)metadataWriteConfig1.getCleanerPolicy());
        Assertions.assertEquals((int)20, (int)metadataWriteConfig1.getCleanerCommitsRetained());
        Assertions.assertNotEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_FILE_VERSIONS, (Object)metadataWriteConfig1.getCleanerPolicy());
        Assertions.assertNotEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_BY_HOURS, (Object)metadataWriteConfig1.getCleanerPolicy());
        HoodieWriteConfig writeConfig2 = HoodieWriteConfig.newBuilder().withPath("/tmp").withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(20).build()).build();
        HoodieWriteConfig metadataWriteConfig2 = HoodieMetadataWriteUtils.createMetadataWriteConfig((HoodieWriteConfig)writeConfig2, (HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER, (HoodieTableVersion)HoodieTableVersion.SIX);
        Assertions.assertEquals((Object)HoodieFailedWritesCleaningPolicy.EAGER, (Object)metadataWriteConfig2.getFailedWritesCleanPolicy());
        Assertions.assertEquals((Object)HoodieCleaningPolicy.KEEP_LATEST_COMMITS, (Object)metadataWriteConfig2.getCleanerPolicy());
        Assertions.assertEquals((int)24, (int)metadataWriteConfig2.getCleanerCommitsRetained());
    }

    @Test
    public void testCreateMetadataWriteConfigForNBCC() {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp/base_path/").withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(5).build()).withMetadataConfig(HoodieMetadataConfig.newBuilder().withStreamingWriteEnabled(true).build()).build();
        HoodieWriteConfig metadataWriteConfig = HoodieMetadataWriteUtils.createMetadataWriteConfig((HoodieWriteConfig)writeConfig, (HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER, (HoodieTableVersion)HoodieTableVersion.EIGHT);
        this.validateMetadataWriteConfig(metadataWriteConfig, HoodieFailedWritesCleaningPolicy.LAZY, WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL, InProcessLockProvider.class.getCanonicalName());
        Properties properties = new Properties();
        properties.put(HoodieMetadataConfig.STREAMING_WRITE_ENABLED.key(), "false");
        writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp/base_path/.hoodie/metadata/").withCleanConfig(HoodieCleanConfig.newBuilder().withCleanerPolicy(HoodieCleaningPolicy.KEEP_LATEST_COMMITS).retainCommits(5).build()).withProperties(properties).build();
        metadataWriteConfig = HoodieMetadataWriteUtils.createMetadataWriteConfig((HoodieWriteConfig)writeConfig, (HoodieFailedWritesCleaningPolicy)HoodieFailedWritesCleaningPolicy.EAGER, (HoodieTableVersion)HoodieTableVersion.EIGHT);
        this.validateMetadataWriteConfig(metadataWriteConfig, HoodieFailedWritesCleaningPolicy.EAGER, WriteConcurrencyMode.SINGLE_WRITER, null);
    }

    private void validateMetadataWriteConfig(HoodieWriteConfig metadataWriteConfig, HoodieFailedWritesCleaningPolicy expectedPolicy, WriteConcurrencyMode expectedWriteConcurrencyMode, String expectedLockProviderClass) {
        Assertions.assertEquals((Object)expectedPolicy, (Object)metadataWriteConfig.getFailedWritesCleanPolicy());
        Assertions.assertEquals((Object)expectedWriteConcurrencyMode, (Object)metadataWriteConfig.getWriteConcurrencyMode());
        if (expectedLockProviderClass != null) {
            Assertions.assertEquals((Object)expectedLockProviderClass, (Object)metadataWriteConfig.getLockProviderClass());
        } else {
            Assertions.assertNull((Object)metadataWriteConfig.getLockProviderClass());
        }
    }
}

