/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieReaderContext;
import org.apache.hudi.common.engine.ReaderContextFactory;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieIndexDefinition;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.io.SecondaryIndexStreamingTracker;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.hudi.metadata.SecondaryIndexRecordGenerationUtils;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class TestSecondaryIndexStreamingTrackerFileSlice {
    private HoodieTable hoodieTable;
    private HoodieWriteConfig config;
    private WriteStatus writeStatus;
    private Schema schema;
    private HoodieTableMetaClient metaClient;
    private HoodieEngineContext engineContext;
    private HoodieReaderContext readerContext;

    @BeforeEach
    public void setUp() {
        this.hoodieTable = (HoodieTable)Mockito.mock(HoodieTable.class);
        this.config = (HoodieWriteConfig)Mockito.mock(HoodieWriteConfig.class);
        this.writeStatus = new WriteStatus(Boolean.valueOf(true), Double.valueOf(0.0));
        this.schema = (Schema)Mockito.mock(Schema.class);
        this.metaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        this.engineContext = (HoodieEngineContext)Mockito.mock(HoodieEngineContext.class);
        this.readerContext = (HoodieReaderContext)Mockito.mock(HoodieReaderContext.class);
        ReaderContextFactory readerContextFactory = (ReaderContextFactory)Mockito.mock(ReaderContextFactory.class);
        Mockito.when((Object)readerContextFactory.getContext()).thenReturn((Object)this.readerContext);
        Mockito.when((Object)this.hoodieTable.getContext()).thenReturn((Object)this.engineContext);
        Mockito.when((Object)this.engineContext.getReaderContextFactory((HoodieTableMetaClient)ArgumentMatchers.any())).thenReturn((Object)readerContextFactory);
        Mockito.when((Object)this.hoodieTable.getMetaClient()).thenReturn((Object)this.metaClient);
        Mockito.when((Object)this.config.getBasePath()).thenReturn((Object)"/tmp/test");
        Mockito.when((Object)this.config.getProps()).thenReturn((Object)new TypedProperties());
    }

    @Test
    public void testTrackSecondaryIndexStats_EmptyFileSlice() {
        String partitionPath = "2023/01/01";
        String fileId = "file-001";
        List<String> newLogFiles = Arrays.asList(partitionPath + "/.file-001_20231201120000.log.1", partitionPath + "/.file-001_20231201120000.log.2");
        String instantTime = "20231201120000";
        HoodieIndexDefinition indexDef = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_fare_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("fare")).build();
        try (MockedStatic mockedUtils = Mockito.mockStatic(SecondaryIndexRecordGenerationUtils.class);){
            Map emptyMap = Collections.emptyMap();
            HashMap<String, String> currentMap = new HashMap<String, String>();
            currentMap.put("key1", "100.5");
            currentMap.put("key2", "200.75");
            mockedUtils.when(() -> SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey((HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.metaClient)), (HoodieReaderContext)((HoodieReaderContext)ArgumentMatchers.eq((Object)this.readerContext)), (FileSlice)((FileSlice)ArgumentMatchers.any(FileSlice.class)), (Schema)((Schema)ArgumentMatchers.eq((Object)this.schema)), (HoodieIndexDefinition)((HoodieIndexDefinition)ArgumentMatchers.eq((Object)indexDef)), (String)((String)ArgumentMatchers.eq((Object)instantTime)), (TypedProperties)((TypedProperties)ArgumentMatchers.any(TypedProperties.class)), (boolean)ArgumentMatchers.eq((boolean)true))).thenReturn(currentMap);
            SecondaryIndexStreamingTracker.trackSecondaryIndexStats((String)partitionPath, (String)fileId, (Option)Option.empty(), newLogFiles, (WriteStatus)this.writeStatus, (HoodieTable)this.hoodieTable, Collections.singletonList(indexDef), (HoodieWriteConfig)this.config, (String)instantTime, (Schema)this.schema);
            Assertions.assertEquals((int)2, (int)((List)this.writeStatus.getIndexStats().getSecondaryIndexStats().get(indexDef.getIndexName())).size());
            ((List)this.writeStatus.getIndexStats().getSecondaryIndexStats().get(indexDef.getIndexName())).forEach(stats -> {
                Assertions.assertTrue((boolean)currentMap.containsKey(stats.getRecordKey()));
                Assertions.assertEquals(currentMap.get(stats.getRecordKey()), (Object)stats.getSecondaryKeyValue());
                Assertions.assertEquals((Object)false, (Object)stats.isDeleted());
            });
        }
    }

    @Test
    public void testTrackSecondaryIndexStats_WithExistingFileSlice() {
        String partitionPath = "2023/01/01";
        String fileId = "file-002";
        List<String> newLogFiles = Arrays.asList(partitionPath + "/.file-002_20231201130000.log.1");
        String instantTime = "20231201130000";
        FileSlice existingFileSlice = new FileSlice(new HoodieFileGroupId(partitionPath, fileId), instantTime);
        HoodieIndexDefinition indexDef = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_fare_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("fare")).build();
        try (MockedStatic mockedUtils = Mockito.mockStatic(SecondaryIndexRecordGenerationUtils.class);){
            HashMap<String, String> previousMap = new HashMap<String, String>();
            previousMap.put("key1", "100.5");
            previousMap.put("key2", "200.75");
            previousMap.put("key3", "300.0");
            HashMap<String, String> currentMap = new HashMap<String, String>();
            currentMap.put("key1", "100.5");
            currentMap.put("key2", "250.0");
            currentMap.put("key4", "400.5");
            mockedUtils.when(() -> SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey((HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.metaClient)), (HoodieReaderContext)((HoodieReaderContext)ArgumentMatchers.eq((Object)this.readerContext)), (FileSlice)((FileSlice)ArgumentMatchers.eq((Object)existingFileSlice)), (Schema)((Schema)ArgumentMatchers.eq((Object)this.schema)), (HoodieIndexDefinition)((HoodieIndexDefinition)ArgumentMatchers.eq((Object)indexDef)), (String)((String)ArgumentMatchers.eq((Object)instantTime)), (TypedProperties)((TypedProperties)ArgumentMatchers.any(TypedProperties.class)), (boolean)ArgumentMatchers.eq((boolean)false))).thenReturn(previousMap);
            mockedUtils.when(() -> SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey((HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.metaClient)), (HoodieReaderContext)((HoodieReaderContext)ArgumentMatchers.eq((Object)this.readerContext)), (FileSlice)((FileSlice)ArgumentMatchers.any(FileSlice.class)), (Schema)((Schema)ArgumentMatchers.eq((Object)this.schema)), (HoodieIndexDefinition)((HoodieIndexDefinition)ArgumentMatchers.eq((Object)indexDef)), (String)((String)ArgumentMatchers.eq((Object)instantTime)), (TypedProperties)((TypedProperties)ArgumentMatchers.any(TypedProperties.class)), (boolean)ArgumentMatchers.eq((boolean)true))).thenReturn(currentMap);
            SecondaryIndexStreamingTracker.trackSecondaryIndexStats((String)partitionPath, (String)fileId, (Option)Option.of((Object)existingFileSlice), newLogFiles, (WriteStatus)this.writeStatus, (HoodieTable)this.hoodieTable, Collections.singletonList(indexDef), (HoodieWriteConfig)this.config, (String)instantTime, (Schema)this.schema);
            List stats = (List)this.writeStatus.getIndexStats().getSecondaryIndexStats().get(indexDef.getIndexName());
            Assertions.assertEquals((int)4, (int)stats.size());
            long deleteCount = stats.stream().filter(s -> s.isDeleted()).count();
            Assertions.assertEquals((long)2L, (long)deleteCount);
            long insertCount = stats.stream().filter(s -> !s.isDeleted()).count();
            Assertions.assertEquals((long)2L, (long)insertCount);
            Assertions.assertTrue((boolean)stats.stream().anyMatch(s -> s.getRecordKey().equals("key2") && s.getSecondaryKeyValue().equals("200.75") && s.isDeleted()), (String)"Should have delete entry for key2's old value");
            Assertions.assertTrue((boolean)stats.stream().anyMatch(s -> s.getRecordKey().equals("key2") && s.getSecondaryKeyValue().equals("250.0") && !s.isDeleted()), (String)"Should have insert entry for key2's new value");
            Assertions.assertTrue((boolean)stats.stream().anyMatch(s -> s.getRecordKey().equals("key3") && s.getSecondaryKeyValue().equals("300.0") && s.isDeleted()), (String)"Should have delete entry for key3");
            Assertions.assertTrue((boolean)stats.stream().anyMatch(s -> s.getRecordKey().equals("key4") && s.getSecondaryKeyValue().equals("400.5") && !s.isDeleted()), (String)"Should have insert entry for key4");
            Assertions.assertFalse((boolean)stats.stream().anyMatch(s -> s.getRecordKey().equals("key1")), (String)"key1 should not have any stats entries as its value didn't change");
        }
    }

    @Test
    public void testTrackSecondaryIndexStats_MultipleIndexes() {
        String partitionPath = "2023/01/01";
        String fileId = "file-003";
        List newLogFiles = Collections.emptyList();
        String instantTime = "20231201140000";
        HoodieIndexDefinition fareIndex = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_fare_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("fare")).build();
        HoodieIndexDefinition nameIndex = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_name_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("name")).build();
        try (MockedStatic mockedUtils = Mockito.mockStatic(SecondaryIndexRecordGenerationUtils.class);){
            HashMap<String, String> fareMap = new HashMap<String, String>();
            fareMap.put("key1", "100.5");
            HashMap<String, String> nameMap = new HashMap<String, String>();
            nameMap.put("key1", "John Doe");
            mockedUtils.when(() -> SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey((HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.metaClient)), (HoodieReaderContext)((HoodieReaderContext)ArgumentMatchers.eq((Object)this.readerContext)), (FileSlice)((FileSlice)ArgumentMatchers.any(FileSlice.class)), (Schema)((Schema)ArgumentMatchers.eq((Object)this.schema)), (HoodieIndexDefinition)((HoodieIndexDefinition)ArgumentMatchers.eq((Object)fareIndex)), (String)((String)ArgumentMatchers.eq((Object)instantTime)), (TypedProperties)((TypedProperties)ArgumentMatchers.any(TypedProperties.class)), (boolean)ArgumentMatchers.anyBoolean())).thenReturn(fareMap);
            mockedUtils.when(() -> SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey((HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.metaClient)), (HoodieReaderContext)((HoodieReaderContext)ArgumentMatchers.eq((Object)this.readerContext)), (FileSlice)((FileSlice)ArgumentMatchers.any(FileSlice.class)), (Schema)((Schema)ArgumentMatchers.eq((Object)this.schema)), (HoodieIndexDefinition)((HoodieIndexDefinition)ArgumentMatchers.eq((Object)nameIndex)), (String)((String)ArgumentMatchers.eq((Object)instantTime)), (TypedProperties)((TypedProperties)ArgumentMatchers.any(TypedProperties.class)), (boolean)ArgumentMatchers.anyBoolean())).thenReturn(nameMap);
            SecondaryIndexStreamingTracker.trackSecondaryIndexStats((String)partitionPath, (String)fileId, (Option)Option.empty(), newLogFiles, (WriteStatus)this.writeStatus, (HoodieTable)this.hoodieTable, Arrays.asList(fareIndex, nameIndex), (HoodieWriteConfig)this.config, (String)instantTime, (Schema)this.schema);
            Assertions.assertEquals((int)2, (int)this.writeStatus.getIndexStats().getSecondaryIndexStats().size());
            Assertions.assertTrue((boolean)this.writeStatus.getIndexStats().getSecondaryIndexStats().containsKey(fareIndex.getIndexName()));
            Assertions.assertTrue((boolean)this.writeStatus.getIndexStats().getSecondaryIndexStats().containsKey(nameIndex.getIndexName()));
        }
    }

    @Test
    public void testTrackSecondaryIndexStats_IOExceptionHandling() {
        String partitionPath = "2023/01/01";
        String fileId = "file-004";
        List<String> newLogFiles = Arrays.asList(partitionPath + "/.file-004_20231201150000.log.1");
        String instantTime = "20231201150000";
        FileSlice existingFileSlice = new FileSlice(new HoodieFileGroupId(partitionPath, fileId), instantTime);
        HoodieIndexDefinition indexDef = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_fare_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("fare")).build();
        try (MockedStatic mockedUtils = Mockito.mockStatic(SecondaryIndexRecordGenerationUtils.class);){
            mockedUtils.when(() -> SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey((HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.metaClient)), (HoodieReaderContext)((HoodieReaderContext)ArgumentMatchers.eq((Object)this.readerContext)), (FileSlice)((FileSlice)ArgumentMatchers.eq((Object)existingFileSlice)), (Schema)((Schema)ArgumentMatchers.eq((Object)this.schema)), (HoodieIndexDefinition)((HoodieIndexDefinition)ArgumentMatchers.eq((Object)indexDef)), (String)((String)ArgumentMatchers.eq((Object)instantTime)), (TypedProperties)((TypedProperties)ArgumentMatchers.any(TypedProperties.class)), (boolean)ArgumentMatchers.eq((boolean)false))).thenThrow(new Throwable[]{new IOException("Failed to read file slice")});
            Assertions.assertThrows(HoodieIOException.class, () -> SecondaryIndexStreamingTracker.trackSecondaryIndexStats((String)partitionPath, (String)fileId, (Option)Option.of((Object)existingFileSlice), (List)newLogFiles, (WriteStatus)this.writeStatus, (HoodieTable)this.hoodieTable, Collections.singletonList(indexDef), (HoodieWriteConfig)this.config, (String)instantTime, (Schema)this.schema));
        }
    }

    @Test
    public void testTrackSecondaryIndexStats_EmptyIndexDefinitions() {
        String partitionPath = "2023/01/01";
        String fileId = "file-005";
        List<String> newLogFiles = Arrays.asList(partitionPath + "/.file-005_20231201160000.log.1");
        String instantTime = "20231201160000";
        SecondaryIndexStreamingTracker.trackSecondaryIndexStats((String)partitionPath, (String)fileId, (Option)Option.empty(), newLogFiles, (WriteStatus)this.writeStatus, (HoodieTable)this.hoodieTable, Collections.emptyList(), (HoodieWriteConfig)this.config, (String)instantTime, (Schema)this.schema);
        Assertions.assertEquals((int)0, (int)this.writeStatus.getIndexStats().getSecondaryIndexStats().size());
    }

    @Test
    public void testTrackSecondaryIndexStats_NullSecondaryKeyValues() {
        String partitionPath = "2023/01/01";
        String fileId = "file-006";
        List<String> newLogFiles = Arrays.asList(partitionPath + "/.file-006_20231201170000.log.1");
        String instantTime = "20231201170000";
        HoodieIndexDefinition indexDef = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_fare_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("fare")).build();
        try (MockedStatic mockedUtils = Mockito.mockStatic(SecondaryIndexRecordGenerationUtils.class);){
            HashMap<String, String> mapWithNulls = new HashMap<String, String>();
            mapWithNulls.put("key1", null);
            mapWithNulls.put("key2", "200.0");
            mockedUtils.when(() -> SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey((HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.metaClient)), (HoodieReaderContext)((HoodieReaderContext)ArgumentMatchers.eq((Object)this.readerContext)), (FileSlice)((FileSlice)ArgumentMatchers.any(FileSlice.class)), (Schema)((Schema)ArgumentMatchers.eq((Object)this.schema)), (HoodieIndexDefinition)((HoodieIndexDefinition)ArgumentMatchers.eq((Object)indexDef)), (String)((String)ArgumentMatchers.eq((Object)instantTime)), (TypedProperties)((TypedProperties)ArgumentMatchers.any(TypedProperties.class)), (boolean)ArgumentMatchers.anyBoolean())).thenReturn(mapWithNulls);
            SecondaryIndexStreamingTracker.trackSecondaryIndexStats((String)partitionPath, (String)fileId, (Option)Option.empty(), newLogFiles, (WriteStatus)this.writeStatus, (HoodieTable)this.hoodieTable, Collections.singletonList(indexDef), (HoodieWriteConfig)this.config, (String)instantTime, (Schema)this.schema);
            Assertions.assertEquals((int)2, (int)((List)this.writeStatus.getIndexStats().getSecondaryIndexStats().get(indexDef.getIndexName())).size());
            boolean hasNullValue = ((List)this.writeStatus.getIndexStats().getSecondaryIndexStats().get(indexDef.getIndexName())).stream().anyMatch(stats -> stats.getSecondaryKeyValue() == null);
            Assertions.assertTrue((boolean)hasNullValue);
        }
    }

    @Test
    public void testTrackSecondaryIndexStats_SameSecondaryKeyNoUpdate() {
        String partitionPath = "2023/01/01";
        String fileId = "file-007";
        List<String> newLogFiles = Arrays.asList(partitionPath + "/.file-007_20231201180000.log.1");
        String instantTime = "20231201180000";
        FileSlice existingFileSlice = new FileSlice(new HoodieFileGroupId(partitionPath, fileId), instantTime);
        HoodieIndexDefinition indexDef = HoodieIndexDefinition.newBuilder().withIndexName(MetadataPartitionType.SECONDARY_INDEX.getPartitionPath() + "_fare_index").withIndexType("SECONDARY_INDEX").withSourceFields(Collections.singletonList("fare")).build();
        try (MockedStatic mockedUtils = Mockito.mockStatic(SecondaryIndexRecordGenerationUtils.class);){
            HashMap<String, String> sameMap = new HashMap<String, String>();
            sameMap.put("key1", "100.5");
            sameMap.put("key2", "200.75");
            mockedUtils.when(() -> SecondaryIndexRecordGenerationUtils.getRecordKeyToSecondaryKey((HoodieTableMetaClient)((HoodieTableMetaClient)ArgumentMatchers.eq((Object)this.metaClient)), (HoodieReaderContext)((HoodieReaderContext)ArgumentMatchers.eq((Object)this.readerContext)), (FileSlice)((FileSlice)ArgumentMatchers.any(FileSlice.class)), (Schema)((Schema)ArgumentMatchers.eq((Object)this.schema)), (HoodieIndexDefinition)((HoodieIndexDefinition)ArgumentMatchers.eq((Object)indexDef)), (String)((String)ArgumentMatchers.eq((Object)instantTime)), (TypedProperties)((TypedProperties)ArgumentMatchers.any(TypedProperties.class)), (boolean)ArgumentMatchers.anyBoolean())).thenReturn(sameMap);
            SecondaryIndexStreamingTracker.trackSecondaryIndexStats((String)partitionPath, (String)fileId, (Option)Option.of((Object)existingFileSlice), newLogFiles, (WriteStatus)this.writeStatus, (HoodieTable)this.hoodieTable, Collections.singletonList(indexDef), (HoodieWriteConfig)this.config, (String)instantTime, (Schema)this.schema);
            Assertions.assertEquals((int)0, (int)this.writeStatus.getIndexStats().getSecondaryIndexStats().size());
        }
    }
}

