/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.io;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.LocalTaskContextSupplier;
import org.apache.hudi.common.engine.TaskContextSupplier;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.model.IOType;
import org.apache.hudi.common.model.MetadataValues;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestDataGenerator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetUtils;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieInsertException;
import org.apache.hudi.io.HoodieCreateHandle;
import org.apache.hudi.io.storage.HoodieFileWriter;
import org.apache.hudi.io.storage.TestFileWriter;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.StoragePath;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.TestBaseHoodieTable;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
public class TestHoodieCreateHandle
extends HoodieCommonTestHarness {
    private static final String TEST_INSTANT_TIME = "20231201120000";
    private static final String TEST_FILE_ID = "file-001";
    private static final Schema TEST_SCHEMA = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
    private static final String TEST_PARTITION_PATH = "2016/03/15";
    private HoodieWriteConfig writeConfig;
    private TaskContextSupplier taskContextSupplier;
    private HoodieTable hoodieTable;

    @BeforeEach
    void setUp() throws IOException {
        this.initPath();
        this.initMetaClient(false);
        this.initTestDataGenerator();
        this.writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withSchema("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}").withMarkersType("DIRECT").withMetadataConfig(HoodieMetadataConfig.newBuilder().enable(false).build()).build();
        this.hoodieTable = new TestBaseHoodieTable(this.writeConfig, this.getEngineContext(), this.metaClient);
        this.taskContextSupplier = new LocalTaskContextSupplier();
    }

    @AfterEach
    void tearDown() throws Exception {
        this.cleanMetaClient();
        this.cleanupTestDataGenerator();
    }

    @Test
    void testConstructorWithBasicParameters() {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        Assertions.assertNotNull((Object)createHandle);
        Assertions.assertEquals((Object)IOType.CREATE, (Object)createHandle.getIOType());
        Assertions.assertFalse((boolean)createHandle.preserveMetadata);
    }

    @Test
    void testConstructorWithPreserveMetadata() {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier, true);
        Assertions.assertNotNull((Object)createHandle);
        Assertions.assertTrue((boolean)createHandle.preserveMetadata);
    }

    @Test
    public void testConstructorWithOverriddenSchema() {
        Schema overridenSchema = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"fare\", \"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        HoodieCreateHandle handleWithOverridenSchema = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, Option.of((Object)overridenSchema), this.taskContextSupplier);
        Assertions.assertEquals((Object)overridenSchema, (Object)handleWithOverridenSchema.writeSchema);
    }

    @Test
    void testConstructorCreatesPartitionMetadataAndMarkerAndBaseFile() throws Exception {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        Assertions.assertNotNull((Object)createHandle);
        HoodieStorage hoodieStorage = this.metaClient.getStorage();
        StoragePath partitionPath = new StoragePath(this.basePath, TEST_PARTITION_PATH);
        this.validatePartitionMetaPathExistence(hoodieStorage, true);
        String expectedBaseFileName = this.getExpectedBaseFileName();
        this.validateMarkerFileExistence(hoodieStorage, expectedBaseFileName, true);
        StoragePath expectedBaseFilePath = new StoragePath(partitionPath, expectedBaseFileName);
        Assertions.assertTrue((boolean)hoodieStorage.exists(expectedBaseFilePath));
    }

    @ParameterizedTest
    @MethodSource(value={"generateParametersForCanWrite"})
    void testCanWriteWhenFileWriterCanWrite(String partitionPath, boolean expectedCanWrite) {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, partitionPath, TEST_FILE_ID, this.taskContextSupplier);
        boolean canWrite = createHandle.canWrite((HoodieRecord)this.dataGen.generateInserts(TEST_INSTANT_TIME, Integer.valueOf(1)).get(0));
        Assertions.assertEquals((Object)expectedCanWrite, (Object)canWrite);
    }

    private static Stream<Arguments> generateParametersForCanWrite() {
        return Stream.of(Arguments.of((Object[])new Object[]{TEST_PARTITION_PATH, true}), Arguments.of((Object[])new Object[]{"2015/03/16", false}));
    }

    @Test
    void testEmptyRecordMapNoWrite() {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        createHandle.recordMap = new HashMap();
        Assertions.assertDoesNotThrow(() -> createHandle.write());
        Assertions.assertEquals((long)0L, (long)createHandle.recordsWritten);
    }

    @Test
    void testWriteSingleRecordFromRecordMap() {
        HashMap<String, HoodieRecord> recordMap = new HashMap<String, HoodieRecord>();
        HoodieRecord record = (HoodieRecord)this.dataGen.generateInserts(TEST_INSTANT_TIME, Integer.valueOf(1)).get(0);
        recordMap.put(record.getRecordKey(), record);
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, recordMap, this.taskContextSupplier);
        Assertions.assertDoesNotThrow(() -> createHandle.write());
        Assertions.assertEquals((long)1L, (long)createHandle.recordsWritten);
    }

    @Test
    void testDoWrite() throws Exception {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        List sourceRecords = this.dataGen.generateInserts(TEST_INSTANT_TIME, Integer.valueOf(4));
        for (HoodieRecord record : sourceRecords) {
            createHandle.doWrite(record, TEST_SCHEMA, new TypedProperties());
        }
        List writeStatuses = createHandle.close();
        this.validateWrittenRecords(writeStatuses, sourceRecords, true);
    }

    @Test
    public void testDoWriteWithPreserveMetadata() throws Exception {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier, true);
        List sourceRecords = this.dataGen.generateInserts(TEST_INSTANT_TIME, Integer.valueOf(4));
        for (HoodieRecord record : sourceRecords) {
            createHandle.doWrite(record, TEST_SCHEMA, new TypedProperties());
        }
        List writeStatuses = createHandle.close();
        this.validateWrittenRecords(writeStatuses, sourceRecords, false);
    }

    @Test
    public void testDoWriteWithDeleteRecord() throws Exception {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        List deleteRecords = this.dataGen.generateDeletes(TEST_INSTANT_TIME, Integer.valueOf(4));
        for (HoodieRecord deleteRecord : deleteRecords) {
            createHandle.doWrite(deleteRecord, TEST_SCHEMA, new TypedProperties());
        }
        List writeStatuses = createHandle.close();
        Assertions.assertEquals((long)0L, (long)createHandle.recordsWritten);
        Assertions.assertEquals((long)4L, (long)createHandle.recordsDeleted);
        this.validateNoRecordWritten(writeStatuses);
    }

    @Test
    public void testDoWriteHandlesException() throws Exception {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        HoodieRecord realRecord = (HoodieRecord)this.dataGen.generateInserts(TEST_INSTANT_TIME, Integer.valueOf(1)).get(0);
        HoodieRecord spyRecord = (HoodieRecord)Mockito.spy((Object)realRecord);
        ((HoodieRecord)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Test exception")}).when((Object)spyRecord)).prependMetaFields((Schema)ArgumentMatchers.any(), (Schema)ArgumentMatchers.any(), (MetadataValues)ArgumentMatchers.any(), (Properties)ArgumentMatchers.any());
        Assertions.assertDoesNotThrow(() -> createHandle.doWrite(spyRecord, TEST_SCHEMA, new TypedProperties()));
        List writeStatuses = createHandle.close();
        Assertions.assertEquals((int)1, (int)createHandle.writeStatus.getErrors().size());
        this.validateNoRecordWritten(writeStatuses);
    }

    @Test
    public void testCloseWhenAlreadyClosed() {
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        List writeStatuses = createHandle.close();
        Assertions.assertEquals((int)1, (int)writeStatuses.size());
        List secondCloseOutput = createHandle.close();
        Assertions.assertEquals((Object)writeStatuses, (Object)secondCloseOutput);
    }

    @Test
    public void testCloseWithFileWriterIOException() throws IOException {
        HoodieFileWriter spyFileWriter;
        HoodieCreateHandle createHandle = new HoodieCreateHandle(this.writeConfig, TEST_INSTANT_TIME, this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        createHandle.fileWriter = spyFileWriter = (HoodieFileWriter)Mockito.spy((Object)createHandle.fileWriter);
        ((HoodieFileWriter)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("Test IO exception")}).when((Object)spyFileWriter)).close();
        Assertions.assertThrows(HoodieInsertException.class, () -> createHandle.close());
    }

    @Test
    void testMarkerFileCreatedWhenFileWriterInitializationFails() throws Exception {
        HoodieInsertException exception = (HoodieInsertException)Assertions.assertThrows(HoodieInsertException.class, () -> {
            class CreateHandleWithFileWriterInitFailure
            extends HoodieCreateHandle<Object, Object, Object, Object> {
                public CreateHandleWithFileWriterInitFailure(HoodieWriteConfig config, String instantTime, HoodieTable<Object, Object, Object, Object> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
                    super(config, instantTime, hoodieTable, partitionPath, fileId, taskContextSupplier);
                }

                protected HoodieFileWriter initializeFileWriter() throws IOException {
                    return new TestFileWriter(this.path, this.hoodieTable.getStorage(), true);
                }
            }
            new CreateHandleWithFileWriterInitFailure(this.writeConfig, TEST_INSTANT_TIME, (HoodieTable<Object, Object, Object, Object>)this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        });
        Assertions.assertEquals((Object)("Failed to initialize HoodieStorageWriter for path " + String.format("%s/%s/%s", this.basePath, TEST_PARTITION_PATH, this.getExpectedBaseFileName())), (Object)exception.getMessage());
        HoodieStorage hoodieStorage = this.metaClient.getStorage();
        this.validatePartitionMetaPathExistence(hoodieStorage, true);
        String expectedBaseFileName = this.getExpectedBaseFileName();
        this.validateMarkerFileExistence(hoodieStorage, expectedBaseFileName, true);
        StoragePath partitionPath = new StoragePath(this.basePath, TEST_PARTITION_PATH);
        StoragePath expectedFilePath = new StoragePath(partitionPath, expectedBaseFileName);
        Assertions.assertTrue((boolean)hoodieStorage.exists(expectedFilePath), (String)"File should have been created during TestFileWriter initialization");
    }

    @Test
    void testMarkerFileCreatedWhenFileWriterWriteFails() throws Exception {
        class CreateHandleWithFileWriterWriteFailure
        extends HoodieCreateHandle<Object, Object, Object, Object> {
            public CreateHandleWithFileWriterWriteFailure(HoodieWriteConfig config, String instantTime, HoodieTable<Object, Object, Object, Object> hoodieTable, String partitionPath, String fileId, TaskContextSupplier taskContextSupplier) {
                super(config, instantTime, hoodieTable, partitionPath, fileId, taskContextSupplier);
            }

            protected HoodieFileWriter initializeFileWriter() throws IOException {
                return new TestFileWriter(this.path, this.hoodieTable.getStorage(), false, true);
            }
        }
        CreateHandleWithFileWriterWriteFailure createHandle = new CreateHandleWithFileWriterWriteFailure(this.writeConfig, TEST_INSTANT_TIME, (HoodieTable<Object, Object, Object, Object>)this.hoodieTable, TEST_PARTITION_PATH, TEST_FILE_ID, this.taskContextSupplier);
        Assertions.assertNotNull((Object)((Object)createHandle));
        Assertions.assertNotNull((Object)createHandle.fileWriter);
        Assertions.assertTrue((boolean)createHandle.fileWriter.canWrite());
        HoodieStorage hoodieStorage = this.metaClient.getStorage();
        this.validatePartitionMetaPathExistence(hoodieStorage, true);
        String expectedBaseFileName = this.getExpectedBaseFileName();
        this.validateMarkerFileExistence(hoodieStorage, expectedBaseFileName, true);
        StoragePath partitionPath = new StoragePath(this.basePath, TEST_PARTITION_PATH);
        StoragePath expectedFilePath = new StoragePath(partitionPath, expectedBaseFileName);
        Assertions.assertTrue((boolean)hoodieStorage.exists(expectedFilePath));
        HoodieRecord testRecord = (HoodieRecord)this.dataGen.generateInserts(TEST_INSTANT_TIME, Integer.valueOf(1)).get(0);
        IOException writeException = (IOException)Assertions.assertThrows(IOException.class, () -> createHandle.fileWriter.write("key1", testRecord, TEST_SCHEMA, new Properties()));
        Assertions.assertEquals((Object)"Simulated file writer write failure", (Object)writeException.getMessage());
        IOException writeWithMetadataException = (IOException)Assertions.assertThrows(IOException.class, () -> createHandle.fileWriter.writeWithMetadata(testRecord.getKey(), testRecord, TEST_SCHEMA, new Properties()));
        Assertions.assertEquals((Object)"Simulated file writer write failure", (Object)writeWithMetadataException.getMessage());
        Assertions.assertDoesNotThrow(() -> createHandle.fileWriter.close());
        Assertions.assertFalse((boolean)createHandle.fileWriter.canWrite());
        Assertions.assertDoesNotThrow(() -> ((CreateHandleWithFileWriterWriteFailure)createHandle).close());
    }

    private void validateWrittenRecords(List<WriteStatus> writeStatuses, List<HoodieRecord> originalRecords, boolean populateMetaFields) throws IOException {
        Assertions.assertEquals((int)1, (int)writeStatuses.size());
        WriteStatus writeStatus = writeStatuses.get(0);
        Assertions.assertEquals((Object)TEST_FILE_ID, (Object)writeStatus.getFileId());
        Assertions.assertEquals((Object)TEST_PARTITION_PATH, (Object)writeStatus.getPartitionPath());
        Assertions.assertEquals((long)originalRecords.size(), (long)writeStatus.getTotalRecords());
        Assertions.assertEquals((long)0L, (long)writeStatus.getTotalErrorRecords());
        Assertions.assertFalse((boolean)writeStatus.hasErrors());
        Assertions.assertNull((Object)writeStatus.getGlobalError());
        HoodieWriteStat writeStat = writeStatus.getStat();
        Assertions.assertEquals((long)originalRecords.size(), (long)writeStat.getNumInserts());
        Assertions.assertEquals((long)originalRecords.size(), (long)writeStat.getNumWrites());
        Assertions.assertEquals((long)0L, (long)writeStat.getNumDeletes());
        Assertions.assertEquals((long)0L, (long)writeStat.getNumUpdateWrites());
        Assertions.assertEquals((long)0L, (long)writeStat.getTotalWriteErrors());
        Assertions.assertEquals((Object)TEST_FILE_ID, (Object)writeStat.getFileId());
        Assertions.assertEquals((Object)TEST_PARTITION_PATH, (Object)writeStat.getPartitionPath());
        Assertions.assertTrue((writeStat.getTotalWriteBytes() > 0L ? 1 : 0) != 0);
        Assertions.assertTrue((writeStat.getFileSizeInBytes() > 0L ? 1 : 0) != 0);
        Assertions.assertEquals((Object)String.format("%s/%s", TEST_PARTITION_PATH, this.getExpectedBaseFileName()), (Object)writeStat.getPath());
        StoragePath writtenFilePath = new StoragePath(this.basePath, writeStat.getPath());
        Assertions.assertTrue((boolean)this.metaClient.getStorage().exists(writtenFilePath));
        List writtenRecords = new ParquetUtils().readAvroRecords(this.metaClient.getStorage(), writtenFilePath);
        Assertions.assertEquals((int)originalRecords.size(), (int)writtenRecords.size());
        for (int i = 0; i < originalRecords.size(); ++i) {
            HoodieRecord originalRecord = originalRecords.get(i);
            GenericRecord writtenRecord = (GenericRecord)writtenRecords.get(i);
            Assertions.assertNotNull((Object)writtenRecord, (String)("Written record not found for key: " + originalRecord.getRecordKey()));
            if (populateMetaFields) {
                Assertions.assertEquals((Object)TEST_INSTANT_TIME, (Object)writtenRecord.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD).toString());
                String expectedCommitSeqId = HoodieRecord.generateSequenceId((String)TEST_INSTANT_TIME, (int)((Integer)this.taskContextSupplier.getPartitionIdSupplier().get()), (long)i);
                Assertions.assertEquals((Object)expectedCommitSeqId, (Object)writtenRecord.get(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD).toString());
                Assertions.assertEquals((Object)originalRecords.get(i).getRecordKey(), (Object)writtenRecord.get(HoodieRecord.RECORD_KEY_METADATA_FIELD).toString());
                Assertions.assertEquals((Object)HoodieTestDataGenerator.DEFAULT_PARTITION_PATHS[i % 3], (Object)writtenRecord.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD).toString());
            } else {
                Assertions.assertNull((Object)writtenRecord.get(HoodieRecord.COMMIT_TIME_METADATA_FIELD));
                Assertions.assertNull((Object)writtenRecord.get(HoodieRecord.COMMIT_SEQNO_METADATA_FIELD));
                Assertions.assertNull((Object)writtenRecord.get(HoodieRecord.RECORD_KEY_METADATA_FIELD));
                Assertions.assertNull((Object)writtenRecord.get(HoodieRecord.PARTITION_PATH_METADATA_FIELD));
            }
            Assertions.assertEquals((Object)this.getExpectedBaseFileName(), (Object)writtenRecord.get(HoodieRecord.FILENAME_METADATA_FIELD).toString());
        }
    }

    private void validateNoRecordWritten(List<WriteStatus> writeStatuses) throws IOException {
        WriteStatus writeStatus = writeStatuses.get(0);
        StoragePath writtenFilePath = new StoragePath(this.basePath, writeStatus.getStat().getPath());
        Assertions.assertTrue((boolean)this.metaClient.getStorage().exists(writtenFilePath));
        List writtenRecords = new ParquetUtils().readAvroRecords(this.metaClient.getStorage(), writtenFilePath);
        Assertions.assertEquals((int)0, (int)writtenRecords.size());
    }

    private String getExpectedBaseFileName() {
        String writeToken = FSUtils.makeWriteToken((int)0, (int)0, (long)0L);
        return FSUtils.makeBaseFileName((String)TEST_INSTANT_TIME, (String)writeToken, (String)TEST_FILE_ID, (String)".parquet");
    }

    private void validateMarkerFileExistence(HoodieStorage hoodieStorage, String expectedBaseFileName, boolean shouldExist) throws IOException {
        StoragePath expectedMarkerFolder = new StoragePath(this.metaClient.getMarkerFolderPath(TEST_INSTANT_TIME), TEST_PARTITION_PATH);
        StoragePath expectedMarkerPath = new StoragePath(expectedMarkerFolder, expectedBaseFileName + ".marker" + "." + IOType.CREATE.name());
        if (shouldExist) {
            Assertions.assertTrue((boolean)hoodieStorage.exists(expectedMarkerPath));
        } else {
            Assertions.assertFalse((boolean)hoodieStorage.exists(expectedMarkerPath));
            StoragePath markerFolderPath = new StoragePath(this.metaClient.getMarkerFolderPath(TEST_INSTANT_TIME));
            if (hoodieStorage.exists(markerFolderPath)) {
                Assertions.assertTrue((boolean)hoodieStorage.listDirectEntries(markerFolderPath).isEmpty(), (String)"Marker folder should be empty when marker file should not exist");
            }
        }
    }

    private void validatePartitionMetaPathExistence(HoodieStorage hoodieStorage, boolean shouldExist) throws IOException {
        StoragePath partitionPath = new StoragePath(this.basePath, TEST_PARTITION_PATH);
        StoragePath partitionMetaPath = new StoragePath(partitionPath, ".hoodie_partition_metadata");
        Assertions.assertEquals((Object)shouldExist, (Object)hoodieStorage.exists(partitionMetaPath));
    }
}

