/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index.bucket;

import java.util.Arrays;
import java.util.List;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.hudi.common.model.HoodieAvroRecord;
import org.apache.hudi.common.model.HoodieKey;
import org.apache.hudi.index.bucket.BucketIdentifier;
import org.apache.hudi.keygen.KeyGenUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestBucketIdentifier {
    public static final String NESTED_COL_SCHEMA = "{\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": \"string\"},{\"name\": \"prop2\", \"type\": \"long\"}]}";
    public static final String EXAMPLE_SCHEMA = "{\"type\": \"record\",\"name\": \"testrec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"ts_ms\", \"type\": \"string\"},{\"name\": \"pii_col\", \"type\": \"string\"},{\"name\": \"nested_col\",\"type\": {\"type\":\"record\", \"name\":\"nested_col\",\"fields\": [{\"name\": \"prop1\",\"type\": \"string\"},{\"name\": \"prop2\", \"type\": \"long\"}]}}]}";

    public static GenericRecord getRecord() {
        return TestBucketIdentifier.getRecord(TestBucketIdentifier.getNestedColRecord("val1", 10L));
    }

    public static GenericRecord getNestedColRecord(String prop1Value, Long prop2Value) {
        GenericData.Record nestedColRecord = new GenericData.Record(new Schema.Parser().parse(NESTED_COL_SCHEMA));
        nestedColRecord.put("prop1", (Object)prop1Value);
        nestedColRecord.put("prop2", (Object)prop2Value);
        return nestedColRecord;
    }

    public static GenericRecord getRecord(GenericRecord nestedColRecord) {
        GenericData.Record record = new GenericData.Record(new Schema.Parser().parse(EXAMPLE_SCHEMA));
        record.put("timestamp", (Object)4357686L);
        record.put("_row_key", (Object)"key1");
        record.put("ts_ms", (Object)"2020-03-21");
        record.put("pii_col", (Object)"pi");
        record.put("nested_col", (Object)nestedColRecord);
        return record;
    }

    @Test
    public void testBucketFileId() {
        int[] ids;
        for (int id : ids = new int[]{0, 4, 8, 16, 32, 64, 128, 256, 512, 1000, 1024, 4096, 10000, 100000}) {
            String fileId = BucketIdentifier.newBucketFileIdPrefix((int)id);
            assert (BucketIdentifier.bucketIdFromFileId((String)fileId) == id);
        }
    }

    @Test
    public void testBucketIdWithSimpleRecordKey() {
        String recordKeyField = "_row_key";
        String indexKeyField = "_row_key";
        GenericRecord record = TestBucketIdentifier.getRecord();
        HoodieAvroRecord hoodieRecord = new HoodieAvroRecord(new HoodieKey(KeyGenUtils.getRecordKey((GenericRecord)record, (String)recordKeyField, (boolean)false), ""), null);
        int bucketId = BucketIdentifier.getBucketId((String)hoodieRecord.getRecordKey(), (String)indexKeyField, (int)8);
        assert (bucketId == BucketIdentifier.getBucketId(Arrays.asList(record.get(indexKeyField).toString()), (int)8));
    }

    @Test
    public void testBucketIdWithComplexRecordKey() {
        List<String> recordKeyField = Arrays.asList("_row_key", "ts_ms");
        String indexKeyField = "_row_key";
        GenericRecord record = TestBucketIdentifier.getRecord();
        HoodieAvroRecord hoodieRecord = new HoodieAvroRecord(new HoodieKey(KeyGenUtils.getRecordKey((GenericRecord)record, recordKeyField, (boolean)false), ""), null);
        int bucketId = BucketIdentifier.getBucketId((String)hoodieRecord.getRecordKey(), (String)indexKeyField, (int)8);
        assert (bucketId == BucketIdentifier.getBucketId(Arrays.asList(record.get(indexKeyField).toString()), (int)8));
    }

    @Test
    public void testGetHashKeys() {
        List keys = BucketIdentifier.getHashKeys((String)"abc", (String)"");
        Assertions.assertEquals((int)1, (int)keys.size());
        Assertions.assertEquals((Object)"abc", keys.get(0));
        keys = BucketIdentifier.getHashKeys((String)"f1:abc,f2:bcd", (String)"f2");
        Assertions.assertEquals((int)1, (int)keys.size());
        Assertions.assertEquals((Object)"bcd", keys.get(0));
        keys = BucketIdentifier.getHashKeys((String)"f1:abc,f2:bcd", (String)"f1,f2");
        Assertions.assertEquals((int)2, (int)keys.size());
        Assertions.assertEquals((Object)"abc", keys.get(0));
        Assertions.assertEquals((Object)"bcd", keys.get(1));
        keys = BucketIdentifier.getHashKeys((String)"f1:abc,f2:bcd,efg", (String)"f1,f2");
        Assertions.assertEquals((int)2, (int)keys.size());
        Assertions.assertEquals((Object)"abc", keys.get(0));
        Assertions.assertEquals((Object)"bcd,efg", keys.get(1));
    }
}

