/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.index;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.SchemaBuilder;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.TableSchemaResolver;
import org.apache.hudi.exception.HoodieMetadataIndexException;
import org.apache.hudi.index.HoodieIndexUtils;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockedConstruction;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;

public class TestHoodieIndexUtils {
    @Mock
    private HoodieTableMetaClient mockMetaClient;
    @Mock
    private HoodieTableConfig mockTableConfig;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.mockMetaClient.getTableConfig()).thenReturn((Object)this.mockTableConfig);
    }

    @Test
    public void testIsEligibleForSecondaryIndexWithSupportedDataTypes() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().requiredString("stringField").requiredString("charField").optionalInt("intField").requiredLong("longField").name("doubleField").type().doubleType().noDefault().endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashSet<String> partitions = new HashSet<String>();
            partitions.add(MetadataPartitionType.RECORD_INDEX.getPartitionPath());
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(partitions);
            HashMap columns = new HashMap();
            columns.put("stringField", Collections.emptyMap());
            HashMap<String, String> options = new HashMap<String, String>();
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(Collections.emptySet());
            options.put(HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key(), "true");
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            columns.clear();
            columns.put("stringField", Collections.emptyMap());
            columns.put("intField", Collections.emptyMap());
            columns.put("longField", Collections.emptyMap());
            columns.put("doubleField", Collections.emptyMap());
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            columns.clear();
            columns.put("doubleField", Collections.emptyMap());
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
        }
    }

    public void testValidateDataTypeForSecondaryOrExpressionIndex() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"TestRecord").fields().requiredString("stringField").optionalInt("intField").name("arrayField").type().array().items().stringType()).noDefault().name("mapField").type().map().values().intType()).noDefault().name("structField").type().record("NestedRecord").fields().requiredString("nestedString").endRecord()).noDefault().endRecord();
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryOrExpressionIndex(Arrays.asList("stringField", "intField"), (Schema)schema));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryOrExpressionIndex(Arrays.asList("arrayField", "mapField", "structField"), (Schema)schema));
    }

    @Test
    public void testValidateDataTypeForSecondaryIndex() {
        Schema schema = (Schema)((SchemaBuilder.RecordDefault)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"TestRecord").fields().requiredString("stringField").requiredString("charField").optionalInt("intField").requiredLong("longField").name("timestampField").type().longType().longDefault(0L).name("booleanField").type().booleanType().noDefault().name("floatField").type().floatType().noDefault().name("doubleField").type().doubleType().noDefault().name("arrayField").type().array().items().stringType()).noDefault().name("mapField").type().map().values().intType()).noDefault().name("structField").type().record("NestedRecord").fields().requiredString("nestedString").endRecord()).noDefault().endRecord();
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("stringField"), (Schema)schema));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("charField"), (Schema)schema));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("intField"), (Schema)schema));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("longField"), (Schema)schema));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("timestampField"), (Schema)schema));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("doubleField"), (Schema)schema));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Arrays.asList("stringField", "intField", "longField"), (Schema)schema));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("booleanField"), (Schema)schema));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("arrayField"), (Schema)schema));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("mapField"), (Schema)schema));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("structField"), (Schema)schema));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("floatField"), (Schema)schema));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Arrays.asList("stringField", "booleanField"), (Schema)schema));
    }

    @Test
    public void testValidateDataTypeForSecondaryIndexWithLogicalTypes() {
        Schema timestampMillis = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema timestampMicros = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema date = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeMillis = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeMicros = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema decimal = LogicalTypes.decimal((int)10, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        Schema uuid = LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        Schema localTimestampMillis = LogicalTypes.localTimestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema localTimestampMicros = LogicalTypes.localTimestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema schemaWithLogicalTypes = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestampMillisField").type(timestampMillis).noDefault().name("timestampMicrosField").type(timestampMicros).noDefault().name("dateField").type(date).noDefault().name("timeMillisField").type(timeMillis).noDefault().name("timeMicrosField").type(timeMicros).noDefault().name("decimalField").type(decimal).noDefault().name("uuidField").type(uuid).noDefault().name("localTimestampMillisField").type(localTimestampMillis).noDefault().name("localTimestampMicrosField").type(localTimestampMicros).noDefault().endRecord();
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("timestampMillisField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("timestampMicrosField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("dateField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("timeMillisField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertTrue((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("timeMicrosField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("decimalField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("uuidField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("localTimestampMillisField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Collections.singletonList("localTimestampMicrosField"), (Schema)schemaWithLogicalTypes));
        Assertions.assertFalse((boolean)HoodieIndexUtils.validateDataTypeForSecondaryIndex(Arrays.asList("timestampMillisField", "decimalField"), (Schema)schemaWithLogicalTypes));
    }

    @Test
    public void testIsEligibleForSecondaryIndexWithUnsupportedDataTypes() {
        Schema decimalType = LogicalTypes.decimal((int)10, (int)2).addToSchema(Schema.create((Schema.Type)Schema.Type.BYTES));
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().requiredString("stringField").name("floatField").type().floatType().noDefault().name("doubleField").type().doubleType().noDefault().name("booleanField").type().booleanType().noDefault().name("decimalField").type(decimalType).noDefault().endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashSet<String> partitions = new HashSet<String>();
            partitions.add(MetadataPartitionType.RECORD_INDEX.getPartitionPath());
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(partitions);
            HashMap columns = new HashMap();
            HashMap options = new HashMap();
            columns.put("floatField", Collections.emptyMap());
            Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            columns.clear();
            columns.put("doubleField", Collections.emptyMap());
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            columns.clear();
            columns.put("booleanField", Collections.emptyMap());
            HoodieMetadataIndexException ex3 = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex3.getMessage().contains("unsupported data type"));
            Assertions.assertTrue((boolean)ex3.getMessage().contains("BOOLEAN"));
            Assertions.assertTrue((boolean)ex3.getMessage().contains("Secondary indexes only support"));
            columns.clear();
            columns.put("decimalField", Collections.emptyMap());
            HoodieMetadataIndexException ex4 = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex4.getMessage().contains("unsupported data type"));
            Assertions.assertTrue((boolean)ex4.getMessage().contains("BYTES with logical type"));
            Assertions.assertTrue((boolean)ex4.getMessage().contains("Decimal"));
            Assertions.assertTrue((boolean)ex4.getMessage().contains("Secondary indexes only support"));
            columns.clear();
            columns.put("stringField", Collections.emptyMap());
            columns.put("doubleField", Collections.emptyMap());
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
        }
    }

    @Test
    public void testIsEligibleForSecondaryIndexWithLogicalTypes() {
        Schema timestampMillis = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema date = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestampField").type(timestampMillis).noDefault().name("dateField").type(date).noDefault().endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashSet<String> partitions = new HashSet<String>();
            partitions.add(MetadataPartitionType.RECORD_INDEX.getPartitionPath());
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(partitions);
            HashMap columns = new HashMap();
            columns.put("timestampField", Collections.emptyMap());
            columns.put("dateField", Collections.emptyMap());
            HashMap options = new HashMap();
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
        }
    }

    @Test
    public void testIsEligibleForSecondaryIndexWithoutRecordIndex() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().requiredString("stringField").endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(Collections.emptySet());
            HashMap columns = new HashMap();
            columns.put("stringField", Collections.emptyMap());
            HashMap<String, String> options = new HashMap<String, String>();
            HoodieMetadataIndexException ex = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("Record index is required"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("not enabled"));
            options.put(HoodieMetadataConfig.GLOBAL_RECORD_LEVEL_INDEX_ENABLE_PROP.key(), "false");
            HoodieMetadataIndexException ex2 = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex2.getMessage().contains("Record index is required"));
            Assertions.assertTrue((boolean)ex2.getMessage().contains("not enabled"));
        }
    }

    @Test
    public void testIsEligibleForExpressionIndex() {
        Schema schema = (Schema)((SchemaBuilder.MapDefault)((SchemaBuilder.ArrayDefault)SchemaBuilder.record((String)"TestRecord").fields().requiredString("stringField").name("floatField").type().floatType().noDefault().name("arrayField").type().array().items().stringType()).noDefault().name("mapField").type().map().values().intType()).noDefault().endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashMap columns = new HashMap();
            HashMap options = new HashMap();
            columns.put("stringField", Collections.emptyMap());
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"EXPRESSION_INDEX", (Map)options, (Map)columns, (String)"test_index"));
            columns.clear();
            columns.put("floatField", Collections.emptyMap());
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"EXPRESSION_INDEX", (Map)options, (Map)columns, (String)"test_index"));
            columns.clear();
            columns.put("arrayField", Collections.emptyMap());
            HoodieMetadataIndexException ex = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"EXPRESSION_INDEX", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("Complex types"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("ARRAY"));
            columns.clear();
            columns.put("mapField", Collections.emptyMap());
            HoodieMetadataIndexException ex2 = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"EXPRESSION_INDEX", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex2.getMessage().contains("Complex types"));
            Assertions.assertTrue((boolean)ex2.getMessage().contains("MAP"));
        }
    }

    @Test
    public void testIsEligibleForExpressionIndexWithNullableFields() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().optionalString("nullableStringField").name("nullableIntField").type().nullable().intType().intDefault(0).endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashMap columns = new HashMap();
            columns.put("nullableStringField", Collections.emptyMap());
            columns.put("nullableIntField", Collections.emptyMap());
            HashMap options = new HashMap();
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"EXPRESSION_INDEX", (Map)options, (Map)columns, (String)"test_index"));
        }
    }

    @Test
    public void testIsEligibleForSecondaryIndexWithNullableFields() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().optionalString("nullableStringField").name("nullableIntField").type().nullable().intType().intDefault(0).name("nullableLongField").type().nullable().longType().longDefault(0L).endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashSet<String> partitions = new HashSet<String>();
            partitions.add(MetadataPartitionType.RECORD_INDEX.getPartitionPath());
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(partitions);
            HashMap columns = new HashMap();
            columns.put("nullableStringField", Collections.emptyMap());
            columns.put("nullableIntField", Collections.emptyMap());
            columns.put("nullableLongField", Collections.emptyMap());
            HashMap options = new HashMap();
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
        }
    }

    @Test
    public void testIsEligibleForSecondaryIndexWithAllLogicalTypes() {
        Schema timestampMillis = LogicalTypes.timestampMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema timestampMicros = LogicalTypes.timestampMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema date = LogicalTypes.date().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeMillis = LogicalTypes.timeMillis().addToSchema(Schema.create((Schema.Type)Schema.Type.INT));
        Schema timeMicros = LogicalTypes.timeMicros().addToSchema(Schema.create((Schema.Type)Schema.Type.LONG));
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("timestampMillisField").type(timestampMillis).noDefault().name("timestampMicrosField").type(timestampMicros).noDefault().name("dateField").type(date).noDefault().name("timeMillisField").type(timeMillis).noDefault().name("timeMicrosField").type(timeMicros).noDefault().endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashSet<String> partitions = new HashSet<String>();
            partitions.add(MetadataPartitionType.RECORD_INDEX.getPartitionPath());
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(partitions);
            HashMap columns = new HashMap();
            columns.put("timestampMillisField", Collections.emptyMap());
            columns.put("timestampMicrosField", Collections.emptyMap());
            columns.put("dateField", Collections.emptyMap());
            columns.put("timeMillisField", Collections.emptyMap());
            columns.put("timeMicrosField", Collections.emptyMap());
            HashMap options = new HashMap();
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
        }
    }

    @Test
    public void testIsEligibleForSecondaryIndexWithColumnNotInSchema() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().requiredString("existingField").endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashSet<String> partitions = new HashSet<String>();
            partitions.add(MetadataPartitionType.RECORD_INDEX.getPartitionPath());
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(partitions);
            HashMap columns = new HashMap();
            columns.put("nonExistentField", Collections.emptyMap());
            HashMap options = new HashMap();
            HoodieMetadataIndexException ex = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("Column 'nonExistentField' does not exist"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("verify the column name"));
        }
    }

    @Test
    public void testIsEligibleForSecondaryIndexWithStringLogicalTypes() {
        Schema uuidSchema = LogicalTypes.uuid().addToSchema(Schema.create((Schema.Type)Schema.Type.STRING));
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().name("uuidField").type(uuidSchema).noDefault().requiredString("regularStringField").endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashSet<String> partitions = new HashSet<String>();
            partitions.add(MetadataPartitionType.RECORD_INDEX.getPartitionPath());
            Mockito.when((Object)this.mockTableConfig.getMetadataPartitions()).thenReturn(partitions);
            HashMap columns = new HashMap();
            HashMap options = new HashMap();
            columns.put("uuidField", Collections.emptyMap());
            HoodieMetadataIndexException ex = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("unsupported data type"), (String)("Expected message to contain 'unsupported data type', but was: " + ex.getMessage()));
            Assertions.assertTrue((ex.getMessage().contains("STRING") && ex.getMessage().contains("uuid") ? 1 : 0) != 0, (String)("Expected message to mention STRING and uuid, but was: " + ex.getMessage()));
            columns.clear();
            columns.put("regularStringField", Collections.emptyMap());
            Assertions.assertDoesNotThrow(() -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"secondary_index", (Map)options, (Map)columns, (String)"test_index"));
        }
    }

    @Test
    public void testIsEligibleForExpressionIndexWithColumnNotInSchema() {
        Schema schema = (Schema)SchemaBuilder.record((String)"TestRecord").fields().requiredString("existingField").endRecord();
        try (MockedConstruction mockedResolver = Mockito.mockConstruction(TableSchemaResolver.class, (mock, context) -> Mockito.when((Object)mock.getTableAvroSchema()).thenReturn((Object)schema));){
            HashMap columns = new HashMap();
            columns.put("nonExistentField", Collections.emptyMap());
            HashMap options = new HashMap();
            HoodieMetadataIndexException ex = (HoodieMetadataIndexException)Assertions.assertThrows(HoodieMetadataIndexException.class, () -> HoodieIndexUtils.validateEligibilityForSecondaryOrExpressionIndex((HoodieTableMetaClient)this.mockMetaClient, (String)"EXPRESSION_INDEX", (Map)options, (Map)columns, (String)"test_index"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("Column 'nonExistentField' does not exist"));
            Assertions.assertTrue((boolean)ex.getMessage().contains("verify the column name"));
        }
    }
}

