/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.estimator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieFileFormat;
import org.apache.hudi.common.model.HoodieWriteStat;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.versioning.v2.BaseTimelineV2;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.collection.Pair;
import org.apache.hudi.config.HoodieCompactionConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.estimator.AverageRecordSizeEstimator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.Mockito;

public class TestAverageRecordSizeEstimator {
    private static final String BASE_FILE_EXTENSION = ((HoodieFileFormat)HoodieTableConfig.BASE_FILE_FORMAT.defaultValue()).getFileExtension();
    private final HoodieTimeline mockTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
    private final CommitMetadataSerDe mockCommitMetadataSerDe = (CommitMetadataSerDe)Mockito.mock(CommitMetadataSerDe.class);
    private static final String PARTITION1 = "partition1";
    private static final String TEST_WRITE_TOKEN = "1-0-1";
    private static final Integer DEFAULT_MAX_COMMITS = 2;
    private static final Integer DEFAULT_AVERAGE_PARQUET_METADATA_SIZE = 10000000;
    private static final Double DEFAULT_RECORD_SIZE_ESTIMATE_THRESHOLD = 0.1;

    @Test
    public void testAverageBytesPerRecordForEmptyCommitTimeLine() throws Exception {
        HoodieTimeline commitTimeLine = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        HoodieWriteConfig config = HoodieWriteConfig.newBuilder().withPath("/tmp").build();
        Mockito.when((Object)commitTimeLine.empty()).thenReturn((Object)true);
        long expectAvgSize = config.getCopyOnWriteRecordSizeEstimate();
        AverageRecordSizeEstimator averageRecordSizeEstimator = new AverageRecordSizeEstimator(config);
        long actualAvgSize = averageRecordSizeEstimator.averageBytesPerRecord(commitTimeLine, HoodieTestUtils.COMMIT_METADATA_SER_DE);
        Assertions.assertEquals((long)expectAvgSize, (long)actualAvgSize);
    }

    @Test
    public void testErrorHandling() {
        int recordSize = 10000;
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withProps(Collections.singletonMap(HoodieCompactionConfig.COPY_ON_WRITE_RECORD_SIZE_ESTIMATE.key(), String.valueOf(recordSize))).build(false);
        BaseTimelineV2 commitsTimeline = new BaseTimelineV2();
        List<HoodieInstant> instants = Collections.singletonList(HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.COMPLETED, "commit", "1"));
        Mockito.when((Object)this.mockTimeline.getInstants()).thenReturn(instants);
        Mockito.when((Object)this.mockTimeline.getReverseOrderedInstants()).then(i -> instants.stream());
        commitsTimeline.setInstants(new ArrayList());
        AverageRecordSizeEstimator averageRecordSizeEstimator = new AverageRecordSizeEstimator(writeConfig);
        long actualAvgSize = averageRecordSizeEstimator.averageBytesPerRecord(this.mockTimeline, HoodieTestUtils.COMMIT_METADATA_SER_DE);
        Assertions.assertEquals((long)recordSize, (long)actualAvgSize);
    }

    @ParameterizedTest
    @MethodSource(value={"testCases"})
    public void testAverageRecordSizeWithNonEmptyCommitTimeline(List<Pair<HoodieInstant, List<HWriteStat>>> instantSizePairs, long expectedSize) {
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath("/tmp").withRecordSizeEstimator(AverageRecordSizeEstimator.class.getName()).withRecordSizeEstimatorMaxCommits(DEFAULT_MAX_COMMITS.intValue()).withRecordSizeEstimatorAverageMetadataSize((long)DEFAULT_AVERAGE_PARQUET_METADATA_SIZE.intValue()).withCompactionConfig(HoodieCompactionConfig.newBuilder().compactionRecordSizeEstimateThreshold(DEFAULT_RECORD_SIZE_ESTIMATE_THRESHOLD.doubleValue()).build()).build();
        ArrayList instants = new ArrayList();
        instantSizePairs.forEach(entry -> {
            HoodieInstant hoodieInstant = (HoodieInstant)entry.getKey();
            HoodieCommitMetadata commitMetadata = new HoodieCommitMetadata();
            ((List)entry.getValue()).forEach(hWriteStat -> {
                HoodieWriteStat writeStat = new HoodieWriteStat();
                writeStat.setNumWrites(hWriteStat.getTotalRecordsWritten().longValue());
                writeStat.setTotalWriteBytes(hWriteStat.getPerRecordSize() * hWriteStat.getTotalRecordsWritten());
                writeStat.setPath(hWriteStat.getPath());
                commitMetadata.addWriteStat(PARTITION1, writeStat);
            });
            instants.add(hoodieInstant);
            try {
                Mockito.when((Object)this.mockTimeline.readCommitMetadata(hoodieInstant)).thenReturn((Object)commitMetadata);
            }
            catch (IOException e) {
                throw new RuntimeException("Should not have failed", e);
            }
        });
        ArrayList reverseOrderInstants = new ArrayList(instants);
        Collections.reverse(reverseOrderInstants);
        Mockito.when((Object)this.mockTimeline.filterCompletedInstants()).thenReturn((Object)this.mockTimeline);
        Mockito.when((Object)this.mockTimeline.getReverseOrderedInstants()).then(i -> reverseOrderInstants.stream());
        AverageRecordSizeEstimator averageRecordSizeEstimator = new AverageRecordSizeEstimator(writeConfig);
        long actualSize = averageRecordSizeEstimator.averageBytesPerRecord(this.mockTimeline, this.mockCommitMetadataSerDe);
        Assertions.assertEquals((long)expectedSize, (long)actualSize);
    }

    private static String getBaseFileName(String instantTime) {
        String fileName = UUID.randomUUID().toString();
        return FSUtils.makeBaseFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName, (String)BASE_FILE_EXTENSION);
    }

    private static String getLogFileName(String instantTime) {
        String fileName = UUID.randomUUID().toString();
        String fullFileName = FSUtils.makeBaseFileName((String)instantTime, (String)TEST_WRITE_TOKEN, (String)fileName, (String)BASE_FILE_EXTENSION);
        Assertions.assertEquals((Object)instantTime, (Object)FSUtils.getCommitTime((String)fullFileName));
        return FSUtils.makeLogFileName((String)fileName, (String)HoodieFileFormat.HOODIE_LOG.getFileExtension(), (String)instantTime, (int)1, (String)TEST_WRITE_TOKEN);
    }

    private static Stream<Arguments> testCases() {
        Long baseInstant = 20231204194919610L;
        Long standardCount = 10000000L;
        ArrayList<Arguments> arguments = new ArrayList<Arguments>();
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 100L)))), 99L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 100L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant + 100L)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 100L, standardCount, 200L)))), 199L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 100L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant + 100L)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 100L, 1000L, 200L)))), 99L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 200L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("replacecommit", Long.toString(baseInstant + 100L)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 100L, standardCount, 100L)))), 199L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 100L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant + 100L)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 100L, standardCount, 200L)))), 199L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 100L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant + 100L)), Arrays.asList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 100L, standardCount, 200L), TestAverageRecordSizeEstimator.generateLogWriteStat(baseInstant + 100L, standardCount, 300L)))), 199L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 100L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant + 100L)), Arrays.asList(TestAverageRecordSizeEstimator.generateLogWriteStat(baseInstant + 100L, standardCount, 200L), TestAverageRecordSizeEstimator.generateLogWriteStat(baseInstant + 100L, standardCount, 300L)))), 99L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 200L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant + 100L)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 100L, 1L, 50L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant + 200L)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 200L, 1L, 100L)))), Long.valueOf((String)HoodieCompactionConfig.COPY_ON_WRITE_RECORD_SIZE_ESTIMATE.defaultValue())}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 100L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant + 100L)), Arrays.asList(TestAverageRecordSizeEstimator.generateLogWriteStat(baseInstant + 100L, standardCount, 200L), TestAverageRecordSizeEstimator.generateLogWriteStat(baseInstant + 100L, 1000000L, 300L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("replacecommit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 200L, standardCount, 2000L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("replacecommit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 300L, standardCount, 3000L)))), 99L}));
        arguments.add(Arguments.of((Object[])new Object[]{Arrays.asList(Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant, standardCount, 1000L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("commit", Long.toString(baseInstant + 100L)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 100L, standardCount, 50L))), Pair.of((Object)TestAverageRecordSizeEstimator.generateCompletedInstant("deltacommit", Long.toString(baseInstant + 200L)), Collections.singletonList(TestAverageRecordSizeEstimator.generateBaseWriteStat(baseInstant + 200L, 0L, 1000L)))), 49L}));
        return arguments.stream();
    }

    private static HoodieInstant generateCompletedInstant(String action, String instant) {
        return new HoodieInstant(HoodieInstant.State.COMPLETED, action, instant, HoodieTestUtils.INSTANT_COMPARATOR.requestedTimeOrderedComparator());
    }

    private static HWriteStat generateBaseWriteStat(long instant, long totalRecordsWritten, long perRecordSize) {
        return new HWriteStat(TestAverageRecordSizeEstimator.getBaseFileName(String.valueOf(instant)), totalRecordsWritten, perRecordSize);
    }

    private static HWriteStat generateLogWriteStat(long instant, long totalRecordsWritten, long perRecordSize) {
        return new HWriteStat(TestAverageRecordSizeEstimator.getLogFileName(String.valueOf(instant)), totalRecordsWritten, perRecordSize);
    }

    static class HWriteStat {
        private final String path;
        private final Long totalRecordsWritten;
        private final Long perRecordSize;

        public HWriteStat(String path, Long totalRecordsWritten, Long perRecordSize) {
            this.path = path;
            this.totalRecordsWritten = totalRecordsWritten;
            this.perRecordSize = perRecordSize;
        }

        public String getPath() {
            return this.path;
        }

        public Long getTotalRecordsWritten() {
            return this.totalRecordsWritten;
        }

        public Long getPerRecordSize() {
            return this.perRecordSize;
        }
    }
}

