/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.config.StorageBasedLockConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestStorageBasedLockConfig {
    TestStorageBasedLockConfig() {
    }

    @Test
    void testDefaultValues() {
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieCommonConfig.BASE_PATH.key(), "s3://hudi-bucket/table/basepath");
        StorageBasedLockConfig.Builder builder = new StorageBasedLockConfig.Builder();
        StorageBasedLockConfig config = builder.fromProperties(props).build();
        Assertions.assertEquals((long)300L, (long)config.getValiditySeconds(), (String)"Default lock validity should be 5 minutes");
        Assertions.assertEquals((long)30L, (long)config.getRenewIntervalSecs(), (String)"Default heartbeat poll time should be 30 seconds");
    }

    @Test
    void testCustomValues() {
        TypedProperties props = new TypedProperties();
        props.setProperty(StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), "120");
        props.setProperty(StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), "10");
        props.setProperty(HoodieCommonConfig.BASE_PATH.key(), "/hudi/table/basepath");
        StorageBasedLockConfig config = new StorageBasedLockConfig.Builder().fromProperties(props).build();
        Assertions.assertEquals((long)120L, (long)config.getValiditySeconds());
        Assertions.assertEquals((long)10L, (long)config.getRenewIntervalSecs());
        Assertions.assertEquals((Object)"/hudi/table/basepath", (Object)config.getHudiTableBasePath());
    }

    @Test
    void testBasePathPropertiesValidation() {
        TypedProperties props = new TypedProperties();
        props.setProperty(StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), "120");
        StorageBasedLockConfig.Builder propsBuilder = new StorageBasedLockConfig.Builder();
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> propsBuilder.fromProperties(props));
        Assertions.assertTrue((boolean)exception.getMessage().contains(HoodieCommonConfig.BASE_PATH.key()));
    }

    @Test
    void testTimeThresholds() {
        TypedProperties props = new TypedProperties();
        props.setProperty(HoodieCommonConfig.BASE_PATH.key(), "/hudi/table/basepath");
        props.setProperty(StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), "5");
        props.setProperty(StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), "3");
        StorageBasedLockConfig.Builder propsBuilder = new StorageBasedLockConfig.Builder();
        IllegalArgumentException exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> propsBuilder.fromProperties(props));
        Assertions.assertTrue((boolean)exception.getMessage().contains(StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key()));
        props.setProperty(StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), "9");
        props.setProperty(StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), "1");
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> propsBuilder.fromProperties(props));
        Assertions.assertTrue((boolean)exception.getMessage().contains(StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key()));
        props.setProperty(StorageBasedLockConfig.VALIDITY_TIMEOUT_SECONDS.key(), "10");
        props.setProperty(StorageBasedLockConfig.RENEW_INTERVAL_SECS.key(), "0");
        exception = (IllegalArgumentException)Assertions.assertThrows(IllegalArgumentException.class, () -> propsBuilder.fromProperties(props));
        Assertions.assertTrue((boolean)exception.getMessage().contains(StorageBasedLockConfig.RENEW_INTERVAL_SECS.key()));
    }
}

