/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.config;

import java.util.Map;
import java.util.Properties;
import org.apache.hudi.config.HoodieClusteringConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestHoodieWriteConfigFileStitching {
    @Test
    public void testFileStitchingBinaryCopySchemaEvolutionConfig() {
        HoodieWriteConfig config1 = HoodieWriteConfig.newBuilder().withPath("/test/path").build();
        Assertions.assertFalse((boolean)config1.isBinaryCopySchemaEvolutionEnabled(), (String)"File stitching binary copy schema evolution should be disabled by default");
        Properties props = new Properties();
        props.setProperty(HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE.key(), "false");
        HoodieWriteConfig config2 = HoodieWriteConfig.newBuilder().withPath("/test/path").withProps((Map)props).build();
        Assertions.assertFalse((boolean)config2.isBinaryCopySchemaEvolutionEnabled(), (String)"File stitching binary copy schema evolution should be disabled when explicitly set to false");
        props.setProperty(HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE.key(), "true");
        HoodieWriteConfig config3 = HoodieWriteConfig.newBuilder().withPath("/test/path").withProps((Map)props).build();
        Assertions.assertTrue((boolean)config3.isBinaryCopySchemaEvolutionEnabled(), (String)"File stitching binary copy schema evolution should be enabled when explicitly set to true");
    }

    @Test
    public void testClusteringConfigProperty() {
        Assertions.assertEquals((Object)HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE.key(), (Object)HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE.key(), (String)"Config key should match expected value");
        Assertions.assertFalse((boolean)((Boolean)HoodieClusteringConfig.FILE_STITCHING_BINARY_COPY_SCHEMA_EVOLUTION_ENABLE.defaultValue()), (String)"Default value should be false to disable schema evolution");
    }
}

