/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.utils;

import java.io.IOException;
import java.util.Collections;
import java.util.Properties;
import org.apache.hudi.client.transaction.TestConflictResolutionStrategyUtil;
import org.apache.hudi.client.utils.TransactionUtils;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.HoodieActiveTimeline;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.exception.HoodieWriteConflictException;
import org.apache.hudi.table.HoodieTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestTransactionUtils
extends HoodieCommonTestHarness {
    TestTransactionUtils() {
    }

    @BeforeEach
    void init() throws IOException {
        this.initMetaClient();
    }

    @ParameterizedTest
    @ValueSource(booleans={false, true})
    void resolveWriteConflictIfAnyThrowsExceptionIfConflict(boolean timelineRefreshedWithinTransaction) throws Exception {
        TestConflictResolutionStrategyUtil.createCommit(HoodieTestTable.makeNewCommitTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieTestTable.makeNewCommitTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        TestConflictResolutionStrategyUtil.createCommit(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "commit", currentWriterInstant));
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant, "file-1");
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.metaClient.getBasePath().toString()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).build();
        this.metaClient.reloadActiveTimeline();
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        HoodieTableMetaClient spyMetaClient = (HoodieTableMetaClient)Mockito.spy((Object)this.metaClient);
        Mockito.when((Object)table.getMetaClient()).thenReturn((Object)spyMetaClient);
        Assertions.assertThrows(HoodieWriteConflictException.class, () -> TransactionUtils.resolveWriteConflictIfAny((HoodieTable)table, (Option)currentInstant, (Option)Option.of((Object)currentMetadata), (HoodieWriteConfig)writeConfig, (Option)lastSuccessfulInstant, (boolean)timelineRefreshedWithinTransaction, Collections.singleton(newInstantTime)));
        ((HoodieTableMetaClient)Mockito.verify((Object)spyMetaClient, (VerificationMode)Mockito.times((int)(timelineRefreshedWithinTransaction ? 0 : 1)))).reloadActiveTimeline();
    }

    @Test
    void resolveWriteConflictIfAnyNoExceptionForMetadataTable() throws Exception {
        this.metaClient = HoodieTestUtils.init((String)(this.basePath + "/.hoodie/metadata/"), (HoodieTableType)HoodieTableType.MERGE_ON_READ);
        TestConflictResolutionStrategyUtil.createCommit(HoodieTestTable.makeNewCommitTime(), this.metaClient);
        HoodieActiveTimeline timeline = this.metaClient.getActiveTimeline();
        Option lastSuccessfulInstant = timeline.getCommitsTimeline().filterCompletedInstants().lastInstant();
        String currentWriterInstant = HoodieTestTable.makeNewCommitTime();
        TestConflictResolutionStrategyUtil.createInflightCommit(currentWriterInstant, this.metaClient);
        String newInstantTime = HoodieTestTable.makeNewCommitTime();
        TestConflictResolutionStrategyUtil.createCommit(newInstantTime, this.metaClient);
        Option currentInstant = Option.of((Object)HoodieTestUtils.INSTANT_GENERATOR.createNewInstant(HoodieInstant.State.INFLIGHT, "deltacommit", currentWriterInstant));
        HoodieCommitMetadata currentMetadata = TestConflictResolutionStrategyUtil.createCommitMetadata(currentWriterInstant, "file-1");
        Properties props = new Properties();
        props.setProperty(HoodieMetadataConfig.STREAMING_WRITE_ENABLED.key(), "true");
        props.setProperty(HoodieTableConfig.TYPE.key(), HoodieTableType.MERGE_ON_READ.name());
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.metaClient.getBasePath().toString()).withWriteConcurrencyMode(WriteConcurrencyMode.NON_BLOCKING_CONCURRENCY_CONTROL).withProperties(props).build();
        this.metaClient.reloadActiveTimeline();
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        Mockito.when((Object)table.isMetadataTable()).thenReturn((Object)true);
        HoodieTableMetaClient spyMetaClient = (HoodieTableMetaClient)Mockito.spy((Object)this.metaClient);
        Mockito.when((Object)table.getMetaClient()).thenReturn((Object)spyMetaClient);
        Option actualResult = TransactionUtils.resolveWriteConflictIfAny((HoodieTable)table, (Option)currentInstant, (Option)Option.of((Object)currentMetadata), (HoodieWriteConfig)writeConfig, (Option)lastSuccessfulInstant, (boolean)false, Collections.singleton(newInstantTime));
        ((HoodieTableMetaClient)Mockito.verify((Object)spyMetaClient, (VerificationMode)Mockito.times((int)0))).reloadActiveTimeline();
    }
}

