/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock.audit;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.hudi.client.transaction.lock.StorageLockClient;
import org.apache.hudi.client.transaction.lock.audit.AuditOperationState;
import org.apache.hudi.client.transaction.lock.audit.StorageLockProviderAuditService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentCaptor;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestStorageLockProviderAuditService {
    private static final String BASE_PATH = "s3://bucket/table";
    private static final String OWNER_ID = "writer-12345678-9abc-def0-1234-567890abcdef";
    private static final long TRANSACTION_START_TIME = 1234567890000L;
    private static final long LOCK_EXPIRATION = 1000000L;
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private StorageLockClient storageLockClient;
    private Supplier<Boolean> lockHeldSupplier;
    private StorageLockProviderAuditService auditService;

    @BeforeEach
    void setUp() {
        this.storageLockClient = (StorageLockClient)Mockito.mock(StorageLockClient.class);
        this.lockHeldSupplier = (Supplier)Mockito.mock(Supplier.class);
        Mockito.when((Object)this.lockHeldSupplier.get()).thenReturn((Object)true);
        this.auditService = new StorageLockProviderAuditService(BASE_PATH, OWNER_ID, 1234567890000L, this.storageLockClient, timestamp -> 1000000L, this.lockHeldSupplier);
    }

    private void validateAuditRecord(Map<String, Object> auditRecord, AuditOperationState expectedState, long expectedTimestamp, boolean expectedLockHeld) {
        Assertions.assertNotNull(auditRecord, (String)"Audit record should not be null");
        Assertions.assertEquals((int)6, (int)auditRecord.size(), (String)"Audit record should contain exactly 6 fields");
        Assertions.assertNotNull((Object)auditRecord.get("ownerId"), (String)"ownerId should be present");
        Assertions.assertNotNull((Object)auditRecord.get("transactionStartTime"), (String)"transactionStartTime should be present");
        Assertions.assertNotNull((Object)auditRecord.get("timestamp"), (String)"timestamp should be present");
        Assertions.assertNotNull((Object)auditRecord.get("state"), (String)"state should be present");
        Assertions.assertNotNull((Object)auditRecord.get("lockExpiration"), (String)"lockExpiration should be present");
        Assertions.assertNotNull((Object)auditRecord.get("lockHeld"), (String)"lockHeld should be present");
        Assertions.assertEquals((Object)OWNER_ID, (Object)auditRecord.get("ownerId"));
        Assertions.assertEquals((long)1234567890000L, (long)((Number)auditRecord.get("transactionStartTime")).longValue());
        Assertions.assertEquals((long)expectedTimestamp, (long)((Number)auditRecord.get("timestamp")).longValue());
        Assertions.assertEquals((Object)expectedState.name(), (Object)auditRecord.get("state"));
        Assertions.assertEquals((long)1000000L, (long)((Number)auditRecord.get("lockExpiration")).longValue());
        Assertions.assertEquals((Object)expectedLockHeld, (Object)auditRecord.get("lockHeld"));
    }

    private void validateFilePath(String actualPath, String ownerId, long transactionStartTime) {
        String expectedPath = String.format("%s%s.hoodie%s.locks%saudit%s%d_%s.jsonl", BASE_PATH, "/", "/", "/", "/", transactionStartTime, ownerId);
        Assertions.assertEquals((Object)expectedPath, (Object)actualPath);
    }

    @Test
    void testCompleteAuditLifecycle() throws Exception {
        Mockito.when((Object)this.storageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        long startTime = System.currentTimeMillis();
        long renewTime = startTime + 1000L;
        long endTime = startTime + 2000L;
        Mockito.when((Object)this.lockHeldSupplier.get()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        this.auditService.recordOperation(AuditOperationState.START, startTime);
        this.auditService.recordOperation(AuditOperationState.RENEW, renewTime);
        this.auditService.recordOperation(AuditOperationState.END, endTime);
        ArgumentCaptor pathCaptor = ArgumentCaptor.forClass(String.class);
        ArgumentCaptor contentCaptor = ArgumentCaptor.forClass(String.class);
        ((StorageLockClient)Mockito.verify((Object)this.storageLockClient, (VerificationMode)Mockito.times((int)3))).writeObject((String)pathCaptor.capture(), (String)contentCaptor.capture());
        this.validateFilePath((String)pathCaptor.getValue(), OWNER_ID, 1234567890000L);
        String finalContent = (String)contentCaptor.getValue();
        String[] lines = finalContent.trim().split("\n");
        Assertions.assertEquals((int)3, (int)lines.length, (String)"Should have three JSON lines");
        Map startRecord = (Map)OBJECT_MAPPER.readValue(lines[0], Map.class);
        Map renewRecord = (Map)OBJECT_MAPPER.readValue(lines[1], Map.class);
        Map endRecord = (Map)OBJECT_MAPPER.readValue(lines[2], Map.class);
        this.validateAuditRecord(startRecord, AuditOperationState.START, startTime, true);
        this.validateAuditRecord(renewRecord, AuditOperationState.RENEW, renewTime, true);
        this.validateAuditRecord(endRecord, AuditOperationState.END, endTime, false);
    }

    static Stream<Arguments> ownerIdTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{"12345678-9abc-def0-1234-567890abcdef", "Full UUID format"}), Arguments.of((Object[])new Object[]{"abc123", "Short owner ID"}), Arguments.of((Object[])new Object[]{"regular-owner-id-without-uuid", "Regular owner ID"}), Arguments.of((Object[])new Object[]{OWNER_ID, "Writer with UUID"}));
    }

    @ParameterizedTest(name="{1}: {0}")
    @MethodSource(value={"ownerIdTestCases"})
    void testFileNameWithDifferentOwnerIds(String ownerId, String description) throws Exception {
        long txnStartTime = System.currentTimeMillis();
        StorageLockProviderAuditService service = new StorageLockProviderAuditService(BASE_PATH, ownerId, txnStartTime, this.storageLockClient, timestamp -> 1000000L, this.lockHeldSupplier);
        Mockito.when((Object)this.storageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        service.recordOperation(AuditOperationState.START, System.currentTimeMillis());
        ArgumentCaptor pathCaptor = ArgumentCaptor.forClass(String.class);
        ((StorageLockClient)Mockito.verify((Object)this.storageLockClient, (VerificationMode)Mockito.times((int)1))).writeObject((String)pathCaptor.capture(), ArgumentMatchers.anyString());
        this.validateFilePath((String)pathCaptor.getValue(), ownerId, txnStartTime);
    }

    static Stream<Arguments> writeFailureTestCases() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, "Write returns false"}), Arguments.of((Object[])new Object[]{new RuntimeException("Storage error"), "Write throws exception"}));
    }

    @ParameterizedTest(name="{1}")
    @MethodSource(value={"writeFailureTestCases"})
    void testWriteFailureHandling(Object failureCondition, String description) throws Exception {
        long timestamp = System.currentTimeMillis();
        if (failureCondition instanceof Boolean) {
            Mockito.when((Object)this.storageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)((Boolean)failureCondition));
        } else if (failureCondition instanceof Exception) {
            Mockito.when((Object)this.storageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenThrow(new Throwable[]{(Exception)failureCondition});
        }
        this.auditService.recordOperation(AuditOperationState.START, timestamp);
        ((StorageLockClient)Mockito.verify((Object)this.storageLockClient, (VerificationMode)Mockito.times((int)1))).writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    void testDynamicFunctionValues() throws Exception {
        long timestamp = System.currentTimeMillis();
        Mockito.when((Object)this.storageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        StorageLockProviderAuditService dynamicService = new StorageLockProviderAuditService(BASE_PATH, OWNER_ID, 1234567890000L, this.storageLockClient, ts -> ts + 1000L, this.lockHeldSupplier);
        Mockito.when((Object)this.lockHeldSupplier.get()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        dynamicService.recordOperation(AuditOperationState.START, timestamp);
        dynamicService.recordOperation(AuditOperationState.END, timestamp + 1000L);
        ArgumentCaptor contentCaptor = ArgumentCaptor.forClass(String.class);
        ((StorageLockClient)Mockito.verify((Object)this.storageLockClient, (VerificationMode)Mockito.times((int)2))).writeObject(ArgumentMatchers.anyString(), (String)contentCaptor.capture());
        String[] firstLines = ((String)contentCaptor.getAllValues().get(0)).trim().split("\n");
        Map firstRecord = (Map)OBJECT_MAPPER.readValue(firstLines[0], Map.class);
        String[] secondLines = ((String)contentCaptor.getAllValues().get(1)).trim().split("\n");
        Map secondRecord = (Map)OBJECT_MAPPER.readValue(secondLines[1], Map.class);
        Assertions.assertTrue((boolean)((Boolean)firstRecord.get("lockHeld")));
        Assertions.assertEquals((long)(timestamp + 1000L), (long)((Number)firstRecord.get("lockExpiration")).longValue());
        Assertions.assertFalse((boolean)((Boolean)secondRecord.get("lockHeld")));
        Assertions.assertEquals((long)(timestamp + 1000L + 1000L), (long)((Number)secondRecord.get("lockExpiration")).longValue());
    }

    @Test
    void testFilePathGeneration() throws Exception {
        Mockito.when((Object)this.storageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.auditService.recordOperation(AuditOperationState.START, System.currentTimeMillis());
        String expectedPath = String.format("%s/.hoodie/.locks/audit/%d_%s.jsonl", BASE_PATH, 1234567890000L, OWNER_ID);
        ((StorageLockClient)Mockito.verify((Object)this.storageLockClient)).writeObject((String)ArgumentMatchers.eq((Object)expectedPath), ArgumentMatchers.anyString());
    }

    @Test
    void testCloseMethodWithBufferedData() throws Exception {
        Mockito.when((Object)this.storageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        this.auditService.recordOperation(AuditOperationState.START, System.currentTimeMillis());
        this.auditService.close();
        ((StorageLockClient)Mockito.verify((Object)this.storageLockClient, (VerificationMode)Mockito.times((int)1))).writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString());
    }

    @Test
    void testConcurrentOperations() throws Exception {
        Mockito.when((Object)this.storageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.lockHeldSupplier.get()).thenReturn((Object)true, (Object[])new Boolean[]{false});
        ExecutorService executor = Executors.newFixedThreadPool(2);
        CountDownLatch startLatch = new CountDownLatch(1);
        CountDownLatch completionLatch = new CountDownLatch(2);
        long baseTime = System.currentTimeMillis();
        executor.submit(() -> {
            try {
                startLatch.await();
                this.auditService.recordOperation(AuditOperationState.RENEW, baseTime + 1000L);
            }
            catch (Exception exception) {
            }
            finally {
                completionLatch.countDown();
            }
        });
        executor.submit(() -> {
            try {
                startLatch.await();
                this.auditService.recordOperation(AuditOperationState.END, baseTime + 1001L);
            }
            catch (Exception exception) {
            }
            finally {
                completionLatch.countDown();
            }
        });
        startLatch.countDown();
        Assertions.assertTrue((boolean)completionLatch.await(5L, TimeUnit.SECONDS));
        ArgumentCaptor contentCaptor = ArgumentCaptor.forClass(String.class);
        ((StorageLockClient)Mockito.verify((Object)this.storageLockClient, (VerificationMode)Mockito.times((int)2))).writeObject(ArgumentMatchers.anyString(), (String)contentCaptor.capture());
        String finalContent = (String)contentCaptor.getValue();
        String[] lines = finalContent.trim().split("\\n");
        Assertions.assertEquals((int)2, (int)lines.length);
        Map record1 = (Map)OBJECT_MAPPER.readValue(lines[0], Map.class);
        Map record2 = (Map)OBJECT_MAPPER.readValue(lines[1], Map.class);
        String state1 = (String)record1.get("state");
        String state2 = (String)record2.get("state");
        Assertions.assertTrue((state1.equals("RENEW") && state2.equals("END") || state1.equals("END") && state2.equals("RENEW") ? 1 : 0) != 0);
        executor.shutdown();
        Assertions.assertTrue((boolean)executor.awaitTermination(1L, TimeUnit.SECONDS));
    }
}

