/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction.lock.audit;

import org.apache.hudi.client.transaction.lock.StorageLockClient;
import org.apache.hudi.client.transaction.lock.audit.AuditServiceFactory;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class TestAuditServiceFactory {
    private StorageLockClient mockStorageLockClient;
    private final String ownerId = "test-owner";
    private final String basePath = "s3://bucket/path/to/table";

    @BeforeEach
    void setUp() {
        this.mockStorageLockClient = (StorageLockClient)Mockito.mock(StorageLockClient.class);
    }

    @Test
    void testCreateAuditServiceWhenConfigNotFound() {
        String expectedPath = "s3://bucket/path/to/table/.hoodie/.locks/audit_enabled.json";
        Mockito.when((Object)this.mockStorageLockClient.readObject((String)ArgumentMatchers.eq((Object)expectedPath), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.empty());
        Option result = AuditServiceFactory.createLockProviderAuditService((String)"test-owner", (String)"s3://bucket/path/to/table", (StorageLockClient)this.mockStorageLockClient, (long)System.currentTimeMillis(), timestamp -> timestamp + 10000L, () -> true);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((StorageLockClient)Mockito.verify((Object)this.mockStorageLockClient)).readObject(expectedPath, true);
    }

    @Test
    void testCreateAuditServiceWhenDisabledInConfig() {
        String expectedPath = "s3://bucket/path/to/table/.hoodie/.locks/audit_enabled.json";
        String configJson = "{\"STORAGE_LOCK_AUDIT_SERVICE_ENABLED\": false}";
        Mockito.when((Object)this.mockStorageLockClient.readObject((String)ArgumentMatchers.eq((Object)expectedPath), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.of((Object)configJson));
        Option result = AuditServiceFactory.createLockProviderAuditService((String)"test-owner", (String)"s3://bucket/path/to/table", (StorageLockClient)this.mockStorageLockClient, (long)System.currentTimeMillis(), timestamp -> timestamp + 10000L, () -> true);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((StorageLockClient)Mockito.verify((Object)this.mockStorageLockClient)).readObject(expectedPath, true);
    }

    @Test
    void testCreateAuditServiceWhenEnabledInConfig() {
        String expectedPath = "s3://bucket/path/to/table/.hoodie/.locks/audit_enabled.json";
        String configJson = "{\"STORAGE_LOCK_AUDIT_SERVICE_ENABLED\": true}";
        Mockito.when((Object)this.mockStorageLockClient.readObject((String)ArgumentMatchers.eq((Object)expectedPath), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.of((Object)configJson));
        Mockito.when((Object)this.mockStorageLockClient.writeObject(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        Option result = AuditServiceFactory.createLockProviderAuditService((String)"test-owner", (String)"s3://bucket/path/to/table", (StorageLockClient)this.mockStorageLockClient, (long)System.currentTimeMillis(), timestamp -> timestamp + 10000L, () -> true);
        Assertions.assertTrue((boolean)result.isPresent());
        ((StorageLockClient)Mockito.verify((Object)this.mockStorageLockClient)).readObject(expectedPath, true);
    }

    @Test
    void testCreateAuditServiceWithMalformedJson() {
        String expectedPath = "s3://bucket/path/to/table/.hoodie/.locks/audit_enabled.json";
        String malformedJson = "{invalid json}";
        Mockito.when((Object)this.mockStorageLockClient.readObject((String)ArgumentMatchers.eq((Object)expectedPath), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.of((Object)malformedJson));
        Option result = AuditServiceFactory.createLockProviderAuditService((String)"test-owner", (String)"s3://bucket/path/to/table", (StorageLockClient)this.mockStorageLockClient, (long)System.currentTimeMillis(), timestamp -> timestamp + 10000L, () -> true);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((StorageLockClient)Mockito.verify((Object)this.mockStorageLockClient)).readObject(expectedPath, true);
    }

    @Test
    void testCreateAuditServiceWithEmptyConfig() {
        String expectedPath = "s3://bucket/path/to/table/.hoodie/.locks/audit_enabled.json";
        String configJson = "{\"some_other_field\": true}";
        Mockito.when((Object)this.mockStorageLockClient.readObject((String)ArgumentMatchers.eq((Object)expectedPath), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.of((Object)configJson));
        Option result = AuditServiceFactory.createLockProviderAuditService((String)"test-owner", (String)"s3://bucket/path/to/table", (StorageLockClient)this.mockStorageLockClient, (long)System.currentTimeMillis(), timestamp -> timestamp + 10000L, () -> true);
        Assertions.assertTrue((boolean)result.isEmpty());
        ((StorageLockClient)Mockito.verify((Object)this.mockStorageLockClient)).readObject(expectedPath, true);
    }

    @Test
    void testCreateAuditServiceUsesCheckExistsFirst() {
        String expectedPath = "s3://bucket/path/to/table/.hoodie/.locks/audit_enabled.json";
        Mockito.when((Object)this.mockStorageLockClient.readObject((String)ArgumentMatchers.eq((Object)expectedPath), ArgumentMatchers.eq((boolean)true))).thenReturn((Object)Option.empty());
        AuditServiceFactory.createLockProviderAuditService((String)"test-owner", (String)"s3://bucket/path/to/table", (StorageLockClient)this.mockStorageLockClient, (long)System.currentTimeMillis(), timestamp -> timestamp + 10000L, () -> true);
        ((StorageLockClient)Mockito.verify((Object)this.mockStorageLockClient)).readObject(expectedPath, true);
    }
}

