/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.MetricRegistry;
import org.apache.hudi.client.transaction.lock.metrics.HoodieLockMetrics;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.config.metrics.HoodieMetricsConfig;
import org.apache.hudi.metrics.Metrics;
import org.apache.hudi.metrics.MetricsReporterType;
import org.apache.hudi.storage.HoodieStorage;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public class TestHoodieLockMetrics {
    @Test
    public void testMetricsHappyPath() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/gdsafsd").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(HoodieWriteConfig.newBuilder().forTable("idk").withPath("/dsfasdf/asdf").withMetricsConfig(metricsConfig).build(), storage);
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).startLockApiTimerContext());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockAcquiredMetric());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockHeldTimerMetrics());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).startLockApiTimerContext());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockNotAcquiredMetric());
    }

    @Test
    public void testMetricsMisses() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/gdsafsd").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(HoodieWriteConfig.newBuilder().forTable("idk").withPath("/dsfasdf/asdf").withMetricsConfig(metricsConfig).build(), storage);
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockHeldTimerMetrics());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockNotAcquiredMetric());
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockAcquiredMetric());
    }

    @Test
    public void testLockReleaseSuccessMetric() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().forTable("testTable").withPath("/test/path").withMetricsConfig(metricsConfig).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(writeConfig, storage);
        Metrics metrics = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)storage);
        MetricRegistry registry = metrics.getRegistry();
        String metricName = writeConfig.getMetricReporterMetricsNamePrefix() + "." + "lock.release.success";
        Counter lockReleaseSuccessCounter = (Counter)registry.getCounters().get(metricName);
        Assertions.assertNotNull((Object)lockReleaseSuccessCounter, (String)"Lock release success counter should exist");
        long initialCount = lockReleaseSuccessCounter.getCount();
        lockMetrics.updateLockReleaseSuccessMetric();
        Assertions.assertEquals((long)(initialCount + 1L), (long)lockReleaseSuccessCounter.getCount(), (String)"Lock release success counter should increment by 1");
        lockMetrics.updateLockReleaseSuccessMetric();
        lockMetrics.updateLockReleaseSuccessMetric();
        Assertions.assertEquals((long)(initialCount + 3L), (long)lockReleaseSuccessCounter.getCount(), (String)"Lock release success counter should increment by 3 total");
    }

    @Test
    public void testLockLifecycleWithReleaseSuccess() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().forTable("testTable").withPath("/test/path").withMetricsConfig(metricsConfig).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(writeConfig, storage);
        Metrics metrics = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)storage);
        MetricRegistry registry = metrics.getRegistry();
        String acquireMetricName = writeConfig.getMetricReporterMetricsNamePrefix() + "." + "lock.acquire.success";
        String releaseMetricName = writeConfig.getMetricReporterMetricsNamePrefix() + "." + "lock.release.success";
        Counter lockAcquiredCounter = (Counter)registry.getCounters().get(acquireMetricName);
        Counter lockReleaseSuccessCounter = (Counter)registry.getCounters().get(releaseMetricName);
        long initialAcquireCount = lockAcquiredCounter.getCount();
        long initialReleaseCount = lockReleaseSuccessCounter.getCount();
        lockMetrics.startLockApiTimerContext();
        lockMetrics.updateLockAcquiredMetric();
        Assertions.assertEquals((long)(initialAcquireCount + 1L), (long)lockAcquiredCounter.getCount(), (String)"Lock acquired counter should increment by 1");
        Assertions.assertEquals((long)initialReleaseCount, (long)lockReleaseSuccessCounter.getCount(), (String)"Lock release success counter should not change yet");
        lockMetrics.updateLockReleaseSuccessMetric();
        lockMetrics.updateLockHeldTimerMetrics();
        Assertions.assertEquals((long)(initialAcquireCount + 1L), (long)lockAcquiredCounter.getCount(), (String)"Lock acquired counter should still be incremented by 1");
        Assertions.assertEquals((long)(initialReleaseCount + 1L), (long)lockReleaseSuccessCounter.getCount(), (String)"Lock release success counter should increment by 1");
        for (int i = 0; i < 5; ++i) {
            lockMetrics.startLockApiTimerContext();
            lockMetrics.updateLockAcquiredMetric();
            lockMetrics.updateLockReleaseSuccessMetric();
            lockMetrics.updateLockHeldTimerMetrics();
        }
        Assertions.assertEquals((long)(initialAcquireCount + 6L), (long)lockAcquiredCounter.getCount(), (String)"Lock acquired counter should increment by 6 total");
        Assertions.assertEquals((long)(initialReleaseCount + 6L), (long)lockReleaseSuccessCounter.getCount(), (String)"Lock release success counter should increment by 6 total");
    }

    @Test
    public void testNewErrorMetrics() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(HoodieWriteConfig.newBuilder().forTable("idk").withPath("/dsfasdf/asdf").withMetricsConfig(metricsConfig).build(), storage);
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockAcquiredByOthersErrorMetric(), (String)"updateLockAcquiredByOthersErrorMetric should not throw");
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockStateUnknownMetric(), (String)"updateLockStateUnknownMetric should not throw");
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockAcquirePreconditionFailureMetric(), (String)"updateLockAcquirePreconditionFailureMetric should not throw");
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockProviderFatalErrorMetric(), (String)"updateLockProviderFatalErrorMetric should not throw");
    }

    @Test
    public void testNewErrorMetricsWithDisabledMetrics() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(false).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(HoodieWriteConfig.newBuilder().forTable("idk").withPath("/dsfasdf/asdf").withMetricsConfig(metricsConfig).build(), storage);
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockAcquiredByOthersErrorMetric(), (String)"updateLockAcquiredByOthersErrorMetric should not throw when metrics disabled");
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockStateUnknownMetric(), (String)"updateLockStateUnknownMetric should not throw when metrics disabled");
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockAcquirePreconditionFailureMetric(), (String)"updateLockAcquirePreconditionFailureMetric should not throw when metrics disabled");
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockProviderFatalErrorMetric(), (String)"updateLockProviderFatalErrorMetric should not throw when metrics disabled");
    }

    @Test
    public void testCombinedMetricsScenario() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(HoodieWriteConfig.newBuilder().forTable("idk").withPath("/dsfasdf/asdf").withMetricsConfig(metricsConfig).build(), storage);
        Assertions.assertDoesNotThrow(() -> {
            lockMetrics.startLockApiTimerContext();
            lockMetrics.updateLockStateUnknownMetric();
            lockMetrics.updateLockNotAcquiredMetric();
            lockMetrics.startLockApiTimerContext();
            lockMetrics.updateLockAcquirePreconditionFailureMetric();
            lockMetrics.updateLockNotAcquiredMetric();
            lockMetrics.startLockApiTimerContext();
            lockMetrics.updateLockAcquiredByOthersErrorMetric();
            lockMetrics.updateLockNotAcquiredMetric();
        }, (String)"Combined metrics scenario should not throw");
    }

    @Test
    public void testLockInterruptedMetric() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().forTable("testTable").withPath("/test/path").withMetricsConfig(metricsConfig).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(writeConfig, storage);
        Metrics metrics = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)storage);
        MetricRegistry registry = metrics.getRegistry();
        String metricName = writeConfig.getMetricReporterMetricsNamePrefix() + "." + "lock.interrupted";
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockInterruptedMetric(), (String)"updateLockInterruptedMetric should not throw");
        Counter interruptedCounter = (Counter)registry.getCounters().get(metricName);
        Assertions.assertNotNull((Object)interruptedCounter, (String)"Lock interrupted counter should exist");
        long initialCount = interruptedCounter.getCount();
        lockMetrics.updateLockInterruptedMetric();
        lockMetrics.updateLockInterruptedMetric();
        lockMetrics.updateLockInterruptedMetric();
        Assertions.assertEquals((long)(initialCount + 3L), (long)interruptedCounter.getCount(), (String)"Lock interrupted counter should increment by 3");
    }

    @Test
    public void testLockExpirationDeadlineGauge() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().forTable("testTable").withPath("/test/path").withMetricsConfig(metricsConfig).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(writeConfig, storage);
        Assertions.assertDoesNotThrow(() -> lockMetrics.updateLockExpirationDeadlineMetric(5000), (String)"updateLockExpirationDeadlineMetric should not throw");
        Assertions.assertDoesNotThrow(() -> {
            lockMetrics.updateLockExpirationDeadlineMetric(5000);
            lockMetrics.updateLockExpirationDeadlineMetric(15000);
            lockMetrics.updateLockExpirationDeadlineMetric(500);
            lockMetrics.updateLockExpirationDeadlineMetric(-1000);
            lockMetrics.updateLockExpirationDeadlineMetric(1);
        }, (String)"Multiple updateLockExpirationDeadlineMetric calls should not throw");
        Metrics metrics = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)storage);
        MetricRegistry registry = metrics.getRegistry();
        String metricName = writeConfig.getMetricReporterMetricsNamePrefix() + "." + "lock.expiration.deadline";
        Gauge deadlineGaugeRaw = (Gauge)registry.getGauges().get(metricName);
        Assertions.assertNotNull((Object)deadlineGaugeRaw, (String)"Lock expiration deadline gauge should exist");
        Assertions.assertEquals((int)1, (int)((Number)deadlineGaugeRaw.getValue()).intValue(), (String)"Final gauge value should be 1");
    }

    @Test
    public void testLockDanglingMetric() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(true).build();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().forTable("testTable").withPath("/test/path").withMetricsConfig(metricsConfig).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(writeConfig, storage);
        Metrics metrics = Metrics.getInstance((HoodieMetricsConfig)metricsConfig, (HoodieStorage)storage);
        MetricRegistry registry = metrics.getRegistry();
        String metricName = writeConfig.getMetricReporterMetricsNamePrefix() + "." + "lock.dangling";
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockDanglingMetric(), (String)"updateLockDanglingMetric should not throw");
        Counter danglingCounter = (Counter)registry.getCounters().get(metricName);
        Assertions.assertNotNull((Object)danglingCounter, (String)"Lock dangling counter should exist");
        long initialCount = danglingCounter.getCount();
        lockMetrics.updateLockDanglingMetric();
        lockMetrics.updateLockDanglingMetric();
        Assertions.assertEquals((long)(initialCount + 2L), (long)danglingCounter.getCount(), (String)"Lock dangling counter should increment by 2");
    }

    @Test
    public void testNewMetricsWithDisabledLocking() {
        HoodieStorage storage = (HoodieStorage)Mockito.mock(HoodieStorage.class);
        HoodieMetricsConfig metricsConfig = HoodieMetricsConfig.newBuilder().withPath("/test").withReporterType(MetricsReporterType.INMEMORY.name()).withLockingMetrics(false).build();
        HoodieLockMetrics lockMetrics = new HoodieLockMetrics(HoodieWriteConfig.newBuilder().forTable("testTable").withPath("/test/path").withMetricsConfig(metricsConfig).build(), storage);
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockInterruptedMetric(), (String)"updateLockInterruptedMetric should not throw when locking metrics disabled");
        Assertions.assertDoesNotThrow(() -> lockMetrics.updateLockExpirationDeadlineMetric(5000), (String)"updateLockExpirationDeadlineMetric should not throw when locking metrics disabled");
        Assertions.assertDoesNotThrow(() -> ((HoodieLockMetrics)lockMetrics).updateLockDanglingMetric(), (String)"updateLockDanglingMetric should not throw when locking metrics disabled");
    }
}

