/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.transaction;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Stream;
import org.apache.avro.Schema;
import org.apache.hudi.avro.HoodieAvroUtils;
import org.apache.hudi.avro.model.HoodieActionInstant;
import org.apache.hudi.avro.model.HoodieCleanMetadata;
import org.apache.hudi.avro.model.HoodieCleanerPlan;
import org.apache.hudi.avro.model.HoodieClusteringGroup;
import org.apache.hudi.avro.model.HoodieClusteringPlan;
import org.apache.hudi.avro.model.HoodieClusteringStrategy;
import org.apache.hudi.avro.model.HoodieRequestedReplaceMetadata;
import org.apache.hudi.avro.model.HoodieRollbackMetadata;
import org.apache.hudi.avro.model.HoodieRollbackPlan;
import org.apache.hudi.avro.model.HoodieSavepointMetadata;
import org.apache.hudi.client.transaction.ConcurrentSchemaEvolutionTableSchemaGetter;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieReplaceCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.timeline.CommitMetadataSerDe;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.versioning.clean.CleanPlanV2MigrationHandler;
import org.apache.hudi.common.testutils.FileCreateUtils;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestTable;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.CommitUtils;
import org.apache.hudi.common.util.Option;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestConcurrentSchemaEvolutionTableSchemaGetter
extends HoodieCommonTestHarness {
    public static final int REQUEST_TIME_LENGTH = 4;
    HoodieTestTable testTable;
    private static final String SCHEMA_WITHOUT_METADATA_STR = "{\n  \"namespace\": \"example.avro\",\n  \"type\": \"record\",\n  \"name\": \"User\",\n  \"fields\": [\n    {\"name\": \"timestamp\", \"type\": \"long\"},\n    {\"name\": \"_row_key\", \"type\": \"string\"},\n    {\"name\": \"rider\", \"type\": \"string\"},\n    {\"name\": \"driver\", \"type\": \"string\"}\n  ]\n}";
    private static final String SCHEMA_WITHOUT_METADATA_STR2 = "{\n  \"namespace\": \"example.avro\",\n  \"type\": \"record\",\n  \"name\": \"User\",\n  \"fields\": [\n    {\"name\": \"timestamp\", \"type\": \"long\"},\n    {\"name\": \"_row_key\", \"type\": \"string\"},\n    {\"name\": \"rider\", \"type\": \"string\"},\n    {\"name\": \"rider2\", \"type\": \"string\"},\n    {\"name\": \"driver\", \"type\": \"string\"}\n  ]\n}";
    private static final String SCHEMA_WITH_PARTITION_COLUMN_STR = "{\n  \"namespace\": \"example.avro\",\n  \"type\": \"record\",\n  \"name\": \"User\",\n  \"fields\": [\n    {\"name\": \"timestamp\", \"type\": \"long\"},\n    {\"name\": \"_row_key\", \"type\": \"string\"},\n    {\"name\": \"rider\", \"type\": \"string\"},\n    {\"name\": \"driver\", \"type\": \"string\"},\n    {\"name\":\"partitionColumn\",\"type\":[\"null\",\"string\"],\"doc\":\"\",\"default\":null}  ]\n}";
    private static Schema SCHEMA_WITHOUT_METADATA2 = new Schema.Parser().parse("{\n  \"namespace\": \"example.avro\",\n  \"type\": \"record\",\n  \"name\": \"User\",\n  \"fields\": [\n    {\"name\": \"timestamp\", \"type\": \"long\"},\n    {\"name\": \"_row_key\", \"type\": \"string\"},\n    {\"name\": \"rider\", \"type\": \"string\"},\n    {\"name\": \"rider2\", \"type\": \"string\"},\n    {\"name\": \"driver\", \"type\": \"string\"}\n  ]\n}");
    private static Schema SCHEMA_WITHOUT_METADATA = new Schema.Parser().parse("{\n  \"namespace\": \"example.avro\",\n  \"type\": \"record\",\n  \"name\": \"User\",\n  \"fields\": [\n    {\"name\": \"timestamp\", \"type\": \"long\"},\n    {\"name\": \"_row_key\", \"type\": \"string\"},\n    {\"name\": \"rider\", \"type\": \"string\"},\n    {\"name\": \"driver\", \"type\": \"string\"}\n  ]\n}");
    private static Schema SCHEMA_WITH_METADATA = HoodieAvroUtils.addMetadataFields((Schema)SCHEMA_WITHOUT_METADATA, (boolean)false);
    private static Schema SCHEMA_WITH_PARTITION_COLUMN = new Schema.Parser().parse("{\n  \"namespace\": \"example.avro\",\n  \"type\": \"record\",\n  \"name\": \"User\",\n  \"fields\": [\n    {\"name\": \"timestamp\", \"type\": \"long\"},\n    {\"name\": \"_row_key\", \"type\": \"string\"},\n    {\"name\": \"rider\", \"type\": \"string\"},\n    {\"name\": \"driver\", \"type\": \"string\"},\n    {\"name\":\"partitionColumn\",\"type\":[\"null\",\"string\"],\"doc\":\"\",\"default\":null}  ]\n}");

    @BeforeEach
    public void setUp() throws Exception {
        if (this.basePath == null) {
            this.initPath();
        }
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.cleanMetaClient();
    }

    private static Stream<Arguments> testGetTableSchemaFromLatestCommitMetadataTestDimension() {
        return Stream.of(Arguments.of((Object[])new Object[]{true, HoodieTableType.COPY_ON_WRITE, "commitOrDeltaCommit"}), Arguments.of((Object[])new Object[]{true, HoodieTableType.COPY_ON_WRITE, "replacementCommit"}), Arguments.of((Object[])new Object[]{true, HoodieTableType.MERGE_ON_READ, "commitOrDeltaCommit"}), Arguments.of((Object[])new Object[]{true, HoodieTableType.MERGE_ON_READ, "replacementCommit"}), Arguments.of((Object[])new Object[]{false, HoodieTableType.COPY_ON_WRITE, "commitOrDeltaCommit"}), Arguments.of((Object[])new Object[]{false, HoodieTableType.COPY_ON_WRITE, "replacementCommit"}), Arguments.of((Object[])new Object[]{false, HoodieTableType.MERGE_ON_READ, "commitOrDeltaCommit"}), Arguments.of((Object[])new Object[]{false, HoodieTableType.MERGE_ON_READ, "replacementCommit"}));
    }

    @ParameterizedTest
    @MethodSource(value={"testGetTableSchemaFromLatestCommitMetadataTestDimension"})
    void testGetTableSchemaFromLatestCommitMetadata(boolean enableMetadata, HoodieTableType tableType, String type) throws Exception {
        this.initMetaClient(enableMetadata, tableType);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        String requestTime1 = "0010";
        if (type.equals("commitOrDeltaCommit")) {
            this.addCommitOrDeltaCommitWithSchema(tableType, requestTime1, SCHEMA_WITH_METADATA.toString());
        } else if (type.equals("replacementCommit")) {
            HoodieClusteringGroup group = new HoodieClusteringGroup();
            HoodieClusteringPlan plan = new HoodieClusteringPlan(Collections.singletonList(group), HoodieClusteringStrategy.newBuilder().build(), Collections.emptyMap(), Integer.valueOf(1), Boolean.valueOf(false), null);
            HoodieRequestedReplaceMetadata requestedMetadata = new HoodieRequestedReplaceMetadata(WriteOperationType.UNKNOWN.name(), plan, Collections.emptyMap(), Integer.valueOf(1));
            this.testTable.addReplaceCommit(requestTime1, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)requestTime1)), Option.of((Object)requestedMetadata), Option.empty(), (HoodieReplaceCommitMetadata)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)SCHEMA_WITH_METADATA.toString(), (String)"replacecommit"));
        }
        this.metaClient.reloadActiveTimeline();
        ConcurrentSchemaEvolutionTableSchemaGetter resolver = new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaIfPresent(false, Option.empty());
        Assertions.assertTrue((boolean)schemaOption.isPresent());
        Assertions.assertEquals((Object)SCHEMA_WITHOUT_METADATA, (Object)schemaOption.get());
    }

    @Test
    void testGetTableSchemaFromLatestCommitMetadata() throws Exception {
        HoodieTableType tableType = HoodieTableType.MERGE_ON_READ;
        this.initMetaClient(false, HoodieTableType.MERGE_ON_READ);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        String requestTime1 = "0010";
        String requestTime2 = "0020";
        String commitTime1 = "0040";
        String commitTime2 = "0030";
        FileCreateUtils.createRequestedDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)requestTime1);
        FileCreateUtils.createInflightDeltaCommit((HoodieTableMetaClient)this.metaClient, (String)requestTime1);
        this.testTable.addDeltaCommit(requestTime2, Option.of((Object)commitTime2), CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)SCHEMA_WITHOUT_METADATA2.toString(), (String)"deltacommit"));
        FileCreateUtils.createDeltaCommit((HoodieTableMetaClient)this.metaClient, (CommitMetadataSerDe)this.metaClient.getCommitMetadataSerDe(), (String)commitTime1, (Option)Option.of((Object)commitTime1), (HoodieCommitMetadata)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)SCHEMA_WITH_METADATA.toString(), (String)"deltacommit"));
        this.metaClient.reloadActiveTimeline();
        ConcurrentSchemaEvolutionTableSchemaGetter resolver = new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaIfPresent(false, Option.empty());
        Assertions.assertTrue((boolean)schemaOption.isPresent());
        Assertions.assertEquals((Object)SCHEMA_WITHOUT_METADATA, (Object)schemaOption.get());
    }

    private void addCommitOrDeltaCommitWithSchema(HoodieTableType tableType, String requestTime1, String schemaStr) throws Exception {
        if (tableType == HoodieTableType.COPY_ON_WRITE) {
            this.testTable.addCommit(requestTime1, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)requestTime1)), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)schemaStr, (String)"commit")));
        } else {
            this.testTable.addDeltaCommit(requestTime1, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)requestTime1)), CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)schemaStr, (String)"deltacommit"));
        }
    }

    private static Stream<Arguments> commonTableConfigTestDimension() {
        return Stream.of(Arguments.of((Object[])new Object[]{HoodieTableType.COPY_ON_WRITE}), Arguments.of((Object[])new Object[]{HoodieTableType.MERGE_ON_READ}));
    }

    @ParameterizedTest
    @MethodSource(value={"commonTableConfigTestDimension"})
    void testGetTableAvroSchemaInternalNoSchemaFoundEmptyTimeline(HoodieTableType tableType) throws IOException {
        this.initMetaClient(false, tableType);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        this.metaClient.reloadActiveTimeline();
        ConcurrentSchemaEvolutionTableSchemaGetter resolver = new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaIfPresent(true, Option.empty());
        Assertions.assertFalse((boolean)schemaOption.isPresent());
    }

    @ParameterizedTest
    @MethodSource(value={"commonTableConfigTestDimension"})
    void testGetTableAvroSchemaInternalNoSchemaFoundDisqualifiedInstant(HoodieTableType tableType) throws Exception {
        this.initMetaClient(false, tableType);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        int startCommitTime = 10;
        this.createExhaustiveDisqualifiedInstants(startCommitTime, tableType);
        this.metaClient.reloadActiveTimeline();
        ConcurrentSchemaEvolutionTableSchemaGetter resolver = new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaIfPresent(true, Option.empty());
        Assertions.assertTrue((boolean)schemaOption.isEmpty());
    }

    private int createExhaustiveDisqualifiedInstants(int startCommitTime, HoodieTableType tableType) throws Exception {
        if (tableType.equals((Object)HoodieTableType.MERGE_ON_READ)) {
            String requestTime = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime), (int)4);
            this.testTable.addCompaction(requestTime, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)requestTime)), CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.COMPACT, (String)SCHEMA_WITH_METADATA.toString(), (String)"compaction"));
        }
        HoodieCleanerPlan cleanerPlan = new HoodieCleanerPlan(new HoodieActionInstant("", "", ""), "", "", new HashMap(), CleanPlanV2MigrationHandler.VERSION, new HashMap(), new ArrayList(), Collections.emptyMap());
        HoodieCleanMetadata cleanMeta = new HoodieCleanMetadata("", Long.valueOf(0L), Integer.valueOf(0), "20", "", Collections.emptyMap(), Integer.valueOf(this.metaClient.getTableConfig().getTableVersion().versionCode()), Collections.emptyMap(), Collections.singletonMap("schema", SCHEMA_WITH_METADATA.toString()));
        String cleanTimestamp = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime += 10), (int)4);
        this.testTable.addClean(cleanTimestamp, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)cleanTimestamp)), cleanerPlan, cleanMeta);
        HoodieClusteringGroup group = new HoodieClusteringGroup();
        HoodieClusteringPlan plan = new HoodieClusteringPlan(Collections.singletonList(group), HoodieClusteringStrategy.newBuilder().build(), Collections.emptyMap(), Integer.valueOf(1), Boolean.valueOf(false), null);
        HoodieRequestedReplaceMetadata requestedMetadata = new HoodieRequestedReplaceMetadata(WriteOperationType.CLUSTER.name(), plan, Collections.emptyMap(), Integer.valueOf(1));
        String replaceInstantTime = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime += 10), (int)4);
        this.testTable.addReplaceCommit(replaceInstantTime, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)replaceInstantTime)), Option.of((Object)requestedMetadata), Option.empty(), (HoodieReplaceCommitMetadata)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)SCHEMA_WITH_METADATA.toString(), (String)"clustering"));
        this.testTable.addInflightCommit(TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime += 10), (int)4));
        this.testTable.addInflightDeltaCommit(TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime += 10), (int)4));
        String commitTimestamp = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime += 10), (int)4);
        this.testTable.addCommit(commitTimestamp, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)commitTimestamp)), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)"", (String)"commit")));
        String deltaCommitTimestamp = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime += 10), (int)4);
        this.testTable.addDeltaCommit(deltaCommitTimestamp, Option.of((Object)deltaCommitTimestamp), CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)"", (String)"deltacommit"));
        startCommitTime += 10;
        HoodieSavepointMetadata savepointMetadata = new HoodieSavepointMetadata();
        savepointMetadata.setSavepointedAt(12345L);
        savepointMetadata.setSavepointedBy("12345");
        savepointMetadata.setComments("12345");
        savepointMetadata.setPartitionMetadata(Collections.emptyMap());
        String savepointTimestamp = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime), (int)4);
        this.testTable.addSavepointCommit(savepointTimestamp, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)savepointTimestamp)), savepointMetadata);
        this.testTable.addInflightRollback(TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime += 10), (int)4));
        this.testTable.addRollback(TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime), (int)4), new HoodieRollbackMetadata(), new HoodieRollbackPlan());
        return startCommitTime;
    }

    private static Stream<Arguments> schemaTestParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{SCHEMA_WITH_METADATA, false, SCHEMA_WITHOUT_METADATA}), Arguments.of((Object[])new Object[]{SCHEMA_WITHOUT_METADATA, true, SCHEMA_WITH_METADATA}));
    }

    @ParameterizedTest
    @MethodSource(value={"schemaTestParams"})
    void testGetTableAvroSchema(Schema inputSchema, boolean includeMetadataFields, Schema expectedSchema) throws Exception {
        this.metaClient = HoodieTestUtils.getMetaClientBuilder((HoodieTableType)HoodieTableType.COPY_ON_WRITE, (Properties)new Properties(), (String)"").setTableCreateSchema(SCHEMA_WITH_METADATA.toString()).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        this.testTable.addCommit("0010", Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)"0010")), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)inputSchema.toString(), (String)"commit")));
        Assertions.assertEquals((Object)expectedSchema, (Object)new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient).getTableAvroSchemaIfPresent(includeMetadataFields, Option.empty()).get());
        HoodieInstant instant = this.metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, "commit", "0010", "0011");
        Assertions.assertEquals((Object)expectedSchema, (Object)new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient).getTableAvroSchemaIfPresent(includeMetadataFields, Option.of((Object)instant)).get());
    }

    private static Stream<Arguments> partitionColumnSchemaTestParams() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, SCHEMA_WITHOUT_METADATA}), Arguments.of((Object[])new Object[]{true, SCHEMA_WITH_PARTITION_COLUMN}));
    }

    @ParameterizedTest
    @MethodSource(value={"partitionColumnSchemaTestParams"})
    void testGetTableAvroSchemaAppendPartitionColumn(boolean shouldIncludePartitionColumns, Schema expectedSchema) throws Exception {
        this.metaClient = HoodieTestUtils.getMetaClientBuilder((HoodieTableType)HoodieTableType.COPY_ON_WRITE, (Properties)new Properties(), (String)"").setPartitionFields("partitionColumn").setShouldDropPartitionColumns(Boolean.valueOf(shouldIncludePartitionColumns)).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        this.testTable.addCommit("0010", Option.of((Object)"0011"), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)SCHEMA_WITHOUT_METADATA.toString(), (String)"commit")));
        Assertions.assertEquals((Object)expectedSchema, (Object)new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient).getTableAvroSchemaIfPresent(false, Option.empty()).get());
        Assertions.assertEquals((Object)expectedSchema, (Object)new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient).getTableAvroSchemaIfPresent(false, Option.of((Object)this.metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, "commit", "0010", "0011"))).get());
    }

    private static Stream<Arguments> createSchemaTestParam() {
        return Stream.of(Arguments.of((Object[])new Object[]{false, SCHEMA_WITHOUT_METADATA}), Arguments.of((Object[])new Object[]{true, SCHEMA_WITH_METADATA}));
    }

    @ParameterizedTest
    @MethodSource(value={"createSchemaTestParam"})
    void testGetTableCreateAvroSchema(boolean includeMetadataFields, Schema expectedSchema) throws Exception {
        this.metaClient = HoodieTestUtils.getMetaClientBuilder((HoodieTableType)HoodieTableType.COPY_ON_WRITE, (Properties)new Properties(), (String)"").setTableCreateSchema(SCHEMA_WITH_METADATA.toString()).initTable(HoodieTestUtils.getDefaultStorageConf(), this.basePath);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        Assertions.assertEquals((Object)expectedSchema, (Object)new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient).getTableAvroSchemaIfPresent(includeMetadataFields, Option.empty()).get());
        Assertions.assertEquals((Object)expectedSchema, (Object)new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient).getTableAvroSchemaIfPresent(includeMetadataFields, Option.of((Object)this.metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, "commit", "0010", "0011"))).get());
    }

    @Test
    public void testGetTableAvroSchemaInternalWithPartitionFields() throws IOException {
        this.initMetaClient(false, HoodieTableType.COPY_ON_WRITE);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        CharSequence[] partitionFields = new String[]{"partition_path"};
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.PARTITION_FIELDS, String.join((CharSequence)",", partitionFields));
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.DROP_PARTITION_COLUMNS, "true");
        this.metaClient.getTableConfig().setValue(HoodieTableConfig.CREATE_SCHEMA, SCHEMA_WITH_METADATA.toString());
        this.metaClient.reloadActiveTimeline();
        ConcurrentSchemaEvolutionTableSchemaGetter resolver = new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient);
        Option schemaOption = resolver.getTableAvroSchemaIfPresent(true, Option.empty());
        Assertions.assertTrue((boolean)schemaOption.isPresent());
        Schema resultSchema = (Schema)schemaOption.get();
        Assertions.assertTrue((boolean)resultSchema.getFields().stream().anyMatch(f -> f.name().equals("partition_path")));
    }

    @ParameterizedTest
    @MethodSource(value={"commonTableConfigTestDimension"})
    void testGetTableAvroSchemaInternalWithSpecificInstant(HoodieTableType tableType) throws Exception {
        this.initMetaClient(false, tableType);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        Schema schema1 = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        Schema schema2 = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"tripUberRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}");
        int startCommitTime = 10;
        String instantTime = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime), (int)4);
        if (tableType.equals((Object)HoodieTableType.COPY_ON_WRITE)) {
            this.testTable.addCommit(instantTime, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)instantTime)), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)schema1.toString(), (String)"commit")));
        } else {
            this.testTable.addDeltaCommit(instantTime, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)instantTime)), CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)schema1.toString(), (String)"deltacommit"));
        }
        String instantTime2 = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(startCommitTime += 10), (int)4);
        if (tableType.equals((Object)HoodieTableType.COPY_ON_WRITE)) {
            this.testTable.addCommit(instantTime2, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)instantTime2)), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)schema2.toString(), (String)"commit")));
        } else {
            this.testTable.addDeltaCommit(instantTime2, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)instantTime2)), CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)schema2.toString(), (String)"deltacommit"));
        }
        startCommitTime += 10;
        this.metaClient.reloadActiveTimeline();
        ConcurrentSchemaEvolutionTableSchemaGetter resolver = new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient);
        String timestamp1 = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(10), (int)4);
        Option schema1Option = resolver.getTableAvroSchemaIfPresent(false, Option.of((Object)this.metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, "commit", timestamp1, TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)timestamp1))));
        Assertions.assertTrue((boolean)schema1Option.isPresent());
        Assertions.assertEquals((Object)schema1.toString(), (Object)((Schema)schema1Option.get()).toString());
        String timestamp2 = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(20), (int)4);
        Option schema2Option = resolver.getTableAvroSchemaIfPresent(false, Option.of((Object)this.metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, "commit", timestamp2, TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)timestamp2))));
        Assertions.assertTrue((boolean)schema2Option.isPresent());
        Assertions.assertEquals((Object)schema2.toString(), (Object)((Schema)schema2Option.get()).toString());
        int endCommitTime = this.createExhaustiveDisqualifiedInstants(startCommitTime, tableType);
        this.metaClient.reloadActiveTimeline();
        Integer i = startCommitTime + 10;
        while (i <= endCommitTime + 10) {
            String timestampI = TestConcurrentSchemaEvolutionTableSchemaGetter.padWithLeadingZeros((String)Integer.toString(i), (int)4);
            schema2Option = resolver.getTableAvroSchemaIfPresent(false, Option.of((Object)this.metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, "commit", timestampI, TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)timestampI))));
            Assertions.assertTrue((boolean)schema2Option.isPresent(), i::toString);
            Assertions.assertEquals((Object)schema2.toString(), (Object)((Schema)schema2Option.get()).toString());
            i = i + 10;
        }
    }

    @Test
    void testTableAvroSchemaFromTimelineCachingBehavior() throws Exception {
        this.initMetaClient(false, HoodieTableType.COPY_ON_WRITE);
        this.testTable = HoodieTestTable.of((HoodieTableMetaClient)this.metaClient);
        Schema schema1 = new Schema.Parser().parse("{\"type\": \"record\",\"name\": \"triprec\",\"fields\": [ {\"name\": \"timestamp\",\"type\": \"long\"},{\"name\": \"_row_key\", \"type\": \"string\"},{\"name\": \"partition_path\", \"type\": [\"null\", \"string\"], \"default\": null },{\"name\": \"trip_type\", \"type\": {\"type\": \"enum\", \"name\": \"TripType\", \"symbols\": [\"UNKNOWN\", \"UBERX\", \"BLACK\"], \"default\": \"UNKNOWN\"}},{\"name\": \"rider\", \"type\": \"string\"},{\"name\": \"driver\", \"type\": \"string\"},{\"name\": \"begin_lat\", \"type\": \"double\"},{\"name\": \"begin_lon\", \"type\": \"double\"},{\"name\": \"end_lat\", \"type\": \"double\"},{\"name\": \"end_lon\", \"type\": \"double\"},{\"name\": \"distance_in_meters\", \"type\": \"int\"},{\"name\": \"seconds_since_epoch\", \"type\": \"long\"},{\"name\": \"weight\", \"type\": \"float\"},{\"name\": \"nation\", \"type\": \"bytes\"},{\"name\":\"current_date\",\"type\": {\"type\": \"int\", \"logicalType\": \"date\"}},{\"name\":\"current_ts\",\"type\": {\"type\": \"long\"}},{\"name\":\"height\",\"type\":{\"type\":\"fixed\",\"name\":\"abc\",\"size\":5,\"logicalType\":\"decimal\",\"precision\":10,\"scale\":6}},{\"name\": \"city_to_state\", \"type\": {\"type\": \"map\", \"values\": \"string\"}},{\"name\": \"fare\",\"type\": {\"type\":\"record\", \"name\":\"fare\",\"fields\": [{\"name\": \"amount\",\"type\": \"double\"},{\"name\": \"currency\", \"type\": \"string\"}]}},{\"name\": \"tip_history\", \"default\": [], \"type\": {\"type\": \"array\", \"default\": [], \"items\": {\"type\": \"record\", \"default\": null, \"name\": \"tip_history\", \"fields\": [{\"name\": \"amount\", \"type\": \"double\"}, {\"name\": \"currency\", \"type\": \"string\"}]}}},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false} ]}");
        Schema schema2 = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"shortTripRec\",\"fields\":[{\"name\":\"timestamp\",\"type\":\"long\"},{\"name\":\"_row_key\",\"type\":\"string\"},{\"name\":\"rider\",\"type\":\"string\"},{\"name\":\"driver\",\"type\":\"string\"},{\"name\":\"fare\",\"type\":\"double\"},{\"name\": \"_hoodie_is_deleted\", \"type\": \"boolean\", \"default\": false}]}");
        String commitTime1 = "0010";
        this.testTable.addCommit(commitTime1, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)commitTime1)), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)schema1.toString(), (String)"commit")));
        String commitTime2 = "0020";
        this.testTable.addCommit(commitTime2, Option.of((Object)TestConcurrentSchemaEvolutionTableSchemaGetter.incTimestampStrByOne((String)commitTime2)), Option.of((Object)CommitUtils.buildMetadata(Collections.emptyList(), Collections.emptyMap(), (Option)Option.empty(), (WriteOperationType)WriteOperationType.UNKNOWN, (String)schema2.toString(), (String)"commit")));
        this.metaClient.reloadActiveTimeline();
        ConcurrentSchemaEvolutionTableSchemaGetter resolver = (ConcurrentSchemaEvolutionTableSchemaGetter)Mockito.spy((Object)new ConcurrentSchemaEvolutionTableSchemaGetter(this.metaClient));
        HoodieInstant instant2 = (HoodieInstant)this.metaClient.getCommitsTimeline().filterCompletedInstants().lastInstant().get();
        HoodieInstant instant1 = (HoodieInstant)this.metaClient.getCommitsTimeline().filterCompletedInstants().nthInstant(0).get();
        Option schemaOption1 = resolver.getTableAvroSchemaFromTimelineWithCache(Option.empty());
        Assertions.assertTrue((boolean)schemaOption1.isPresent());
        Assertions.assertEquals((Object)schema2, (Object)schemaOption1.get());
        ((ConcurrentSchemaEvolutionTableSchemaGetter)Mockito.verify((Object)resolver, (VerificationMode)Mockito.times((int)1))).getLastCommitMetadataWithValidSchemaFromTimeline((Stream)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        Option schemaOption2 = resolver.getTableAvroSchemaFromTimelineWithCache(Option.empty());
        Assertions.assertTrue((boolean)schemaOption2.isPresent());
        Assertions.assertEquals((Object)schema2, (Object)schemaOption2.get());
        ((ConcurrentSchemaEvolutionTableSchemaGetter)Mockito.verify((Object)resolver, (VerificationMode)Mockito.times((int)1))).getLastCommitMetadataWithValidSchemaFromTimeline((Stream)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        Option schemaOption3 = resolver.getTableAvroSchemaFromTimelineWithCache(Option.of((Object)instant2));
        Assertions.assertTrue((boolean)schemaOption3.isPresent());
        Assertions.assertEquals((Object)schema2, (Object)schemaOption3.get());
        ((ConcurrentSchemaEvolutionTableSchemaGetter)Mockito.verify((Object)resolver, (VerificationMode)Mockito.times((int)1))).getLastCommitMetadataWithValidSchemaFromTimeline((Stream)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        Option schemaOption4 = resolver.getTableAvroSchemaFromTimelineWithCache(Option.of((Object)instant1));
        Assertions.assertTrue((boolean)schemaOption4.isPresent());
        Assertions.assertEquals((Object)schema1, (Object)schemaOption4.get());
        ((ConcurrentSchemaEvolutionTableSchemaGetter)Mockito.verify((Object)resolver, (VerificationMode)Mockito.times((int)2))).getLastCommitMetadataWithValidSchemaFromTimeline((Stream)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        String nonExistentTime = "9999";
        HoodieInstant nonExistentInstant = this.metaClient.getInstantGenerator().createNewInstant(HoodieInstant.State.COMPLETED, "commit", nonExistentTime, nonExistentTime);
        Option schemaOption5 = resolver.getTableAvroSchemaFromTimelineWithCache(Option.of((Object)nonExistentInstant));
        Assertions.assertEquals((Object)schema2, (Object)schemaOption5.get());
        ((ConcurrentSchemaEvolutionTableSchemaGetter)Mockito.verify((Object)resolver, (VerificationMode)Mockito.times((int)3))).getLastCommitMetadataWithValidSchemaFromTimeline((Stream)ArgumentMatchers.any(), (Option)ArgumentMatchers.any());
        Assertions.assertEquals((long)3L, (long)resolver.getTableSchemaCache().size());
    }
}

