/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.timeline;

import java.util.Collections;
import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.hudi.client.timeline.versioning.v1.TimelineArchiverV1;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.table.timeline.versioning.v1.ActiveTimelineV1;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.InProcessTimeGenerator;
import org.apache.hudi.common.testutils.SchemaTestUtil;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieArchivalConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.storage.HoodieStorage;
import org.apache.hudi.storage.hadoop.HoodieHadoopStorage;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.HoodieWriteableTestTable;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestHoodieTimelineArchiver
extends HoodieCommonTestHarness {
    private static final Schema SCHEMA = SchemaTestUtil.getSchemaFromResource(TestHoodieTimelineArchiver.class, (String)"/exampleSchema.avsc", (boolean)true);

    TestHoodieTimelineArchiver() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.initPath();
        this.initMetaClient();
    }

    @Test
    void archiveIfRequired_instantsAreArchived() throws Exception {
        TypedProperties advanceProperties = new TypedProperties();
        advanceProperties.put((Object)"hoodie.archive.limit.instants", (Object)1L);
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.tempDir.toString()).withArchivalConfig(HoodieArchivalConfig.newBuilder().archiveCommitsWith(2, 3).build()).withMarkersType("DIRECT").withProperties((Properties)advanceProperties).build();
        HoodieLocalEngineContext context = new HoodieLocalEngineContext(this.metaClient.getStorageConf());
        HoodieHadoopStorage hoodieStorage = new HoodieHadoopStorage(this.basePath, this.metaClient.getStorageConf());
        HoodieWriteableTestTable testTable = new HoodieWriteableTestTable(this.basePath, (HoodieStorage)hoodieStorage, this.metaClient, SCHEMA, null, null, (Option<HoodieEngineContext>)Option.of((Object)context));
        testTable.addCommit(InProcessTimeGenerator.createNewInstantTime());
        testTable.addCommit(InProcessTimeGenerator.createNewInstantTime());
        testTable.addCommit(InProcessTimeGenerator.createNewInstantTime());
        testTable.addCommit(InProcessTimeGenerator.createNewInstantTime());
        testTable.addCommit(InProcessTimeGenerator.createNewInstantTime());
        HoodieTable hoodieTable = this.setupMockHoodieTable((HoodieEngineContext)context, writeConfig);
        TimelineArchiverV1 archiver = new TimelineArchiverV1(writeConfig, hoodieTable);
        archiver.archiveIfRequired((HoodieEngineContext)context);
        Assertions.assertEquals((int)4, (int)this.metaClient.reloadActiveTimeline().countInstants());
        hoodieTable = this.setupMockHoodieTable((HoodieEngineContext)context, writeConfig);
        archiver = new TimelineArchiverV1(writeConfig, hoodieTable);
        archiver.archiveIfRequired((HoodieEngineContext)context);
        Assertions.assertEquals((int)3, (int)this.metaClient.reloadActiveTimeline().countInstants());
        hoodieTable = this.setupMockHoodieTable((HoodieEngineContext)context, writeConfig);
        archiver = new TimelineArchiverV1(writeConfig, hoodieTable);
        archiver.archiveIfRequired((HoodieEngineContext)context);
        Assertions.assertEquals((int)3, (int)this.metaClient.reloadActiveTimeline().countInstants());
        ActiveTimelineV1 rawActiveTimeline = new ActiveTimelineV1(this.metaClient, false);
        Assertions.assertEquals((int)9, (int)rawActiveTimeline.countInstants());
    }

    private HoodieTable setupMockHoodieTable(HoodieEngineContext context, HoodieWriteConfig writeConfig) {
        HoodieTable hoodieTable = (HoodieTable)Mockito.mock(HoodieTable.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        Mockito.when((Object)hoodieTable.getContext()).thenReturn((Object)context);
        Mockito.when((Object)hoodieTable.getConfig()).thenReturn((Object)writeConfig);
        Mockito.when((Object)hoodieTable.getMetaClient()).thenReturn((Object)this.metaClient);
        Mockito.when((Object)hoodieTable.getActiveTimeline()).thenReturn((Object)this.metaClient.getActiveTimeline());
        Mockito.when((Object)hoodieTable.getCompletedCommitsTimeline()).thenReturn((Object)this.metaClient.getCommitsTimeline().filterCompletedInstants());
        Mockito.when((Object)hoodieTable.getCompletedCleanTimeline()).thenReturn((Object)this.metaClient.getActiveTimeline().getCleanerTimeline().filterCompletedInstants());
        Mockito.when((Object)hoodieTable.getCompletedSavepointTimeline()).thenReturn((Object)this.metaClient.getActiveTimeline().getSavePointTimeline().filterCompletedInstants());
        Mockito.when((Object)hoodieTable.getSavepointTimestamps()).thenReturn(Collections.emptySet());
        return hoodieTable;
    }
}

