/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client;

import java.io.IOException;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hudi.callback.common.WriteStatusValidator;
import org.apache.hudi.client.BaseHoodieTableServiceClient;
import org.apache.hudi.client.BaseHoodieWriteClient;
import org.apache.hudi.client.embedded.EmbeddedTimelineService;
import org.apache.hudi.client.transaction.TransactionManager;
import org.apache.hudi.client.transaction.lock.InProcessLockProvider;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.model.HoodieTableType;
import org.apache.hudi.common.model.HoodieTimelineTimeZone;
import org.apache.hudi.common.model.WriteConcurrencyMode;
import org.apache.hudi.common.model.WriteOperationType;
import org.apache.hudi.common.table.HoodieTableConfig;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.HoodieTableVersion;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieInstantTimeGenerator;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.table.timeline.TimeGenerator;
import org.apache.hudi.common.table.timeline.versioning.v2.InstantComparatorV2;
import org.apache.hudi.common.table.view.FileSystemViewStorageConfig;
import org.apache.hudi.common.table.view.FileSystemViewStorageType;
import org.apache.hudi.common.testutils.HoodieCommonTestHarness;
import org.apache.hudi.common.testutils.HoodieTestUtils;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.config.HoodieLockConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.index.HoodieIndex;
import org.apache.hudi.index.simple.HoodieSimpleIndex;
import org.apache.hudi.keygen.ComplexAvroKeyGenerator;
import org.apache.hudi.keygen.constant.KeyGeneratorOptions;
import org.apache.hudi.storage.StorageConfiguration;
import org.apache.hudi.table.BulkInsertPartitioner;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.testutils.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;
import org.mockito.InOrder;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

class TestBaseHoodieWriteClient
extends HoodieCommonTestHarness {
    TestBaseHoodieWriteClient() {
    }

    @Test
    void startCommitWillRollbackFailedWritesInEagerMode() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class, (Answer)Mockito.RETURNS_DEEP_STUBS);
        BaseHoodieTableServiceClient tableServiceClient = (BaseHoodieTableServiceClient)Mockito.mock(BaseHoodieTableServiceClient.class);
        TestWriteClient writeClient = new TestWriteClient(writeConfig, (HoodieTable<String, String, String, String>)table, (Option<EmbeddedTimelineService>)Option.empty(), (BaseHoodieTableServiceClient<String, String, String>)tableServiceClient);
        HoodieTimeline inflightRestoreTimeline = (HoodieTimeline)Mockito.mock(HoodieTimeline.class);
        Mockito.when((Object)mockMetaClient.getActiveTimeline().getRestoreTimeline().filterInflightsAndRequested()).thenReturn((Object)inflightRestoreTimeline);
        Mockito.when((Object)inflightRestoreTimeline.countInstants()).thenReturn((Object)0);
        Mockito.when((Object)mockMetaClient.getActiveTimeline().filterPendingCompactionTimeline().lastInstant()).thenReturn((Object)Option.empty());
        Mockito.when((Object)mockMetaClient.getTableConfig().getTableVersion()).thenReturn((Object)HoodieTableVersion.current());
        writeClient.startCommit("commit", mockMetaClient);
        ((BaseHoodieTableServiceClient)Mockito.verify((Object)tableServiceClient)).rollbackFailedWrites(mockMetaClient);
    }

    @Test
    void rollbackDelegatesToTableServiceClient() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).build();
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        HoodieTableMetaClient mockMetaClient = (HoodieTableMetaClient)Mockito.mock(HoodieTableMetaClient.class);
        BaseHoodieTableServiceClient tableServiceClient = (BaseHoodieTableServiceClient)Mockito.mock(BaseHoodieTableServiceClient.class);
        TestWriteClient writeClient = new TestWriteClient(writeConfig, (HoodieTable<String, String, String, String>)table, (Option<EmbeddedTimelineService>)Option.empty(), (BaseHoodieTableServiceClient<String, String, String>)tableServiceClient);
        writeClient.rollbackFailedWrites(mockMetaClient);
        ((BaseHoodieTableServiceClient)Mockito.verify((Object)tableServiceClient)).rollbackFailedWrites(mockMetaClient);
    }

    private static Stream<Arguments> testWithComplexKeyGeneratorValidation() {
        ArrayList arguments = new ArrayList();
        List<Arguments> keyAndPartitionFieldOptions = Arrays.asList(Arguments.of((Object[])new Object[]{"r1", "p1"}), Arguments.of((Object[])new Object[]{"r1", "p1,p2"}), Arguments.of((Object[])new Object[]{"r1", ""}), Arguments.of((Object[])new Object[]{"r1,r2", "p1"}));
        List<Arguments> booleanOptions = Arrays.asList(Arguments.of((Object[])new Object[]{false, true}), Arguments.of((Object[])new Object[]{true, true}), Arguments.of((Object[])new Object[]{true, false}));
        List<Integer> tableVersionOptions = Arrays.asList(8, 9);
        arguments.addAll(Stream.of("org.apache.hudi.keygen.ComplexAvroKeyGenerator", "org.apache.hudi.keygen.ComplexKeyGenerator").flatMap(keyGenClass -> keyAndPartitionFieldOptions.stream().flatMap(keyAndPartitionField -> booleanOptions.stream().flatMap(booleans -> tableVersionOptions.stream().map(tableVersion -> Arguments.of((Object[])new Object[]{keyGenClass, keyAndPartitionField.get()[0], keyAndPartitionField.get()[1], booleans.get()[0], booleans.get()[1], tableVersion}))))).collect(Collectors.toList()));
        arguments.addAll(Stream.of("org.apache.hudi.keygen.SimpleAvroKeyGenerator", "org.apache.hudi.keygen.SimpleKeyGenerator", "org.apache.hudi.keygen.TimestampBasedAvroKeyGenerator", "org.apache.hudi.keygen.TimestampBasedKeyGenerator").flatMap(keyGenClass -> booleanOptions.stream().flatMap(booleans -> tableVersionOptions.stream().map(tableVersion -> Arguments.of((Object[])new Object[]{keyGenClass, "r1", "p1", booleans.get()[0], booleans.get()[1], tableVersion})))).collect(Collectors.toList()));
        arguments.addAll(Stream.of("org.apache.hudi.keygen.NonpartitionedAvroKeyGenerator", "org.apache.hudi.keygen.NonpartitionedKeyGenerator").flatMap(keyGenClass -> booleanOptions.stream().flatMap(booleans -> tableVersionOptions.stream().map(tableVersion -> Arguments.of((Object[])new Object[]{keyGenClass, "r1", "", booleans.get()[0], booleans.get()[1], tableVersion})))).collect(Collectors.toList()));
        arguments.addAll(Stream.of("org.apache.hudi.keygen.CustomAvroKeyGenerator", "org.apache.hudi.keygen.CustomKeyGenerator").flatMap(keyGenClass -> booleanOptions.stream().flatMap(booleans -> tableVersionOptions.stream().map(tableVersion -> Arguments.of((Object[])new Object[]{keyGenClass, "r1", "p1:SIMPLE", booleans.get()[0], booleans.get()[1], tableVersion})))).collect(Collectors.toList()));
        return arguments.stream();
    }

    @ParameterizedTest
    @MethodSource
    void testWithComplexKeyGeneratorValidation(String keyGeneratorClass, String recordKeyFields, String partitionPathFields, boolean setComplexKeyGeneratorValidationConfig, boolean enableComplexKeyGeneratorValidation, int tableVersion) throws IOException {
        if (this.basePath == null) {
            this.initPath();
        }
        Properties tableProperties = new Properties();
        tableProperties.put(HoodieTableConfig.KEY_GENERATOR_CLASS_NAME.key(), keyGeneratorClass);
        tableProperties.put(HoodieTableConfig.RECORDKEY_FIELDS.key(), recordKeyFields);
        tableProperties.put(HoodieTableConfig.PARTITION_FIELDS.key(), partitionPathFields);
        tableProperties.put(HoodieTableConfig.VERSION.key(), String.valueOf(tableVersion));
        Properties writeProperties = new Properties();
        writeProperties.put(HoodieWriteConfig.KEYGENERATOR_CLASS_NAME.key(), keyGeneratorClass);
        writeProperties.put(KeyGeneratorOptions.RECORDKEY_FIELD_NAME.key(), recordKeyFields);
        writeProperties.put(KeyGeneratorOptions.PARTITIONPATH_FIELD_NAME.key(), partitionPathFields);
        writeProperties.put(HoodieWriteConfig.WRITE_TABLE_VERSION.key(), String.valueOf(tableVersion));
        if (setComplexKeyGeneratorValidationConfig) {
            writeProperties.put(HoodieWriteConfig.ENABLE_COMPLEX_KEYGEN_VALIDATION.key(), (Object)enableComplexKeyGeneratorValidation);
        }
        this.metaClient = HoodieTestUtils.init((StorageConfiguration)HoodieTestUtils.getDefaultStorageConf(), (String)this.basePath, (HoodieTableType)this.getTableType(), (Properties)tableProperties);
        HoodieWriteConfig.Builder writeConfigBuilder = HoodieWriteConfig.newBuilder().withPath(this.basePath).withProperties(writeProperties);
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        BaseHoodieTableServiceClient tableServiceClient = (BaseHoodieTableServiceClient)Mockito.mock(BaseHoodieTableServiceClient.class);
        TestWriteClient writeClient = new TestWriteClient(writeConfigBuilder.build(), (HoodieTable<String, String, String, String>)table, (Option<EmbeddedTimelineService>)Option.empty(), (BaseHoodieTableServiceClient<String, String, String>)tableServiceClient);
        if (tableVersion <= 8 && enableComplexKeyGeneratorValidation && (ComplexAvroKeyGenerator.class.getCanonicalName().equals(keyGeneratorClass) || "org.apache.hudi.keygen.ComplexKeyGenerator".equals(keyGeneratorClass)) && recordKeyFields.split(",").length == 1) {
            Assertions.assertComplexKeyGeneratorValidationThrows(() -> writeClient.initTable(WriteOperationType.INSERT, Option.empty()), "ingestion");
        } else {
            writeClient.initTable(WriteOperationType.INSERT, Option.empty());
            String requestedTime = writeClient.startCommit("commit");
            HoodieTimeline writeTimeline = this.metaClient.getActiveTimeline().getWriteTimeline();
            org.junit.jupiter.api.Assertions.assertTrue((boolean)writeTimeline.lastInstant().isPresent());
            org.junit.jupiter.api.Assertions.assertEquals((Object)"commit", (Object)((HoodieInstant)writeTimeline.lastInstant().get()).getAction());
            org.junit.jupiter.api.Assertions.assertEquals((Object)requestedTime, (Object)((HoodieInstant)writeTimeline.lastInstant().get()).requestedTime());
        }
    }

    @Test
    void testStartCommit() throws IOException {
        this.initMetaClient();
        HoodieWriteConfig writeConfig = HoodieWriteConfig.newBuilder().withPath(this.basePath).withFileSystemViewConfig(FileSystemViewStorageConfig.newBuilder().withStorageType(FileSystemViewStorageType.MEMORY).build()).withWriteConcurrencyMode(WriteConcurrencyMode.OPTIMISTIC_CONCURRENCY_CONTROL).withLockConfig(HoodieLockConfig.newBuilder().withLockProvider(InProcessLockProvider.class).withLockWaitTimeInMillis(Long.valueOf(50L)).withNumRetries(2).withRetryWaitTimeInMillis(Long.valueOf(10L)).withClientNumRetries(2).withClientRetryWaitTimeInMillis(Long.valueOf(10L)).build()).build();
        HoodieInstantTimeGenerator.setCommitTimeZone((HoodieTimelineTimeZone)HoodieTimelineTimeZone.UTC);
        TransactionManager transactionManager = (TransactionManager)Mockito.mock(TransactionManager.class);
        TimeGenerator timeGenerator = (TimeGenerator)Mockito.mock(TimeGenerator.class);
        Instant now = Instant.now().truncatedTo(ChronoUnit.SECONDS).plusSeconds(1L);
        Mockito.when((Object)timeGenerator.generateTime(true)).thenReturn((Object)now.toEpochMilli());
        HoodieTable table = (HoodieTable)Mockito.mock(HoodieTable.class);
        BaseHoodieTableServiceClient tableServiceClient = (BaseHoodieTableServiceClient)Mockito.mock(BaseHoodieTableServiceClient.class);
        TestWriteClient writeClient = new TestWriteClient(writeConfig, (HoodieTable<String, String, String, String>)table, (Option<EmbeddedTimelineService>)Option.empty(), (BaseHoodieTableServiceClient<String, String, String>)tableServiceClient, transactionManager, timeGenerator);
        String instantTime = writeClient.startCommit("commit");
        HoodieTimeline writeTimeline = this.metaClient.getActiveTimeline().getWriteTimeline();
        org.junit.jupiter.api.Assertions.assertTrue((boolean)writeTimeline.lastInstant().isPresent());
        org.junit.jupiter.api.Assertions.assertEquals((Object)"commit", (Object)((HoodieInstant)writeTimeline.lastInstant().get()).getAction());
        org.junit.jupiter.api.Assertions.assertEquals((Object)instantTime, (Object)((HoodieInstant)writeTimeline.lastInstant().get()).requestedTime());
        HoodieInstant expectedInstant = new HoodieInstant(HoodieInstant.State.REQUESTED, "commit", instantTime, InstantComparatorV2.COMPLETION_TIME_BASED_COMPARATOR);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{transactionManager, timeGenerator});
        ((TransactionManager)inOrder.verify((Object)transactionManager)).beginStateChange(Option.empty(), Option.empty());
        ((TimeGenerator)inOrder.verify((Object)timeGenerator)).generateTime(true);
        ((TransactionManager)inOrder.verify((Object)transactionManager)).endStateChange(Option.of((Object)expectedInstant));
    }

    private static class TestWriteClient
    extends BaseHoodieWriteClient<String, String, String, String> {
        private final HoodieTable<String, String, String, String> table;

        public TestWriteClient(HoodieWriteConfig writeConfig, HoodieTable<String, String, String, String> table, Option<EmbeddedTimelineService> timelineService, BaseHoodieTableServiceClient<String, String, String> tableServiceClient) {
            super((HoodieEngineContext)new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf()), writeConfig, timelineService, null);
            this.table = table;
            this.tableServiceClient = tableServiceClient;
        }

        public TestWriteClient(HoodieWriteConfig writeConfig, HoodieTable<String, String, String, String> table, Option<EmbeddedTimelineService> timelineService, BaseHoodieTableServiceClient<String, String, String> tableServiceClient, TransactionManager transactionManager, TimeGenerator timeGenerator) {
            super((HoodieEngineContext)new HoodieLocalEngineContext(HoodieTestUtils.getDefaultStorageConf()), writeConfig, timelineService, null, transactionManager, timeGenerator);
            this.table = table;
            this.tableServiceClient = tableServiceClient;
        }

        protected HoodieIndex<?, ?> createIndex(HoodieWriteConfig writeConfig) {
            return new HoodieSimpleIndex(this.config, Option.empty());
        }

        public boolean commit(String instantTime, String writeStatuses, Option<Map<String, String>> extraMetadata, String commitActionType, Map<String, List<String>> partitionToReplacedFileIds, Option<BiConsumer<HoodieTableMetaClient, HoodieCommitMetadata>> extraPreCommitFunc, Option<WriteStatusValidator> writeStatusValidatorOpt) {
            return false;
        }

        protected HoodieTable<String, String, String, String> createTable(HoodieWriteConfig config) {
            FileSystemViewStorageType storageType = config.getViewStorageConfig().getStorageType();
            org.junit.jupiter.api.Assertions.assertTrue((storageType == FileSystemViewStorageType.REMOTE_FIRST || storageType == FileSystemViewStorageType.REMOTE_ONLY ? 1 : 0) != 0);
            return this.table;
        }

        protected HoodieTable<String, String, String, String> createTable(HoodieWriteConfig config, HoodieTableMetaClient metaClient) {
            FileSystemViewStorageType storageType = config.getViewStorageConfig().getStorageType();
            org.junit.jupiter.api.Assertions.assertTrue((storageType == FileSystemViewStorageType.REMOTE_FIRST || storageType == FileSystemViewStorageType.REMOTE_ONLY ? 1 : 0) != 0);
            Mockito.when((Object)this.table.getMetaClient()).thenReturn((Object)metaClient);
            return this.table;
        }

        public String filterExists(String hoodieRecords) {
            return "";
        }

        public String upsert(String records, String instantTime) {
            return "";
        }

        public String upsertPreppedRecords(String preppedRecords, String instantTime) {
            return "";
        }

        public String insert(String records, String instantTime) {
            return "";
        }

        public String insertPreppedRecords(String preppedRecords, String instantTime) {
            return "";
        }

        public String bulkInsert(String records, String instantTime) {
            return "";
        }

        public String bulkInsert(String records, String instantTime, Option<BulkInsertPartitioner> userDefinedBulkInsertPartitioner) {
            return "";
        }

        public String bulkInsertPreppedRecords(String preppedRecords, String instantTime, Option<BulkInsertPartitioner> bulkInsertPartitioner) {
            return "";
        }

        public String delete(String keys, String instantTime) {
            return "";
        }

        public String deletePrepped(String preppedRecords, String instantTime) {
            return "";
        }

        protected void updateColumnsToIndexWithColStats(HoodieTableMetaClient metaClient, List<String> columnsToIndex) {
        }
    }
}

