/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth.win;

import com.sun.jna.platform.win32.Secur32;
import com.sun.jna.platform.win32.Sspi;
import com.sun.jna.platform.win32.Win32Exception;
import com.sun.jna.ptr.IntByReference;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.win.CurrentWindowsCredentials;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class WindowsNegotiateScheme
extends AuthSchemeBase {
    private final String scheme;
    private Sspi.CredHandle clientCred;
    private Sspi.CtxtHandle sppicontext;
    private boolean continueNeeded;
    private String challenge;
    private String servicePrincipalName;

    public WindowsNegotiateScheme(String scheme, String servicePrincipalName) {
        this.scheme = scheme == null ? "negotiate" : scheme;
        this.challenge = null;
        this.continueNeeded = true;
        this.servicePrincipalName = servicePrincipalName;
    }

    public void dispose() {
        int rc;
        if (this.clientCred != null && !this.clientCred.isNull() && 0 != (rc = Secur32.INSTANCE.FreeCredentialsHandle(this.clientCred))) {
            throw new Win32Exception(rc);
        }
        if (this.sppicontext != null && !this.sppicontext.isNull() && 0 != (rc = Secur32.INSTANCE.DeleteSecurityContext(this.sppicontext))) {
            throw new Win32Exception(rc);
        }
        this.continueNeeded = true;
        this.clientCred = null;
        this.sppicontext = null;
    }

    public void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public String getSchemeName() {
        return this.scheme;
    }

    public String getParameter(String name) {
        return null;
    }

    public String getRealm() {
        return null;
    }

    public boolean isConnectionBased() {
        return true;
    }

    protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex) throws MalformedChallengeException {
        this.challenge = buffer.substringTrimmed(beginIndex, endIndex);
        if (this.challenge.isEmpty() && this.clientCred != null) {
            if (this.continueNeeded) {
                throw new RuntimeException("Unexpected token");
            }
            this.dispose();
        }
    }

    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        String response;
        if (this.clientCred == null) {
            if (!(credentials instanceof CurrentWindowsCredentials)) {
                throw new InvalidCredentialsException("Credentials cannot be used for " + this.getSchemeName() + " authentication: " + credentials.getClass().getName());
            }
            try {
                String username = CurrentWindowsCredentials.getCurrentUsername();
                Sspi.TimeStamp lifetime = new Sspi.TimeStamp();
                this.clientCred = new Sspi.CredHandle();
                int rc = Secur32.INSTANCE.AcquireCredentialsHandle(username, this.scheme, 2, null, null, null, null, this.clientCred, lifetime);
                if (0 != rc) {
                    throw new Win32Exception(rc);
                }
                response = this.getToken(null, null, this.servicePrincipalName != null ? this.servicePrincipalName : username);
            }
            catch (Throwable t) {
                this.dispose();
                throw new AuthenticationException("Authentication Failed", t);
            }
        }
        if (this.challenge == null || this.challenge.isEmpty()) {
            this.dispose();
            throw new AuthenticationException("Authentication Failed");
        }
        try {
            byte[] continueTokenBytes = Base64.decodeBase64((String)this.challenge);
            Sspi.SecBufferDesc continueTokenBuffer = new Sspi.SecBufferDesc(2, continueTokenBytes);
            response = this.getToken(this.sppicontext, continueTokenBuffer, this.servicePrincipalName != null ? this.servicePrincipalName : "localhost");
        }
        catch (Throwable t) {
            this.dispose();
            throw new AuthenticationException("Authentication Failed", t);
        }
        CharArrayBuffer buffer = new CharArrayBuffer(this.scheme.length() + 30);
        if (this.isProxy()) {
            buffer.append("Proxy-Authorization");
        } else {
            buffer.append("Authorization");
        }
        buffer.append(": ");
        buffer.append(this.scheme);
        buffer.append(" ");
        buffer.append(response);
        return new BufferedHeader(buffer);
    }

    private String getToken(Sspi.CtxtHandle continueCtx, Sspi.SecBufferDesc continueToken, String targetName) {
        IntByReference attr = new IntByReference();
        Sspi.SecBufferDesc token = new Sspi.SecBufferDesc(2, 12288);
        this.sppicontext = new Sspi.CtxtHandle();
        int rc = Secur32.INSTANCE.InitializeSecurityContext(this.clientCred, continueCtx, targetName, 2048, 0, 16, continueToken, 0, this.sppicontext, token, attr, null);
        switch (rc) {
            case 590610: {
                this.continueNeeded = true;
                break;
            }
            case 0: {
                this.dispose();
                this.continueNeeded = false;
                break;
            }
            default: {
                this.dispose();
                throw new Win32Exception(rc);
            }
        }
        return Base64.encodeBase64String((byte[])token.getBytes());
    }

    public boolean isComplete() {
        return !this.continueNeeded;
    }

    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        return this.authenticate(credentials, request, null);
    }
}

