/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafkaesqueesque.common.security.oauthbearer.internals;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.security.sasl.SaslException;
import org.apache.kafkaesqueesque.common.security.auth.SaslExtensions;
import org.apache.kafkaesqueesque.common.utils.Utils;

public class OAuthBearerClientInitialResponse {
    static final String SEPARATOR = "\u0001";
    private static final String SASLNAME = "(?:[\\x01-\\x7F&&[^=,]]|=2C|=3D)+";
    private static final String KEY = "[A-Za-z]+";
    private static final String VALUE = "[\\x21-\\x7E \t\r\n]+";
    private static final String KVPAIRS = String.format("(%s=%s%s)*", "[A-Za-z]+", "[\\x21-\\x7E \t\r\n]+", "\u0001");
    private static final Pattern AUTH_PATTERN = Pattern.compile("(?<scheme>[\\w]+)[ ]+(?<token>[-_\\.a-zA-Z0-9]+)");
    private static final Pattern CLIENT_INITIAL_RESPONSE_PATTERN = Pattern.compile(String.format("n,(a=(?<authzid>%s))?,%s(?<kvpairs>%s)%s", "(?:[\\x01-\\x7F&&[^=,]]|=2C|=3D)+", "\u0001", KVPAIRS, "\u0001"));
    public static final String AUTH_KEY = "auth";
    private final String tokenValue;
    private final String authorizationId;
    private SaslExtensions saslExtensions;
    public static final Pattern EXTENSION_KEY_PATTERN = Pattern.compile("[A-Za-z]+");
    public static final Pattern EXTENSION_VALUE_PATTERN = Pattern.compile("[\\x21-\\x7E \t\r\n]+");

    public OAuthBearerClientInitialResponse(byte[] response) throws SaslException {
        String responseMsg = new String(response, StandardCharsets.UTF_8);
        Matcher matcher = CLIENT_INITIAL_RESPONSE_PATTERN.matcher(responseMsg);
        if (!matcher.matches()) {
            throw new SaslException("Invalid OAUTHBEARER client first message");
        }
        String authzid = matcher.group("authzid");
        this.authorizationId = authzid == null ? "" : authzid;
        String kvPairs = matcher.group("kvpairs");
        Map<String, String> properties = Utils.parseMap(kvPairs, "=", SEPARATOR);
        String auth = properties.get(AUTH_KEY);
        if (auth == null) {
            throw new SaslException("Invalid OAUTHBEARER client first message: 'auth' not specified");
        }
        properties.remove(AUTH_KEY);
        SaslExtensions extensions = new SaslExtensions(properties);
        OAuthBearerClientInitialResponse.validateExtensions(extensions);
        this.saslExtensions = extensions;
        Matcher authMatcher = AUTH_PATTERN.matcher(auth);
        if (!authMatcher.matches()) {
            throw new SaslException("Invalid OAUTHBEARER client first message: invalid 'auth' format");
        }
        if (!"bearer".equalsIgnoreCase(authMatcher.group("scheme"))) {
            String msg = String.format("Invalid scheme in OAUTHBEARER client first message: %s", matcher.group("scheme"));
            throw new SaslException(msg);
        }
        this.tokenValue = authMatcher.group("token");
    }

    public OAuthBearerClientInitialResponse(String tokenValue, SaslExtensions extensions) throws SaslException {
        this(tokenValue, "", extensions);
    }

    public OAuthBearerClientInitialResponse(String tokenValue, String authorizationId, SaslExtensions extensions) throws SaslException {
        this.tokenValue = Objects.requireNonNull(tokenValue, "token value must not be null");
        this.authorizationId = authorizationId == null ? "" : authorizationId;
        OAuthBearerClientInitialResponse.validateExtensions(extensions);
        this.saslExtensions = extensions != null ? extensions : SaslExtensions.NO_SASL_EXTENSIONS;
    }

    public SaslExtensions extensions() {
        return this.saslExtensions;
    }

    public byte[] toBytes() {
        String authzid = this.authorizationId.isEmpty() ? "" : "a=" + this.authorizationId;
        String extensions = this.extensionsMessage();
        if (extensions.length() > 0) {
            extensions = SEPARATOR + extensions;
        }
        String message = String.format("n,%s,%sauth=Bearer %s%s%s%s", authzid, SEPARATOR, this.tokenValue, extensions, SEPARATOR, SEPARATOR);
        return message.getBytes(StandardCharsets.UTF_8);
    }

    public String tokenValue() {
        return this.tokenValue;
    }

    public String authorizationId() {
        return this.authorizationId;
    }

    public static void validateExtensions(SaslExtensions extensions) throws SaslException {
        if (extensions == null) {
            return;
        }
        if (extensions.map().containsKey(AUTH_KEY)) {
            throw new SaslException("Extension name auth is invalid");
        }
        for (Map.Entry<String, String> entry : extensions.map().entrySet()) {
            String extensionName = entry.getKey();
            String extensionValue = entry.getValue();
            if (!EXTENSION_KEY_PATTERN.matcher(extensionName).matches()) {
                throw new SaslException("Extension name " + extensionName + " is invalid");
            }
            if (EXTENSION_VALUE_PATTERN.matcher(extensionValue).matches()) continue;
            throw new SaslException("Extension value (" + extensionValue + ") for extension " + extensionName + " is invalid");
        }
    }

    private String extensionsMessage() {
        return Utils.mkString(this.saslExtensions.map(), "", "", "=", SEPARATOR);
    }
}

