/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.kafka;

import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputSplit;

public class KafkaInputSplit
extends FileSplit
implements InputSplit {
    private String topic;
    private long startOffset;
    private int partition;
    private long endOffset;

    public KafkaInputSplit() {
        super(null, 0L, 0L, (String[])null);
    }

    public KafkaInputSplit(String topic, int partition, long startOffset, long endOffset, Path dummyPath) {
        super(dummyPath, 0L, 0L, (String[])null);
        this.topic = topic;
        this.startOffset = startOffset;
        this.partition = partition;
        this.endOffset = endOffset;
        Preconditions.checkArgument((startOffset >= 0L && startOffset <= endOffset ? 1 : 0) != 0, (String)"start [%s] has to be positive and >= end [%]", (Object[])new Object[]{startOffset, endOffset});
    }

    public long getLength() {
        return 0L;
    }

    public String[] getLocations() {
        return new String[0];
    }

    public void write(DataOutput dataOutput) throws IOException {
        super.write(dataOutput);
        dataOutput.writeUTF(this.topic);
        dataOutput.writeInt(this.partition);
        dataOutput.writeLong(this.startOffset);
        dataOutput.writeLong(this.endOffset);
    }

    public void readFields(DataInput dataInput) throws IOException {
        super.readFields(dataInput);
        this.topic = dataInput.readUTF();
        this.partition = dataInput.readInt();
        this.startOffset = dataInput.readLong();
        this.endOffset = dataInput.readLong();
        Preconditions.checkArgument((this.startOffset >= 0L && this.startOffset <= this.endOffset ? 1 : 0) != 0, (String)"start [%s] has to be positive and >= end [%]", (Object[])new Object[]{this.startOffset, this.endOffset});
    }

    public String getTopic() {
        return this.topic;
    }

    public int getPartition() {
        return this.partition;
    }

    public long getStartOffset() {
        return this.startOffset;
    }

    public long getEndOffset() {
        return this.endOffset;
    }

    @Nullable
    public static KafkaInputSplit intersectRange(KafkaInputSplit split1, KafkaInputSplit split2) {
        long endOffset;
        assert (split1.topic.equals(split2.topic));
        assert (split1.partition == split2.partition);
        long startOffset = Math.max(split1.getStartOffset(), split2.getStartOffset());
        if (startOffset > (endOffset = Math.min(split1.getEndOffset(), split2.getEndOffset()))) {
            return null;
        }
        return new KafkaInputSplit(split1.topic, split1.partition, startOffset, endOffset, split1.getPath());
    }

    public static KafkaInputSplit unionRange(KafkaInputSplit split1, KafkaInputSplit split2) {
        assert (split1.topic.equals(split2.topic));
        assert (split1.partition == split2.partition);
        long startOffset = Math.min(split1.getStartOffset(), split2.getStartOffset());
        long endOffset = Math.max(split1.getEndOffset(), split2.getEndOffset());
        return new KafkaInputSplit(split1.topic, split1.partition, startOffset, endOffset, split1.getPath());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof KafkaInputSplit)) {
            return false;
        }
        KafkaInputSplit that = (KafkaInputSplit)((Object)o);
        return Objects.equal((Object)this.getTopic(), (Object)that.getTopic()) && Objects.equal((Object)this.getStartOffset(), (Object)that.getStartOffset()) && Objects.equal((Object)this.getPartition(), (Object)that.getPartition()) && Objects.equal((Object)this.getEndOffset(), (Object)that.getEndOffset());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.getTopic(), this.getStartOffset(), this.getPartition(), this.getEndOffset()});
    }

    public String toString() {
        return "KafkaInputSplit{topic='" + this.topic + '\'' + ", startOffset=" + this.startOffset + ", partition=" + this.partition + ", endOffset=" + this.endOffset + ", path=" + super.getPath().toString() + '}';
    }

    public static KafkaInputSplit copyOf(KafkaInputSplit other) {
        return new KafkaInputSplit(other.getTopic(), other.getPartition(), other.getStartOffset(), other.getEndOffset(), other.getPath());
    }

    public static List<KafkaInputSplit> slice(long sliceSize, KafkaInputSplit split) {
        if (split.getEndOffset() - split.getStartOffset() > sliceSize) {
            long start;
            ImmutableList.Builder builder = ImmutableList.builder();
            for (start = split.getStartOffset(); start < split.getEndOffset() - sliceSize; start += sliceSize + 1L) {
                builder.add((Object)new KafkaInputSplit(split.topic, split.partition, start, start + sliceSize + 1L, split.getPath()));
            }
            if (start < split.getEndOffset()) {
                builder.add((Object)new KafkaInputSplit(split.topic, split.partition, start, split.getEndOffset(), split.getPath()));
            }
            return builder.build();
        }
        return Collections.singletonList(KafkaInputSplit.copyOf(split));
    }
}

