/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import com.google.common.collect.ImmutableMap;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hive.common.StatsSetupConst;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.EnvironmentContext;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.PartitionSpec;
import org.apache.hadoop.hive.metastore.api.PartitionSpecWithSharedSD;
import org.apache.hadoop.hive.metastore.api.PartitionWithoutSD;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.client.builder.PartitionBuilder;
import org.apache.hadoop.hive.metastore.client.builder.TableBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.utils.MetaStoreServerUtils;
import org.apache.hadoop.hive.metastore.utils.MetaStoreUtils;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.test.appender.ListAppender;
import org.apache.thrift.TException;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

@Category(value={MetastoreUnitTest.class})
public class TestMetaStoreServerUtils {
    private static final String DB_NAME = "db1";
    private static final String TABLE_NAME = "tbl1";
    private static ListAppender listAppender;
    public static final String STATS_CALC_CALL_LOG_MSG_FORMAT = "Calling updateTableStatsSlow for table {0}.{1}.{2}";
    private final Map<String, String> paramsWithStats = ImmutableMap.of((Object)"numFiles", (Object)"1", (Object)"totalSize", (Object)"2", (Object)"numFilesErasureCoded", (Object)"0");
    private Database db;

    public TestMetaStoreServerUtils() {
        try {
            this.db = new DatabaseBuilder().setName(DB_NAME).build(null);
        }
        catch (TException e) {
            e.printStackTrace();
        }
    }

    @BeforeClass
    public static void initLoggerAppender() {
        LoggerContext loggerContext = (LoggerContext)LogManager.getContext((boolean)false);
        Configuration configuration = loggerContext.getConfiguration();
        LoggerConfig rootLoggerConfig = configuration.getLoggerConfig("");
        listAppender = new ListAppender("testAppender");
        rootLoggerConfig.addAppender((Appender)listAppender, Level.ALL, null);
    }

    @Before
    public void startLoggerAppender() {
        listAppender.start();
    }

    @After
    public void stopLoggerAppender() {
        listAppender.stop();
        listAppender.clear();
    }

    private boolean messageWasLogged(String message) {
        return listAppender.getEvents().stream().map(x -> x.getMessage().getFormattedMessage()).collect(Collectors.toList()).contains(message);
    }

    @Test
    public void testTrimMapNullsXform() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("akey", "aval");
        m.put("blank", "");
        m.put("null", null);
        ImmutableMap expected = ImmutableMap.of((Object)"akey", (Object)"aval", (Object)"blank", (Object)"", (Object)"null", (Object)"");
        Map xformed = MetaStoreServerUtils.trimMapNulls(m, (boolean)true);
        Assert.assertThat((Object)xformed, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testTrimMapNullsPrune() throws Exception {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("akey", "aval");
        m.put("blank", "");
        m.put("null", null);
        ImmutableMap expected = ImmutableMap.of((Object)"akey", (Object)"aval", (Object)"blank", (Object)"");
        Map pruned = MetaStoreServerUtils.trimMapNulls(m, (boolean)false);
        Assert.assertThat((Object)pruned, (Matcher)Is.is((Object)expected));
    }

    @Test
    public void testcolumnsIncludedByNameType() {
        FieldSchema col1 = new FieldSchema("col1", "string", "col1 comment");
        FieldSchema col1a = new FieldSchema("col1", "string", "col1 but with a different comment");
        FieldSchema col2 = new FieldSchema("col2", "string", "col2 comment");
        FieldSchema col3 = new FieldSchema("col3", "string", "col3 comment");
        Assert.assertTrue((boolean)MetaStoreServerUtils.columnsIncludedByNameType(Arrays.asList(col1), Arrays.asList(col1)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.columnsIncludedByNameType(Arrays.asList(col1), Arrays.asList(col1a)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col1, col2)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col2, col1)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col1, col2, col3)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col3, col2, col1)));
        Assert.assertFalse((boolean)MetaStoreServerUtils.columnsIncludedByNameType(Arrays.asList(col1, col2), Arrays.asList(col1)));
    }

    @Test
    public void testUpdateTableStatsSlow_statsUpdated() throws TException {
        long fileLength = 5L;
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).build(null);
        FileStatus fs1 = TestMetaStoreServerUtils.getFileStatus(1L, true, 2, 3, 4, "/tmp/0", false);
        FileStatus fs2 = TestMetaStoreServerUtils.getFileStatus(fileLength, false, 3, 4, 5, "/tmp/1", true);
        FileStatus fs3 = TestMetaStoreServerUtils.getFileStatus(fileLength, false, 3, 4, 5, "/tmp/1", false);
        List<FileStatus> fileStatus = Arrays.asList(fs1, fs2, fs3);
        Warehouse wh = (Warehouse)Mockito.mock(Warehouse.class);
        Mockito.when((Object)wh.getFileStatusesForUnpartitionedTable(this.db, tbl)).thenReturn(fileStatus);
        ImmutableMap expected = ImmutableMap.of((Object)"numFiles", (Object)"2", (Object)"totalSize", (Object)String.valueOf(2L * fileLength), (Object)"numFilesErasureCoded", (Object)"1");
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl, (Warehouse)wh, (boolean)false, (boolean)false, null);
        Assert.assertThat((Object)tbl.getParameters(), (Matcher)Is.is((Object)expected));
        Table tbl1 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("numFiles", "0").addTableParam("totalSize", "0").build(null);
        Mockito.when((Object)wh.getFileStatusesForUnpartitionedTable(this.db, tbl1)).thenReturn(fileStatus);
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl1, (Warehouse)wh, (boolean)false, (boolean)true, null);
        Assert.assertThat((Object)tbl1.getParameters(), (Matcher)Is.is((Object)expected));
        Table tbl2 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("COLUMN_STATS_ACCURATE", "true").build(null);
        Mockito.when((Object)wh.getFileStatusesForUnpartitionedTable(this.db, tbl2)).thenReturn(fileStatus);
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl2, (Warehouse)wh, (boolean)false, (boolean)true, null);
        Assert.assertThat((Object)tbl2.getParameters(), (Matcher)Is.is((Object)expected));
        EnvironmentContext context = new EnvironmentContext((Map)ImmutableMap.of((Object)"STATS_GENERATED", (Object)"TASK"));
        Table tbl3 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("COLUMN_STATS_ACCURATE", "foo").build(null);
        Mockito.when((Object)wh.getFileStatusesForUnpartitionedTable(this.db, tbl3)).thenReturn(fileStatus);
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl3, (Warehouse)wh, (boolean)false, (boolean)true, (EnvironmentContext)context);
        ImmutableMap expected1 = ImmutableMap.of((Object)"numFiles", (Object)"2", (Object)"totalSize", (Object)String.valueOf(2L * fileLength), (Object)"numFilesErasureCoded", (Object)"1", (Object)"COLUMN_STATS_ACCURATE", (Object)"{\"BASIC_STATS\":\"true\"}");
        Assert.assertThat((Object)tbl3.getParameters(), (Matcher)Is.is((Object)expected1));
    }

    @Test
    public void testUpdateTableStatsSlow_removesDoNotUpdateStats() throws TException {
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("DO_NOT_UPDATE_STATS", "true").build(null);
        Table tbl1 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).addTableParam("DO_NOT_UPDATE_STATS", "false").build(null);
        Warehouse wh = (Warehouse)Mockito.mock(Warehouse.class);
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl, (Warehouse)wh, (boolean)false, (boolean)true, null);
        Assert.assertThat((Object)tbl.getParameters(), (Matcher)Is.is(Collections.emptyMap()));
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl);
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl1, (Warehouse)wh, (boolean)true, (boolean)false, null);
        Assert.assertThat((Object)tbl.getParameters(), (Matcher)Is.is(Collections.emptyMap()));
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl1);
    }

    @Test
    public void testUpdateTableStatsSlow_doesNotUpdateStats() throws TException {
        FieldSchema fs = new FieldSchema("date", "string", "date column");
        List<FieldSchema> cols = Collections.singletonList(fs);
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).build(null);
        Warehouse wh = (Warehouse)Mockito.mock(Warehouse.class);
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl, (Warehouse)wh, (boolean)true, (boolean)false, null);
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl);
        Table tbl1 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setPartCols(cols).build(null);
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl1, (Warehouse)wh, (boolean)false, (boolean)false, null);
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl1);
        Table tbl2 = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setTableParams(this.paramsWithStats).build(null);
        MetaStoreServerUtils.updateTableStatsSlow((Database)this.db, (Table)tbl2, (Warehouse)wh, (boolean)false, (boolean)false, null);
        ((Warehouse)Mockito.verify((Object)wh, (VerificationMode)Mockito.never())).getFileStatusesForUnpartitionedTable(this.db, tbl2);
    }

    @Test
    public void testUpdateTableStatsForCreateTableDoesNotInvokeStatsCalc() throws TException {
        HashMap<String, String> params = new HashMap<String, String>(this.paramsWithStats);
        Warehouse wh = (Warehouse)Mockito.mock(Warehouse.class);
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setTableParams(params).build(null);
        EnvironmentContext env = new EnvironmentContext();
        env.putToProperties("DO_NOT_UPDATE_STATS", "true");
        MetaStoreServerUtils.updateTableStatsForCreateTable((Warehouse)wh, (Database)this.db, (Table)tbl, (EnvironmentContext)env, (org.apache.hadoop.conf.Configuration)MetastoreConf.newMetastoreConf(), (Path)new Path("/tmp/0"), (boolean)false);
        Assert.assertFalse((boolean)this.messageWasLogged(MessageFormat.format(STATS_CALC_CALL_LOG_MSG_FORMAT, tbl.getCatName(), tbl.getDbName(), tbl.getTableName())));
    }

    @Test
    public void testUpdateTableStatsForCreateTableInvokeStatsCalc() throws TException {
        HashMap<String, String> params = new HashMap<String, String>(this.paramsWithStats);
        Warehouse wh = (Warehouse)Mockito.mock(Warehouse.class);
        Table tbl = ((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setTableParams(params).build(null);
        MetaStoreServerUtils.updateTableStatsForCreateTable((Warehouse)wh, (Database)this.db, (Table)tbl, null, (org.apache.hadoop.conf.Configuration)MetastoreConf.newMetastoreConf(), (Path)new Path("/tmp/0"), (boolean)false);
        Assert.assertTrue((boolean)this.messageWasLogged(MessageFormat.format(STATS_CALC_CALL_LOG_MSG_FORMAT, tbl.getCatName(), tbl.getDbName(), tbl.getTableName())));
        EnvironmentContext env = new EnvironmentContext();
        env.putToProperties("DO_NOT_UPDATE_STATS", "false");
        MetaStoreServerUtils.updateTableStatsForCreateTable((Warehouse)wh, (Database)this.db, (Table)tbl, (EnvironmentContext)env, (org.apache.hadoop.conf.Configuration)MetastoreConf.newMetastoreConf(), (Path)new Path("/tmp/0"), (boolean)false);
        Assert.assertTrue((boolean)this.messageWasLogged(MessageFormat.format(STATS_CALC_CALL_LOG_MSG_FORMAT, tbl.getCatName(), tbl.getDbName(), tbl.getTableName())));
    }

    @Test
    public void isFastStatsSameWithNullPartitions() {
        Partition partition = new Partition();
        Assert.assertFalse((boolean)MetaStoreServerUtils.isFastStatsSame(null, null));
        Assert.assertFalse((boolean)MetaStoreServerUtils.isFastStatsSame(null, (Partition)partition));
        Assert.assertFalse((boolean)MetaStoreServerUtils.isFastStatsSame((Partition)partition, null));
    }

    @Test
    public void isFastStatsSameWithNoMatchingStats() {
        Partition oldPartition = new Partition();
        HashMap<String, String> stats = new HashMap<String, String>();
        oldPartition.setParameters(stats);
        Assert.assertFalse((boolean)MetaStoreServerUtils.isFastStatsSame((Partition)oldPartition, null));
        stats.put("someKeyThatIsNotInFastStats", "value");
        oldPartition.setParameters(stats);
        Assert.assertFalse((boolean)MetaStoreServerUtils.isFastStatsSame((Partition)oldPartition, null));
    }

    @Test
    public void isFastStatsSameMatchingButOnlyOneStat() {
        Partition oldPartition = new Partition();
        Partition newPartition = new Partition();
        HashMap<String, String> randomParams = new HashMap<String, String>();
        randomParams.put("randomParam1", "randomVal1");
        newPartition.setParameters(randomParams);
        Assert.assertFalse((boolean)MetaStoreServerUtils.isFastStatsSame((Partition)oldPartition, (Partition)newPartition));
    }

    @Test
    public void isFastStatsSameMatching() {
        Partition oldPartition = new Partition();
        Partition newPartition = new Partition();
        HashMap stats = new HashMap();
        HashMap<String, String> oldParams = new HashMap<String, String>();
        HashMap<String, String> newParams = new HashMap<String, String>();
        long testVal = 1L;
        for (String key : StatsSetupConst.FAST_STATS) {
            oldParams.put(key, String.valueOf(testVal));
            newParams.put(key, String.valueOf(testVal));
        }
        oldPartition.setParameters(oldParams);
        newPartition.setParameters(newParams);
        Assert.assertTrue((boolean)MetaStoreServerUtils.isFastStatsSame((Partition)oldPartition, (Partition)newPartition));
    }

    @Test
    public void isFastStatsSameDifferent() {
        Partition oldPartition = new Partition();
        Partition newPartition = new Partition();
        HashMap stats = new HashMap();
        HashMap<String, String> oldParams = new HashMap<String, String>();
        HashMap<String, String> newParams = new HashMap<String, String>();
        long testVal = 1L;
        for (String key : StatsSetupConst.FAST_STATS) {
            oldParams.put(key, String.valueOf(testVal));
            newParams.put(key, String.valueOf(++testVal));
        }
        oldPartition.setParameters(oldParams);
        newPartition.setParameters(newParams);
        Assert.assertFalse((boolean)MetaStoreServerUtils.isFastStatsSame((Partition)oldPartition, (Partition)newPartition));
    }

    @Test
    public void isFastStatsSameNullStatsInNew() {
        Partition oldPartition = new Partition();
        Partition newPartition = new Partition();
        HashMap<String, String> oldParams = new HashMap<String, String>();
        HashMap<String, Object> newParams = new HashMap<String, Object>();
        long testVal = 1L;
        for (String key : StatsSetupConst.FAST_STATS) {
            oldParams.put(key, String.valueOf(testVal));
            newParams.put(key, null);
        }
        oldPartition.setParameters(oldParams);
        newPartition.setParameters(newParams);
        Assert.assertFalse((boolean)MetaStoreServerUtils.isFastStatsSame((Partition)oldPartition, (Partition)newPartition));
    }

    private static FileStatus getFileStatus(long fileLength, boolean isdir, int blockReplication, int blockSize, int modificationTime, String pathString, boolean isErasureCoded) {
        return new FileStatus(fileLength, isdir, blockReplication, (long)blockSize, (long)modificationTime, 0L, (FsPermission)null, (String)null, (String)null, null, new Path(pathString), false, false, isErasureCoded);
    }

    @Test
    public void testFilterMapWithPredicates() {
        Map<String, String> testMap = this.getTestParamMap();
        List<String> excludePatterns = Arrays.asList("lastDdl", "num");
        this.testMapFilter(testMap, excludePatterns);
        Assert.assertFalse((boolean)testMap.containsKey("transient_lastDdlTime"));
        Assert.assertFalse((boolean)testMap.containsKey("numFiles"));
        Assert.assertFalse((boolean)testMap.containsKey("numFilesErasureCoded"));
        Assert.assertFalse((boolean)testMap.containsKey("numRows"));
        HashMap<String, String> expectedMap = new HashMap<String, String>(){
            {
                this.put("totalSize", "1024");
                this.put("rawDataSize", "3243234");
                this.put("COLUMN_STATS_ACCURATE", "{\"BASIC_STATS\":\"true\"");
                this.put("COLUMN_STATS_ACCURATED", "dummy");
                this.put("bucketing_version", "2");
                this.put("testBucketing_version", "2");
            }
        };
        Assert.assertThat((Object)expectedMap, (Matcher)Is.is(testMap));
        testMap = this.getTestParamMap();
        excludePatterns = Arrays.asList("^bucket", "ACCURATE$");
        this.testMapFilter(testMap, excludePatterns);
        expectedMap = new HashMap<String, String>(){
            {
                this.put("totalSize", "1024");
                this.put("numRows", "10");
                this.put("rawDataSize", "3243234");
                this.put("COLUMN_STATS_ACCURATED", "dummy");
                this.put("numFiles", "2");
                this.put("transient_lastDdlTime", "1537487124");
                this.put("testBucketing_version", "2");
                this.put("numFilesErasureCoded", "0");
            }
        };
        Assert.assertThat((Object)expectedMap, (Matcher)Is.is(testMap));
        org.apache.hadoop.conf.Configuration testConf = MetastoreConf.newMetastoreConf();
        testMap = this.getTestParamMap();
        excludePatterns = Arrays.asList(MetastoreConf.getTrimmedStringsVar((org.apache.hadoop.conf.Configuration)testConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_NOTIFICATION_PARAMETERS_EXCLUDE_PATTERNS));
        this.testMapFilter(testMap, excludePatterns);
        Assert.assertThat(this.getTestParamMap(), (Matcher)Is.is(testMap));
        testConf.setStrings(MetastoreConf.ConfVars.EVENT_NOTIFICATION_PARAMETERS_EXCLUDE_PATTERNS.getVarname(), new String[]{""});
        testMap = this.getTestParamMap();
        excludePatterns = Arrays.asList(MetastoreConf.getTrimmedStringsVar((org.apache.hadoop.conf.Configuration)testConf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_NOTIFICATION_PARAMETERS_EXCLUDE_PATTERNS));
        this.testMapFilter(testMap, excludePatterns);
        Assert.assertThat(this.getTestParamMap(), (Matcher)Is.is(testMap));
    }

    private void testMapFilter(Map<String, String> testMap, List<String> patterns) {
        List paramsFilter = patterns.stream().map(pattern -> Pattern.compile(pattern).asPredicate()).collect(Collectors.toList());
        MetaStoreUtils.filterMapkeys(testMap, paramsFilter);
    }

    private Map<String, String> getTestParamMap() {
        return new HashMap<String, String>(){
            {
                this.put("totalSize", "1024");
                this.put("numRows", "10");
                this.put("rawDataSize", "3243234");
                this.put("COLUMN_STATS_ACCURATE", "{\"BASIC_STATS\":\"true\"");
                this.put("COLUMN_STATS_ACCURATED", "dummy");
                this.put("numFiles", "2");
                this.put("transient_lastDdlTime", "1537487124");
                this.put("bucketing_version", "2");
                this.put("testBucketing_version", "2");
                this.put("numFilesErasureCoded", "0");
            }
        };
    }

    @Test
    public void testCompareNullSdKey() {
        Assert.assertThat((Object)MetaStoreServerUtils.StorageDescriptorKey.UNSET_KEY, (Matcher)Is.is((Object)new MetaStoreServerUtils.StorageDescriptorKey()));
    }

    @Test
    public void testCompareNullSd() {
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", null), (Matcher)Is.is((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", null)));
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", null), (Matcher)IsNot.not((Matcher)CoreMatchers.equalTo((Object)new MetaStoreServerUtils.StorageDescriptorKey("b", null))));
    }

    @Test
    public void testCompareWithSdSamePrefixDifferentLocation() throws MetaException {
        Partition p1 = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l1")).addCol("a", "int")).addValue("val1").build(null);
        Partition p2 = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l2")).addCol("a", "int")).addValue("val1").build(null);
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p1.getSd()), (Matcher)Is.is((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p2.getSd())));
    }

    @Test
    public void testCompareWithSdSamePrefixDifferentCols() throws MetaException {
        Partition p1 = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l1")).addCol("a", "int")).addValue("val1").build(null);
        Partition p2 = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l2")).addCol("b", "int")).addValue("val1").build(null);
        Partition p3 = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l2")).addCol("a", "int")).addValue("val1").build(null);
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p1.getSd()), (Matcher)IsNot.not((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p2.getSd())));
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p1.getSd()), (Matcher)Is.is((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p3.getSd())));
    }

    @Test
    public void testCompareWithSdSamePrefixDifferentOutputFormat() throws MetaException {
        Partition p1 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l1")).addCol("a", "int")).addValue("val1").setOutputFormat("foo")).build(null);
        Partition p2 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l2")).addCol("a", "int")).setOutputFormat("bar")).addValue("val1").build(null);
        Partition p3 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l2")).addCol("a", "int")).setOutputFormat("foo")).addValue("val1").build(null);
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p1.getSd()), (Matcher)IsNot.not((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p2.getSd())));
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p1.getSd()), (Matcher)Is.is((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p3.getSd())));
    }

    @Test
    public void testCompareWithSdSamePrefixDifferentInputFormat() throws MetaException {
        Partition p1 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l1")).addCol("a", "int")).addValue("val1").setInputFormat("foo")).build(null);
        Partition p2 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l2")).addCol("a", "int")).setInputFormat("bar")).addValue("val1").build(null);
        Partition p3 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("l1")).addCol("a", "int")).addValue("val1").setInputFormat("foo")).build(null);
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p1.getSd()), (Matcher)IsNot.not((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p2.getSd())));
        Assert.assertThat((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p1.getSd()), (Matcher)Is.is((Object)new MetaStoreServerUtils.StorageDescriptorKey("a", p3.getSd())));
    }

    @Test
    public void testGetPartitionspecsGroupedBySDNullSD() throws MetaException {
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setLocation("/foo")).build(null);
        Partition p1 = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).addCol("a", "int")).addValue("val1").setInputFormat("foo")).build(null);
        p1.unsetSd();
        Assert.assertThat((Object)p1.getSd(), (Matcher)Is.is((Object)null));
        List result = MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor((Table)tbl, Collections.singleton(p1));
        Assert.assertThat((Object)result.size(), (Matcher)Is.is((Object)1));
        PartitionSpec ps = (PartitionSpec)result.get(0);
        Assert.assertThat((Object)ps.getRootPath(), (Matcher)Is.is((Object)null));
        List partitions = ps.getSharedSDPartitionSpec().getPartitions();
        Assert.assertThat((Object)partitions.size(), (Matcher)Is.is((Object)1));
        PartitionWithoutSD partition = (PartitionWithoutSD)partitions.get(0);
        Assert.assertThat((Object)partition.getRelativePath(), (Matcher)Is.is((Object)null));
        Assert.assertThat((Object)partition.getValues(), (Matcher)Is.is(Collections.singletonList("val1")));
    }

    @Test
    public void testGetPartitionspecsGroupedBySDOnePartitionInTable() throws MetaException {
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setLocation("/foo")).build(null);
        Partition p1 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("/foo/bar")).addCol("a", "int")).addValue("val1").setInputFormat("foo")).build(null);
        List result = MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor((Table)tbl, Collections.singleton(p1));
        Assert.assertThat((Object)result.size(), (Matcher)Is.is((Object)1));
        PartitionSpec ps = (PartitionSpec)result.get(0);
        Assert.assertThat((Object)ps.getRootPath(), (Matcher)Is.is((Object)tbl.getSd().getLocation()));
        List partitions = ps.getSharedSDPartitionSpec().getPartitions();
        Assert.assertThat((Object)partitions.size(), (Matcher)Is.is((Object)1));
        PartitionWithoutSD partition = (PartitionWithoutSD)partitions.get(0);
        Assert.assertThat((Object)partition.getRelativePath(), (Matcher)Is.is((Object)"/bar"));
        Assert.assertThat((Object)partition.getValues(), (Matcher)Is.is(Collections.singletonList("val1")));
    }

    @Test
    public void testGetPartitionspecsGroupedBySDonePartitionExternal() throws MetaException {
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setLocation("/foo")).build(null);
        Partition p1 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("/a/b")).addCol("a", "int")).addValue("val1").setInputFormat("foo")).build(null);
        List result = MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor((Table)tbl, Collections.singleton(p1));
        Assert.assertThat((Object)result.size(), (Matcher)Is.is((Object)1));
        PartitionSpec ps = (PartitionSpec)result.get(0);
        Assert.assertThat((Object)ps.getRootPath(), (Matcher)Is.is((Object)null));
        List partitions = ps.getPartitionList().getPartitions();
        Assert.assertThat((Object)partitions.size(), (Matcher)Is.is((Object)1));
        Partition partition = (Partition)partitions.get(0);
        Assert.assertThat((Object)partition.getSd().getLocation(), (Matcher)Is.is((Object)"/a/b"));
        Assert.assertThat((Object)partition.getValues(), (Matcher)Is.is(Collections.singletonList("val1")));
    }

    @Test
    public void testGetPartitionspecsGroupedBySDonePartitionCombined() throws MetaException {
        String sharedInputFormat = "foo1";
        Table tbl = ((TableBuilder)((TableBuilder)new TableBuilder().setDbName(DB_NAME).setTableName(TABLE_NAME).addCol("id", "int")).setLocation("/foo")).build(null);
        Partition p1 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("/foo/bar")).addCol("a1", "int")).addValue("val1").setInputFormat(sharedInputFormat)).build(null);
        Partition p2 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).setLocation("/a/b")).addCol("a2", "int")).addValue("val2").setInputFormat("foo2")).build(null);
        Partition p3 = ((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName(TABLE_NAME).addCol("a3", "int")).addValue("val3").setInputFormat("foo3")).build(null);
        Partition p4 = ((PartitionBuilder)((PartitionBuilder)((PartitionBuilder)new PartitionBuilder().setDbName("DB_NAME").setTableName("TABLE_NAME").setLocation("/foo/baz")).addCol("a1", "int")).addValue("val4").setInputFormat(sharedInputFormat)).build(null);
        p3.unsetSd();
        List result = MetaStoreServerUtils.getPartitionspecsGroupedByStorageDescriptor((Table)tbl, Arrays.asList(p1, p2, p3, p4));
        Assert.assertThat((Object)result.size(), (Matcher)Is.is((Object)3));
        PartitionSpec ps1 = (PartitionSpec)result.get(0);
        Assert.assertThat((Object)ps1.getRootPath(), (Matcher)Is.is((Object)null));
        Assert.assertThat((Object)ps1.getPartitionList(), (Matcher)Is.is((Object)null));
        PartitionSpecWithSharedSD partSpec = ps1.getSharedSDPartitionSpec();
        List partitions1 = partSpec.getPartitions();
        Assert.assertThat((Object)partitions1.size(), (Matcher)Is.is((Object)1));
        PartitionWithoutSD partition1 = (PartitionWithoutSD)partitions1.get(0);
        Assert.assertThat((Object)partition1.getRelativePath(), (Matcher)Is.is((Object)null));
        Assert.assertThat((Object)partition1.getValues(), (Matcher)Is.is(Collections.singletonList("val3")));
        PartitionSpec ps2 = (PartitionSpec)result.get(1);
        Assert.assertThat((Object)ps2.getRootPath(), (Matcher)Is.is((Object)tbl.getSd().getLocation()));
        Assert.assertThat((Object)ps2.getPartitionList(), (Matcher)Is.is((Object)null));
        List partitions2 = ps2.getSharedSDPartitionSpec().getPartitions();
        Assert.assertThat((Object)partitions2.size(), (Matcher)Is.is((Object)2));
        PartitionWithoutSD partition2_1 = (PartitionWithoutSD)partitions2.get(0);
        PartitionWithoutSD partition2_2 = (PartitionWithoutSD)partitions2.get(1);
        if (partition2_1.getRelativePath().equals("baz")) {
            PartitionWithoutSD tmp = partition2_1;
            partition2_1 = partition2_2;
            partition2_2 = tmp;
        }
        Assert.assertThat((Object)partition2_1.getRelativePath(), (Matcher)Is.is((Object)"/bar"));
        Assert.assertThat((Object)partition2_1.getValues(), (Matcher)Is.is(Collections.singletonList("val1")));
        Assert.assertThat((Object)partition2_2.getRelativePath(), (Matcher)Is.is((Object)"/baz"));
        Assert.assertThat((Object)partition2_2.getValues(), (Matcher)Is.is(Collections.singletonList("val4")));
        PartitionSpec ps4 = (PartitionSpec)result.get(2);
        Assert.assertThat((Object)ps4.getRootPath(), (Matcher)Is.is((Object)null));
        Assert.assertThat((Object)ps4.getSharedSDPartitionSpec(), (Matcher)Is.is((Object)null));
        List partitions = ps4.getPartitionList().getPartitions();
        Assert.assertThat((Object)partitions.size(), (Matcher)Is.is((Object)1));
        Partition partition = (Partition)partitions.get(0);
        Assert.assertThat((Object)partition.getSd().getLocation(), (Matcher)Is.is((Object)"/a/b"));
        Assert.assertThat((Object)partition.getValues(), (Matcher)Is.is(Collections.singletonList("val2")));
    }

    @Test
    public void testAnonymizeConnectionURL() {
        String connectionURL = null;
        String expectedConnectionURL = null;
        String result = MetaStoreServerUtils.anonymizeConnectionURL(connectionURL);
        Assert.assertEquals(expectedConnectionURL, (Object)result);
        connectionURL = "jdbc:mysql://localhost:1111/db?user=user&password=password";
        expectedConnectionURL = "jdbc:mysql://localhost:1111/db?user=****&password=****";
        result = MetaStoreServerUtils.anonymizeConnectionURL((String)connectionURL);
        Assert.assertEquals((Object)expectedConnectionURL, (Object)result);
        connectionURL = "jdbc:derby:sample;user=jill;password=toFetchAPail";
        expectedConnectionURL = "jdbc:derby:sample;user=****;password=****";
        result = MetaStoreServerUtils.anonymizeConnectionURL((String)connectionURL);
        Assert.assertEquals((Object)expectedConnectionURL, (Object)result);
        connectionURL = "jdbc:mysql://[(host=myhost1,port=1111,user=sandy,password=secret),(host=myhost2,port=2222,user=finn,password=secret)]/db";
        expectedConnectionURL = "jdbc:mysql://[(host=myhost1,port=1111,user=****,password=****),(host=myhost2,port=2222,user=****,password=****)]/db";
        result = MetaStoreServerUtils.anonymizeConnectionURL((String)connectionURL);
        Assert.assertEquals((Object)expectedConnectionURL, (Object)result);
        connectionURL = "jdbc:derby:memory:${test.tmp.dir}/junit_metastore_db;create=true";
        result = MetaStoreServerUtils.anonymizeConnectionURL((String)connectionURL);
        Assert.assertEquals((Object)connectionURL, (Object)result);
    }

    @Test
    public void testConversionToSignificantNumericTypes() {
        Assert.assertEquals((Object)"1", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"0001", (String)"tinyint"));
        Assert.assertEquals((Object)"1", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"0001", (String)"smallint"));
        Assert.assertEquals((Object)"10", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"00010", (String)"int"));
        Assert.assertEquals((Object)"-10", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"-00010", (String)"int"));
        Assert.assertEquals((Object)"10", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"00010", (String)"bigint"));
        Assert.assertEquals((Object)"-10", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"-00010", (String)"bigint"));
        Assert.assertEquals((Object)"1.01", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"0001.0100", (String)"float"));
        Assert.assertEquals((Object)"-1.01", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"-0001.0100", (String)"float"));
        Assert.assertEquals((Object)"1.01", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"0001.010000", (String)"double"));
        Assert.assertEquals((Object)"-1.01", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"-0001.010000", (String)"double"));
        Assert.assertEquals((Object)"1.01", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"0001.0100", (String)"decimal"));
        Assert.assertEquals((Object)"-1.01", (Object)MetaStoreServerUtils.getNormalisedPartitionValue((String)"-0001.0100", (String)"decimal"));
    }

    @Test
    public void throwFailExceptionWithHDFSStorageIsRootPath() {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("hdfs://localhost:8020");
        Assert.assertFalse((boolean)MetaStoreUtils.validateTblStorage((StorageDescriptor)sd));
        sd.setLocation("hdfs://localhost:8020/other_path");
        Assert.assertTrue((boolean)MetaStoreUtils.validateTblStorage((StorageDescriptor)sd));
    }

    @Test
    public void throwFailExceptionWithS3StorageIsRootPath() {
        StorageDescriptor sd = new StorageDescriptor();
        sd.setLocation("s3a://bucket/");
        Assert.assertFalse((boolean)MetaStoreUtils.validateTblStorage((StorageDescriptor)sd));
        sd.setLocation("s3a://bucket");
        Assert.assertFalse((boolean)MetaStoreUtils.validateTblStorage((StorageDescriptor)sd));
        sd.setLocation("s3a://bucket/other_path");
        Assert.assertTrue((boolean)MetaStoreUtils.validateTblStorage((StorageDescriptor)sd));
    }

    @Test
    public void testSameColumns() {
        FieldSchema col1 = new FieldSchema("col1", "string", "col1 comment");
        FieldSchema Col1 = new FieldSchema("Col1", "string", "col1 comment");
        FieldSchema col2 = new FieldSchema("col2", "string", "col2 comment");
        Assert.assertTrue((boolean)MetaStoreServerUtils.areSameColumns(null, null));
        Assert.assertFalse((boolean)MetaStoreServerUtils.areSameColumns(Arrays.asList(col1), null));
        Assert.assertFalse((boolean)MetaStoreServerUtils.areSameColumns(null, Arrays.asList(col1)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.areSameColumns(Arrays.asList(col1), Arrays.asList(col1)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.areSameColumns(Arrays.asList(col1, col2), Arrays.asList(col1, col2)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.areSameColumns(Arrays.asList(Col1, col2), Arrays.asList(col1, col2)));
    }

    @Test
    public void testPrefixColumns() {
        FieldSchema col1 = new FieldSchema("col1", "string", "col1 comment");
        FieldSchema Col1 = new FieldSchema("Col1", "string", "col1 comment");
        FieldSchema col2 = new FieldSchema("col2", "string", "col2 comment");
        FieldSchema col3 = new FieldSchema("col3", "string", "col3 comment");
        Assert.assertTrue((boolean)MetaStoreServerUtils.arePrefixColumns(null, null));
        Assert.assertFalse((boolean)MetaStoreServerUtils.arePrefixColumns(Arrays.asList(col1), null));
        Assert.assertFalse((boolean)MetaStoreServerUtils.arePrefixColumns(null, Arrays.asList(col1)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.arePrefixColumns(Arrays.asList(col1), Arrays.asList(col1)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.arePrefixColumns(Arrays.asList(col1, col2), Arrays.asList(col1, col2, col3)));
        Assert.assertTrue((boolean)MetaStoreServerUtils.arePrefixColumns(Arrays.asList(Col1, col2), Arrays.asList(col1, col2, col3)));
        Assert.assertFalse((boolean)MetaStoreServerUtils.arePrefixColumns(Arrays.asList(col1, col2, col3), Arrays.asList(col1, col2)));
    }
}

