/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.utils;

import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.api.LockType;
import org.apache.hadoop.hive.metastore.utils.LockTypeUtil;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestLockTypeUtil {
    @Test
    public void testGetEncoding() {
        Assert.assertEquals((long)114L, (long)LockTypeUtil.getEncoding((LockType)LockType.SHARED_READ));
        Assert.assertEquals((long)119L, (long)LockTypeUtil.getEncoding((LockType)LockType.SHARED_WRITE));
        Assert.assertEquals((long)120L, (long)LockTypeUtil.getEncoding((LockType)LockType.EXCL_WRITE));
        Assert.assertEquals((long)101L, (long)LockTypeUtil.getEncoding((LockType)LockType.EXCLUSIVE));
    }

    @Test
    public void testGetLockType() {
        Assert.assertEquals((Object)LockType.SHARED_READ, LockTypeUtil.getLockTypeFromEncoding((char)'r').get());
        Assert.assertEquals((Object)LockType.SHARED_WRITE, LockTypeUtil.getLockTypeFromEncoding((char)'w').get());
        Assert.assertEquals((Object)LockType.EXCL_WRITE, LockTypeUtil.getLockTypeFromEncoding((char)'x').get());
        Assert.assertEquals((Object)LockType.EXCLUSIVE, LockTypeUtil.getLockTypeFromEncoding((char)'e').get());
        Assert.assertFalse((boolean)LockTypeUtil.getLockTypeFromEncoding((char)'y').isPresent());
    }
}

