/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.schematool;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import org.apache.hadoop.hive.metastore.tools.schematool.MetastoreSchemaTool;
import org.apache.hadoop.hive.metastore.tools.schematool.SchemaToolTaskDrop;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestSchemaToolTaskDrop {
    private SchemaToolTaskDrop uut;
    private Statement stmtMock;
    private final InputStream stdin = System.in;

    @Before
    public void setUp() throws Exception {
        this.uut = new SchemaToolTaskDrop();
        this.uut.schemaTool = (MetastoreSchemaTool)Mockito.mock(MetastoreSchemaTool.class);
    }

    @After
    public void tearDown() throws Exception {
        System.setIn(this.stdin);
    }

    private void mockPromptWith(String answer) {
        ByteArrayInputStream in = new ByteArrayInputStream((answer + "\n").getBytes());
        System.setIn(in);
    }

    private void setUpTwoDatabases() throws Exception {
        Connection connMock = (Connection)Mockito.mock(Connection.class);
        this.stmtMock = (Statement)Mockito.mock(Statement.class);
        ResultSet databasesResult = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)databasesResult.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)databasesResult.getString(ArgumentMatchers.anyInt())).thenReturn((Object)"mydb", (Object[])new String[]{"default"});
        ResultSet tablesResult = (ResultSet)Mockito.mock(ResultSet.class);
        Mockito.when((Object)tablesResult.next()).thenReturn((Object)true, (Object[])new Boolean[]{true, false});
        Mockito.when((Object)tablesResult.getString(ArgumentMatchers.anyInt())).thenReturn((Object)"table1", (Object[])new String[]{"table2"});
        Mockito.when((Object)this.stmtMock.executeQuery(ArgumentMatchers.anyString())).thenReturn((Object)databasesResult, (Object[])new ResultSet[]{tablesResult});
        Mockito.when((Object)connMock.createStatement()).thenReturn((Object)this.stmtMock);
        Mockito.when((Object)this.uut.schemaTool.getConnectionToMetastore(ArgumentMatchers.anyBoolean())).thenReturn((Object)connMock);
    }

    @Test
    public void testExecutePromptYes() throws Exception {
        this.setUpTwoDatabases();
        this.mockPromptWith("y");
        this.uut.execute();
        ((Statement)Mockito.verify((Object)this.stmtMock)).execute("DROP DATABASE `mydb` CASCADE");
        ((Statement)Mockito.verify((Object)this.stmtMock)).execute(String.format("DROP TABLE `%s`.`table1`", "default"));
        ((Statement)Mockito.verify((Object)this.stmtMock)).execute(String.format("DROP TABLE `%s`.`table2`", "default"));
        ((Statement)Mockito.verify((Object)this.stmtMock, (VerificationMode)Mockito.times((int)3))).execute(ArgumentMatchers.anyString());
    }

    @Test
    public void testExecutePromptNo() throws Exception {
        this.setUpTwoDatabases();
        this.mockPromptWith("n");
        this.uut.execute();
        ((Statement)Mockito.verify((Object)this.stmtMock, (VerificationMode)Mockito.times((int)0))).execute(ArgumentMatchers.anyString());
    }

    @Test
    public void testExecuteDryRun() throws Exception {
        this.setUpTwoDatabases();
        Mockito.when((Object)this.uut.schemaTool.isDryRun()).thenReturn((Object)true);
        this.uut.execute();
        ((Statement)Mockito.verify((Object)this.stmtMock, (VerificationMode)Mockito.times((int)0))).execute(ArgumentMatchers.anyString());
    }

    @Test
    public void testExecuteWithYes() throws Exception {
        this.setUpTwoDatabases();
        this.uut.yes = true;
        this.uut.execute();
        ((Statement)Mockito.verify((Object)this.stmtMock, (VerificationMode)Mockito.times((int)3))).execute(ArgumentMatchers.anyString());
    }
}

