/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.tools.metatool;

import org.apache.commons.cli.ParseException;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.tools.metatool.HiveMetaToolCommandLine;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.rules.ExpectedException;

@Category(value={MetastoreUnitTest.class})
public class TestHiveMetaToolCommandLine {
    @Rule
    public final ExpectedException exception = ExpectedException.none();

    @Test
    public void testParseListFSRoot() throws ParseException {
        HiveMetaToolCommandLine cl = new HiveMetaToolCommandLine(new String[]{"-listFSRoot"});
        Assert.assertTrue((boolean)cl.isListFSRoot());
        Assert.assertFalse((boolean)cl.isExecuteJDOQL());
        Assert.assertNull((Object)cl.getJDOQLQuery());
        Assert.assertFalse((boolean)cl.isUpdateLocation());
        Assert.assertNull((Object)cl.getUpddateLocationParams());
        Assert.assertFalse((boolean)cl.isListExtTblLocs());
        Assert.assertNull((Object)cl.getListExtTblLocsParams());
        Assert.assertFalse((boolean)cl.isDryRun());
        Assert.assertNull((Object)cl.getSerdePropKey());
        Assert.assertNull((Object)cl.getTablePropKey());
    }

    @Test
    public void testParseExecuteJDOQL() throws ParseException {
        HiveMetaToolCommandLine cl = new HiveMetaToolCommandLine(new String[]{"-executeJDOQL", "select a from b"});
        Assert.assertFalse((boolean)cl.isListFSRoot());
        Assert.assertTrue((boolean)cl.isExecuteJDOQL());
        Assert.assertEquals((Object)"select a from b", (Object)cl.getJDOQLQuery());
        Assert.assertFalse((boolean)cl.isUpdateLocation());
        Assert.assertNull((Object)cl.getUpddateLocationParams());
        Assert.assertFalse((boolean)cl.isListExtTblLocs());
        Assert.assertNull((Object)cl.getListExtTblLocsParams());
        Assert.assertFalse((boolean)cl.isDryRun());
        Assert.assertNull((Object)cl.getSerdePropKey());
        Assert.assertNull((Object)cl.getTablePropKey());
    }

    @Test
    public void testParseUpdateLocation() throws ParseException {
        String[] args = new String[]{"-updateLocation", "hdfs://new.loc", "hdfs://old.loc", "-dryRun", "-serdePropKey", "abc", "-tablePropKey", "def"};
        HiveMetaToolCommandLine cl = new HiveMetaToolCommandLine(args);
        Assert.assertFalse((boolean)cl.isListFSRoot());
        Assert.assertFalse((boolean)cl.isExecuteJDOQL());
        Assert.assertNull((Object)cl.getJDOQLQuery());
        Assert.assertTrue((boolean)cl.isUpdateLocation());
        Assert.assertEquals((Object)"hdfs://new.loc", (Object)cl.getUpddateLocationParams()[0]);
        Assert.assertEquals((Object)"hdfs://old.loc", (Object)cl.getUpddateLocationParams()[1]);
        Assert.assertFalse((boolean)cl.isListExtTblLocs());
        Assert.assertNull((Object)cl.getListExtTblLocsParams());
        Assert.assertTrue((boolean)cl.isDryRun());
        Assert.assertEquals((Object)"abc", (Object)cl.getSerdePropKey());
        Assert.assertEquals((Object)"def", (Object)cl.getTablePropKey());
    }

    @Test
    public void testNoTask() throws ParseException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("exactly one of -listFSRoot, -executeJDOQL, -updateLocation, -listExtTblLocs, -diffExtTblLocs must be set");
        new HiveMetaToolCommandLine(new String[0]);
    }

    @Test
    public void testMultipleTask() throws ParseException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("exactly one of -listFSRoot, -executeJDOQL, -updateLocation, -listExtTblLocs, -diffExtTblLocs must be set");
        new HiveMetaToolCommandLine(new String[]{"-listFSRoot", "-executeJDOQL", "select a from b"});
    }

    @Test
    public void testUpdateLocationOneArgument() throws ParseException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("HiveMetaTool:updateLocation takes in 2 arguments but was passed 1 arguments");
        new HiveMetaToolCommandLine(new String[]{"-updateLocation", "hdfs://abc.de"});
    }

    @Test
    public void testListExtTblLocsOneArgument() throws ParseException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("HiveMetaTool:listExtTblLocs takes in 2 arguments but was passed 1 arguments");
        new HiveMetaToolCommandLine(new String[]{"-listExtTblLocs", "db1"});
    }

    @Test
    public void testDiffExtTblLocsArgCount() throws ParseException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("HiveMetaTool:diffExtTblLocs takes in 3 arguments but was passed 1 arguments");
        new HiveMetaToolCommandLine(new String[]{"-diffExtTblLocs", "file1"});
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("HiveMetaTool:diffExtTblLocs takes in 3 arguments but was passed 2 arguments");
        new HiveMetaToolCommandLine(new String[]{"-diffExtTblLocs", "file1", "file2"});
    }

    @Test
    public void testDryRunNotAllowed() throws ParseException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("-dryRun, -serdePropKey, -tablePropKey may be used only for the -updateLocation command");
        new HiveMetaToolCommandLine(new String[]{"-listFSRoot", "-dryRun"});
    }

    @Test
    public void testSerdePropKeyNotAllowed() throws ParseException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("-dryRun, -serdePropKey, -tablePropKey may be used only for the -updateLocation command");
        new HiveMetaToolCommandLine(new String[]{"-listFSRoot", "-serdePropKey", "abc"});
    }

    @Test
    public void testTablePropKeyNotAllowed() throws ParseException {
        this.exception.expect(IllegalArgumentException.class);
        this.exception.expectMessage("-dryRun, -serdePropKey, -tablePropKey may be used only for the -updateLocation command");
        new HiveMetaToolCommandLine(new String[]{"-executeJDOQL", "select a from b", "-tablePropKey", "abc"});
    }
}

