/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.security;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.annotation.MetastoreUnitTest;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.security.DelegationTokenIdentifier;
import org.apache.hadoop.hive.metastore.security.DelegationTokenStore;
import org.apache.hadoop.hive.metastore.security.MemoryTokenStore;
import org.apache.hadoop.hive.metastore.security.TokenStoreDelegationTokenSecretManager;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.Token;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={MetastoreUnitTest.class})
public class TestTokenStoreDelegationTokenSecretManager {
    private final Configuration conf = MetastoreConf.newMetastoreConf();

    private TokenStoreDelegationTokenSecretManager createTokenMgr(DelegationTokenStore tokenStore, long renewSecs) {
        MetastoreConf.setTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_TOKEN_RENEW_INTERVAL, (long)renewSecs, (TimeUnit)TimeUnit.SECONDS);
        long secretKeyInterval = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_KEY_UPDATE_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        long tokenMaxLifetime = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_TOKEN_MAX_LIFETIME, (TimeUnit)TimeUnit.MILLISECONDS);
        long tokenRenewInterval = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_TOKEN_RENEW_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        long tokenGcInterval = MetastoreConf.getTimeVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.DELEGATION_TOKEN_GC_INTERVAL, (TimeUnit)TimeUnit.MILLISECONDS);
        return new TokenStoreDelegationTokenSecretManager(secretKeyInterval, tokenMaxLifetime, tokenRenewInterval, tokenGcInterval, tokenStore);
    }

    private DelegationTokenIdentifier getID(String tokenStr) throws IOException {
        DelegationTokenIdentifier id = new DelegationTokenIdentifier();
        Token token = new Token();
        token.decodeFromUrlString(tokenStr);
        try (DataInputStream in = new DataInputStream(new ByteArrayInputStream(token.getIdentifier()));){
            id.readFields((DataInput)in);
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testRenewal() throws IOException, InterruptedException {
        MemoryTokenStore tokenStore = new MemoryTokenStore();
        TokenStoreDelegationTokenSecretManager mgr = this.createTokenMgr((DelegationTokenStore)tokenStore, 3600L);
        try {
            mgr.startThreads();
            String tokenStr = mgr.getDelegationToken(UserGroupInformation.getCurrentUser().getShortUserName(), UserGroupInformation.getCurrentUser().getShortUserName());
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr));
            DelegationTokenIdentifier id = this.getID(tokenStr);
            long initialExpiry = tokenStore.getToken(id).getRenewDate();
            Thread.sleep(100L);
            Assert.assertTrue((System.currentTimeMillis() > id.getIssueDate() ? 1 : 0) != 0);
            Assert.assertEquals((long)tokenStore.getToken(id).getRenewDate(), (long)initialExpiry);
            mgr.renewDelegationToken(tokenStr);
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr));
            Assert.assertTrue((tokenStore.getToken(id).getRenewDate() > initialExpiry ? 1 : 0) != 0);
        }
        finally {
            mgr.stopThreads();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpiry() throws IOException, InterruptedException {
        MemoryTokenStore tokenStore = new MemoryTokenStore();
        TokenStoreDelegationTokenSecretManager mgr = this.createTokenMgr((DelegationTokenStore)tokenStore, 1L);
        try {
            mgr.startThreads();
            String tokenStr = mgr.getDelegationToken(UserGroupInformation.getCurrentUser().getShortUserName(), UserGroupInformation.getCurrentUser().getShortUserName());
            DelegationTokenIdentifier id = this.getID(tokenStr);
            Assert.assertNotNull((Object)mgr.verifyDelegationToken(tokenStr));
            Thread.sleep(1000L);
            SecretManager.InvalidToken ex = (SecretManager.InvalidToken)Assert.assertThrows(SecretManager.InvalidToken.class, () -> mgr.verifyDelegationToken(tokenStr));
            Assert.assertTrue((boolean)ex.getMessage().contains("is expired"));
        }
        finally {
            mgr.stopThreads();
        }
    }
}

