/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import com.google.common.base.Supplier;
import java.nio.charset.StandardCharsets;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HMSHandler;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.ObjectStore;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TestObjectStore;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.client.builder.DatabaseBuilder;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.model.MMetastoreDBProperties;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyStoreTest {
    private ObjectStore objectStore = null;
    private Configuration conf;
    private static final String DB1 = "testdb1";
    private static final Logger LOG = LoggerFactory.getLogger((String)TestObjectStore.class.getName());

    @Before
    public void setUp() throws Exception {
        this.conf = MetastoreConf.newMetastoreConf();
        MetastoreConf.setBoolVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.HIVE_IN_TEST, (boolean)true);
        MetastoreConf.setLongVar((Configuration)this.conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EVENT_CLEAN_MAX_EVENTS, (long)1L);
        MetaStoreTestUtils.setConfForStandloneMode(this.conf);
        this.objectStore = new ObjectStore();
        this.objectStore.setConf(this.conf);
        HMSHandler.createDefaultCatalog((RawStore)this.objectStore, (Warehouse)new Warehouse(this.conf));
    }

    @After
    public void tearDown() throws Exception {
        System.clearProperty("javax.net.ssl.trustStore");
        System.clearProperty("javax.net.ssl.trustStorePassword");
        System.clearProperty("javax.net.ssl.trustStoreType");
    }

    @Test
    public void testProperties() throws Exception {
        this.objectStore.createDatabase(new DatabaseBuilder().setName(DB1).setDescription("description").setLocation("locationurl").build(this.conf));
        MMetastoreDBProperties p0 = this.objectStore.putProperties("key", "value", null, "content".getBytes(StandardCharsets.UTF_8));
        Assert.assertNotNull((Object)p0);
        Assert.assertNotNull((Object)p0.getPropertyContent());
        MMetastoreDBProperties p1 = (MMetastoreDBProperties)this.objectStore.fetchProperties("key", p -> {
            p.getPropertyContent();
            return p;
        });
        Assert.assertNotNull((Object)p1);
        Assert.assertEquals((Object)p0.getPropertykey(), (Object)p1.getPropertykey());
        Assert.assertEquals((Object)p0.getPropertyValue(), (Object)p1.getPropertyValue());
        Assert.assertNotNull((Object)p1.getPropertyContent());
        Assert.assertTrue((p0.getPropertyContent() != p1.getPropertyContent() ? 1 : 0) != 0);
        String cp0 = new String(p0.getPropertyContent(), StandardCharsets.UTF_8);
        String cp1 = new String(p1.getPropertyContent(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)cp0, (Object)cp1);
        Assert.assertFalse((boolean)this.objectStore.renameProperties("yek", "KEY"));
        Assert.assertFalse((boolean)this.objectStore.renameProperties("yek", "key"));
        boolean b = this.objectStore.renameProperties("key", "KEY");
        Assert.assertTrue((boolean)b);
        p1 = (MMetastoreDBProperties)this.objectStore.fetchProperties("key", p -> {
            p.getPropertyContent();
            return p;
        });
        Assert.assertNull((Object)p1);
        p1 = (MMetastoreDBProperties)this.objectStore.fetchProperties("KEY", p -> {
            p.getPropertyContent();
            return p;
        });
        Assert.assertNotNull((Object)p1);
        Assert.assertTrue((p0.getPropertyContent() != p1.getPropertyContent() ? 1 : 0) != 0);
        cp1 = new String(p1.getPropertyContent(), StandardCharsets.UTF_8);
        Assert.assertEquals((Object)cp0, (Object)cp1);
    }

    private static final class LongSupplier
    implements Supplier<Long> {
        public long value = 0L;

        private LongSupplier() {
        }

        public Long get() {
            return this.value;
        }
    }
}

