/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.HiveMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreTestUtils;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.properties.HMSTestBase;
import org.apache.hadoop.hive.metastore.security.HadoopThriftAuthBridge;
import org.apache.thrift.TException;
import org.junit.Test;

public class HMSThriftTest
extends HMSTestBase {
    @Override
    protected int createServer(Configuration conf) throws Exception {
        return MetaStoreTestUtils.startMetaStoreWithRetry(HadoopThriftAuthBridge.getBridge(), conf);
    }

    @Override
    protected void stopServer(int port) {
        MetaStoreTestUtils.close(port);
    }

    @Override
    protected HMSTestBase.PropertyClient createClient(Configuration conf, int port) throws Exception {
        MetastoreConf.setVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.THRIFT_URIS, (String)("http://localhost:" + port));
        MetastoreConf.setBoolVar((Configuration)conf, (MetastoreConf.ConfVars)MetastoreConf.ConfVars.EXECUTE_SET_UGI, (boolean)false);
        HiveMetaStoreClient client = new HiveMetaStoreClient(conf);
        return new ThriftPropertyClient(this.NS, client);
    }

    @Test
    public void testThriftProperties0() throws Exception {
        this.runOtherProperties0(this.client);
    }

    @Test
    public void testThriftProperties1() throws Exception {
        this.runOtherProperties1(this.client);
    }

    static class ThriftPropertyClient
    implements HMSTestBase.PropertyClient {
        private final String namespace;
        private final HiveMetaStoreClient client;

        ThriftPropertyClient(String ns, HiveMetaStoreClient c) {
            this.namespace = ns;
            this.client = c;
        }

        @Override
        public boolean setProperties(Map<String, String> properties) {
            try {
                return this.client.setProperties(this.namespace, properties);
            }
            catch (TException tex) {
                return false;
            }
        }

        @Override
        public Map<String, Map<String, String>> getProperties(String mapPrefix, String mapPredicate, String ... selection) throws IOException {
            try {
                return this.client.getProperties(this.namespace, mapPrefix, mapPredicate, selection);
            }
            catch (TException tex) {
                return null;
            }
        }
    }
}

