/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.properties;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.PropertyServlet;
import org.apache.hadoop.hive.metastore.properties.HMSTestBase;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicNameValuePair;
import org.eclipse.jetty.server.Server;
import org.junit.Assert;
import org.junit.Test;

public class HMSServletTest
extends HMSTestBase {
    protected static final String CLI = "hmscli";
    Server servletServer = null;
    int sport = -1;

    @Override
    protected int createServer(Configuration conf) throws Exception {
        if (this.servletServer == null) {
            this.servletServer = PropertyServlet.startServer((Configuration)conf);
            if (this.servletServer == null || !this.servletServer.isStarted()) {
                Assert.fail((String)"http server did not start");
            }
            this.sport = this.servletServer.getURI().getPort();
        }
        return this.sport;
    }

    @Override
    protected void stopServer(int port) throws Exception {
        if (this.servletServer != null) {
            this.servletServer.stop();
            this.servletServer = null;
            this.sport = -1;
        }
    }

    @Override
    protected HMSTestBase.PropertyClient createClient(Configuration conf, int sport) throws Exception {
        URL url = new URL("http://hive@localhost:" + sport + "/" + CLI + "/" + this.NS);
        String jwt = this.generateJWT();
        return new JSonClient(jwt, url);
    }

    @Test
    public void testServletEchoA() throws Exception {
        URL url = new URL("http://hive@localhost:" + this.sport + "/" + CLI + "/" + this.NS);
        Map<String, String> json = Collections.singletonMap("method", "echo");
        String jwt = this.generateJWT();
        Object response = HMSServletTest.clientCall(jwt, url, "POST", json);
        Assert.assertNotNull((Object)response);
        Assert.assertEquals(json, (Object)response);
        String badJwt = this.generateJWT(jwtUnauthorizedKeyFile.toPath());
        response = HMSServletTest.clientCall(badJwt, url, "POST", json);
        Assert.assertNull((Object)response);
    }

    @Test
    public void testProperties1() throws Exception {
        this.runOtherProperties1(this.client);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testProperties0() throws Exception {
        this.runOtherProperties0(this.client);
        CloseableHttpClient client = HttpClients.createDefault();
        String jwt = this.generateJWT();
        NameValuePair[] nvp = new NameValuePair[]{new BasicNameValuePair("key", "db0.table01.fillFactor"), new BasicNameValuePair("key", "db0.table04.fillFactor")};
        URI uri = new URIBuilder().setScheme("http").setUserInfo("hive").setHost("localhost").setPort(this.sport).setPath("/hmscli/" + this.NS).setParameters(nvp).build();
        HttpGet get = new HttpGet(uri);
        get.addHeader("Authorization", "Bearer " + jwt);
        get.addHeader("Content-Type", "application/json");
        get.addHeader("Accept", "application/json");
        get.addHeader("x-actor-username", "hive");
        Map result = null;
        HttpResponse response = client.execute((HttpUriRequest)get);
        try {
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                Gson gson = new GsonBuilder().create();
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = contentType.getCharset();
                InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
                result = (Map)gson.fromJson((Reader)reader, Object.class);
            }
            Assert.assertNotNull(result);
            Assert.assertEquals((long)2L, (long)result.size());
        }
        finally {
            if (response instanceof AutoCloseable) {
                ((AutoCloseable)response).close();
            }
            if (client instanceof AutoCloseable) {
                ((AutoCloseable)client).close();
            }
        }
    }

    private String readString(Reader reader) throws IOException {
        BufferedReader in = new BufferedReader(reader);
        String line = null;
        StringBuilder rslt = new StringBuilder();
        while ((line = in.readLine()) != null) {
            rslt.append(line);
        }
        return rslt.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testServletEchoB() throws Exception {
        CloseableHttpClient client = HttpClients.createDefault();
        HttpResponse response = null;
        try {
            String jwt = this.generateJWT();
            String msgBody = "{\"method\":\"echo\"}";
            HttpPost post = this.createPost(jwt, msgBody);
            response = client.execute((HttpUriRequest)post);
            Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
            String resp = null;
            HttpEntity entity = response.getEntity();
            if (entity != null) {
                ContentType contentType = ContentType.getOrDefault((HttpEntity)entity);
                Charset charset = contentType.getCharset();
                InputStreamReader reader = new InputStreamReader(entity.getContent(), charset);
                resp = this.readString(reader);
            }
            Assert.assertNotNull(resp);
            Assert.assertEquals((Object)msgBody, resp);
        }
        finally {
            if (response instanceof AutoCloseable) {
                ((AutoCloseable)response).close();
            }
            if (client instanceof AutoCloseable) {
                ((AutoCloseable)client).close();
            }
        }
    }

    public static Object clientCall(String jwt, URL url, String method, Object arg) throws IOException {
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod(method);
        con.setRequestProperty("x-actor-username", url.getUserInfo());
        con.setRequestProperty("Content-Type", "application/json");
        con.setRequestProperty("Accept", "application/json");
        if (jwt != null) {
            con.setRequestProperty("Authorization", "Bearer " + jwt);
        }
        con.setDoOutput(true);
        con.setDoInput(true);
        DataOutputStream wr = new DataOutputStream(con.getOutputStream());
        wr.writeBytes(new Gson().toJson(arg));
        wr.flush();
        wr.close();
        int responseCode = con.getResponseCode();
        if (responseCode == 200) {
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(con.getInputStream(), StandardCharsets.UTF_8));){
                Object object = new Gson().fromJson((Reader)reader, Object.class);
                return object;
            }
        }
        return null;
    }

    private HttpPost createPost(String jwt, String msgBody) {
        HttpPost method = new HttpPost("http://hive@localhost:" + this.sport + "/" + CLI + "/" + this.NS);
        method.addHeader("Authorization", "Bearer " + jwt);
        method.addHeader("Content-Type", "application/json");
        method.addHeader("Accept", "application/json");
        StringEntity sre = new StringEntity(msgBody, ContentType.APPLICATION_JSON);
        method.setEntity((HttpEntity)sre);
        return method;
    }

    public static class JSonClient
    implements HMSTestBase.HttpPropertyClient {
        private final URL url;
        private final String jwt;

        JSonClient(String token, URL url) {
            this.jwt = token;
            this.url = url;
        }

        @Override
        public boolean setProperties(Map<String, String> properties) {
            try {
                HMSServletTest.clientCall(this.jwt, this.url, "PUT", properties);
                return true;
            }
            catch (IOException xio) {
                return false;
            }
        }

        @Override
        public Map<String, Map<String, String>> getProperties(String mapPrefix, String mapPredicate, String ... selection) {
            TreeMap<String, Object> args = new TreeMap<String, Object>();
            args.put("prefix", mapPrefix);
            if (mapPredicate != null) {
                args.put("predicate", mapPredicate);
            }
            if (selection != null && selection.length > 0) {
                args.put("selection", selection);
            }
            try {
                Object result = HMSServletTest.clientCall(this.jwt, this.url, "POST", args);
                return result instanceof Map ? (Map)result : null;
            }
            catch (IOException xio) {
                return null;
            }
        }

        @Override
        public Map<String, String> getProperties(List<String> selection) {
            try {
                TreeMap<String, Object> args = new TreeMap<String, Object>();
                args.put("method", "fetchProperties");
                args.put("keys", selection);
                Object result = HMSServletTest.clientCall(this.jwt, this.url, "POST", args);
                return result instanceof Map ? (Map)result : null;
            }
            catch (IOException xio) {
                return null;
            }
        }
    }
}

