/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.minihms;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.metastore.conf.MetastoreConf;
import org.apache.hadoop.hive.metastore.minihms.AbstractMetaStoreService;
import org.apache.hadoop.hive.metastore.minihms.ClusterMetaStoreForTests;
import org.apache.hadoop.hive.metastore.minihms.EmbeddedMetaStoreForTests;
import org.apache.hadoop.hive.metastore.minihms.RemoteMetaStoreForTests;

public class MiniHMS {

    public static class Builder {
        private Configuration metaStoreConf = MetastoreConf.newMetastoreConf();
        private MiniHMSType miniHMSType = MiniHMSType.EMBEDDED;

        public Builder setConf(Configuration conf) {
            this.metaStoreConf = new Configuration(conf);
            return this;
        }

        public Builder setType(MiniHMSType type) {
            this.miniHMSType = type;
            return this;
        }

        public AbstractMetaStoreService build() throws Exception {
            switch (this.miniHMSType) {
                case REMOTE: {
                    return new RemoteMetaStoreForTests(this.metaStoreConf);
                }
                case EMBEDDED: {
                    return new EmbeddedMetaStoreForTests(this.metaStoreConf);
                }
                case CLUSTER: {
                    return new ClusterMetaStoreForTests(this.metaStoreConf);
                }
            }
            throw new IllegalArgumentException("Unexpected miniHMSType: " + (Object)((Object)this.miniHMSType));
        }
    }

    public static enum MiniHMSType {
        EMBEDDED,
        REMOTE,
        CLUSTER;

    }
}

